/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.views;

import com.ibm.cic.agent.core.IAgentEventManager;
import com.ibm.cic.agent.internal.core.notify.EnableImportEventListener;
import com.ibm.cic.agent.internal.core.notify.EnableImportEventManager;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUILabelProvider;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.actions.InstallAction;
import com.ibm.cic.agent.internal.ui.actions.LicenseManagementAction;
import com.ibm.cic.agent.internal.ui.actions.ModifyAction;
import com.ibm.cic.agent.internal.ui.actions.RollbackAction;
import com.ibm.cic.agent.internal.ui.actions.UninstallAction;
import com.ibm.cic.agent.internal.ui.actions.UpdateAction;
import com.ibm.cic.agent.internal.ui.factories.ImportWizardFactory;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.ui.extensions.AbstractAgentUIAction;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.ui.CICImages;
import com.ibm.cic.common.ui.internal.AbstractCICLabelProvider;
import com.ibm.cic.common.ui.internal.CommonUIUtils;
import com.ibm.cic.common.ui.internal.views.AbstractQSView;
import com.ibm.cic.common.ui.services.UiServices;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.util.EventObject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class NewAgentQSView
extends AbstractQSView {
    private AgentUILabelProvider labelProvider;
    private Composite rightComposite = null;
    private Font smallFont = null;
    private Color colorBlue;
    private static final String NotDisplayBGImage = "cic.NotDisplayBGImage";

    public NewAgentQSView() {
        this.setHelpRef("com.ibm.cic.agent.ui.NewAgentQSView");
        IAgentEventManager.AgentJobListener jobListener = new IAgentEventManager.AgentJobListener(){

            public void afterInstallOfferingOrFix(IAgentEventManager.AgentJobEvent event) {
                DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        NewAgentQSView.this.refreshRightComposite();
                    }
                });
            }

            public void afterUninstallOfferingOrFix(IAgentEventManager.AgentJobEvent event) {
                DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        NewAgentQSView.this.refreshRightComposite();
                    }
                });
            }

            public IStatus beforeInstallOfferingOrFix(IAgentEventManager.AgentJobEvent event) {
                return null;
            }

            public IStatus beforeUninstallOfferingOrFix(IAgentEventManager.AgentJobEvent event) {
                return null;
            }
        };
        IAgentEventManager eventManager = AgentUI.getDefault().getAgent().getEventManager();
        eventManager.addInstallOfferingOrFixListener(jobListener);
        eventManager.addUninstallOfferingOrFixListener(jobListener);
        if (ImportWizardFactory.getInstance().hasImportWizards()) {
            EnableImportEventManager.getInstance().addEnableImportListener(new EnableImportEventListener(){

                public void handleEnableImportEvent(EventObject event) {
                    if (PlatformUI.getWorkbench().isClosing()) {
                        return;
                    }
                    DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            NewAgentQSView.this.refreshRightComposite();
                        }
                    });
                }
            });
        }
    }

    private void refreshRightComposite() {
        Control[] control = this.rightComposite.getChildren();
        if (this.backgroundFixer != null) {
            this.backgroundFixer.releaseListener(control);
        }
        Control[] controlArray = control;
        int n = control.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            element.dispose();
            ++n2;
        }
        this.createRightComposite();
        control = this.rightComposite.getChildren();
        if (this.backgroundFixer != null) {
            this.backgroundFixer.hookListener(control);
        }
        Color background = this.rightComposite.getBackground();
        Control[] controlArray2 = control;
        int n3 = control.length;
        n = 0;
        while (n < n3) {
            Control element = controlArray2[n];
            if (this.backgroundFixer != null) {
                element.setBackground(background);
            }
            for (Composite parent = element.getParent(); parent != null; parent = parent.getParent()) {
                parent.layout();
                if (!(parent instanceof ScrolledForm)) continue;
                ((ScrolledForm)parent).reflow(true);
                break;
            }
            ++n;
        }
    }

    private void createRightComposite() {
        AbstractAgentUIAction action;
        ImportWizardFactory.ImportWizardExtension[] extensions;
        int numElements = 2;
        Label seperator = new Label(this.rightComposite, 0);
        seperator.setLayoutData((Object)new GridData(4, 4, true, true));
        if (AgentUIUtils.containUseIMManageLicenseOffering()) {
            this.createImageAndText(this.rightComposite, CICImages.QS_LICENSES, CICImages.QS_LICENSES_HOVER, Messages.AgentQSView_Licenses, this.smallFont, (IAction)new LicenseManagementAction(this.getSite().getWorkbenchWindow()), this.colorBlue);
            ++numElements;
        }
        if (CicPreferenceManager.getInstance().getBoolean(ICicPreferenceConstants.IMPORT_ENABLED.key()) && (extensions = ImportWizardFactory.getInstance().createImportWizards()).length > 0 && extensions[0].getAddToStartPage() && (action = extensions[0].getImportWizard()) != null) {
            action.setWorkbenchWindow(this.getSite().getWorkbenchWindow());
            this.createImageAndText(this.rightComposite, extensions[0].getLinkImage(), extensions[0].getLinkHoverImage(), extensions[0].getLinkLabel(), this.smallFont, (IAction)action, this.colorBlue);
            ++numElements;
        }
        this.createImageAndText(this.rightComposite, CICImages.QS_ROLLBACK, CICImages.QS_ROLLBACK_HOVER, Messages.AgentQSView_Rollback, this.smallFont, (IAction)new RollbackAction(this.getSite().getWorkbenchWindow()), this.colorBlue);
        this.createImageAndText(this.rightComposite, CICImages.QS_UNINSTALL, CICImages.QS_UNINSTALL_HOVER, Messages.AgentQSView_Uninstall, this.smallFont, (IAction)new UninstallAction(this.getSite().getWorkbenchWindow()), this.colorBlue);
        Composite fudgePadding = new Composite(this.rightComposite, 0);
        GridData data = new GridData(1, 0x1000008, true, false);
        data.heightHint = numElements == 2 ? 5 : 13;
        fudgePadding.setLayoutData((Object)data);
        GridLayout layout = (GridLayout)this.rightComposite.getLayout();
        layout.verticalSpacing = numElements == 2 ? 10 : (numElements == 3 ? 5 : 0);
    }

    protected void createImagesAndText(Composite parent) {
        Composite newParent = this.createComposite(parent, 3);
        Composite leftComposite = this.createComposite(newParent, 1);
        this.createComposite(newParent, 1);
        this.rightComposite = this.createComposite(newParent, 1);
        this.colorBlue = new Color((Device)DisplayKeeper.INSTANCE.getDisplay(), 37, 81, 148);
        Font nicefont = this.getFont();
        FontData[] fontData = nicefont.getFontData();
        fontData[0].setHeight((int)((double)fontData[0].getHeight() * 0.75));
        this.smallFont = new Font((Device)DisplayKeeper.INSTANCE.getDisplay(), fontData);
        final Font smallNiceFont = new Font((Device)DisplayKeeper.INSTANCE.getDisplay(), fontData);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (NewAgentQSView.this.colorBlue != null && !NewAgentQSView.this.colorBlue.isDisposed()) {
                    NewAgentQSView.this.colorBlue.dispose();
                }
                smallNiceFont.dispose();
            }
        });
        if (UiServices.getInstance().isWebPlatformActive()) {
            this.createImageAndText(leftComposite, CICImages.QS_INSTALL, CICImages.QS_INSTALL_HOVER, Messages.AgentQSView_Install, this.smallFont, (IAction)new InstallAction(this.getSite().getWorkbenchWindow()), this.colorBlue);
            this.createImageAndText(leftComposite, CICImages.QS_CHECKUPDATE, CICImages.QS_CHECKUPDATE_HOVER, Messages.AgentQSView_Update, this.smallFont, (IAction)new UpdateAction(this.getSite().getWorkbenchWindow()), this.colorBlue);
            this.createImageAndText(leftComposite, CICImages.QS_MANAGE, CICImages.QS_MANAGE_HOVER, Messages.AgentQSView_Manage, this.smallFont, (IAction)new ModifyAction(this.getSite().getWorkbenchWindow()), this.colorBlue);
        } else {
            this.createImageAndText(leftComposite, CICImages.QS_INSTALL, CICImages.QS_INSTALL_HOVER, Messages.AgentQSView_Install, (IAction)new InstallAction(this.getSite().getWorkbenchWindow()), this.colorBlue, Messages.AgentQSView_Install_description, leftComposite.getForeground());
            this.createImageAndText(leftComposite, CICImages.QS_CHECKUPDATE, CICImages.QS_CHECKUPDATE_HOVER, Messages.AgentQSView_Update, (IAction)new UpdateAction(this.getSite().getWorkbenchWindow()), this.colorBlue, Messages.AgentQSView_Update_description, leftComposite.getForeground());
            this.createImageAndText(leftComposite, CICImages.QS_MANAGE, CICImages.QS_MANAGE_HOVER, Messages.AgentQSView_Manage, (IAction)new ModifyAction(this.getSite().getWorkbenchWindow()), this.colorBlue, Messages.AgentQSView_Modify_description, leftComposite.getForeground());
        }
        this.createRightComposite();
    }

    private Composite createComposite(Composite parent, int columns) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.numColumns = columns;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        return composite;
    }

    protected ImageDescriptor getBackgroundImageDescriptor() {
        if (DisplayKeeper.INSTANCE.getDisplay().getHighContrast()) {
            return null;
        }
        String notDisplayBGImage = System.getProperty(NotDisplayBGImage);
        if (notDisplayBGImage != null && Boolean.TRUE.toString().equalsIgnoreCase(notDisplayBGImage)) {
            return null;
        }
        if (CommonUIUtils.runningBiDiLocale()) {
            return super.getBackgroundImageDescriptor();
        }
        return CICImages.WELCOME_BACKGROUND;
    }

    protected ImageDescriptor getBackgroundLowerRightImageDescriptor() {
        return null;
    }

    protected ImageDescriptor getProductTitleImage() {
        return CICImages.WELCOME_IM_TITLE;
    }

    protected AbstractCICLabelProvider getImageCache() {
        if (this.labelProvider == null) {
            this.labelProvider = AgentUI.getDefault().getLabelProvider();
            AgentUI.getDefault().getLabelProvider().connect((Object)this);
        }
        return this.labelProvider;
    }

    protected void logException(Exception x) {
        AgentUI.reportException(x);
    }

    public void dispose() {
        if (this.labelProvider != null) {
            this.labelProvider.disconnect((Object)this);
        }
        super.dispose();
    }
}

