/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.utils;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.sharedUI.IContainsOffering;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.utils.FixNode;
import com.ibm.cic.agent.internal.ui.utils.PackageNode;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.repository.SliceUtils;
import com.ibm.cic.common.core.repository.UnavailableUtils;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class VersionNode
implements IContainsOffering,
IAdaptable {
    private final List<FixNode> fixNodes = new ArrayList<FixNode>();
    private final AbstractJob job;
    private final PackageNode parent;
    private boolean isInstalled = false;
    private boolean isRecommended = false;
    private IStatus toleranceStatus = null;
    private IStatus checkBetaStatus = null;
    private Boolean hasWrongPrivilege = null;
    private Boolean hasWrongGroupModeRequirement = null;
    private Boolean supportCurrentUI = null;
    private Boolean supportCurrentOS = null;
    private Boolean supportCurrentPlatform = null;
    private Boolean supportCurrentArchitecture = null;
    private boolean checkStatus = true;
    public boolean versionSelected = true;
    public String prevFilter = "";

    public VersionNode(AbstractJob job, PackageNode parent) {
        this.job = job;
        this.parent = parent;
    }

    public VersionNode(AbstractJob job, PackageNode parent, boolean checkStatus) {
        this(job, parent);
        this.checkStatus = checkStatus;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IOffering.class) {
            return this.getOffering();
        }
        if (adapter == AbstractJob.class) {
            return this.job;
        }
        return null;
    }

    public boolean isAgentVersionNode() {
        IOffering offering = this.getOffering();
        if (offering == null) {
            return false;
        }
        return AgentUI.getDefault().getAgent().isAgentOffering((IOfferingOrFix)offering);
    }

    public FixNode addFix(AbstractJob fixJob) {
        FixNode fixNode = new FixNode(fixJob, this, this.checkStatus);
        this.fixNodes.add(fixNode);
        return fixNode;
    }

    public List getFixes() {
        return this.fixNodes;
    }

    public AbstractJob getJob() {
        return this.job;
    }

    public IOffering getOffering() {
        return this.job.getOffering();
    }

    public PackageNode getParent() {
        return this.parent;
    }

    public boolean isSelected() {
        return this.job.isSelected();
    }

    public void selectVersion(boolean select) {
        this.versionSelected = select;
    }

    public void setSelected(boolean selected) {
        this.job.setSelected(selected);
    }

    public boolean isInstalled() {
        return this.isInstalled;
    }

    public void setInstalled(boolean isInstalled) {
        this.isInstalled = isInstalled;
    }

    public boolean isRecommended() {
        return this.isRecommended;
    }

    public void setRecommended(boolean isRecommended) {
        this.isRecommended = isRecommended;
    }

    public boolean isPekNode() {
        return this.getOffering() != null && LicenseUtils.isPEKOffering((IOffering)this.getOffering());
    }

    public IStatus getToleranceStatus() {
        if (this.toleranceStatus == null) {
            this.toleranceStatus = Status.OK_STATUS;
            if (this.checkStatus) {
                this.toleranceStatus = AgentUI.getDefault().getAgent().checkAgentRequirement((IOfferingOrFix)this.job.getOffering(), AgentUI.getDefault().getAgentPreferenceStore().getBoolean(ICicPreferenceConstants.DISPLAY_INTERNAL_VERSION.key()));
            }
        }
        return this.toleranceStatus;
    }

    public IStatus getCheckBetaStatus() {
        if (this.checkBetaStatus == null) {
            IOffering offering;
            this.checkBetaStatus = Status.OK_STATUS;
            if (this.checkStatus && (offering = this.job.getOffering()) != null) {
                this.checkBetaStatus = AgentUI.getDefault().getAgent().checkBetaRequirement((IOfferingOrFix)offering);
            }
        }
        return this.checkBetaStatus;
    }

    public boolean hasUnacceptablePrivilege() {
        if (this.hasWrongPrivilege == null) {
            IOffering offering;
            this.hasWrongPrivilege = Boolean.FALSE;
            if (this.checkStatus && (offering = this.job.getOffering()) != null) {
                boolean violatePrivilege = OfferingProperty.hasUnacceptableRequirementForUserRights((IOffering)offering);
                this.hasWrongPrivilege = violatePrivilege;
            }
        }
        return this.hasWrongPrivilege;
    }

    public boolean hasUnacceptableGroupModeRequirement() {
        if (this.hasWrongGroupModeRequirement == null) {
            IOffering offering;
            this.hasWrongGroupModeRequirement = Boolean.FALSE;
            if (this.checkStatus && (offering = this.job.getOffering()) != null) {
                boolean violateGroupModeRequirement = OfferingProperty.hasUnacceptableRequirementForGroupMode((IOfferingOrFix)offering);
                this.hasWrongGroupModeRequirement = violateGroupModeRequirement;
            }
        }
        return this.hasWrongGroupModeRequirement;
    }

    public FixNode containsFix(IFix fix) {
        for (FixNode fixNode : this.fixNodes) {
            IFix currentFix = fixNode.getJob().getFix();
            if (!fix.equals(currentFix)) continue;
            return fixNode;
        }
        return null;
    }

    public boolean supportCurrentOS() {
        if (this.supportCurrentOS == null) {
            if (!this.checkStatus) {
                this.supportCurrentOS = Boolean.TRUE;
            } else {
                IOffering offering = this.job.getOffering();
                if (offering != null) {
                    boolean isSupportedOS = OfferingProperty.isSupportedOS((IOffering)offering);
                    this.supportCurrentOS = isSupportedOS;
                } else {
                    this.supportCurrentOS = Boolean.FALSE;
                }
            }
        }
        return this.supportCurrentOS;
    }

    public boolean supportCurrentUI() {
        if (this.supportCurrentUI == null) {
            if (!this.checkStatus) {
                this.supportCurrentUI = Boolean.TRUE;
            } else {
                IOffering offering = this.job.getOffering();
                if (offering != null) {
                    IStatus status = Agent.getInstance().checkWebUISupported((IOfferingOrFix)offering);
                    this.supportCurrentUI = status.isOK();
                } else {
                    this.supportCurrentUI = Boolean.FALSE;
                }
            }
        }
        return this.supportCurrentUI;
    }

    public boolean supportCurrentPlatform() {
        if (this.supportCurrentPlatform == null) {
            if (!this.checkStatus) {
                this.supportCurrentPlatform = Boolean.TRUE;
            } else {
                IOffering offering = this.job.getOffering();
                if (offering != null) {
                    boolean isSupportedPlatform = BitModeUtils.checkSupportedPlatforms((IOfferingOrFix)offering).isOK();
                    this.supportCurrentPlatform = isSupportedPlatform;
                } else {
                    this.supportCurrentPlatform = Boolean.FALSE;
                }
            }
        }
        return this.supportCurrentPlatform;
    }

    public boolean supportCurrentArchitecture() {
        if (this.supportCurrentArchitecture == null) {
            IOffering offering;
            this.supportCurrentArchitecture = Boolean.TRUE;
            if (this.checkStatus && this.job.isUpdate() && (offering = this.job.getOffering()) != null) {
                Profile profile = this.job.getProfile();
                IStatus status = SliceUtils.checkPlatform((IOfferingOrFix)offering, (String)profile.getOS(), (String)profile.getArch());
                this.supportCurrentArchitecture = status.isOK();
            }
        }
        return this.supportCurrentArchitecture;
    }

    public void resetSupportCurrentPlatform() {
        this.supportCurrentPlatform = null;
    }

    public boolean isUnavailable() {
        if (!this.checkStatus) {
            return false;
        }
        return UnavailableUtils.isUnavailable((IContent)this.getJob().getOfferingOrFix());
    }

    public boolean canBeInstalled() {
        return !this.hasUnacceptablePrivilege() && !this.hasUnacceptableGroupModeRequirement() && this.getCheckBetaStatus().isOK() && this.supportCurrentUI() && this.supportCurrentOS() && this.supportCurrentPlatform() && this.supportCurrentArchitecture() && !this.isUnavailable() && !this.isBaseOfferingUnavailable();
    }

    private boolean isBaseOfferingUnavailable() {
        IOffering offering = this.job.getOffering();
        if (this.parent != null && UpdateOfferingUtils.isUpdate((IContent)offering)) {
            VersionNode baseOfferingVersionNode = this.parent.getVersionNodeForOffering(UpdateOfferingUtils.getBaseOfferingId((IOfferingOrFix)offering));
            return baseOfferingVersionNode != null && UnavailableUtils.isUnavailable((IContent)baseOfferingVersionNode.getOffering());
        }
        return false;
    }

    public Profile getProfile() {
        return this.job.getProfile();
    }

    public boolean containsUnavailableFixes() {
        if (!this.checkStatus) {
            return false;
        }
        for (FixNode fixNode : this.fixNodes) {
            if (!UnavailableUtils.isUnavailable((IContent)fixNode.getFix())) continue;
            return true;
        }
        return false;
    }
}

