/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.parts;

import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.OfferingOrFixFilter;
import com.ibm.cic.agent.internal.ui.wizards.CheckboxTreeFilterSection;
import com.ibm.cic.common.ui.CICImages;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.progress.WorkbenchJob;

public class TreeFilterBoxPart {
    private static final int REFRESH_FIX_TREE_DELAY = 200;
    private ToolBarManager toolbarManager;
    private MenuManager menuManager;
    private Action showFilterBoxAction;
    private Composite filterContainer;
    private Composite filterComp;
    private Text filterText;
    private ToolItem clearItem;
    private Label selectionHintLabel;
    private TreeViewer treeViewer;
    private OfferingOrFixFilter viewerFilter;
    private Job refreshJob;
    private final CheckboxTreeFilterSection section;
    private boolean filterOffering = false;

    public TreeFilterBoxPart(CheckboxTreeFilterSection treeSection, boolean filterOffering) {
        this.section = treeSection;
        this.filterOffering = filterOffering;
    }

    public void createFilterBoxControl(Composite parent, FormToolkit toolkit) {
        this.filterContainer = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        this.filterContainer.setLayout((Layout)layout);
        GridData containerData = new GridData(4, 1, true, false);
        this.filterContainer.setLayoutData((Object)containerData);
        this.filterComp = toolkit.createComposite(this.filterContainer, 0);
        GridLayout filterLayout = new GridLayout();
        filterLayout.marginHeight = 0;
        filterLayout.marginWidth = 0;
        filterLayout.marginBottom = 3;
        filterLayout.numColumns = this.filterOffering ? 4 : 3;
        filterLayout.horizontalSpacing = 0;
        this.filterComp.setLayout((Layout)filterLayout);
        GridData filterData = new GridData(4, 0x1000000, true, false);
        filterData.widthHint = 700;
        filterData.horizontalIndent = 3;
        this.filterComp.setLayoutData((Object)filterData);
        this.filterText = toolkit.createText(this.filterComp, "", 2692);
        GridData filterTextData = new GridData(1, 0x1000000, false, false);
        filterTextData.widthHint = 260;
        this.filterText.setLayoutData((Object)filterTextData);
        this.filterText.setMessage(Messages.AvailableFixSection_tooltip_inputText);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TreeFilterBoxPart.this.viewerFilter != null) {
                    if (TreeFilterBoxPart.this.filterText.getText().length() == 0) {
                        TreeFilterBoxPart.this.clearItem.setEnabled(false);
                    } else {
                        TreeFilterBoxPart.this.clearItem.setEnabled(true);
                    }
                    TreeFilterBoxPart.this.refreshJob.cancel();
                    TreeFilterBoxPart.this.refreshJob.schedule(200L);
                }
            }
        });
        this.filterText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String filterTextString = TreeFilterBoxPart.this.filterText.getText();
                e.result = filterTextString.length() == 0 ? Messages.AvailableFixSection_tooltip_inputText : filterTextString;
            }
        });
        ToolBar clearToolBar = new ToolBar(this.filterComp, 0x800000);
        GridData clearButtonData = new GridData();
        clearButtonData.horizontalIndent = 2;
        clearToolBar.setLayoutData((Object)clearButtonData);
        clearToolBar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.AvailableFixSection_tooltip_clear;
            }
        });
        this.clearItem = new ToolItem(clearToolBar, 8);
        this.clearItem.setImage(AgentUI.getDefault().getLabelProvider().get(CICImages.CLEAR_FILTER_BOX_ENABLED));
        this.clearItem.setDisabledImage(AgentUI.getDefault().getLabelProvider().get(CICImages.CLEAR_FILTER_BOX_DISABLED));
        this.clearItem.setToolTipText(Messages.AvailableFixSection_tooltip_clear);
        this.clearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeFilterBoxPart.this.filterText.setText("");
            }
        });
        ToolBar closeToolBar = new ToolBar(this.filterComp, 0x800000);
        closeToolBar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.AvailableFixSection_tooltip_close;
            }
        });
        ToolItem closeItem = new ToolItem(closeToolBar, 8);
        closeItem.setImage(AgentUI.getDefault().getLabelProvider().get(CICImages.CLOSE_FILTER_BOX));
        closeItem.setToolTipText(Messages.AvailableFixSection_tooltip_close);
        closeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeFilterBoxPart.this.filterText.setText("");
                TreeFilterBoxPart.this.filterComp.setVisible(false);
                TreeFilterBoxPart.this.showFilterBoxAction.setChecked(TreeFilterBoxPart.this.filterComp.isVisible());
            }
        });
        if (this.filterOffering) {
            this.selectionHintLabel = toolkit.createLabel(this.filterComp, "", 64);
            GridData selectionData = new GridData(768);
            selectionData.horizontalIndent = 15;
            selectionData.widthHint = 380;
            this.selectionHintLabel.setLayoutData((Object)selectionData);
        }
        this.showFilterBoxAction = new Action(Messages.AvailableFixSection_filterMenu, 2){

            public void run() {
                boolean isFilterBoxVisible = TreeFilterBoxPart.this.filterComp.isVisible();
                if (isFilterBoxVisible) {
                    TreeFilterBoxPart.this.filterText.setText("");
                }
                TreeFilterBoxPart.this.filterComp.setVisible(!isFilterBoxVisible);
                this.setChecked(!isFilterBoxVisible);
            }
        };
        Composite toolbarComp = toolkit.createComposite(this.filterContainer);
        GridLayout toolbarLayout = new GridLayout();
        toolbarLayout.marginHeight = 0;
        toolbarLayout.marginWidth = 0;
        toolbarComp.setLayout((Layout)toolbarLayout);
        GridData toolbarData = new GridData();
        toolbarData.horizontalAlignment = 3;
        toolbarData.grabExcessHorizontalSpace = true;
        toolbarComp.setLayoutData((Object)toolbarData);
        this.toolbarManager = new ToolBarManager(0x800100);
        this.toolbarManager.createControl(toolbarComp);
        Action popupMenuAction = new Action("", 4){

            public ImageDescriptor getImageDescriptor() {
                return CICImages.LOG_FILTER;
            }

            public void run() {
                if (TreeFilterBoxPart.this.menuManager == null) {
                    TreeFilterBoxPart.this.menuManager = new MenuManager();
                    TreeFilterBoxPart.this.menuManager.add((IAction)TreeFilterBoxPart.this.showFilterBoxAction);
                    TreeFilterBoxPart.this.showFilterBoxAction.setChecked(TreeFilterBoxPart.this.filterComp.isVisible());
                }
                Menu menu = TreeFilterBoxPart.this.menuManager.createContextMenu((Control)TreeFilterBoxPart.this.filterComp.getShell());
                Rectangle bounds = TreeFilterBoxPart.this.toolbarManager.getControl().getBounds();
                Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
                topLeft = TreeFilterBoxPart.this.toolbarManager.getControl().toDisplay(topLeft);
                menu.setLocation(topLeft.x, topLeft.y);
                menu.setVisible(true);
            }
        };
        this.toolbarManager.add((IAction)popupMenuAction);
        this.toolbarManager.update(false);
        this.createRefreshJob();
    }

    private void createRefreshJob() {
        this.refreshJob = this.doCreateRefreshJob();
        this.refreshJob.setSystem(true);
    }

    private String getFilterString() {
        return this.filterText.getText();
    }

    protected WorkbenchJob doCreateRefreshJob() {
        WorkbenchJob job = new WorkbenchJob("Refresh Filter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (TreeFilterBoxPart.this.treeViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                if (TreeFilterBoxPart.this.viewerFilter == null) {
                    return Status.CANCEL_STATUS;
                }
                String text = TreeFilterBoxPart.this.getFilterString();
                if (text == null) {
                    return Status.OK_STATUS;
                }
                TreeFilterBoxPart.this.viewerFilter.setFilterString(text);
                Control redrawFalseControl = TreeFilterBoxPart.this.treeViewer.getControl();
                try {
                    redrawFalseControl.setRedraw(false);
                    TreeFilterBoxPart.this.treeViewer.refresh(true);
                    TreeItem[] items = TreeFilterBoxPart.this.treeViewer.getTree().getItems();
                    int treeHeight = ((TreeFilterBoxPart)TreeFilterBoxPart.this).treeViewer.getTree().getBounds().height;
                    int numVisibleItems = treeHeight / TreeFilterBoxPart.this.treeViewer.getTree().getItemHeight();
                    long stopTime = 200L + System.currentTimeMillis();
                    boolean cancel = false;
                    if (items.length > 0 && this.recursiveExpand(items, monitor, stopTime, new int[]{numVisibleItems})) {
                        cancel = true;
                    }
                    if (cancel) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                }
                finally {
                    TreeItem[] items = TreeFilterBoxPart.this.treeViewer.getTree().getItems();
                    if (items.length > 0 && TreeFilterBoxPart.this.treeViewer.getTree().getSelectionCount() == 0) {
                        TreeFilterBoxPart.this.treeViewer.getTree().setTopItem(items[0]);
                    }
                    redrawFalseControl.setRedraw(true);
                }
                return Status.OK_STATUS;
            }

            private boolean recursiveExpand(TreeItem[] items, IProgressMonitor monitor, long cancelTime, int[] numItemsLeft) {
                boolean canceled = false;
                int i = 0;
                while (!canceled && i < items.length) {
                    boolean visible;
                    TreeItem item = items[i];
                    int n = numItemsLeft[0];
                    numItemsLeft[0] = n - 1;
                    boolean bl = visible = n >= 0;
                    if (monitor.isCanceled() || !visible && System.currentTimeMillis() > cancelTime) {
                        canceled = true;
                    } else {
                        Object itemData = item.getData();
                        if (itemData != null) {
                            if (!item.getExpanded()) {
                                TreeFilterBoxPart.this.treeViewer.setExpandedState(itemData, true);
                            }
                            TreeItem[] children = item.getItems();
                            if (items.length > 0) {
                                canceled = this.recursiveExpand(children, monitor, cancelTime, numItemsLeft);
                            }
                        }
                    }
                    ++i;
                }
                return canceled;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (TreeFilterBoxPart.this.treeViewer.getTree().isDisposed()) {
                                return;
                            }
                            TreeFilterBoxPart.this.section.restoreCheckState();
                        }
                    });
                }
            }
        });
        return job;
    }

    public void resetFilterBoxState(boolean showFilterBox) {
        this.filterComp.setVisible(showFilterBox);
        this.showFilterBoxAction.setChecked(showFilterBox);
    }

    public void showFilterBox() {
        if (!this.filterComp.isVisible()) {
            this.resetFilterBoxState(true);
        }
    }

    public void setFilterContainerVisible(boolean visible) {
        if (visible) {
            this.viewerFilter = new OfferingOrFixFilter(this.filterOffering);
            this.treeViewer.addFilter((ViewerFilter)this.viewerFilter);
        } else if (this.viewerFilter != null) {
            this.treeViewer.removeFilter((ViewerFilter)this.viewerFilter);
            this.viewerFilter = null;
        }
        this.filterText.setText("");
        this.filterContainer.setVisible(visible);
    }

    public boolean isFilterContainerVisible() {
        return this.filterContainer.isVisible();
    }

    public void setFilterTreeViewer(TreeViewer viewer) {
        this.treeViewer = viewer;
        this.treeViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TreeFilterBoxPart.this.refreshJob.cancel();
            }
        });
    }

    public void setSelectionHint(String msg) {
        if (this.selectionHintLabel != null) {
            this.selectionHintLabel.setText(msg == null ? "" : msg);
            this.selectionHintLabel.redraw();
            Composite parent = this.selectionHintLabel.getParent();
            parent.layout();
            parent = parent.getParent();
            if (parent != null) {
                parent.layout();
                parent = parent.getParent();
                if (parent != null) {
                    parent.layout();
                }
            }
        }
    }
}

