/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.dialogs;

import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class DisplayLogDialog
extends TrayDialog {
    private final File logFile;
    private IDialogSettings dialogSettings;
    private Point dialogLocation;
    private Point dialogSize;
    private static int DIALOG_DEFAULT_WIDTH = 750;
    private static int DIALOG_DEFAULT_HEIGHT = 800;

    public DisplayLogDialog(Shell parentShell, File logFile) {
        super(parentShell);
        this.logFile = logFile;
        this.setShellStyle(3312);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.DisplayLogDialog_title);
        this.readConfiguration();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, JFaceResources.getString((String)"close"), true);
    }

    public void create() {
        super.create();
        if (this.dialogLocation != null) {
            this.getShell().setLocation(this.dialogLocation);
        }
        if (this.dialogSize != null) {
            this.getShell().setSize(this.dialogSize);
        } else {
            this.getShell().setSize(DIALOG_DEFAULT_WIDTH, DIALOG_DEFAULT_HEIGHT);
        }
        this.getButton(12).setFocus();
    }

    protected Control createDialogArea(Composite parent) {
        Composite outer = (Composite)super.createDialogArea(parent);
        Text text = new Text(outer, 527114);
        text.setBackground(DisplayKeeper.INSTANCE.getDisplay().getSystemColor(25));
        GridData gridData = new GridData(272);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)gridData);
        text.setText(this.getLogContent());
        return outer;
    }

    private String getLogContent() {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        this.readFileWithMonitor(writer);
        writer.close();
        return out.toString();
    }

    private void readFile(PrintWriter writer) throws FileNotFoundException, IOException {
        try (BufferedReader bReader = new BufferedReader(Encodings.UTF8.reader(this.logFile));){
            while (bReader.ready()) {
                writer.println(bReader.readLine());
            }
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12) {
            this.writeConfiguration();
            this.close();
        }
        super.buttonPressed(buttonId);
    }

    private void readFileWithMonitor(final PrintWriter writer) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.OpenLogDialog_message, -1);
                try {
                    try {
                        DisplayLogDialog.this.readFile(writer);
                    }
                    catch (IOException e) {
                        writer.println(Messages.DisplayLogDialog_error);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            AgentUI.getDefault().run(true, runnable);
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getCause();
            AgentUI.reportException(throwable);
        }
        catch (InterruptedException e) {
            AgentUI.reportException(e);
        }
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = AgentUI.getDefault().getDialogSettings();
        this.dialogSettings = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (this.dialogSettings == null) {
            this.dialogSettings = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return this.dialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        try {
            int x = s.getInt("x");
            int y = s.getInt("y");
            this.dialogLocation = new Point(x, y);
            x = s.getInt("width");
            y = s.getInt("height");
            this.dialogSize = new Point(x, y);
        }
        catch (NumberFormatException e) {
            this.dialogLocation = null;
            this.dialogSize = null;
        }
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        Point location = this.getShell().getLocation();
        s.put("x", location.x);
        s.put("y", location.y);
        Point size = this.getShell().getSize();
        s.put("width", size.x);
        s.put("height", size.y);
    }
}

