/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.actions;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.actions.AgentUIAction;
import com.ibm.cic.agent.internal.ui.licenses.Messages;
import com.ibm.cic.agent.internal.ui.wizards.AbstractAgentUIPrimaryPage;
import com.ibm.cic.agent.internal.ui.wizards.AvailableFixPage;
import com.ibm.cic.agent.internal.ui.wizards.AvailableOfferingPageWrapper;
import com.ibm.cic.agent.internal.ui.wizards.PrimaryInstallWizard;
import com.ibm.cic.agent.ui.extensions.AbstractAgentUIWizard;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import com.ibm.cic.common.core.utils.UserFeedback;
import com.ibm.cic.common.core.utils.UserFeedbackProvider;
import com.ibm.cic.common.ui.CICImages;
import com.ibm.cic.common.ui.internal.misc.PaUserFeedbackProvider;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class InstallAction
extends AgentUIAction {
    public InstallAction() {
    }

    public InstallAction(IWorkbenchWindow window) {
        super(window);
    }

    private List getAllOfferingsAndUpdates(SubProgressMonitor monitor) {
        monitor.setTaskName(com.ibm.cic.agent.internal.console.Messages.ProgressDialog_Obtain_offerings);
        monitor.beginTask(com.ibm.cic.agent.internal.console.Messages.ProgressDialog_Obtain_offerings, 1);
        try {
            List list = UpdateOfferingUtils.getAllOfferingsAndTheirUpdates((boolean)true, (IRepository)Agent.getInstance().getRepositoryGroup(), (boolean)true, (IProgressMonitor)monitor);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    private List getOfferingFixes(List offerings, SubProgressMonitor monitor) {
        monitor.setTaskName(com.ibm.cic.agent.internal.console.Messages.ProgressDialog_Obtain_offerings);
        monitor.beginTask(com.ibm.cic.agent.internal.console.Messages.ProgressDialog_Obtain_offerings, 1);
        LinkedList fixes = new LinkedList();
        try {
            for (IOffering offering : offerings) {
                fixes.addAll(Agent.getInstance().findFixes(true, offering, (IProgressMonitor)monitor));
            }
        }
        finally {
            monitor.done();
        }
        return fixes;
    }

    private Object[] getOfferings(Shell shell, IProgressMonitor monitor) {
        LinkedList result = new LinkedList();
        monitor.beginTask("", 2);
        try {
            SubProgressMonitor partMonitor = new SubProgressMonitor(monitor, 1);
            List offerings = this.getAllOfferingsAndUpdates(partMonitor);
            result.addAll(offerings);
            if (!monitor.isCanceled()) {
                partMonitor = new SubProgressMonitor(monitor, 1);
                result.addAll(this.getOfferingFixes(offerings, partMonitor));
            }
            Object[] objectArray = result.toArray();
            return objectArray;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected AbstractAgentUIWizard getWizard(IProgressMonitor monitor) {
        PrimaryInstallWizard wizard = new PrimaryInstallWizard(Messages.InstallWizard_installing, Messages.InstallAction_finishButtonLabel, CICImages.WIZ_INSTALL);
        AvailableOfferingPageWrapper wrapperPage = new AvailableOfferingPageWrapper(wizard);
        AvailableFixPage fixPage = new AvailableFixPage(wizard);
        wizard.setPrimaryPages(new AbstractAgentUIPrimaryPage[]{wrapperPage, fixPage});
        wizard.setHelpAvailable(true);
        Object[] offerings = this.getOfferings(wizard.getShell(), monitor);
        wizard.setInput(offerings);
        return wizard;
    }

    @Override
    public void run() {
        block5: {
            UserFeedbackProvider oldProvider = null;
            try {
                try {
                    oldProvider = UserFeedback.setProvider((UserFeedbackProvider)new PaUserFeedbackProvider());
                    this.runChecksForRepositoriesAndAgentUpdate();
                }
                catch (Exception e) {
                    AgentUI.reportException(e);
                    UserFeedback.setProvider((UserFeedbackProvider)oldProvider);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                UserFeedback.setProvider(oldProvider);
                throw throwable;
            }
            UserFeedback.setProvider((UserFeedbackProvider)oldProvider);
        }
    }
}

