/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.CacheLocationManager;
import com.ibm.cic.agent.core.StartupManager;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.core.utils.InstallJobTracker;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUIWorkbenchAdvisorListener;
import com.ibm.cic.agent.internal.ui.AgentUIWorkbenchWindowAdvisor;
import com.ibm.cic.agent.internal.ui.licenses.Messages;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.CommonImages;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.services.UiServices;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.internal.UISynchronizer;

public class AgentUIWorkbenchAdvisor
extends WorkbenchAdvisor {
    private final List listeners = new ArrayList();
    private boolean isPostStartup = false;
    private String initialWindowPerspectiveId = null;

    public AgentUIWorkbenchAdvisor() {
        AgentUI.getDefault().setWorkbenchAdvisor(this);
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new AgentUIWorkbenchWindowAdvisor(configurer);
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        configurer.setSaveAndRestore(false);
        ImageRegistry reg = JFaceResources.getImageRegistry();
        reg.put("dialog_help_image", CommonImages.DESC_HELP_ELCL);
    }

    public void preStartup() {
        super.preStartup();
        AgentUI ui = AgentUI.getDefault();
        if (ui != null) {
            ui.initializeDiskPrompterAndAuthenticationDialog();
            ui.processArguments();
        }
    }

    public void postStartup() {
        this.isPostStartup = true;
    }

    private void doAgentStartup() {
        if (AgentUI.getDefault() == null) {
            return;
        }
        AgentUI.getDefault().getAgent();
        DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean noProductInstalled;
                IStatus agentStartStatus = AgentUI.getDefault().getAgentStartStatus();
                if (!agentStartStatus.isOK()) {
                    WrapDetailUIDErrorDialog.openError((Shell)AgentUI.getActiveWorkbenchShell(), (String)com.ibm.cic.agent.internal.ui.Messages.AgentUIWorkbenchWindowAdvisor_windowTitle, null, (IStatus)agentStartStatus, (int)15);
                    AgentUIWorkbenchAdvisor.this.getWorkbenchConfigurer().getWorkbench().close();
                    return;
                }
                if (agentStartStatus.isOK() && AgentUI.getDefault().isOnlyUninstallAgentCommand() && !(noProductInstalled = CacheLocationManager.getInstance().isCacheLocationChangeable())) {
                    MessageDialog.openWarning((Shell)AgentUI.getActiveWorkbenchShell(), (String)com.ibm.cic.agent.internal.ui.Messages.AgentUIWorkbenchWindowAdvisor_windowTitle, (String)com.ibm.cic.agent.internal.ui.Messages.InstalledOfferingPage_uninstallIM_msg);
                    AgentUIWorkbenchAdvisor.this.getWorkbenchConfigurer().getWorkbench().close();
                    return;
                }
                AgentInput agentInput = AgentInput.getInstance();
                if (agentInput.getMode() == 0 && agentInput.getQuickStartMessage() != null && CmdLine.CL.isLiveInput()) {
                    MessageDialog.openInformation((Shell)AgentUI.getActiveWorkbenchShell(), (String)Messages.ManageLicanseWizardTitle, (String)agentInput.getQuickStartMessage());
                }
                AgentUI.getDefault().preprocessInputCommands();
                agentStartStatus = AgentUI.getDefault().getAgentStartStatus();
                if (StatusUtil.isErrorOrCancel((IStatus)agentStartStatus)) {
                    WrapDetailUIDErrorDialog.openError((Shell)AgentUI.getActiveWorkbenchShell(), (String)com.ibm.cic.agent.internal.ui.Messages.AgentUIWorkbenchWindowAdvisor_windowTitle, null, (IStatus)agentStartStatus, (int)15);
                    AgentUIWorkbenchAdvisor.this.getWorkbenchConfigurer().getWorkbench().close();
                    return;
                }
                IStatus status = Status.OK_STATUS;
                try {
                    status = AgentUIWorkbenchAdvisor.this.runStartupWithProgressMonitor();
                }
                catch (Exception e) {
                    status = new Status(4, Agent.PI_AGENT, 0, e.getLocalizedMessage(), (Throwable)e);
                }
                if (!status.isOK()) {
                    WrapDetailUIDErrorDialog.openError((Shell)CicCommonUiPlugin.getActiveWorkbenchShell(), (String)com.ibm.cic.agent.internal.ui.Messages.AgentUIWorkbenchWindowAdvisor_windowTitle, null, (IStatus)status, (int)15);
                }
                boolean isWizardMode = false;
                if (agentInput.getMode() == 1) {
                    isWizardMode = true;
                    int subMode = agentInput.getWizardSubMode();
                    if (subMode != 7 && subMode != 8) {
                        AgentUI.getDefault().setWizardJobs();
                    }
                    String finalPerspectiveId = agentInput.getMode() == 1 ? "com.ibm.cic.agent.ui.wizards" : "com.ibm.cic.agent.ui.quickstart";
                    for (AgentUIWorkbenchAdvisorListener listener : AgentUIWorkbenchAdvisor.this.listeners) {
                        listener.prePerspectiveChange(finalPerspectiveId);
                    }
                    AgentUI.showPerspective(finalPerspectiveId, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                } else {
                    Shell shell = CicCommonUiPlugin.getActiveWorkbenchShell();
                    if (shell != null) {
                        shell.redraw(0, 0, shell.getSize().x, shell.getSize().y, true);
                    }
                }
                IStatus wizardStatus = agentInput.getWizardStatus();
                if (wizardStatus != null && !wizardStatus.isOK()) {
                    if (CmdLine.CL.isLiveInput()) {
                        AgentUI.reportStatus(wizardStatus, false);
                    } else {
                        AgentUI.reportStatus(wizardStatus, true);
                    }
                    if (isWizardMode && wizardStatus.matches(4)) {
                        AgentUIWorkbenchAdvisor.this.getWorkbenchConfigurer().getWorkbench().close();
                    }
                }
            }
        });
    }

    public String getInitialWindowPerspectiveId() {
        if (this.initialWindowPerspectiveId == null) {
            this.doAgentStartup();
            this.initialWindowPerspectiveId = AgentInput.getInstance().getMode() == 1 ? "com.ibm.cic.agent.ui.init" : "com.ibm.cic.agent.ui.quickstart";
        }
        return this.initialWindowPerspectiveId;
    }

    public void postShutdown() {
        this.doShutdownAgent();
    }

    private synchronized void doShutdownAgent() {
        final AgentUI ui = AgentUI.getDefault();
        if (ui != null) {
            new Thread(){

                @Override
                public void run() {
                    while (UiServices.getInstance().isWebPlatformActive() && InstallJobTracker.INSTANCE.current() != null) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    ui.stopAgent();
                }
            }.start();
        }
    }

    private IStatus runStartup(IProgressMonitor monitor) {
        return StartupManager.getInstance().runStartups(monitor);
    }

    public String getMainPreferencePageId() {
        return "com.ibm.cic.agent.internal.ui.preferences.AgentMainPreferencePage";
    }

    private IStatus runStartupWithProgressMonitor() {
        final IStatus[] status = new IStatus[]{Status.OK_STATUS};
        try {
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    status[0] = AgentUIWorkbenchAdvisor.this.runStartup(monitor);
                }
            }, 1000);
        }
        catch (Exception e) {
            status[0] = new Status(4, Agent.PI_AGENT, 0, e.getLocalizedMessage(), (Throwable)e);
        }
        return status[0];
    }

    public void addListener(AgentUIWorkbenchAdvisorListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public boolean isPostStartup() {
        return this.isPostStartup;
    }

    public boolean openWindows() {
        if (Agent.getInstance().isServerMode()) {
            return super.openWindows();
        }
        final Display display = PlatformUI.getWorkbench().getDisplay();
        final boolean[] result = new boolean[1];
        final boolean[] initDone = new boolean[1];
        final boolean[] initDoneAcknowledged = new boolean[1];
        final Throwable[] error = new Throwable[1];
        Thread initThread = new Thread(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                block20: {
                    block19: {
                        block18: {
                            UISynchronizer.startupThread.set(Boolean.TRUE);
                            myConfigurer = new IWorkbenchConfigurer[1];
                            StartupThreading.runWithoutExceptions((StartupThreading.StartupRunnable)new StartupThreading.StartupRunnable(){

                                public void runWithException() throws Throwable {
                                    myConfigurer[0] = AgentUIWorkbenchAdvisor.this.getWorkbenchConfigurer();
                                }
                            });
                            status = myConfigurer[0].restoreState();
                            if (status.isOK()) ** GOTO lbl24
                            if (status.getCode() != 2) break block18;
                            result[0] = false;
                            initDone[0] = true;
                            ** while (!initDoneAcknowledged[0])
lbl-1000:
                            // 1 sources

                            {
                                display.wake();
                                try {
                                    Thread.sleep(50L);
                                }
                                catch (InterruptedException var4_4) {
                                    // empty catch block
                                }
                                continue;
                            }
lbl18:
                            // 1 sources

                            return;
                        }
                        try {
                            try {
                                if (status.getCode() == 1) {
                                    myConfigurer[0].openFirstTimeWindow();
                                }
lbl24:
                                // 4 sources

                                result[0] = true;
                                break block19;
                            }
                            catch (Throwable e) {
                                error[0] = e;
                                initDone[0] = true;
                                ** while (!initDoneAcknowledged[0])
                            }
                        }
                        catch (Throwable var3_8) {
                            initDone[0] = true;
                            ** while (!initDoneAcknowledged[0])
                        }
lbl-1000:
                        // 1 sources

                        {
                            display.wake();
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException var4_5) {
                                // empty catch block
                            }
                            continue;
lbl37:
                            // 1 sources

                            break block20;
                        }
lbl-1000:
                        // 1 sources

                        {
                            display.wake();
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException var4_6) {
                                // empty catch block
                            }
                            continue;
                        }
lbl48:
                        // 1 sources

                        throw var3_8;
                    }
                    initDone[0] = true;
                    while (!initDoneAcknowledged[0]) {
                        display.wake();
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException var4_7) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        initThread.start();
        while (true) {
            if (display.readAndDispatch()) {
                continue;
            }
            if (initDone[0]) break;
            display.sleep();
        }
        initDoneAcknowledged[0] = true;
        if (error[0] instanceof Error) {
            throw (Error)error[0];
        }
        if (error[0] instanceof RuntimeException) {
            throw (RuntimeException)error[0];
        }
        return result[0];
    }
}

