/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.IVariableProvider;
import com.ibm.cic.agent.core.SubstitutionOperation;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class VariableProvider
implements IVariableProvider {
    private static final Logger log = Logger.getLogger(VariableProvider.class);
    private static IVariableProvider variableProvider = null;
    private static final String PT_PROVIDER = "variableProvider";
    private static final String PT_CLASS_ATTR = "class";
    private ProviderData[] registeredProvidersData = null;

    public static IVariableProvider getInstance() {
        if (variableProvider == null) {
            variableProvider = new VariableProvider();
        }
        return variableProvider;
    }

    @Override
    public String substitute(SubstitutionOperation operation, String variableName, String variableArg) {
        ProviderData[] providersData = this.getProvidersData();
        String result = null;
        ProviderData[] providerDataArray = providersData;
        int n = providersData.length;
        int n2 = 0;
        while (n2 < n) {
            ProviderData providerData = providerDataArray[n2];
            IVariableProvider provider = providerData.getProvider();
            result = provider.substitute(operation, variableName, variableArg);
            if (result != null) break;
            ++n2;
        }
        return result;
    }

    private VariableProvider() {
    }

    private ProviderData[] getProvidersData() {
        if (this.registeredProvidersData == null) {
            this.registeredProvidersData = this.initializeProvidersData();
        }
        return this.registeredProvidersData;
    }

    private ProviderData[] initializeProvidersData() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(Agent.PI_AGENT, PT_PROVIDER);
        if (point == null) {
            variableProvider = new DefaultVariableProvider();
            return new ProviderData[0];
        }
        IExtension[] extensions = point.getExtensions();
        ProviderData[] result = new ProviderData[extensions.length];
        if (extensions.length == 0) {
            variableProvider = new DefaultVariableProvider();
            return result;
        }
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements;
            IExtension extension = extensions[i];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                result[i] = new ProviderData(element);
                ++n2;
            }
            ++i;
        }
        return result;
    }

    private static class DefaultVariableProvider
    implements IVariableProvider {
        private DefaultVariableProvider() {
        }

        @Override
        public String substitute(SubstitutionOperation operation, String variableName, String variableArg) {
            return null;
        }
    }

    private static class ProviderData {
        private final IConfigurationElement configElement;
        private IVariableProvider provider = null;

        public ProviderData(IConfigurationElement configElement) {
            this.configElement = configElement;
        }

        public IVariableProvider getProvider() {
            if (this.provider == null) {
                this.provider = this.createVariableProvider();
            }
            return this.provider;
        }

        private IVariableProvider createVariableProvider() {
            try {
                Object extension = this.configElement.createExecutableExtension(VariableProvider.PT_CLASS_ATTR);
                if (extension instanceof IVariableProvider) {
                    return (IVariableProvider)extension;
                }
                log.error(Messages.VariableProvider_class_for_extension_point_does_not_implement, new Object[]{this.configElement.getAttribute(VariableProvider.PT_CLASS_ATTR), VariableProvider.PT_PROVIDER, "IVariableProvider"});
                return new DefaultVariableProvider();
            }
            catch (CoreException e) {
                log.error(Messages.VariableProvider_failed_to_create_executable_extension, new Object[]{this.configElement.getAttribute(VariableProvider.PT_CLASS_ATTR), e});
                return new DefaultVariableProvider();
            }
        }
    }
}

