/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentActivator;
import com.ibm.cic.agent.core.AgentInstall;
import com.ibm.cic.agent.core.AgentSettings;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.internal.expander.ProfileSelectorExpander;
import com.ibm.cic.agent.internal.core.IdVersion;
import com.ibm.cic.agent.internal.core.InstallRegistryParser;
import com.ibm.cic.agent.internal.core.InstallRegistryXML;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.agent.internal.core.MetadataCache;
import com.ibm.cic.agent.internal.core.ProfileRegistry;
import com.ibm.cic.agent.internal.core.SimpleProfileRegistry;
import com.ibm.cic.agent.publish.InstallPublication;
import com.ibm.cic.common.core.model.ExtensionCategory;
import com.ibm.cic.common.core.model.FixUtil;
import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.model.InstallationContextScope;
import com.ibm.cic.common.core.model.Walker;
import com.ibm.cic.common.core.model.expander.ExpanderUtils;
import com.ibm.cic.common.core.model.expander.SelectorExpander;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.model.utils.SelectorContext;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.RepositorySiteProperties;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import com.ibm.cic.common.core.utils.Check;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.IdentityUtil;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.MetaInfo;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.NoTaskNameProgressMonitor;
import com.ibm.cic.common.core.utils.ReverseComparator;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.core.utils.XMLWriter;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class InstallRegistry {
    private static final Logger log = Logger.getLogger(InstallRegistry.class, (Plugin)AgentActivator.getDefault());
    private static final Logger plog = Logger.getLoggerUsingDebug((String)((Object)((Object)AgentActivator.getDefault()) + "/debug/InstallRegistry/performance"));
    private static InstallRegistry instance = null;
    private static final String METADATA_DIR = "metadata";
    private static final String ACCESS_RIGHTS = "accessRights";
    private static final String IS_DATA_PARTITION = "isDataPartition";
    private Map<String, ProfileInstallRegistry> profileRegistries;
    private ProfileRegistry profileRegistry;
    private File location;
    private IRepository metadataRepo;
    private final MetadataCache installedMetadata = new MetadataCache((IRepositoryGroup)new RepositoryGroup("InstallRegistry"));
    private String cacheLocation;
    private boolean needsUpdateVersion = false;

    public static InstallRegistry getInstance() {
        if (instance == null) {
            instance = new InstallRegistry();
        }
        return instance;
    }

    private static void setInstance(InstallRegistry registry) {
        instance = registry;
    }

    private InstallRegistry() {
        this.profileRegistries = new LinkedHashMap<String, ProfileInstallRegistry>();
        this.profileRegistry = new SimpleProfileRegistry();
    }

    public String toString() {
        if (this.location == null) {
            return "uninitialized";
        }
        return this.location + ": " + this.profileRegistries.size() + " profiles";
    }

    public String getCacheLocation() {
        return this.cacheLocation;
    }

    public ICicStatus setCacheLocation(String newCacheLocation) {
        ICicStatus return_value = ICicStatus.OK_STATUS;
        String oldValue = this.getCacheLocation();
        if (newCacheLocation != null) {
            if (oldValue == null) {
                log.info(Messages.InstallProfileRegistry_setCacheLocation, new Object[]{newCacheLocation});
            } else if (!(newCacheLocation.equals(oldValue) || oldValue.equals("C:\\IBM\\common") || oldValue.equals("/opt/IBM/common"))) {
                if (newCacheLocation.equals(CicCommonSettings.getApplicationDataLocation())) {
                    return_value = Statuses.ERROR.get(Messages.InstallProfileRegistry_changedCacheLocationToAgentDataLocation, new Object[]{oldValue, newCacheLocation});
                    log.status((IStatus)return_value);
                } else {
                    log.info(Messages.InstallProfileRegistry_changedCacheLocation, new Object[]{oldValue, newCacheLocation});
                }
            }
        }
        this.cacheLocation = newCacheLocation;
        return return_value;
    }

    public ProfileRegistry getProfileRegistry() {
        return this.profileRegistry;
    }

    public Profile getProfile(String id) {
        return this.profileRegistry.getProfile(id);
    }

    public boolean hasProfile(Profile profile) {
        Profile profile2 = this.getProfile(profile.getProfileId());
        if (profile2 == null) {
            return false;
        }
        if (profile == profile2) {
            return true;
        }
        throw new IllegalStateException("Conflicting profiles for id " + profile.getProfileId());
    }

    public void addProfile(Profile profile) {
        assert (!profile.isPhantom()) : "addProfile: profile is a phantom";
        Check.notTrue((boolean)profile.isPhantom(), (String)"addProfile: profile is a phantom: {0}", (Object[])new Object[]{profile});
        this.profileRegistry.addProfile(profile);
    }

    public void removeProfile(Profile profile) {
        this.profileRegistry.removeProfile(profile);
        this.profileRegistries.remove(profile.getProfileId());
    }

    public Profile[] getProfiles() {
        return this.profileRegistry.getProfiles();
    }

    public LinkedProperties getProperties() {
        return this.profileRegistry.getProperties();
    }

    public String getProperty(String key) {
        if ("cacheLocation".equals(key)) {
            return this.getCacheLocation();
        }
        return this.profileRegistry.getProperty(key);
    }

    public IStatus setProperty(String key, String value) {
        if ("cacheLocation".equals(key)) {
            return this.setCacheLocation(value);
        }
        return this.profileRegistry.setProperty(key, value);
    }

    private void removeProperty(String key) {
        if ("cacheLocation".equals(key)) {
            this.setCacheLocation(null);
        }
        this.profileRegistry.removeProperty(key);
    }

    void setNeedsUpdateVersion(boolean needsUpdateVersion) {
        this.needsUpdateVersion = needsUpdateVersion;
    }

    public void updateVersion() {
        if (!this.needsUpdateVersion) {
            return;
        }
        this.setNeedsUpdateVersion(false);
        InstallRegistry oldInstance = instance;
        InstallRegistry.setInstance(new InstallRegistry());
        try {
            try {
                instance.openFile(this.getLocation());
                instance.saveXML();
            }
            catch (CoreException e) {
                log.error((Throwable)e);
                instance.close();
                InstallRegistry.setInstance(oldInstance);
            }
        }
        finally {
            instance.close();
            InstallRegistry.setInstance(oldInstance);
        }
    }

    public void saveXML() throws CoreException {
        this.setNeedsUpdateVersion(false);
        this.checkMetadata();
        File xmlFile = this.getLocation();
        plog.start(plog.debug("Saving {0}", new Object[]{xmlFile}));
        if (this.isEmpty()) {
            this.removeProperty(ACCESS_RIGHTS);
            xmlFile.delete();
            if (xmlFile.exists()) {
                throw new CoreException((IStatus)Statuses.ERROR.get(Messages.InstallRegistry_Failed_To_Delete_Install_Registry, new Object[]{xmlFile}));
            }
        } else {
            CicCommonSettings.AccessRights mode = CicCommonSettings.getAccessRightsMode();
            this.setProperty(ACCESS_RIGHTS, mode.toString());
            try {
                new FileUtil.SafeUpdate(xmlFile){

                    public void write(FileOutputStream stream) throws IOException {
                        XMLWriter writer = new XMLWriter((OutputStream)stream, XML.getProcessingInstruction());
                        XML.writeInstallRegistry(writer, InstallRegistry.this);
                        writer.flush();
                        FileUtil.fdSync((FileDescriptor)stream.getFD());
                        writer.close();
                    }
                }.write();
            }
            catch (IOException e) {
                throw new CoreException((IStatus)Statuses.ERROR.get(Messages.InstallRegistry_Error_Saving, new Object[]{xmlFile, e.getMessage()}));
            }
        }
        for (final ProfileInstallRegistry registry : this.getProfileInstallRegistries()) {
            if (!registry.isDataPartitionedProfile()) continue;
            String profileDataLocation = registry.getProfile().getDataLocation();
            File profileXmlFile = new File(profileDataLocation, "installRegistry.xml");
            plog.start(plog.debug("Saving {0}", new Object[]{profileXmlFile}));
            if (registry.isEmpty()) {
                profileXmlFile.delete();
                if (profileXmlFile.exists()) {
                    throw new CoreException((IStatus)Statuses.ERROR.get(Messages.InstallRegistry_Failed_To_Delete_Install_Registry, new Object[]{profileXmlFile}));
                }
            } else {
                try {
                    new File(profileDataLocation).mkdirs();
                    new FileUtil.SafeUpdate(profileXmlFile){

                        public void write(FileOutputStream stream) throws IOException {
                            XMLWriter writer = new XMLWriter((OutputStream)stream, XML.getProcessingInstruction());
                            XML.writePartitionedInstallRegistry(writer, registry);
                            writer.flush();
                            FileUtil.fdSync((FileDescriptor)stream.getFD());
                            writer.close();
                        }
                    }.write();
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)Statuses.ERROR.get(Messages.InstallRegistry_Error_Saving, new Object[]{profileXmlFile, e.getMessage()}));
                }
            }
            plog.stop();
        }
        try {
            new InstallPublication(this, this.profileRegistry).publish();
        }
        catch (Throwable e) {
            log.error(e);
        }
        plog.stop();
    }

    public File getLocation() {
        return this.location;
    }

    private File getLegacyLocation(String subdir) {
        return InstallRegistry.getLegacyLocation(this.getLocation(), subdir);
    }

    private static File getLegacyLocation(File installRegistryLocation, String subdir) {
        String path = installRegistryLocation.getPath();
        path = path.endsWith(".xml") ? path.substring(0, path.length() - ".xml".length()) : String.valueOf(path) + ".dir";
        return new File(path, subdir);
    }

    public Profile getPhantomAgentProfile() {
        return PhantomProfileInstallRegistry.PROFILE;
    }

    public ProfileInstallRegistry getProfileInstallRegistry(Profile profile) {
        assert (!profile.isPhantom());
        String profileId = profile.getProfileId();
        ProfileInstallRegistry result = this.profileRegistries.get(profileId);
        if (result == null) {
            result = new ProfileInstallRegistry(this, profileId, null, null);
            this.profileRegistries.put(profileId, result);
        }
        return result;
    }

    public void refactorAgentProfileId(Profile profile, String newId) {
        assert (profile.isAgentProfile()) : "refactorAgentProfileId() called on non-agent profile";
        String oldId = profile.getProfileId();
        ProfileInstallRegistry registry = this.profileRegistries.remove(oldId);
        if (registry != null) {
            registry.refactorAgentProfileId(newId);
            this.profileRegistries.put(newId, registry);
        }
    }

    public boolean isOpen() {
        return this.metadataRepo != null;
    }

    @Deprecated
    public IRepository getRepository() {
        return this.metadataRepo;
    }

    public void open() throws CoreException {
        this.openFile(Agent.getInstance().getInstallRegistryLocation());
    }

    public void open(File dir) throws CoreException {
        this.openFile(new File(dir, "installRegistry.xml"));
    }

    private void openFile(File file) throws CoreException {
        if (this.isOpen()) {
            throw new CoreException((IStatus)Statuses.ERROR.get(Messages.InstallRegistry_Install_Registry_Is_Already_Open, new Object[0]));
        }
        this.location = file;
        if (this.location.isDirectory()) {
            throw new CoreException((IStatus)Statuses.ERROR.get(Messages.InstallRegistry_Install_Registry_Exists_And_Is_A_Directory, new Object[]{this.location}));
        }
        if (!this.location.exists()) {
            this.location.getParentFile().mkdirs();
            try {
                new FileOutputStream(this.location).close();
            }
            catch (IOException e) {
                throw new CoreException((IStatus)Statuses.ERROR.get((Throwable)e, e.getMessage(), new Object[0]));
            }
            this.location.delete();
        }
        File metadataDir = this.getLegacyLocation(METADATA_DIR);
        try {
            this.metadataRepo = RepositoryUtils.addOrCreateRepository((IRepositoryGroup)this.installedMetadata.getRepositoryGroup(), (File)metadataDir);
        }
        catch (RuntimeException e) {
            ExceptionUtil.debugLogToReview((Throwable)e);
        }
        if (this.metadataRepo == null) {
            throw new CoreException((IStatus)Statuses.ERROR.get(Messages.InstallRegistry_Failed_To_Create_Install_Registry_Repo, new Object[]{metadataDir}));
        }
        RepositorySiteProperties rsp = this.metadataRepo.getSiteProperties();
        String prop = rsp.getProperty("DisablePortableFilter");
        if (prop.length() == 0) {
            rsp.setProperty("DisablePortableFilter", "true");
            rsp.save();
        }
        this.metadataRepo.setOpen(true);
        this.load();
        Profile[] profileArray = this.getProfiles();
        int n = profileArray.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            profile.getInstallRegistry().initializeRepository();
            ++n2;
        }
        this.checkMetadata();
        this.checkAccessRights();
        this.checkIsDataPartition();
    }

    private void checkAccessRights() throws CoreException {
        CicCommonSettings.AccessRights imAccessRights = CicCommonSettings.getAccessRightsMode();
        String value = this.getProperty(ACCESS_RIGHTS);
        if (value == null) {
            return;
        }
        CicCommonSettings.AccessRights regAccessRights = CicCommonSettings.AccessRights.toMode((String)value);
        if (!imAccessRights.equals((Object)regAccessRights)) {
            this.checkDataLocationConflict(imAccessRights, regAccessRights);
            throw new CoreException((IStatus)Statuses.ERROR.get(Messages.InstallRegistry_Incompatible_Access_Rights, new Object[]{imAccessRights, this.location, value}));
        }
    }

    private void checkIsDataPartition() throws CoreException {
        boolean isDataPartition = Boolean.valueOf(this.getProperty(IS_DATA_PARTITION));
        if (isDataPartition) {
            throw new CoreException((IStatus)Statuses.ERROR.get(Messages.InstallRegistry_partitionedDataLocationNotSupported, new Object[]{this.location.getParent()}));
        }
    }

    private void checkDataLocationConflict(CicCommonSettings.AccessRights imAccessRights, CicCommonSettings.AccessRights regAccessRights) throws CoreException {
        String defaultAppDataLoc;
        if ("win32".equals(Platform.getOS())) {
            return;
        }
        if (!AgentInstall.getInstance().isAgentInstallerRunning()) {
            return;
        }
        File slashDir = new File("/");
        File userhome = new File(System.getProperty("user.home"));
        if (!FileUtil.filesAreSame((File)slashDir, (File)userhome)) {
            return;
        }
        if (imAccessRights.isGroupMode() || regAccessRights.isGroupMode()) {
            return;
        }
        String appDataLoc = CicCommonSettings.getApplicationDataLocation();
        if (!FileUtil.filesAreSame((String)appDataLoc, (String)(defaultAppDataLoc = CicCommonSettings.getDefaultApplicationDataLocation()))) {
            return;
        }
        throw new CoreException((IStatus)Statuses.ERROR.get(Messages.InstallRegistry_dataLocationConflict, new Object[]{imAccessRights, this.location, regAccessRights}));
    }

    public void cleanup() {
        log.debug("InstallRegistry cleanup");
        for (ProfileInstallRegistry registry : this.getProfileInstallRegistries()) {
            registry.clearCachedIUs();
        }
        this.installedMetadata.getRepositoryGroup().refresh();
    }

    public void close() {
        this.installedMetadata.getRepositoryGroup().removeAllRepositories();
        this.metadataRepo = null;
        if (this.isEmpty()) {
            this.purge();
        }
    }

    public void purge() {
        File[] locations;
        File[] fileArray = locations = this.getLocations();
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            File loc = fileArray[n2];
            loc.delete();
            ++n2;
        }
        FileUtil.rm_r((File)this.getLegacyLocation(""), (boolean)true);
    }

    public File[] getLocations() {
        File pubLoc = InstallPublication.getPublicationLocation(this);
        return new File[]{this.getLocation(), new File(pubLoc, "installed.xml"), new File(pubLoc, "installed.xsd"), new File(pubLoc, "installed.xsl")};
    }

    public Collection<ProfileInstallRegistry> getProfileInstallRegistries() {
        return this.profileRegistries.values();
    }

    public boolean isEmpty() {
        for (ProfileInstallRegistry registry : this.getProfileInstallRegistries()) {
            if (registry.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void purgeMetadata() throws CoreException {
        try {
            new Purge().purge();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)Statuses.ERROR.get((Throwable)e, e.getMessage(), new Object[0]));
        }
    }

    void saveMetadata(Profile profile, IOfferingOrFix offeringOrFix, IProgressMonitor monitor) throws CoreException {
        assert (this.isOpen()) : "InstallRegistry is not open";
        plog.start(plog.debug("Save offering or fix {0} {1}", new Object[]{offeringOrFix.getIdentity(), offeringOrFix.getVersion()}));
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(null, 1);
        monitor.subTask(Messages.InstallRegistry_Saving_Offering_Metadata);
        try {
            IOffering existing;
            IRepository profileMetadataRepo = profile.getInstallRegistry().initializeRepository();
            Object object = existing = offeringOrFix instanceof IOffering ? profileMetadataRepo.findOffering(offeringOrFix.getIdentity(), offeringOrFix.getVersion(), null) : profileMetadataRepo.findFix(offeringOrFix.getIdentity(), offeringOrFix.getVersion(), null);
            if (existing != null) {
                ConsistencyChecker.check(offeringOrFix, (IOfferingOrFix)existing);
            } else {
                IContent added = profileMetadataRepo.addContent((IContent)offeringOrFix);
                Check.notNull((Object)added);
                if (added instanceof IOffering) {
                    profileMetadataRepo.unsetUpdateOffering((IOffering)added);
                }
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)Statuses.ERROR.get((Throwable)e, e.getMessage(), new Object[0]));
        }
        monitor.done();
        plog.stop();
    }

    public void reload() throws CoreException {
        this.load();
    }

    private void load() throws CoreException {
        boolean convertFormat;
        this.profileRegistries = new LinkedHashMap<String, ProfileInstallRegistry>();
        this.profileRegistry = new SimpleProfileRegistry();
        this.setNeedsUpdateVersion(false);
        File xmlFile = this.getLocation();
        if (xmlFile.exists()) {
            try {
                InstallRegistryParser parser = new InstallRegistryParser(AgentActivator.getDefault().getContext());
                plog.start(plog.debug("Parsing {0}", new Object[]{xmlFile}));
                try {
                    parser.parse(xmlFile);
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)Statuses.ERROR.get((Throwable)e, e.getMessage(), new Object[0]));
                }
                plog.stop();
                if (!parser.getStatus().isOK()) {
                    throw new CoreException(parser.getStatus());
                }
            }
            catch (CoreException e) {
                this.installedMetadata.getRepositoryGroup().removeAllRepositories();
                this.metadataRepo = null;
                throw e;
            }
        }
        if (convertFormat = this.convertFormat()) {
            log.info(Messages.InstallRegistry_Converted_Install_Registry_Format);
            this.saveXML();
        }
    }

    private boolean convertFormat() {
        boolean result = false;
        for (ProfileInstallRegistry registry : this.getProfileInstallRegistries()) {
            result |= registry.convertFormat();
        }
        return result;
    }

    private void checkMetadata() {
        if (log.isDebugLoggable()) {
            for (ProfileInstallRegistry registry : this.getProfileInstallRegistries()) {
                try {
                    registry.checkMetadata();
                }
                catch (Exception e) {
                    log.debug("Check metadata failed: {0}", new Object[]{e.getMessage()});
                }
            }
        }
    }

    public Collection<IOfferingOrFix> findInstalledShareableEntityContainers(IIdentity seId, VersionRange tolerance, IProgressMonitor monitor) {
        assert (this.isOpen()) : "InstallRegistry is not open";
        return this.installedMetadata.findShareableEntityContainers(seId, tolerance, monitor);
    }

    private Collection<IOfferingOrFix> findShareableEntityContainers(IIdentity seId, Version version, IProgressMonitor monitor) {
        assert (this.isOpen()) : "InstallRegistry is not open";
        return this.installedMetadata.findShareableEntityContainers(seId, version, monitor);
    }

    private IShareableEntity getInstalledShareableEntity(IIdentity id, Version version) {
        assert (this.isOpen()) : "InstallRegistry is not open";
        return this.installedMetadata.findShareableEntity(id, version, null);
    }

    private static class ConsistencyChecker
    extends Walker {
        private static final Logger log2 = Logger.getLogger();
        private final SortedSet<String> trace = new TreeSet<String>();

        static void check(IOfferingOrFix newOof, IOfferingOrFix oldOof) throws CoreException {
            Set d2;
            log2.start(log2.debug("check {0}", new Object[]{newOof}));
            Check.isTrue((boolean)oldOof.getIdentity().equals(newOof.getIdentity()));
            Check.isTrue((boolean)oldOof.getVersion().equals((Object)newOof.getVersion()));
            StatusUtil.throwIfError((IStatus)RepositoryUtils.resolve((IOfferingOrFix)oldOof, null));
            StatusUtil.throwIfError((IStatus)RepositoryUtils.resolve((IOfferingOrFix)newOof, null));
            SortedSet<String> oldTrace = new ConsistencyChecker().walk(oldOof);
            SortedSet<String> newTrace = new ConsistencyChecker().walk(newOof);
            if (oldTrace.equals(newTrace)) {
                log2.stop();
                return;
            }
            Set d1 = Util.setDiff(oldTrace, newTrace);
            if (!d1.isEmpty()) {
                log2.error("In install registry but not in repository:\n  " + Util.toString((Collection)d1, (Util.Formatter)new Util.Formatter("\n  ")));
            }
            if (!(d2 = Util.setDiff(newTrace, oldTrace)).isEmpty()) {
                log2.error("In repository but not in install registry:\n  " + Util.toString((Collection)d2, (Util.Formatter)new Util.Formatter("\n  ")));
            }
            throw new CoreException((IStatus)Statuses.ERROR.get(Messages.InstallRegistry_Inconsistent_Metadata, new Object[]{oldOof.getIdentity(), oldOof.getVersion(), newOof.getRepository().getLocationStr()}));
        }

        private ConsistencyChecker() {
            this.allowUnresolvedIncludes();
        }

        private SortedSet<String> walk(IOfferingOrFix oof) {
            this.walkIncludesUnchecked((IContent)oof);
            return this.trace;
        }

        public void doAssembly(IAssembly assembly) {
            this.trace.add("assembly " + assembly.getIdentity() + ' ' + assembly.getVersion());
        }

        public void doShareableUnit(IShareableUnit su) {
            this.trace.add("SU " + su.getIdentity() + ' ' + su.getVersion());
        }

        public void doSuFragment(ISuFragment fragment) {
            this.trace.add("fragment " + fragment.getIdentity() + ' ' + fragment.getVersion());
        }

        public void doInstallableUnit(IInstallableUnit iu) {
            this.trace.add("IU " + iu.getQualifiedId() + ' ' + iu.getVersion());
        }
    }

    public static class ContextInstallRegistry {
        final InstallRegistry installRegistry;
        private ContextInstallRegistry parent;
        private String registryId;
        private final List<IdVersion> installableUnits;
        private final Map<String, ContextInstallRegistry> contextRegistries;
        private IdVersionMap shareableEntities;

        private ContextInstallRegistry(InstallRegistry installRegistry, String registryId) {
            this.installRegistry = installRegistry;
            this.registryId = registryId;
            this.contextRegistries = new LinkedHashMap<String, ContextInstallRegistry>();
            this.installableUnits = new ArrayList<IdVersion>(64);
            this.shareableEntities = null;
        }

        protected boolean isUsedByLatestContainers(IIdentity id, Version version) {
            if (this.parent == null) {
                return false;
            }
            return this.parent.isUsedByLatestContainers(id, version);
        }

        public boolean convertFormat() {
            if (!this.installableUnits.isEmpty()) {
                assert (!this.hasShareableEntities());
                return false;
            }
            assert (this.installableUnits.isEmpty());
            boolean result = false;
            if (this.hasShareableEntities()) {
                result = true;
                HashSet<IOfferingOrFix> prepared = new HashSet<IOfferingOrFix>();
                for (IIdentity id : this.shareableEntities.getIds()) {
                    Version version;
                    if (!this.isUsedByLatestContainers(id, version = this.shareableEntities.getLast(id))) continue;
                    IShareableEntity se = this.installRegistry.getInstalledShareableEntity(id, version);
                    if (se == null) {
                        throw new IllegalStateException(NLS.bind((String)Messages.InstallRegistry_No_Metadata_Found_For_Installed_Shareable_Entity, (Object)id, (Object)version));
                    }
                    if (!(se instanceof IShareableUnit)) continue;
                    Collection containers = this.installRegistry.findShareableEntityContainers(id, version, null);
                    IOfferingOrFix container = (IOfferingOrFix)containers.iterator().next();
                    assert (container != null);
                    if (prepared.add(container)) {
                        IStatus status = Agent.getInstance().prepare(container, ExtensionCategory.ALL, null);
                        log.statusNotOK(status);
                    }
                    SuSelectorExpander expander = new SuSelectorExpander(this.getProfile(), container);
                    expander.expand(se, this.shareableEntities.getSelectors(se));
                    for (IInstallableUnit iu : ExpanderUtils.getAllIUs((SelectorExpander)expander)) {
                        this.markInstalled(iu);
                    }
                }
            }
            this.shareableEntities = null;
            for (ContextInstallRegistry cr : this.getChildRegistries()) {
                result |= cr.convertFormat();
            }
            return result;
        }

        public void clearIUs() {
            this.shareableEntities = null;
            this.installableUnits.clear();
            for (ContextInstallRegistry cr : this.getChildRegistries()) {
                cr.clearIUs();
            }
        }

        public InstallContext getInstallContext() {
            if (this.parent == null || this.parent instanceof ProfileInstallRegistry) {
                Profile profile = this.getProfile();
                return profile == null ? null : profile.getRootContext();
            }
            InstallContext parentContext = this.parent.getInstallContext();
            return parentContext == null ? null : parentContext.getSubcontext(this.registryId);
        }

        public Collection<ContextInstallRegistry> getChildRegistries() {
            return this.contextRegistries.values();
        }

        void addContextInstallRegistries(Collection<ContextInstallRegistry> result) {
            for (ContextInstallRegistry cr : this.getChildRegistries()) {
                result.add(cr);
                cr.addContextInstallRegistries(result);
            }
        }

        public String getId() {
            return this.registryId;
        }

        protected void refactorAgentProfileId(String newId) {
            this.registryId = newId;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(256);
            sb.append("Install registry for ").append(this.registryId);
            if (!this.installableUnits.isEmpty()) {
                sb.append("\ninstallable units:");
                for (IdVersion iu : this.installableUnits) {
                    sb.append("\n  ").append(iu.getIdentity()).append(' ').append(iu.getVersion());
                }
            }
            if (this.hasShareableEntities()) {
                sb.append('\n').append(this.shareableEntities);
            }
            return sb.toString();
        }

        public Profile getProfile() {
            return this.parent.getProfile();
        }

        public boolean isEmpty() {
            return !this.hasShareableEntities() && this.installableUnits.isEmpty();
        }

        private boolean hasShareableEntities() {
            return this.shareableEntities != null && !this.shareableEntities.isEmpty();
        }

        public ContextInstallRegistry getContextInstallRegistry(String contextId) {
            ContextInstallRegistry result = this.contextRegistries.get(contextId);
            if (result == null) {
                result = new ContextInstallRegistry(this.installRegistry, contextId);
                result.setParent(this);
                this.contextRegistries.put(contextId, result);
            }
            return result;
        }

        public boolean hasContextInstallRegistry(String contextId) {
            return this.contextRegistries.containsKey(contextId);
        }

        public void setParent(ContextInstallRegistry parent) {
            this.parent = parent;
        }

        public Collection<IInstallableUnit> getInstalledIUs() {
            ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>(128);
            this.addInstalledIUs(result);
            return result;
        }

        void addInstalledIUs(List<IInstallableUnit> list) {
            assert (!this.hasShareableEntities());
            for (IdVersion idVersion : this.installableUnits) {
                IInstallableUnit iu = this.getInstalledIU(idVersion);
                if (iu == null) {
                    throw new IllegalStateException(NLS.bind((String)Messages.InstallRegistry_No_Metadata_Found_For_Installed_IU, (Object)idVersion.getIdentity(), (Object)idVersion.getVersion()));
                }
                list.add(iu);
            }
        }

        protected IInstallableUnit getInstalledIU(IdVersion idVersion) {
            return this.parent.getInstalledIU(idVersion);
        }

        public void markInstalled(IInstallableUnit iu) {
            this.markInstalled(new IdVersion(iu.getQualifiedId(), iu.getVersion()));
        }

        void markInstalled(IdVersion idVersion) {
            this.installableUnits.add(idVersion);
        }

        protected void emitXML(XMLWriter writer) {
            assert (!this.hasShareableEntities());
            String prevSuId = null;
            for (IdVersion iu : this.installableUnits) {
                String[] idParts = IdentityUtil.splitQualifiedId((IIdentity)iu.getIdentity());
                String suId = idParts[0];
                String iuId = idParts[1];
                if (!suId.equals(prevSuId)) {
                    if (prevSuId != null) {
                        writer.end("su");
                    }
                    writer.start("su");
                    writer.attribute("id", (Object)suId);
                    prevSuId = suId;
                }
                writer.start("iu");
                writer.attribute("id", (Object)iuId);
                writer.attribute("version", (Object)iu.getVersion());
                writer.end();
            }
            if (prevSuId != null) {
                writer.end("su");
            }
        }

        void markEntityInstalled(IContent unit, Set<String> selectorIds) {
            assert (this.installableUnits.isEmpty());
            if (this.shareableEntities == null) {
                this.shareableEntities = new IdVersionMap("entity");
            }
            for (String selectorId : selectorIds) {
                this.shareableEntities.addSelector(unit, selectorId);
            }
        }

        void markEntityUsage(IIdentity id, Version version, IIdentity refId, Version refVersion, VersionRange tolerance) {
        }

        private static class SuSelectorExpander
        extends ProfileSelectorExpander {
            private final IOfferingOrFix container;

            public SuSelectorExpander(Profile profile, IOfferingOrFix container) {
                super(profile);
                this.container = container;
            }

            public void expand(IShareableEntity se, Set<String> selectorIds) {
                this.addShareableEntity(se, Util.toSelectors((IShareableEntity)se, selectorIds));
                super.expand(null);
            }

            @Override
            protected SelectorContext createSelectorContext() {
                return new com.ibm.cic.agent.core.internal.expander.SelectorContext(this.getProfile(), this.container, Collections.EMPTY_SET);
            }
        }
    }

    private static class IdVersionMap {
        private static final Comparator<String> STRING_COMPARATOR = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareTo(s2);
            }
        };
        private static final Comparator<IIdentity> ID_COMPARATOR = new Comparator<IIdentity>(){

            @Override
            public int compare(IIdentity id1, IIdentity id2) {
                return id1.getId().compareTo(id2.getId());
            }
        };
        private static final Comparator<Version> REVERSE_COMPARATOR = new ReverseComparator();
        private final String elementName;
        private final Map<IIdentity, SortedMap<Version, VersionData>> data = new TreeMap<IIdentity, SortedMap<Version, VersionData>>(ID_COMPARATOR);

        public IdVersionMap(String elementName) {
            this.elementName = elementName;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append(this.elementName).append(" map");
            List<IIdentity> ids = this.getIds();
            if (ids.size() == 0) {
                result.append("\n  <none>");
            } else {
                for (IIdentity id : ids) {
                    result.append("\n  ").append(id).append(':');
                    for (Version version : this.getVersions(id)) {
                        result.append(' ').append(version);
                        result.append('=').append(this.getVersionData(id, version));
                    }
                }
            }
            return result.toString();
        }

        public void clear() {
            this.data.clear();
        }

        public int size() {
            return this.data.size();
        }

        public boolean isEmpty() {
            for (SortedMap<Version, VersionData> map : this.data.values()) {
                if (map.isEmpty()) continue;
                return false;
            }
            return true;
        }

        public void add(IIdentity id, Version version, VersionData v) {
            this.getMap(id).put(version, v);
        }

        public boolean contains(IContent unit) {
            return this.contains(unit.getIdentity(), unit.getVersion());
        }

        private boolean contains(IIdentity id, Version version) {
            Map innerMap = this.data.get(id);
            return innerMap != null && innerMap.containsKey(version);
        }

        public void remove(IIdentity id, Version version) {
            SortedMap<Version, VersionData> map = this.getMap(id);
            map.remove(version);
            if (map.isEmpty()) {
                this.data.remove(id);
            }
        }

        public void remove(IIdentity id) {
            this.data.remove(id);
        }

        public void emitXML(XMLWriter writer) {
            for (IIdentity id : this.getIds()) {
                writer.start(this.elementName);
                writer.attribute("id", (Object)id);
                for (Version version : this.getVersions(id)) {
                    writer.start("version");
                    writer.attribute("value", (Object)version.toString());
                    VersionData v = this.getVersionData(id, version);
                    if (v.repoInfo != null) {
                        writer.attribute("repoInfo", (Object)v.repoInfo);
                    }
                    for (String string : v.selectors) {
                        writer.start("feature");
                        writer.attribute("id", (Object)string);
                        writer.end();
                    }
                    for (Map.Entry entry : v.predefineds.entrySet()) {
                        writer.start("predefined");
                        writer.attribute("key", entry.getKey());
                        writer.attribute("value", (Object)InstallRegistryParser.serializePredefineds(entry.getValue()));
                        writer.end();
                    }
                    writer.end("version");
                }
                writer.end(this.elementName);
            }
        }

        private SortedMap<Version, VersionData> getMap(IIdentity id) {
            SortedMap<Version, VersionData> result = this.data.get(id);
            if (result == null) {
                result = new TreeMap<Version, VersionData>(REVERSE_COMPARATOR);
                this.data.put(id, result);
            }
            return result;
        }

        private VersionData getVersionData(IContent unit) {
            return this.getVersionData(unit.getIdentity(), unit.getVersion());
        }

        private VersionData getVersionData(IIdentity id, Version version) {
            SortedMap<Version, VersionData> map = this.getMap(id);
            VersionData result = (VersionData)map.get(version);
            if (result == null) {
                result = new VersionData();
                map.put(version, result);
            }
            return result;
        }

        private VersionData getVersionDataNoAdd(IContent unit) {
            SortedMap<Version, VersionData> map = this.data.get(unit.getIdentity());
            VersionData result = map == null ? null : (VersionData)map.get(unit.getVersion());
            return result == null ? VersionData.EMPTY : result;
        }

        public void addSelector(IContent unit, String selectorId) {
            this.getVersionData((IContent)unit).selectors.add(selectorId);
        }

        public void addFeature(IContent offeringOrFix, String featureId) {
            this.addSelector(offeringOrFix, featureId);
        }

        public void setPredefineds(IContent unit, Map<String, Object> predefineds) {
            this.getVersionData((IContent)unit).predefineds = predefineds;
        }

        public void setRepositoryInfo(IContent unit, String repoInfo) {
            this.getVersionData((IContent)unit).repoInfo = repoInfo;
        }

        public void clearFeatures(IOffering offering) {
            this.getVersionData((IContent)offering).selectors.clear();
        }

        public Set<String> getSelectors(IShareableEntity entity) {
            return Collections.unmodifiableSet(this.getVersionDataNoAdd((IContent)entity).selectors);
        }

        public Set<String> getFeatures(IOffering offering) {
            return Collections.unmodifiableSet(this.getVersionDataNoAdd((IContent)offering).selectors);
        }

        public String getRepositoryInfo(IOfferingOrFix offeringOrFix) {
            return this.getVersionDataNoAdd((IContent)offeringOrFix).repoInfo;
        }

        public List<IIdentity> getIds() {
            Set<Map.Entry<IIdentity, SortedMap<Version, VersionData>>> entrySet = this.data.entrySet();
            ArrayList<IIdentity> result = new ArrayList<IIdentity>(entrySet.size());
            for (Map.Entry<IIdentity, SortedMap<Version, VersionData>> entry : entrySet) {
                IIdentity id = entry.getKey();
                Map map = entry.getValue();
                if (map.size() <= 0) continue;
                result.add(id);
            }
            return result;
        }

        public Set<Version> getVersions(IIdentity id) {
            return this.getMap(id).keySet();
        }

        public Version getLast(IIdentity id) {
            SortedMap<Version, VersionData> map = this.data.get(id);
            return map == null || map.isEmpty() ? null : map.firstKey();
        }

        public boolean isLast(IIdentity id, Version version) {
            return version.equals((Object)this.getLast(id));
        }

        static /* synthetic */ Comparator access$0() {
            return STRING_COMPARATOR;
        }

        private static class VersionData {
            public static final VersionData EMPTY = new VersionData();
            public Set<String> selectors = new TreeSet<String>(IdVersionMap.access$0());
            public Map<String, Object> predefineds = Collections.emptyMap();
            public String repoInfo = null;

            private VersionData() {
            }

            public String toString() {
                String result = this.selectors.toString();
                if (!this.predefineds.isEmpty()) {
                    result = String.valueOf(result) + ',' + this.predefineds.toString();
                }
                return result;
            }
        }
    }

    private static class IuCache {
        public static final Logger clog = Logger.getLogger(IuCache.class);
        private final ProfileInstallRegistry registry;
        private Map<IdVersion, IInstallableUnit> ius = null;

        public IuCache(ProfileInstallRegistry registry) {
            this.registry = registry;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(64);
            sb.append("IuCache for ");
            sb.append(this.registry.profileId);
            sb.append(": ");
            if (this.ius == null) {
                sb.append("uninitialized");
            } else {
                sb.append(this.ius.size()).append(" ius");
            }
            return sb.toString();
        }

        public void clear() {
            clog.start(clog.debug("Clearing {0}", new Object[]{this}));
            this.ius = null;
            clog.stop();
        }

        public void populate(IProgressMonitor monitor) {
            if (this.ius != null) {
                return;
            }
            this.ius = new HashMap<IdVersion, IInstallableUnit>(64);
            SplitProgressMonitor pm = new SplitProgressMonitor(monitor, new int[]{10, 1});
            clog.start(clog.debug("Populating IU cache"));
            this.collect((IOfferingOrFix[])this.registry.getInstalledOfferings(), pm.next());
            this.collect((IOfferingOrFix[])this.registry.getInstalledFixes(), pm.next());
            clog.stop();
            clog.debug("Populated {0}", new Object[]{this});
        }

        private void collect(IOfferingOrFix[] pkgs, IProgressMonitor monitor) {
            SplitProgressMonitor pm = new SplitProgressMonitor(monitor, pkgs.length);
            IOfferingOrFix[] iOfferingOrFixArray = pkgs;
            int n = pkgs.length;
            int n2 = 0;
            while (n2 < n) {
                IOfferingOrFix pkg = iOfferingOrFixArray[n2];
                this.collect(pkg, pm.next());
                if (pm.isCanceled()) {
                    return;
                }
                ++n2;
            }
        }

        private void collect(IOfferingOrFix pkg, IProgressMonitor monitor) {
            SplitProgressMonitor pm = new SplitProgressMonitor((IProgressMonitor)new NoTaskNameProgressMonitor(monitor), 2);
            boolean wasResolved = pkg.isResolved();
            if (!wasResolved) {
                clog.statusNotOK(RepositoryUtils.resolve((IOfferingOrFix)pkg, (IProgressMonitor)pm.next()));
            }
            try {
                try {
                    new IuWalker().walkIncludes((IContent)pkg, pm.next());
                }
                catch (InvocationTargetException e) {
                    throw new AssertionError((Object)e);
                }
            }
            finally {
                if (!wasResolved) {
                    RepositoryUtils.unresolve((IOfferingOrFix)pkg);
                }
            }
        }

        public IInstallableUnit getIU(IdVersion idVersion) {
            if (this.ius == null) {
                throw new IuCacheStateException();
            }
            return this.ius.get(idVersion);
        }

        void addIU(IInstallableUnit iu) {
            this.ius.put(new IdVersion(iu.getQualifiedId(), iu.getVersion()), iu);
        }

        public static final class IuCacheStateException
        extends IllegalStateException {
            public IuCacheStateException() {
                super("IU Cache accessed before being initialized");
            }
        }

        private class IuWalker
        extends Walker {
            private IuWalker() {
            }

            public boolean canHaveUnresolvedIncludes() {
                return true;
            }

            public void doInstallableUnit(IInstallableUnit iu) {
                IuCache.this.addIU(iu);
            }
        }
    }

    private static class PhantomProfileInstallRegistry
    extends ProfileInstallRegistry {
        private static final String PROFILE_ID = "Phantom Agent Profile";
        static final Profile PROFILE = new Profile("Phantom Agent Profile", "self"){

            @Override
            public boolean isPhantom() {
                return true;
            }

            @Override
            public ProfileInstallRegistry getInstallRegistry() {
                return new PhantomProfileInstallRegistry();
            }
        };

        PhantomProfileInstallRegistry() {
            super(InstallRegistry.getInstance(), PROFILE_ID);
        }

        @Override
        public Profile getProfile() {
            return PROFILE;
        }

        @Override
        public void refactorAgentProfileId(String newId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ContextInstallRegistry getContextInstallRegistry(String contextId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void commit(IProgressMonitor monitor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void markInstalledOfferings(Map<IOffering, Collection<IFeature>> offeringMap) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void markInstalledFixes(Set<IFix> fixSet) {
            throw new UnsupportedOperationException();
        }
    }

    public static class ProfileInstallRegistry
    extends ContextInstallRegistry {
        private String profileId;
        private final IdVersionMap offerings;
        private final IdVersionMap fixes;
        private final IuCache iuCache = new IuCache(this);
        private IRepository metadataRepo;

        private ProfileInstallRegistry(InstallRegistry installRegistry, String profileId) {
            super(installRegistry, profileId);
            this.setParent(this);
            this.profileId = profileId;
            this.offerings = new IdVersionMap("offering");
            this.fixes = new IdVersionMap("fix");
            this.metadataRepo = null;
        }

        private void deleteRepository() {
            if (this.metadataRepo != null) {
                this.metadataRepo.delete(true);
                this.metadataRepo = null;
            }
        }

        private IRepository initializeRepository() throws CoreException {
            if (this.metadataRepo == null) {
                if (this.isDataPartitionedProfile()) {
                    File profileXmlFile = new File(this.getProfile().getDataLocation(), "installRegistry.xml");
                    File metadataDir = InstallRegistry.getLegacyLocation(profileXmlFile, InstallRegistry.METADATA_DIR);
                    this.metadataRepo = RepositoryUtils.addOrCreateRepository((IRepositoryGroup)this.installRegistry.installedMetadata.getRepositoryGroup(), (File)metadataDir);
                    if (this.metadataRepo == null) {
                        throw new CoreException((IStatus)Statuses.ERROR.get(Messages.InstallRegistry_Failed_To_Create_Install_Registry_Repo, new Object[]{metadataDir}));
                    }
                    this.metadataRepo.setOpen(true);
                } else {
                    this.metadataRepo = this.installRegistry.metadataRepo;
                }
            }
            return this.metadataRepo;
        }

        public IRepository getRepository() {
            return this.metadataRepo;
        }

        public void clear() {
            super.clearIUs();
            this.offerings.clear();
            this.fixes.clear();
        }

        public boolean isAgentProfile() {
            Profile profile = this.getProfile();
            return profile != null && profile.isAgentProfile();
        }

        public boolean isPortableProfile() {
            Profile profile = this.getProfile();
            return profile != null && profile.isPortable();
        }

        public boolean isLicenseProfile() {
            Profile profile = this.getProfile();
            return profile != null && profile.isLicenseProfile();
        }

        public boolean isDataPartitionedProfile() {
            Profile profile = this.getProfile();
            return profile != null && profile.isDataPartitioned();
        }

        @Override
        public void refactorAgentProfileId(String newId) {
            assert (this.isAgentProfile()) : "refactorAgentProfileId() called on non-agent profile";
            super.refactorAgentProfileId(newId);
            this.profileId = newId;
        }

        @Override
        public String toString() {
            return NLS.bind((String)"Profile {0}\n{1}\n{2}", (Object[])new Object[]{super.toString(), this.offerings, this.fixes});
        }

        public String contentsToString() {
            StringBuffer sb = new StringBuffer();
            if (this.offerings.size() > 0) {
                sb.append(this.offerings.toString());
            }
            if (this.fixes.size() > 0) {
                if (this.offerings.size() > 0) {
                    sb.append(Logger.NEWLINE);
                }
                sb.append(this.fixes.toString());
            }
            return sb.toString();
        }

        public String getProfileId() {
            return this.profileId;
        }

        @Override
        public Profile getProfile() {
            return this.installRegistry.getProfile(this.profileId);
        }

        @Override
        public boolean isEmpty() {
            return this.offerings.isEmpty() && this.fixes.isEmpty() && super.isEmpty();
        }

        public Collection<ContextInstallRegistry> getContextInstallRegistries() {
            ArrayList<ContextInstallRegistry> result = new ArrayList<ContextInstallRegistry>(4);
            this.addContextInstallRegistries(result);
            return result;
        }

        @Override
        public ContextInstallRegistry getContextInstallRegistry(String contextId) {
            int i = contextId.lastIndexOf(47);
            if (i < 0) {
                return super.getContextInstallRegistry(contextId);
            }
            String parentId = contextId.substring(0, i);
            String childId = contextId.substring(i + 1);
            return this.getContextInstallRegistry(parentId).getContextInstallRegistry(childId);
        }

        @Override
        public boolean hasContextInstallRegistry(String contextId) {
            int i = contextId.lastIndexOf(47);
            if (i < 0) {
                return super.hasContextInstallRegistry(contextId);
            }
            String parentId = contextId.substring(0, i);
            String childId = contextId.substring(i + 1);
            return this.getContextInstallRegistry(parentId).hasContextInstallRegistry(childId);
        }

        IdVersionMap getOfferings() {
            return this.offerings;
        }

        IdVersionMap getFixes() {
            return this.fixes;
        }

        public void resolveIUs(IProgressMonitor monitor) {
            this.iuCache.populate(monitor);
        }

        void clearCachedIUs() {
            this.iuCache.clear();
        }

        @Override
        protected IInstallableUnit getInstalledIU(IdVersion idVersion) {
            IInstallableUnit iu = this.iuCache.getIU(idVersion);
            if (iu == null) {
                throw new IllegalStateException(NLS.bind((String)Messages.InstallRegistry_No_Metadata_Found_For_Installed_IU, (Object)idVersion.getIdentity(), (Object)idVersion.getVersion()));
            }
            return iu;
        }

        @Override
        public void emitXML(XMLWriter writer) {
            this.offerings.emitXML(writer);
            this.fixes.emitXML(writer);
            super.emitXML(writer);
        }

        public void commit(IProgressMonitor monitor) throws CoreException {
            SplitProgressMonitor pm = new SplitProgressMonitor(monitor, Messages.Director_Saving_Install_Registry, new int[]{1, 10 * this.offerings.size(), 2 * this.fixes.size()});
            this.installRegistry.saveXML();
            pm.next();
            IProgressMonitor sub1 = pm.next();
            sub1.beginTask(Messages.InstallRegistry_Saving_Offering_Metadata, this.offerings.size());
            sub1.subTask("");
            log.start(log.debug("Saving installed metadata"));
            try {
                for (IIdentity id : this.offerings.getIds()) {
                    this.saveOfferingMetadata(id, this.getInstalledVersion(id));
                    sub1.worked(1);
                }
                IProgressMonitor sub2 = pm.next();
                sub2.beginTask(Messages.InstallRegistry_Saving_Fix_Metadata, this.fixes.size());
                for (IIdentity id : this.fixes.getIds()) {
                    this.saveFixMetadata(id, this.fixes.getLast(id));
                    sub2.worked(1);
                }
                log.stop();
            }
            catch (IOException e) {
                throw new CoreException((IStatus)Statuses.ERROR.get((Throwable)e, e.getMessage(), new Object[0]));
            }
        }

        private void saveOfferingMetadata(IIdentity id, Version version) throws IOException, CoreException {
            assert (this.installRegistry.isOpen()) : "InstallRegistry is not open";
            plog.start(plog.debug("Save offering {0} {1}", new Object[]{id, version}));
            this.initializeRepository();
            if (UpdateOfferingUtils.findOfferingOrUpdate((IRepository)this.getRepository(), (IIdentity)id, (Version)version, (IProgressMonitor)new NullProgressMonitor()) == null) {
                IOffering offering = UpdateOfferingUtils.findOfferingOrUpdate((IRepository)RepositoryGroup.getDefault(), (IIdentity)id, (Version)version, (IProgressMonitor)new NullProgressMonitor());
                this.getRepository().addContent((IContent)offering);
                log.debug("Added to internal repository: {0}", new Object[]{offering});
            }
            plog.stop();
        }

        private void saveFixMetadata(IIdentity id, Version version) throws IOException, CoreException {
            assert (this.installRegistry.isOpen()) : "InstallRegistry is not open";
            plog.start(plog.debug("Save offering {0} {1}", new Object[]{id, version}));
            this.initializeRepository();
            if (this.getRepository().findFix(id, version, null) == null) {
                IFix fix = RepositoryGroup.getDefault().findFix(id, version, null);
                this.getRepository().addContent((IContent)fix);
                log.debug("Added to internal repository {0}", new Object[]{fix});
            }
            plog.stop();
        }

        public void markInstalledOfferings(Map<IOffering, Collection<IFeature>> offeringMap) {
            this.clearCachedIUs();
            HashSet<IIdentity> nowInstalled = new HashSet<IIdentity>();
            for (Map.Entry<IOffering, Collection<IFeature>> entry : offeringMap.entrySet()) {
                IOffering offering = entry.getKey();
                this.removeLaterVersions((IOfferingOrFix)offering);
                this.offerings.clearFeatures(offering);
                for (IFeature feature : entry.getValue()) {
                    this.offerings.addFeature((IContent)offering, feature.getIdentity().getId());
                }
                this.setRepoInfo(this.offerings, (IOfferingOrFix)offering);
                nowInstalled.add(offering.getIdentity());
            }
            for (IIdentity id : this.offerings.getIds()) {
                if (nowInstalled.contains(id)) continue;
                this.offerings.remove(id);
            }
            this.getProfile().cleanUserData(nowInstalled);
        }

        public void markInstalledFixes(Set<IFix> fixSet) {
            this.clearCachedIUs();
            HashSet<IIdentity> nowInstalled = new HashSet<IIdentity>();
            for (IFix fix : fixSet) {
                this.removeLaterVersions((IOfferingOrFix)fix);
                this.fixes.setPredefineds((IContent)fix, Collections.emptyMap());
                this.setRepoInfo(this.fixes, (IOfferingOrFix)fix);
                nowInstalled.add(fix.getIdentity());
            }
            for (IIdentity id : this.fixes.getIds()) {
                if (nowInstalled.contains(id)) continue;
                this.fixes.remove(id);
            }
        }

        private void removeLaterVersions(IOfferingOrFix offeringOrFix) {
            Version last;
            IdVersionMap map = this.getOfferingOrFixMap(offeringOrFix);
            IIdentity id = offeringOrFix.getIdentity();
            Version version = offeringOrFix.getVersion();
            while ((last = map.getLast(id)) != null && last.compareTo(version) > 0) {
                map.remove(id, last);
            }
        }

        @Override
        void markInstalled(IdVersion idVersion) {
            assert (false);
        }

        public IOffering getInstalledOffering(IIdentity id) {
            return (IOffering)this.getInstalledOfferingOrFix(id, this.getInstalledVersion(id));
        }

        public IFix getInstalledFix(IIdentity id) {
            return (IFix)this.getInstalledOfferingOrFix(id, this.fixes.getLast(id));
        }

        public IOffering[] getInstalledOfferings(IIdentity id) {
            Set<Version> versions = this.offerings.getVersions(id);
            IOffering[] result = new IOffering[versions.size()];
            int n = 0;
            for (Version version : versions) {
                IOffering offering = (IOffering)this.getInstalledOfferingOrFix(id, version);
                if (offering == null) {
                    throw new IllegalStateException(NLS.bind((String)Messages.InstallRegistry_No_Metadata_Found_For_Installed_Offering, (Object)id, (Object)version));
                }
                result[n++] = offering;
            }
            return result;
        }

        public IOffering[] getInstalledOfferings() {
            List<IIdentity> ids = this.offerings.getIds();
            IOffering[] result = new IOffering[ids.size()];
            int n = 0;
            for (IIdentity id : ids) {
                IOffering offering = this.getInstalledOffering(id);
                if (offering == null) {
                    throw new IllegalStateException(NLS.bind((String)Messages.InstallRegistry_No_Metadata_Found_For_Installed_Offering, (Object)id, (Object)this.getInstalledVersion(id)));
                }
                result[n++] = offering;
            }
            return result;
        }

        public IFix[] getInstalledFixes() {
            List<IIdentity> ids = this.fixes.getIds();
            IFix[] result = new IFix[ids.size()];
            int n = 0;
            for (IIdentity id : ids) {
                IFix fix = this.getInstalledFix(id);
                if (fix == null) {
                    throw new IllegalStateException(NLS.bind((String)Messages.InstallRegistry_No_Metadata_Found_For_Installed_Fix, (Object)id, (Object)this.fixes.getLast(id)));
                }
                result[n++] = fix;
            }
            return result;
        }

        public IFix[] getInstalledFixes(IOffering offering) {
            IIdentity offeringId = offering.getIdentity();
            Version offeringVersion = offering.getVersion();
            return this.getInstalledFixes(offeringId, offeringVersion);
        }

        public IFix[] getInstalledFixes(IIdentity offeringId, Version offeringVersion) {
            List<IIdentity> ids = this.fixes.getIds();
            ArrayList<IFix> result = new ArrayList<IFix>(ids.size());
            for (IIdentity id : ids) {
                IFix fix = this.getInstalledFix(id);
                if (fix == null) {
                    throw new IllegalStateException(NLS.bind((String)Messages.InstallRegistry_No_Metadata_Found_For_Installed_Fix, (Object)id, (Object)this.fixes.getLast(id)));
                }
                if (!FixUtil.isFixApplicable((IFix)fix, (IIdentity)offeringId, (Version)offeringVersion)) continue;
                result.add(fix);
            }
            return result.toArray(new IFix[result.size()]);
        }

        public String getInstalledRepositoryInfo(IOfferingOrFix offeringOrFix) {
            if (offeringOrFix instanceof IOffering) {
                return this.offerings.getRepositoryInfo(offeringOrFix);
            }
            return this.fixes.getRepositoryInfo(offeringOrFix);
        }

        public Set<String> getInstalledFeatureIds(IOffering offering) {
            return this.offerings.getFeatures(offering);
        }

        public Set<IFeature> getInstalledFeatures(IOffering offering) {
            return OfferingUtil.toFeatures((IOffering)offering, this.getInstalledFeatureIds(offering));
        }

        public IFeature[] getInstalledFeaturesAsArray(IOffering offering) {
            return OfferingUtil.toFeaturesAsArray((IOffering)offering, this.getInstalledFeatureIds(offering));
        }

        public Collection<IInstallableUnit> getAllInstalledIUs(IProgressMonitor monitor) {
            this.resolveIUs(monitor);
            ArrayList<IInstallableUnit> list = new ArrayList<IInstallableUnit>(128);
            assert (((ContextInstallRegistry)this).installableUnits.isEmpty());
            for (ContextInstallRegistry reg : this.getContextInstallRegistries()) {
                reg.addInstalledIUs(list);
            }
            return list;
        }

        public boolean isInstalled(IOfferingOrFix offeringOrFix) {
            if (offeringOrFix instanceof IOffering) {
                return this.offerings.contains((IContent)offeringOrFix);
            }
            if (offeringOrFix instanceof IFix) {
                return this.fixes.contains((IContent)offeringOrFix);
            }
            assert (false) : offeringOrFix;
            return false;
        }

        public boolean isInstalled(IOffering offering) {
            return this.offerings.contains((IContent)offering);
        }

        public boolean isInstalled(IFix fix) {
            return this.fixes.contains((IContent)fix);
        }

        void markOfferingInstalled(IContent unit, String repoInfo, Set<String> featureIds, Map<String, Object> predefineds) {
            this.offerings.setRepositoryInfo(unit, repoInfo);
            for (String featureId : featureIds) {
                this.offerings.addFeature(unit, featureId);
            }
            this.offerings.setPredefineds(unit, predefineds);
        }

        void markFixInstalled(IContent unit, String repoInfo, Set<String> featureIds, Map<String, Object> predefineds) {
            this.fixes.setRepositoryInfo(unit, repoInfo);
            for (String featureId : featureIds) {
                this.fixes.addFeature(unit, featureId);
            }
            this.fixes.setPredefineds(unit, predefineds);
        }

        public IOfferingOrFix getInstalledOfferingOrFix(IIdentity id, Version version) {
            assert (this.installRegistry.isOpen()) : "InstallRegistry is not open";
            if (version == null) {
                return null;
            }
            if (this.getRepository() == null) {
                return null;
            }
            IOffering offering = this.getRepository().findOffering(id, version, null);
            return offering != null ? offering : this.getRepository().findFix(id, version, null);
        }

        private Version getInstalledVersion(IIdentity id) {
            return this.offerings.getLast(id);
        }

        private IdVersionMap getOfferingOrFixMap(IOfferingOrFix offeringOrFix) {
            return offeringOrFix instanceof IOffering ? this.offerings : (offeringOrFix instanceof IFix ? this.fixes : null);
        }

        void checkMetadata() throws CoreException {
            this.checkMetadata(this.offerings);
            this.checkMetadata(this.fixes);
        }

        private void checkMetadata(IdVersionMap map) throws CoreException {
            for (IIdentity id : map.getIds()) {
                Version version;
                if (this.getInstalledOfferingOrFix(id, version = map.getLast(id)) != null) continue;
                throw new CoreException((IStatus)Statuses.ERROR.get(Messages.InstallRegistry_No_Metadata_Found_For_Installed_Offering, new Object[]{id, version}));
            }
        }

        private void setRepoInfo(IdVersionMap map, IOfferingOrFix offeringOrFix) {
            String repoInfo = map.getRepositoryInfo(offeringOrFix);
            IRepository repo = offeringOrFix.getRepository();
            if (repo == null) {
                log.debug("Failed to get repository for {0}. Keeping existing repoInfo={1}", new Object[]{offeringOrFix, repoInfo});
            } else if (repo.equals(this.getRepository())) {
                log.debug("Offering is from install registry. Keeping existing repoInfo={0}", new Object[]{repoInfo});
            } else {
                repoInfo = repo.serializeRepositoryInfo();
                log.debug("Save offering repository in install registry repoInfo={0}", new Object[]{repoInfo});
            }
            map.setRepositoryInfo((IContent)offeringOrFix, repoInfo);
        }

        @Override
        protected boolean isUsedByLatestContainers(IIdentity id, Version version) {
            Collection containers = this.installRegistry.findShareableEntityContainers(id, version, null);
            for (IOfferingOrFix offeringOrFix : containers) {
                IIdentity offeringOrFixId = offeringOrFix.getIdentity();
                Version offeringOrFixVersion = offeringOrFix.getVersion();
                boolean isLast = false;
                if (offeringOrFix instanceof IOffering) {
                    isLast = this.offerings.isLast(offeringOrFixId, offeringOrFixVersion);
                } else if (offeringOrFix instanceof IFix) {
                    isLast = this.fixes.isLast(offeringOrFixId, offeringOrFixVersion);
                }
                if (!isLast) continue;
                return true;
            }
            return false;
        }

        /* synthetic */ ProfileInstallRegistry(InstallRegistry installRegistry, String string, ProfileInstallRegistry profileInstallRegistry, ProfileInstallRegistry profileInstallRegistry2) {
            this(installRegistry, string);
        }
    }

    private class Purge {
        private final IdVersionMap neededForGlobal = new IdVersionMap("neededForGlobal");

        private Purge() {
        }

        public void purge() throws IOException {
            for (ProfileInstallRegistry profileInstallRegistry : InstallRegistry.this.getProfileInstallRegistries()) {
                if (profileInstallRegistry.isDataPartitionedProfile()) {
                    if (profileInstallRegistry.getRepository() == null) continue;
                    IdVersionMap neededForProfile = new IdVersionMap("neededForProfile");
                    this.markNeeded(neededForProfile, profileInstallRegistry.getOfferings());
                    this.markNeeded(neededForProfile, profileInstallRegistry.getFixes());
                    this.removeUnneeded(profileInstallRegistry.getRepository(), neededForProfile, UpdateOfferingUtils.getAllOfferingsAndTheirUpdates((IRepository)profileInstallRegistry.getRepository(), (boolean)true, (IProgressMonitor)new NullProgressMonitor()));
                    this.removeUnneeded(profileInstallRegistry.getRepository(), neededForProfile, profileInstallRegistry.getRepository().getAllFixes(null));
                    if (profileInstallRegistry.getRepository().containsMetadata()) continue;
                    InstallRegistry.this.installedMetadata.getRepositoryGroup().removeRepository(profileInstallRegistry.getRepository());
                    profileInstallRegistry.deleteRepository();
                    continue;
                }
                this.markNeeded(this.neededForGlobal, profileInstallRegistry.getOfferings());
                this.markNeeded(this.neededForGlobal, profileInstallRegistry.getFixes());
            }
            this.removeUnneeded(InstallRegistry.this.metadataRepo, this.neededForGlobal, UpdateOfferingUtils.getAllOfferingsAndTheirUpdates((IRepository)InstallRegistry.this.metadataRepo, (boolean)true, (IProgressMonitor)new NullProgressMonitor()));
            this.removeUnneeded(InstallRegistry.this.metadataRepo, this.neededForGlobal, InstallRegistry.this.metadataRepo.getAllFixes(null));
            InstallRegistry.this.installedMetadata.markDirty();
        }

        private void markNeeded(IdVersionMap needed, IdVersionMap map) {
            for (IIdentity id : map.getIds()) {
                for (Version version : map.getVersions(id)) {
                    needed.add(id, version, null);
                }
            }
        }

        private void removeUnneeded(IRepository repository, IdVersionMap needed, List<IContent> units) throws IOException {
            for (IContent unit : units) {
                if (needed.contains(unit)) continue;
                repository.deleteContent(unit);
            }
        }
    }

    private static class XML
    implements InstallRegistryXML {
        private XML() {
        }

        public static XMLWriter.ProcessingInstruction getProcessingInstruction() {
            return new XMLWriter.ProcessingInstruction("installRegistry", MetaInfo.formatVersion((Version)AgentSettings.getRunningAgentVersion()));
        }

        public static void writeInstallRegistry(XMLWriter writer, InstallRegistry ir) {
            writer.start("installRegistry");
            writer.write(ir.profileRegistry.getProperties());
            if (ir.getCacheLocation() != null) {
                writer.writeProperty("cacheLocation", ir.getCacheLocation());
            }
            for (ProfileInstallRegistry registry : ir.getProfileInstallRegistries()) {
                if (registry.isEmpty()) continue;
                if (registry.isDataPartitionedProfile()) {
                    writer.start("linkTo");
                    writer.attribute("dir", (Object)registry.getProfile().getDataLocation());
                    writer.end();
                    continue;
                }
                XML.writeProfile(writer, registry);
            }
            writer.end("installRegistry");
        }

        public static void writePartitionedInstallRegistry(XMLWriter writer, ProfileInstallRegistry profileInstallRegistry) {
            if (!profileInstallRegistry.isEmpty()) {
                writer.start("installRegistry");
                Profile profile = profileInstallRegistry.getProfile();
                writer.writeProperty(InstallRegistry.ACCESS_RIGHTS, CicCommonSettings.getAccessRightsMode().toString());
                if (profile.getCacheLocation() != null) {
                    writer.writeProperty("cacheLocation", profile.getCacheLocation());
                }
                writer.writeProperty(InstallRegistry.IS_DATA_PARTITION, "true");
                writer.start("linkFrom");
                writer.attribute("dir", (Object)CicCommonSettings.getApplicationDataLocation());
                writer.end();
                XML.writeProfile(writer, profileInstallRegistry);
                writer.end("installRegistry");
            }
        }

        private static void writeProfile(XMLWriter writer, ProfileInstallRegistry profileInstallRegistry) {
            writer.start("profile");
            Profile profile = profileInstallRegistry.getProfile();
            writer.attribute("id", (Object)profile.getProfileId());
            writer.attribute("kind", (Object)profile.getProfileKind());
            writer.writeProperty("installLocation", profile.getInstallLocation());
            LinkedProperties data = profile.getAllData();
            String[] stringArray = data.getPropertyKeys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (!profile.isSensitiveUserData(key)) {
                    writer.writeProperty(key, data.getProperty(key));
                }
                ++n2;
            }
            profileInstallRegistry.emitXML(writer);
            InstallContext rootContext = profile.getRootContext();
            if (rootContext != null) {
                XML.writeInstallContext(writer, rootContext);
            }
            writer.end("profile");
        }

        private static void writeInstallContext(XMLWriter writer, InstallContext installContext) {
            InstallContext[] subcontexts;
            String[] adapterTypes;
            writer.start("installContext");
            writer.attribute("id", (Object)installContext.getId());
            writer.attribute("name", (Object)installContext.getName());
            writer.attribute("description", (Object)installContext.getDescription());
            writer.attribute("shareable", installContext.isShareable(), true);
            writer.attribute("qualifiable", installContext.isQualifiable(), false);
            InstallationContextScope scope = installContext.getScope();
            if (scope != InstallationContextScope.NONE_SCOPE) {
                writer.attribute("scope", (Object)scope.getName());
            }
            writer.write(installContext.getLocalProperties());
            String[] stringArray = adapterTypes = installContext.getAdaptorTypes();
            int n = adapterTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String adapterType = stringArray[n2];
                writer.start("adapter");
                writer.attribute("type", (Object)adapterType);
                writer.end();
                ++n2;
            }
            installContext.getInstallRegistry().emitXML(writer);
            InstallContext[] installContextArray = subcontexts = installContext.getSubcontexts();
            int n3 = subcontexts.length;
            n = 0;
            while (n < n3) {
                InstallContext subcontext = installContextArray[n];
                XML.writeInstallContext(writer, subcontext);
                ++n;
            }
            writer.end("installContext");
        }
    }
}

