/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.IAgent;
import com.ibm.cic.agent.core.api.IAgentJob;
import com.ibm.cic.agent.core.api.IDependencyExtender;
import com.ibm.cic.agent.core.api.IDependencyValidationContext;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.ExtensionBundleUtils;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class DependencyExtenderManager {
    private static final Logger log = Logger.getLogger(DependencyExtenderManager.class);
    private static final String NAMESPACE = Agent.PI_AGENT;
    private static final String EXTN_PT = "dependencyExtenders";

    public static IStatus check(IDependencyValidationContext dependencyContext, String bundleId, String className) throws CoreException {
        try {
            return DependencyExtenderManager.checkWithThrows(dependencyContext, bundleId, className);
        }
        catch (CoreException e) {
            if (dependencyContext.isProfilePreliminary()) {
                e = DependencyExtenderManager.reduceSeverity(e);
            }
            log.status(e.getStatus());
            throw e;
        }
    }

    private static CoreException reduceSeverity(CoreException ce) {
        IStatus status = MultiStatusUtil.recodeLevel((IStatus)ce.getStatus(), (int)2);
        return new CoreException(status);
    }

    private static IStatus checkWithThrows(IDependencyValidationContext dependencyContext, String bundleId, String className) throws CoreException {
        IConfigurationElement ce = ExtensionBundleUtils.DEFAULT_EXTENSION_FINDER.findMatchingConfigurationElement(null, NAMESPACE, EXTN_PT, bundleId, className);
        if (ce != null) {
            IDependencyExtender checker = (IDependencyExtender)ExtensionBundleUtils.createExecutableExtension((IConfigurationElement)ce, IDependencyExtender.class);
            log.debug("Dependency checker call to {0}.{1}", new Object[]{ce.getNamespaceIdentifier(), ce.getName()});
            try {
                IStatus status = checker.validate(dependencyContext);
                log.debug("Dependency checker call to {0}.{1} returned status {2}", new Object[]{ce.getNamespaceIdentifier(), ce.getName(), status});
                return status;
            }
            catch (Throwable t) {
                CoreException e = new CoreException(ExtensionBundleUtils.getStatusForUnexpectedExtensionCallException((IConfigurationElement)ce, (String)"validate(IDependencyValidationContext)", (Throwable)t));
                log.debug("Dependency checker call to {0}.{1} threw exception,", new Object[]{ce.getNamespaceIdentifier(), ce.getName(), e.getStatus()});
                throw e;
            }
        }
        return Status.OK_STATUS;
    }

    public static class DependencyValidationContext
    implements IDependencyValidationContext {
        private final boolean profileIsPreliminary;
        private final IProfile profile;
        private final IAgentJob[] jobs;
        private final IOfferingOrFix[] remainingOrAdded;
        private final IOfferingOrFix[] removed;

        public DependencyValidationContext(boolean profileIsPreliminary, IProfile profile, IAgentJob[] jobs, IOfferingOrFix[] remainingOrAdded, IOfferingOrFix[] removed) {
            this.profileIsPreliminary = profileIsPreliminary;
            this.profile = profile;
            this.jobs = jobs;
            this.remainingOrAdded = remainingOrAdded;
            this.removed = removed;
        }

        public IAgent getAgent() {
            return Agent.getInstance();
        }

        public IAgentJob[] getJobs() {
            return this.jobs;
        }

        @Override
        public boolean isProfilePreliminary() {
            return this.profileIsPreliminary;
        }

        @Override
        public IProfile getProfile() {
            return this.profile;
        }

        @Override
        public IOfferingOrFix[] getResultingOfferingsOrFixes() {
            return this.remainingOrAdded;
        }

        @Override
        public IOfferingOrFix[] getUninstalledOfferingsOrFixes() {
            return this.removed;
        }

        public Object getAdapter(Class adapter) {
            if (IProfile.class.equals((Object)adapter) || Profile.class.equals((Object)adapter)) {
                return this.profile;
            }
            if (IAgent.class.equals((Object)adapter) || Agent.class.equals((Object)adapter)) {
                return Agent.getInstance();
            }
            if (AgentJob[].class.equals((Object)adapter)) {
                return this.jobs;
            }
            return Platform.getAdapterManager().getAdapter((Object)this, adapter);
        }
    }
}

