/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.response.impl;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.internal.response.IElement;
import com.ibm.cic.agent.core.internal.response.IElementProxy;
import com.ibm.cic.agent.core.internal.response.IPackageElement;
import com.ibm.cic.agent.core.internal.response.IPackageGroupElement;
import com.ibm.cic.agent.core.internal.response.IPackagesElement;
import com.ibm.cic.agent.core.internal.response.IPropertiesElement;
import com.ibm.cic.agent.core.internal.response.impl.ProfileProxy;
import com.ibm.cic.agent.core.internal.response.impl.ResponseFactory;
import com.ibm.cic.agent.core.internal.response.impl.SimplePackageGroup;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.utils.PlatformUtils;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class PackageGroupElement
extends SimplePackageGroup
implements IPackageGroupElement {
    private static final String ID = "id";

    public PackageGroupElement() {
        super("packageGroup");
    }

    @Override
    public String getId() {
        return this.getAttribute(ID, null);
    }

    @Override
    public void setId(String value) {
        this.setAttribute(ID, value);
    }

    @Override
    public void addChild(IElement element) {
        String name = element.getElementName();
        if (name.equals("package")) {
            IPackagesElement ps = ResponseFactory.getInstance().createPackagesElement();
            ps.addChild(element);
            super.addChild(ps);
        } else if (name.equals("property")) {
            IPropertiesElement ps = ResponseFactory.getInstance().createPropertiesElement();
            ps.addChild(element);
            super.addChild(ps);
        } else {
            super.addChild(element);
        }
    }

    @Override
    public boolean match(IElementProxy elementProxy) {
        if (!(elementProxy instanceof ProfileProxy)) {
            return false;
        }
        ProfileProxy profileProxy = (ProfileProxy)elementProxy;
        if (this.getId() == null && this.getInstallationDirectory() == null) {
            this.searchDefaultProfile();
        }
        String id = this.getId();
        String installDirectory = this.getInstallationDirectory();
        if (id != null) {
            return id.equals(profileProxy.getId());
        }
        if (installDirectory != null) {
            return installDirectory.equals(profileProxy.getInstallationDirectory());
        }
        return false;
    }

    private void searchDefaultProfile() {
        List packagesElements = this.getPackages();
        for (IPackagesElement packagesElement : packagesElements) {
            List packageElements = packagesElement.getPackage();
            for (IPackageElement p : packageElements) {
                IOffering offering = this.findLatestAvailableOffering(p.getId());
                if (offering == null) continue;
                this.setId(OfferingProperty.getDefaultProfile((IOfferingOrFix)offering));
                this.setInstallationDirectory(PlatformUtils.getDefaultInstallLocation((IOffering)offering));
                return;
            }
        }
    }

    private IOffering findLatestAvailableOffering(String offeringId) {
        IOffering latestOffering = null;
        List offerings = Agent.getInstance().getRepositoryGroup().getAllOfferings((IProgressMonitor)new NullProgressMonitor());
        for (IOffering offering : offerings) {
            if (!offeringId.equals(offering.getIdentity().getId()) || latestOffering != null && offering.compareVersion((IContent)latestOffering) <= 0) continue;
            latestOffering = offering;
        }
        return latestOffering;
    }
}

