/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.internal.commands.AbstractAcceptLicenseCommand;
import com.ibm.cic.agent.core.internal.headless.CommandFactory;
import com.ibm.cic.agent.core.internal.headless.IInstallAllCommand;
import com.ibm.cic.agent.core.internal.headless.IInstallCommand;
import com.ibm.cic.agent.core.internal.headless.InstallFixesAction;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class InstallAllCommand
extends AbstractAcceptLicenseCommand
implements IInstallAllCommand {
    public InstallAllCommand() {
        super("installAll");
    }

    @Override
    public IStatus execute(Agent agent, IProgressMonitor monitor) {
        CicMultiStatus result = Statuses.ST.createMultiStatus(Messages.Cmd_installAll_Processing, new Object[0]);
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{1, 17});
        try {
            boolean needRestart = this.installAgentUpdate(agent, result, false, spm.next());
            if (needRestart) {
                CicMultiStatus cicMultiStatus = result;
                return cicMultiStatus;
            }
            Collection offerings = agent.findAllOfferings(false, (IProgressMonitor)new NullProgressMonitor());
            offerings = this.getLatestVersions(offerings);
            Collection extensionOfferings = this.getExtensionOfferings(agent, offerings);
            offerings = this.getBaseOfferings(agent, offerings);
            String installFixesStr = this.getAttribute("installFixes");
            InstallFixesAction ifAction = null;
            if (installFixesStr != null) {
                ifAction = InstallFixesAction.getInstallFixesAction(installFixesStr);
            }
            Profile defaultProfileForExtensionOfferings = null;
            IProgressMonitor loopsMonitor = spm.next();
            loopsMonitor.beginTask("", offerings.size() + extensionOfferings.size());
            try {
                IInstallCommand installCommand;
                Iterator iter = offerings.iterator();
                while (iter.hasNext()) {
                    List profiles;
                    if (loopsMonitor.isCanceled()) {
                        result.add(Status.CANCEL_STATUS);
                        break;
                    }
                    IOfferingOrFix offering = (IOfferingOrFix)iter.next();
                    installCommand = CommandFactory.createInstallCommand();
                    installCommand.setInput(this.getInput());
                    installCommand.addOffering(offering, null, null, ifAction);
                    installCommand.setAcceptLicense(this.isAcceptLicense());
                    CicMultiStatus status = Statuses.ST.createMultiStatusWithChild(installCommand.execute(agent, (IProgressMonitor)new SubProgressMonitor(loopsMonitor, 1)), Messages.Cmd_installAll_Processing_Package, new Object[]{OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offering)});
                    result.add((IStatus)status);
                    if (defaultProfileForExtensionOfferings != null || (profiles = installCommand.getActualProfiles()) == null || profiles.isEmpty()) continue;
                    defaultProfileForExtensionOfferings = (Profile)profiles.get(0);
                }
                Iterator iterator = extensionOfferings.iterator();
                while (iterator.hasNext()) {
                    if (loopsMonitor.isCanceled()) {
                        result.add(Status.CANCEL_STATUS);
                        break;
                    }
                    IOffering extensionOffering = (IOffering)iterator.next();
                    installCommand = CommandFactory.createInstallCommand();
                    installCommand.setInput(this.getInput());
                    installCommand.addOffering((IOfferingOrFix)extensionOffering, defaultProfileForExtensionOfferings, null);
                    installCommand.setAcceptLicense(this.isAcceptLicense());
                    result.add(installCommand.execute(agent, (IProgressMonitor)new SubProgressMonitor(loopsMonitor, 1)));
                }
            }
            finally {
                loopsMonitor.done();
            }
        }
        finally {
            spm.done();
            monitor.done();
        }
        return result;
    }

    private Collection getBaseOfferings(Agent agent, Collection offerings) {
        ArrayList<IOfferingOrFix> baseOfferings = new ArrayList<IOfferingOrFix>();
        if (offerings != null) {
            for (IOfferingOrFix offering : offerings) {
                if (agent.isAgentOffering(offering) || offering instanceof IOffering && Agent.isExtensionOffering(offering)) continue;
                baseOfferings.add(offering);
            }
        }
        return baseOfferings;
    }

    private Collection getExtensionOfferings(Agent agent, Collection offerings) {
        ArrayList<IOfferingOrFix> extensionOfferings = new ArrayList<IOfferingOrFix>();
        if (offerings != null) {
            for (IOfferingOrFix offering : offerings) {
                if (agent.isAgentOffering(offering) || !(offering instanceof IOffering) || !Agent.isExtensionOffering(offering)) continue;
                extensionOfferings.add(offering);
            }
        }
        return extensionOfferings;
    }

    private Collection getLatestVersions(Collection offerings) {
        HashMap<IIdentity, ArrayList<IOffering>> idToOfferings = new HashMap<IIdentity, ArrayList<IOffering>>();
        for (IOffering o : offerings) {
            ArrayList<IOffering> c = (ArrayList<IOffering>)idToOfferings.get(o.getIdentity());
            if (c == null) {
                c = new ArrayList<IOffering>();
            }
            c.add(o);
            idToOfferings.put(o.getIdentity(), c);
        }
        ArrayList<IOffering> latestVersions = new ArrayList<IOffering>();
        Iterator it = idToOfferings.keySet().iterator();
        while (it.hasNext()) {
            Collection versions = (Collection)idToOfferings.get(it.next());
            IOffering latest = null;
            for (IOffering o : versions) {
                if (latest != null && o.getVersion().compareTo(latest.getVersion()) <= 0) continue;
                latest = o;
            }
            if (latest == null) continue;
            latestVersions.add(latest);
        }
        return latestVersions;
    }

    @Override
    public int getExecutionPoint() {
        return 4;
    }

    @Override
    public int getWeight() {
        return 100;
    }

    @Override
    public void addInstallFixesAttribute(InstallFixesAction installFixes) {
        if (installFixes != null) {
            super.addAttribute("installFixes", installFixes.getName());
        }
    }
}

