/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.internal.expander.ExpansionResult;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.utils.CanceledException;
import com.ibm.cic.common.core.utils.MapList;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class ProfilePartitioner {
    private static final Logger log = Logger.getLogger();
    private final List<InstallJob> jobs;
    private MapList<Profile, InstallJob> profileMap = null;
    private final Map<InstallJob, IStatus> statuses = new HashMap<InstallJob, IStatus>();
    private final List<Profile> existingProfiles;

    public ProfilePartitioner(AgentJob[] jobs) {
        this(Arrays.asList(jobs));
    }

    public ProfilePartitioner(List<AgentJob> jobs) {
        this.jobs = new ArrayList<InstallJob>(jobs.size());
        for (AgentJob job : jobs) {
            assert (job instanceof InstallJob);
            assert (job.getOffering() != null);
            assert (!LicenseUtils.isPEKOffering((IOffering)job.getOffering()));
            this.jobs.add((InstallJob)job);
        }
        Profile[] allProfiles = InstallRegistry.getInstance().getProfiles();
        this.existingProfiles = new ArrayList<Profile>(allProfiles.length);
        Profile[] profileArray = allProfiles;
        int n = allProfiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            if ((profile.isProductProfile() || profile.isExistingEclipseProfile()) && profile.shouldBeVisible()) {
                this.existingProfiles.add(profile);
            }
            ++n2;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.profileMap == null) {
            sb.append("perform() not called; jobs:");
            ProfilePartitioner.appendJobs(sb, this.jobs);
        } else {
            Iterator<Object> iterator = this.getProfiles().iterator();
            while (iterator.hasNext()) {
                Profile profile;
                Profile profile2 = profile = iterator.next();
                sb.append("Profile ").append(profile2.getProfileId());
                sb.append(" - ").append(profile2.getInstallLocation());
                ProfilePartitioner.appendJobs(sb, this.getJobs(profile2));
                sb.append('\n');
            }
            for (Object object : this.statuses.entrySet()) {
                Map.Entry entry = (Map.Entry)object;
                InstallJob job = (InstallJob)entry.getKey();
                IStatus status = (IStatus)entry.getValue();
                sb.append(ProfilePartitioner.getPkgNameAndId((IOfferingOrFix)job.getOffering())).append(": ").append(status.getMessage()).append('\n');
            }
            Util.trimEnd((StringBuffer)sb);
        }
        return sb.toString();
    }

    private static String getPkgNameAndId(IOfferingOrFix oof) {
        return NLS.bind((String)"{0} ({1})", (Object)oof.getName(), (Object)oof.getIdentity().getId());
    }

    private static void appendJobs(StringBuffer sb, List jobs) {
        for (InstallJob job : jobs) {
            IOffering offering = job.getOffering();
            sb.append("\n  ").append(ProfilePartitioner.getPkgNameAndId((IOfferingOrFix)offering)).append(' ').append(offering.getVersion());
        }
    }

    public Map<InstallJob, IStatus> perform(IProgressMonitor monitor) throws CanceledException {
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor).split(6);
        this.profileMap = new MapList();
        ArrayList<InstallJob> full = new ArrayList<InstallJob>();
        ArrayList<InstallJob> extns = new ArrayList<InstallJob>();
        ArrayList<InstallJob> extnOfExtns = new ArrayList<InstallJob>();
        for (InstallJob job : this.jobs) {
            if (!ProfilePartitioner.isExtension(job)) {
                full.add(job);
                continue;
            }
            if (!ProfilePartitioner.isExtensionOfExtension(job)) {
                extns.add(job);
                continue;
            }
            extnOfExtns.add(job);
        }
        int fullCount = full.size();
        int extnsCount = extns.size();
        int extnOfExtnsCount = extnOfExtns.size();
        ArrayList<Profile> addedProfiles = new ArrayList<Profile>();
        this.assignProfiles(addedProfiles, full, pm.next());
        for (Profile profile : addedProfiles) {
            InstallRegistry.getInstance().removeProfile(profile);
        }
        if (fullCount != 0) {
            this.logCurrentState("base offerings");
        }
        if (!this.statuses.isEmpty()) {
            return this.statuses;
        }
        this.assignProfiles(null, extns, pm.next());
        if (extnsCount != 0) {
            this.logCurrentState("extension offerings");
        }
        IProgressMonitor mon = pm.next();
        while (this.assignProfiles(null, extnOfExtns, mon)) {
        }
        if (extnOfExtnsCount != 0) {
            this.logCurrentState("extension of extension offerings");
        }
        this.assignGroupsToExistingProfiles(pm.next());
        if (this.existingProfiles.size() != 0) {
            this.logCurrentState("assigning groups to existing profiles");
        }
        extnsCount = extns.size();
        this.assignExistingProfiles(extns, pm.next());
        this.addExtensionErrors(extns);
        if (this.existingProfiles.size() != 0 && extnsCount != 0) {
            this.logCurrentState("assigning remaining extensions to existing profiles");
        }
        extnOfExtnsCount = extnOfExtns.size();
        mon = pm.next();
        while (this.assignExistingProfiles(extnOfExtns, mon)) {
        }
        this.addExtensionErrors(extnOfExtns);
        if (this.existingProfiles.size() != 0 && extnOfExtnsCount != 0) {
            this.logCurrentState("assigning remaining extensions of extensions to existing profiles");
        }
        for (Profile profile : this.profileMap.keySet()) {
            List allJobs = this.profileMap.get((Object)profile);
            BitModeUtils.initializeProfilePlatformProperties(profile, allJobs.toArray(new AgentJob[allJobs.size()]));
        }
        pm.checkDone();
        return this.statuses;
    }

    private void logCurrentState(String phase) {
        if (!log.isDebugLoggable()) {
            return;
        }
        log.debug("ProfilePartitioner state after {0}:\n{1}", new Object[]{phase, this.toString()});
    }

    public void setProfilesInJobs() {
        for (Profile profile : this.getProfileMap().keySet()) {
            HashSet<IOffering> offerings = new HashSet<IOffering>();
            int length = Integer.MAX_VALUE;
            for (InstallJob job : this.getProfileMap().get((Object)profile)) {
                job.setProfile(profile);
                IOffering offering = job.getOffering();
                if (offering == null) continue;
                if (!offerings.contains(offering)) {
                    offerings.add(offering);
                } else {
                    job.setSelected(false);
                }
                int pathLength = PlatformUtils.getMaxInstallLocationLengthForOffering((IOffering)offering);
                if (pathLength >= length) continue;
                length = pathLength;
            }
            profile.setMaxInstallLocationLength(length);
        }
    }

    public Collection<Profile> getProfiles() {
        return this.getProfileMap().keySet();
    }

    public List<InstallJob> getJobs(Profile profile) {
        return this.getProfileMap().get((Object)profile);
    }

    private boolean handleSingleton(InstallJob job) {
        IOffering offering = job.getOffering();
        IStatus status = AgentUtil.singletonOfferingCheck(null, offering);
        if (!status.isOK()) {
            for (Profile existing : this.existingProfiles) {
                if (existing.getInstallRegistry().getInstalledOffering(offering.getIdentity()) != null) {
                    ProfilePartitioner.logCompatibility(existing, job, status);
                    this.statuses.put(job, status);
                    return true;
                }
                if (!AgentUtil.singletonOfferingCheck(existing, offering).isOK()) continue;
                this.profileMap.add((Object)existing, (Object)job);
                return true;
            }
        }
        return false;
    }

    private static boolean isAnyInstalled(Profile profile, List<InstallJob> jobs) {
        InstallRegistry.ProfileInstallRegistry installRegistry = profile.getInstallRegistry();
        for (InstallJob job : jobs) {
            if (installRegistry.getInstalledOffering(job.getOffering().getIdentity()) == null) continue;
            return true;
        }
        return false;
    }

    private boolean assignProfiles(List<Profile> addedProfiles, List<InstallJob> jobsToAssign, IProgressMonitor monitor) throws CanceledException {
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor).split(jobsToAssign.size());
        boolean change = false;
        Iterator<InstallJob> i = jobsToAssign.iterator();
        while (i.hasNext()) {
            InstallJob job = i.next();
            if (!this.assignProfile(addedProfiles, job, pm.next())) continue;
            i.remove();
            change = true;
        }
        return change;
    }

    private boolean assignProfile(List<Profile> addedProfiles, InstallJob job, IProgressMonitor monitor) throws CanceledException {
        if (this.handleSingleton(job)) {
            return true;
        }
        Profile profile = this.getCompatibleProfile(job, this.profileMap.keySet(), monitor);
        if (profile == null) {
            if (ProfilePartitioner.isExtension(job)) {
                return false;
            }
            profile = AgentUtil.makeNewProfileForJob(job);
            if (profile == null) {
                this.statuses.put(job, (IStatus)Statuses.ERROR.get("Internal error: no profile found for " + job, new Object[0]));
                return false;
            }
            InstallRegistry.getInstance().addProfile(profile);
            addedProfiles.add(profile);
        }
        this.profileMap.add((Object)profile, (Object)job);
        return true;
    }

    private void assignGroupsToExistingProfiles(IProgressMonitor monitor) throws CanceledException {
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor).split(this.existingProfiles.size());
        block0: for (Profile existing : this.existingProfiles) {
            pm.splitNext(this.profileMap.size());
            Set profiles = this.profileMap.keySet();
            for (Profile profile : profiles) {
                List profileJobs = this.profileMap.get((Object)profile);
                if (this.existingProfiles.contains(profile) || ProfilePartitioner.isAnyInstalled(existing, profileJobs) || !this.isCompatible(existing, profileJobs, pm.checkCanceled().next())) continue;
                this.profileMap.remove((Object)profile);
                this.profileMap.addAll((Object)existing, (Collection)profileJobs);
                continue block0;
            }
        }
    }

    private void addExtensionErrors(List<InstallJob> extns) {
        for (InstallJob job : extns) {
            this.statuses.put(job, (IStatus)Statuses.ERROR.get(Messages.AgentUtil_Installation_Package_Requires_External_Components, new Object[]{job.getOffering().getName(), AgentUtil.getOfferingHintMessage(job.getOffering())}));
        }
    }

    private boolean assignExistingProfiles(List<InstallJob> jobsToAssign, IProgressMonitor monitor) throws CanceledException {
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor).split(jobsToAssign.size());
        boolean change = false;
        Iterator<InstallJob> i = jobsToAssign.iterator();
        while (i.hasNext()) {
            InstallJob job = i.next();
            if (!this.assignExistingProfile(job, pm.next())) continue;
            i.remove();
            change = true;
        }
        return change;
    }

    private boolean assignExistingProfile(InstallJob job, IProgressMonitor monitor) throws CanceledException {
        Profile profile = this.getCompatibleProfile(job, this.existingProfiles, monitor);
        if (profile == null) {
            return false;
        }
        this.profileMap.add((Object)profile, (Object)job);
        return true;
    }

    private Profile getCompatibleProfile(InstallJob job, Collection<Profile> profiles, IProgressMonitor monitor) throws CanceledException {
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, profiles.size() + 1);
        Profile baseProfile = this.getBaseProfile(job);
        if (baseProfile != null) {
            if (this.isCompatible(baseProfile, Collections.singletonList(job), pm.checkCanceled().next())) {
                return baseProfile;
            }
            return null;
        }
        for (Profile profile : profiles) {
            if (!this.isCompatible(profile, Collections.singletonList(job), pm.checkCanceled().next())) continue;
            return profile;
        }
        return null;
    }

    private Profile getBaseProfile(InstallJob job) {
        String baseId = job.getBaseId();
        if (baseId == null) {
            return null;
        }
        for (Map.Entry entry : this.profileMap.entrySet()) {
            Profile profile = (Profile)entry.getKey();
            List baseJobs = (List)entry.getValue();
            for (InstallJob baseJob : baseJobs) {
                IOffering offering = baseJob.getOffering();
                if (offering == null || !baseId.equals(offering.getIdentity().getId())) continue;
                return profile;
            }
        }
        return null;
    }

    private boolean isCompatible(Profile profile, Collection<InstallJob> newJobs, IProgressMonitor monitor) {
        ExpansionResult expandResult;
        List oldJobs = this.profileMap.get((Object)profile);
        List<InstallJob> allJobsList = new ArrayList<InstallJob>(oldJobs.size() + newJobs.size());
        allJobsList.addAll(oldJobs);
        allJobsList.addAll(newJobs);
        allJobsList = this.getUniqueJobs(allJobsList);
        AgentJob[] allJobs = new InstallJob[allJobsList.size()];
        IOffering[] offerings = new IOffering[allJobs.length];
        int j = 0;
        for (InstallJob job : allJobsList) {
            IOffering offering;
            offerings[j] = offering = job.getOffering();
            allJobs[j] = new InstallJob(profile, (IOfferingOrFix)offering);
            allJobs[j].setBaseId(job.getBaseId());
            ++j;
        }
        AgentJob[] relatedJobs = this.getRelatedJobs(profile, (InstallJob[])allJobs);
        AgentJob[] agentJobArray = allJobs;
        int n = allJobs.length;
        int offering = 0;
        while (offering < n) {
            AgentJob allJob = agentJobArray[offering];
            allJob.setRelatedJobs(relatedJobs);
            ++offering;
        }
        BitModeUtils.initializeProfilePlatformProperties(profile, allJobs);
        Object status = AgentUtil.validateCompatibleOfferings(profile, offerings);
        if (status.isOK() && !(expandResult = ExpansionResult.expand(allJobs, monitor)).isOK()) {
            status = log.isDebugLoggable() ? expandResult.getStatus() : Statuses.ERROR.get("Expansion error", new Object[0]);
        }
        ProfilePartitioner.logCompatibility(profile, (InstallJob[])allJobs, status);
        return status.isOK();
    }

    private InstallJob[] getRelatedJobs(Profile profile, InstallJob[] profileJobs) {
        ArrayList<InstallJob> relatedJobs = new ArrayList<InstallJob>();
        for (Map.Entry entry : this.getProfileMap().entrySet()) {
            Profile assignedProfile = (Profile)entry.getKey();
            if (profile.getProfileId().equals(assignedProfile.getProfileId())) {
                InstallJob[] installJobArray = profileJobs;
                int n = profileJobs.length;
                int n2 = 0;
                while (n2 < n) {
                    InstallJob profileJob = installJobArray[n2];
                    relatedJobs.add(profileJob);
                    ++n2;
                }
                continue;
            }
            List<InstallJob> assignedProfileJobs = this.getUniqueJobs((List)entry.getValue());
            relatedJobs.addAll(assignedProfileJobs);
        }
        return relatedJobs.toArray(new InstallJob[relatedJobs.size()]);
    }

    private static void logCompatibility(Profile profile, InstallJob job, IStatus status) {
        ProfilePartitioner.logCompatibility(profile, new InstallJob[]{job}, status);
    }

    private static void logCompatibility(Profile profile, InstallJob[] jobs, IStatus status) {
        if (!log.isDebugLoggable() || status.isOK()) {
            return;
        }
        String pkgs = Util.toString((Object[])jobs, (Util.Formatter)new Util.Formatter(", "){

            protected String format(Object object) {
                return ProfilePartitioner.getPkgNameAndId(((InstallJob)object).getOfferingOrFix());
            }
        });
        log.debug("In {0}profile: {1} - {2}\nPackage(s): {3}\nCannot be installed due to:\n{4}", new Object[]{profile.isShadow() ? "new " : "", profile.getProfileId(), profile.getInstallLocation(), pkgs, StatusUtil.toString((IStatus)status)});
    }

    private MapList<Profile, InstallJob> getProfileMap() {
        if (this.profileMap == null) {
            throw new IllegalStateException("perform() has not been called");
        }
        return this.profileMap;
    }

    private static boolean isExtension(InstallJob job) {
        return OfferingProperty.isExtension((IOfferingOrFix)job.getOffering());
    }

    private static boolean isExtensionOfExtension(InstallJob job) {
        return OfferingProperty.isExtensionOfExtension((IOffering)job.getOffering());
    }

    private List<InstallJob> getUniqueJobs(List<InstallJob> jobsList) {
        HashSet<IOfferingOrFix> oofs = new HashSet<IOfferingOrFix>(jobsList.size());
        ArrayList<InstallJob> uniqueJobs = new ArrayList<InstallJob>(jobsList.size());
        for (InstallJob job : jobsList) {
            IOfferingOrFix oof = job.getOfferingOrFix();
            if (oofs.contains(oof)) continue;
            oofs.add(oof);
            uniqueJobs.add(job);
        }
        return uniqueJobs;
    }
}

