/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.CacheLocationManager;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.UpdateOfferingJob;
import com.ibm.cic.agent.core.WindowSystemUtils;
import com.ibm.cic.agent.core.api.IAgent;
import com.ibm.cic.agent.core.api.IAgentJob;
import com.ibm.cic.agent.core.api.IAgentJobType;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.core.api.ISelectionExpressionData;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IFixApplicableOffering;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.ISelectionExpression;
import com.ibm.cic.common.core.model.IllegalFeatureStateException;
import com.ibm.cic.common.core.model.PredefinedSelectors;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.model.utils.PlatformFilter;
import com.ibm.cic.common.core.model.utils.SelectorContext;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.ExceptionUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.framework.VersionRange;

public abstract class AgentJob
implements IAgentJob,
IAdaptable,
ISelectionExpression.EvaluationContext {
    public static final AgentJob[] NO_JOBS = new AgentJob[0];
    private boolean selected = true;
    private final AgentJobType type;
    private final IOfferingOrFix offeringOrFix;
    private Profile profile;
    private List features;
    private String featureIds;
    private IAgentJob[] relatedJobs;
    private IAgentJob[] allJobs;
    private IOffering pekOffering = null;
    private boolean isAcceptLicense = false;
    private IStatus featureSelectionStatus = Status.OK_STATUS;
    private Boolean expandFeatureTree = null;
    private ISelectionExpressionData selectionExpressionData;
    private String baseId;
    private Map<String, Set<String>> predefinedSelectorOverrides = null;
    private final Map<IFeatureBase, Boolean> m_canFeatureOrGroupSelected = new HashMap<IFeatureBase, Boolean>();
    private final Map<IFeatureBase, Boolean> m_canFeatureOrGroupRemoved = new HashMap<IFeatureBase, Boolean>();
    private final Map<IFeatureBase, Boolean> m_isFeatureOrGroupVisible = new HashMap<IFeatureBase, Boolean>();
    private final Map<IFeatureBase, IStatus> m_featureBaseApplicabilityStatus = new HashMap<IFeatureBase, IStatus>();
    private final Map<IFeature, IStatus> m_featureAuxiliaryApplicabilityStatus = new HashMap<IFeature, IStatus>();
    private final Set userSelectedElements = new HashSet();
    private Set dependencySelectedElements = new HashSet();
    public static final int SELECT_MODE_NONE = 0;
    public static final int SELECT_MODE_RECOMMENDED = 1;
    public static final int SELECT_MODE_ALL = 2;

    public static AgentJob[] sort(AgentJob[] jobs, boolean ascending) {
        if (jobs.length < 2) {
            return jobs;
        }
        AgentJob[] sorted = new AgentJob[jobs.length];
        System.arraycopy(jobs, 0, sorted, 0, jobs.length);
        Arrays.sort(sorted, new JobsComparator(ascending));
        return sorted;
    }

    public static AgentJob[] toArray(Collection<? extends AgentJob> c) {
        return c.toArray(new AgentJob[c.size()]);
    }

    public static void unresolve(AgentJob[] jobs) {
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            job.unresolve();
            ++n2;
        }
    }

    protected AgentJob(AgentJobType type, IOfferingOrFix offeringOrFix, Profile profile) {
        assert (type == AgentJobType.ERROR_JOB || offeringOrFix != null) : type;
        this.offeringOrFix = offeringOrFix;
        this.profile = profile;
        this.type = type;
        this.features = offeringOrFix instanceof IOffering ? null : Collections.EMPTY_LIST;
        this.featureIds = null;
        this.baseId = null;
        this.relatedJobs = null;
        this.allJobs = null;
        this.selectionExpressionData = new ISelectionExpressionData(){

            @Override
            public IAgent getAgent() {
                return Agent.getInstance();
            }

            @Override
            public IAgentJob[] getAllJobs() {
                if (AgentJob.this.allJobs == null) {
                    return new IAgentJob[0];
                }
                return (IAgentJob[])AgentJob.this.allJobs.clone();
            }

            @Override
            public IAgentJob[] getProfileJobs() {
                if (AgentJob.this.relatedJobs == null) {
                    return new IAgentJob[0];
                }
                return (IAgentJob[])AgentJob.this.relatedJobs.clone();
            }
        };
    }

    protected AgentJob(AgentJobType type, IOfferingOrFix offeringOrFix, Profile profile, IFeature[] features) {
        this(type, offeringOrFix, profile);
        this.features = new ArrayList<IFeature>(Arrays.asList(features));
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean sameJob(AgentJob that) {
        if (this == that) {
            return true;
        }
        return this.offeringOrFix.equals(that.offeringOrFix) && this.getFeatures().equals(that.getFeatures()) && this.profile.equals(that.profile) && this.type.equals(that.type);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.type.getJobType());
        sb.append(" in ");
        sb.append(this.profile == null ? null : this.profile.getProfileId());
        sb.append("; ").append(this.offeringOrFix.getIdentity());
        sb.append(' ').append(this.offeringOrFix.getVersion());
        sb.append(" features: ");
        sb.append(this.features != null ? Util.toFeatureIdString((Collection)this.features) : this.featureIds);
        return sb.toString();
    }

    public void addFeature(IFeature feature) {
        if (!this.getFeatures().contains(feature)) {
            this.getFeatures().add(feature);
        }
    }

    public Object getAdapter(Class adapter) {
        if (IProfile.class.equals((Object)adapter) || Profile.class.equals((Object)adapter)) {
            return this.profile;
        }
        if (IAgent.class.equals((Object)adapter) || Agent.class.equals((Object)adapter)) {
            return Agent.getInstance();
        }
        if (IOffering.class.equals((Object)adapter) && this.offeringOrFix instanceof IOffering) {
            return this.offeringOrFix;
        }
        if (IFix.class.equals((Object)adapter) && this.offeringOrFix instanceof IFix) {
            return this.offeringOrFix;
        }
        if (IOfferingOrFix.class.equals((Object)adapter)) {
            return this.offeringOrFix;
        }
        if (IAgentJob[].class.equals((Object)adapter)) {
            return this.relatedJobs == null ? null : this.relatedJobs.clone();
        }
        if (IFeature[].class.equals((Object)adapter)) {
            return this.getFeaturesArray();
        }
        if (ISelectionExpressionData.class.equals((Object)adapter)) {
            return this.selectionExpressionData;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public List getFeatures() {
        if (this.features == null) {
            IStatus status = this.resolveFeatureIds(Agent.getInstance(), null);
            if (!status.isOK()) {
                this.featureSelectionStatus = status;
                Agent.getLogger().statusNotOK(status);
                this.features = new ArrayList();
            } else {
                this.featureSelectionStatus = Status.OK_STATUS;
            }
        }
        return this.features;
    }

    public void resetFeatures() {
        this.features = null;
    }

    @Override
    public IOffering getOffering() {
        return this.offeringOrFix instanceof IOffering ? (IOffering)this.offeringOrFix : null;
    }

    @Override
    public IFix getFix() {
        return this.offeringOrFix instanceof IFix ? (IFix)this.offeringOrFix : null;
    }

    @Override
    public IOfferingOrFix getOfferingOrFix() {
        return this.offeringOrFix;
    }

    public Profile getProfile() {
        return this.profile;
    }

    @Override
    public IProfile getAssociatedProfile() {
        return this.getProfile();
    }

    public AgentJobType getType() {
        return this.type;
    }

    public AgentJobType getSubType() {
        return this.type;
    }

    public void setFeatures(Collection features) {
        assert (features != null);
        this.features = new ArrayList(features);
    }

    @Override
    public IFeature[] getFeaturesArray() {
        return OfferingUtil.toFeaturesAsArray((Collection)this.getFeatures());
    }

    public boolean removeFeature(IFeature feature) {
        return this.getFeatures().remove(feature);
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    /*
     * WARNING - void declaration
     */
    public IStatus checkOfferingApplicability() {
        CicMultiStatus result = Statuses.ST.createMultiStatus(Messages.AgentUtil_multipleWarnings, new Object[0]);
        IOffering offering = this.getOffering();
        if (offering != null) {
            IFeatureGroup rootGroup;
            IStatus applicabilityStatus;
            IStatus status = BitModeUtils.checkBitmodeSupported(this);
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                return status;
            }
            if (status.matches(2)) {
                result.add(status);
            }
            if (StatusUtil.isErrorOrCancel((IStatus)(status = WindowSystemUtils.checkWindowSystemSupported(this)))) {
                return status;
            }
            status = Agent.getInstance().checkLumRequiredLibs(this);
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                return status;
            }
            if (!this.type.isModify()) {
                status = Agent.getInstance().qualifyNewOffering(this.profile, offering);
                if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                    return status;
                }
                if (status.matches(2)) {
                    result.add(status);
                }
            }
            if (StatusUtil.isErrorOrCancel((IStatus)(applicabilityStatus = (rootGroup = offering.getFeatureGroup()).evaluateApplicability((ISelectionExpression.EvaluationContext)this)))) {
                return applicabilityStatus;
            }
            if (!applicabilityStatus.isOK() && !rootGroup.hasApplicabilityFlag(applicabilityStatus, 2)) {
                result.add(applicabilityStatus);
            }
            String excludedProperty = OfferingProperty.getCapabilityPlatformExclusions((IOfferingOrFix)offering);
            HashMap<String, String> excludedCapsByPlatform = new HashMap<String, String>();
            if (excludedProperty != null && !excludedProperty.isEmpty()) {
                String[] excludeProps;
                String[] stringArray = excludeProps = excludedProperty.split(";");
                int n = excludeProps.length;
                int n2 = 0;
                while (n2 < n) {
                    String excludeProp = stringArray[n2];
                    String[] capAndPlatforms = excludeProp.split(":");
                    excludedCapsByPlatform.put(capAndPlatforms[0], capAndPlatforms[1]);
                    ++n2;
                }
            }
            String requires = OfferingProperty.getRequiresExtensions((IOfferingOrFix)offering);
            ArrayList<AbstractMap.SimpleEntry<String, org.eclipse.osgi.service.resolver.VersionRange>> requiredCapabilities = new ArrayList<AbstractMap.SimpleEntry<String, org.eclipse.osgi.service.resolver.VersionRange>>();
            if (requires != null && !requires.isEmpty()) {
                Object[] props;
                void var12_11;
                String[] capabilitySet;
                String[] n4 = capabilitySet = requires.split(";");
                int n = capabilitySet.length;
                boolean n3 = false;
                while (var12_11 < n) {
                    String capabilityProp = n4[var12_11];
                    props = capabilityProp.split(":");
                    String capability = props[0];
                    String string = OfferingProperty.extractCapabilityId((String)capability);
                    org.eclipse.osgi.service.resolver.VersionRange capVersion = OfferingProperty.extractCapabilityVersion((String)capability);
                    String excludedPlatforms = (String)excludedCapsByPlatform.get(string);
                    if (excludedPlatforms != null) {
                        PlatformFilter f = new PlatformFilter(excludedPlatforms);
                        if (!f.matchesPlatform(Platform.getOS(), Platform.getOSArch()).isOK()) {
                            requiredCapabilities.add(new AbstractMap.SimpleEntry<String, org.eclipse.osgi.service.resolver.VersionRange>(string, capVersion));
                        }
                    } else {
                        requiredCapabilities.add(new AbstractMap.SimpleEntry<String, org.eclipse.osgi.service.resolver.VersionRange>(string, capVersion));
                    }
                    ++var12_11;
                }
                ArrayList<String> availableExtensionOfferings = new ArrayList<String>();
                props = this.profile.getInstalledOfferings();
                int n5 = props.length;
                n = 0;
                while (n < n5) {
                    String string = props[n];
                    if (Agent.isExtensionOffering((IOfferingOrFix)string)) {
                        availableExtensionOfferings.add(string);
                    }
                    ++n;
                }
                if (this.relatedJobs != null) {
                    props = this.relatedJobs;
                    n5 = this.relatedJobs.length;
                    n = 0;
                    while (n < n5) {
                        Object object = props[n];
                        IOffering relatedOffering = object.getOffering();
                        if (Agent.isExtensionOffering((IOfferingOrFix)relatedOffering)) {
                            availableExtensionOfferings.add((String)relatedOffering);
                        }
                        ++n;
                    }
                }
                for (AbstractMap.SimpleEntry simpleEntry : requiredCapabilities) {
                    String reqCapID = (String)simpleEntry.getKey();
                    org.eclipse.osgi.service.resolver.VersionRange reqCapVer = (org.eclipse.osgi.service.resolver.VersionRange)simpleEntry.getValue();
                    Boolean capSatisfied = false;
                    for (IOffering iOffering : availableExtensionOfferings) {
                        String extCapabilityProp = OfferingProperty.getProvidesExtensionCapability((IOfferingOrFix)iOffering);
                        String extCapId = OfferingProperty.extractCapabilityId((String)extCapabilityProp);
                        if (!reqCapID.equals(extCapId)) continue;
                        org.eclipse.osgi.service.resolver.VersionRange extCapVer = OfferingProperty.extractCapabilityVersion((String)extCapabilityProp);
                        if (reqCapVer.intersection(new VersionRange[]{extCapVer}).isEmpty()) break;
                        capSatisfied = true;
                        break;
                    }
                    if (capSatisfied.booleanValue()) continue;
                    String string = OfferingProperty.getCapabilityName((IOfferingOrFix)offering, (String)reqCapID);
                    result.add((IStatus)Statuses.ERROR.get(Messages.UnsatisfiedOfferingCapabilityDuringInstall, new Object[]{offering.getName(), string}));
                }
            }
        }
        return StatusUtil.toSingleStatus((IStatus)result);
    }

    public boolean canEvaluatePredefineds() {
        return this.profile != null && this.getPredefinedSelectorOverrides() != null;
    }

    public IStatus evaluate(String selIdStr, String selValStr) {
        if (this.profile != null) {
            if (PredefinedSelectors.isVariable((String)selIdStr) || PredefinedSelectors.isVariable((String)selValStr)) {
                return this.profile.evaluateVariableSelector(selIdStr, selValStr);
            }
            if (PredefinedSelectors.contains((String)selIdStr)) {
                return SelectorContext.evaluatePredefinedSelector(this.getPredefinedSelectorOverrides(), (boolean)false, (String)selIdStr, (String)selValStr);
            }
        }
        return Status.CANCEL_STATUS;
    }

    public boolean mustIgnoreBundles() {
        return false;
    }

    private Map<String, Set<String>> getPredefinedSelectorOverrides() {
        if (this.predefinedSelectorOverrides == null) {
            this.predefinedSelectorOverrides = PredefinedSelectors.makeOverridesMap((Map)BitModeUtils.getMassagedData(this.profile), (boolean)false);
        }
        return this.predefinedSelectorOverrides;
    }

    public IStatus validate() {
        IOffering offering = this.getOffering();
        if (offering != null) {
            int maxInstall = PlatformUtils.getMaxInstallLocationLengthForOffering((IOffering)offering);
            if (maxInstall < this.profile.getInstallLocation().length()) {
                return Statuses.ERROR.get(Messages.Profile_Offering_Install_Directory_Length, new Object[]{this.profile.getInstallLocation(), offering.getName(), maxInstall});
            }
            if (!Agent.getInstance().isAgentOffering((IOfferingOrFix)offering)) {
                int maxCache = PlatformUtils.getMaxCacheLocationLengthForOffering((IOffering)offering);
                String cacheLocation = CacheLocationManager.getInstance().getCacheLocation();
                if (cacheLocation.length() > maxCache) {
                    return Statuses.ERROR.get(Messages.CacheManager_Offering_Cache_Location_Length_2, new Object[]{offering.getName(), maxCache});
                }
            }
        }
        return Status.OK_STATUS;
    }

    @Override
    public boolean isInstall() {
        return this.type.isInstall();
    }

    @Override
    public boolean isUninstall() {
        return this.type.isUninstall();
    }

    @Override
    public boolean isModify() {
        return this.type.isModify();
    }

    @Override
    public boolean isRollback() {
        return this.type.isRollback();
    }

    @Override
    public boolean isUpdate() {
        return this.type.isUpdate();
    }

    public boolean isError() {
        return this.type.isError();
    }

    public void unresolve() {
        RepositoryUtils.unresolve((IOfferingOrFix)this.getOfferingOrFix());
    }

    public IStatus resolveFeatureIds(Agent agent, IProgressMonitor monitor) {
        IFeature[] featureArray;
        List<IFeature> featuresToAdd;
        if (this.features != null) {
            return Status.OK_STATUS;
        }
        IOffering offering = this.getOffering();
        assert (offering != null);
        IStatus s1 = agent.computeAllFeaturesInterdependencies(this.getProfile(), this.getOffering(), monitor);
        if (StatusUtil.isErrorOrCancel((IStatus)s1)) {
            return s1;
        }
        if (this.featureIds == null || this.featureIds.length() == 0) {
            featuresToAdd = this.isInstall() || this.isModify() && this.getSubType().isInstall() ? this.findClosure(offering.getFeatureGroup(), true, new HashSet(), 1) : (this.isUninstall() ? Arrays.asList(OfferingUtil.getAllFeatures((IOffering)offering)) : Collections.EMPTY_LIST);
        } else {
            featureArray = OfferingUtil.toFeaturesByFeatureIds((IOffering)offering, (String)this.featureIds);
            IStatus iStatus = this.checkFeatureIds(offering, featureArray);
            if (!iStatus.isOK()) {
                return iStatus;
            }
            featuresToAdd = Arrays.asList(featureArray);
        }
        if (this.features == null) {
            this.features = new ArrayList<IFeature>(featuresToAdd);
        } else {
            for (Object e : featuresToAdd) {
                if (this.features.contains(e)) continue;
                this.features.add(e);
            }
        }
        if (this.profile != null && (this.isInstall() || this.isUpdate() || this.isModify() && this.getSubType().isInstall())) {
            IStatus status = this.addRequiredFeatures(monitor);
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                return status;
            }
            if (this.isModify() && this.getSubType().isInstall()) {
                Set set = agent.getInstalledFeatures(this.profile, this.getOffering());
                for (IFeature feature : set) {
                    if (this.features.contains(feature)) continue;
                    this.features.add(feature);
                }
            }
            if (StatusUtil.isErrorOrCancel((IStatus)(status = this.checkAndReomoveExclusiveFeatures(agent)))) {
                return status;
            }
        }
        if (this.isUninstall() || this.isModify() && this.getSubType().isUninstall()) {
            IFeature[] iFeatureArray = featureArray = this.getFeaturesArray();
            int n = featureArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFeature iFeature = iFeatureArray[n2];
                this.addDependentFeatures(iFeature, agent);
                ++n2;
            }
        }
        return Status.OK_STATUS;
    }

    private void addDependentFeatures(IFeature feature, Agent agent) {
        IFeature[] dependents = null;
        try {
            dependents = feature.getDependentFeatures();
        }
        catch (IllegalFeatureStateException e) {
            Agent.getLogger().error((Throwable)e);
        }
        if (dependents != null) {
            int i = 0;
            while (i < dependents.length) {
                Set installedFeatures = agent.getInstalledFeatures(this.profile, this.getOffering());
                if (!this.getFeatures().contains(dependents[i]) && installedFeatures.contains(dependents[i])) {
                    this.getFeatures().add(dependents[i]);
                    this.addDependentFeatures(dependents[i], agent);
                }
                ++i;
            }
        }
    }

    private IStatus checkAndReomoveExclusiveFeatures(Agent agent) {
        IFeature[] featureArray = this.getFeaturesArray();
        LinkedHashSet<IFeature> mutualExclusiveFeatures = new LinkedHashSet<IFeature>(featureArray.length);
        int i = 0;
        while (i < featureArray.length) {
            int j = i + 1;
            while (j < featureArray.length) {
                if (this.getFeatures().contains(featureArray[i]) && this.getFeatures().contains(featureArray[j]) && this.isMutuallyExclusive(featureArray[i], featureArray[j])) {
                    Set installedFeatures = agent.getInstalledFeatures(this.profile, this.getOffering());
                    if (installedFeatures.contains(featureArray[i])) {
                        this.removeFeatureAndDependents(featureArray[i]);
                        break;
                    }
                    if (installedFeatures.contains(featureArray[j])) {
                        this.removeFeatureAndDependents(featureArray[j]);
                        break;
                    }
                    mutualExclusiveFeatures.add(featureArray[i]);
                    mutualExclusiveFeatures.add(featureArray[j]);
                }
                ++j;
            }
            ++i;
        }
        if (mutualExclusiveFeatures.size() > 0) {
            StringBuffer msg = new StringBuffer((mutualExclusiveFeatures.size() + 1) * 64);
            msg.append(Messages.AgentJob_install_mutualExclusiveFeatures_error);
            for (IFeature feature : mutualExclusiveFeatures) {
                msg.append(NLS.bind((String)Messages.AgentJob_install_mutualExclusiveFeatures, (Object)feature.getInformation().getName(), (Object)feature.getIdentity().getId()));
            }
            return Statuses.ERROR.get(msg.toString(), new Object[0]);
        }
        return Status.OK_STATUS;
    }

    boolean isMutuallyExclusive(IFeature feature1, IFeature feature2) {
        if (feature1.equals(feature2)) {
            return false;
        }
        ArrayList<IFeatureGroup> parents = new ArrayList<IFeatureGroup>();
        IFeatureGroup parent = feature1.getParent();
        while (parent != null) {
            parents.add(parent);
            parent = parent.getParent();
        }
        parent = feature2.getParent();
        while (parent != null) {
            if (parents.contains(parent)) {
                return parent.hasMutuallyExclusiveChildren();
            }
            parent = parent.getParent();
        }
        return false;
    }

    private void removeFeatureAndDependents(IFeature feature) {
        if (this.getFeatures().contains(feature)) {
            this.getFeatures().remove(feature);
            IFeature[] dependents = null;
            try {
                dependents = feature.getDependentFeatures();
            }
            catch (IllegalFeatureStateException e) {
                Agent.getLogger().error((Throwable)e);
            }
            if (dependents != null) {
                IFeature[] iFeatureArray = dependents;
                int n = dependents.length;
                int n2 = 0;
                while (n2 < n) {
                    IFeature dependent = iFeatureArray[n2];
                    this.removeFeatureAndDependents(dependent);
                    ++n2;
                }
            }
        }
    }

    private IStatus checkFeatureIds(IOffering offering, IFeature[] featuresToAdd) {
        String[] idArray;
        String[] stringArray = idArray = this.featureIds.split(",");
        int n = idArray.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            String id = element.trim();
            if (!"-".equals(id) && OfferingUtil.getFeatureByFeatureId((IFeature[])featuresToAdd, (String)id) == null) {
                return Statuses.ERROR.get(552, Messages.InstallCommand_InvalidFeatureId, new Object[]{id, offering.getIdentity().getId(), OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offering)});
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    public IStatus addRequiredFeatures(IProgressMonitor monitor) {
        UpdateOfferingJob updateOfferingJob;
        if (this.getFeatures().isEmpty() && this instanceof UpdateOfferingJob && (updateOfferingJob = (UpdateOfferingJob)this).getUpdatedOffering() != null) {
            this.setFeatures(Arrays.asList(Agent.getInstance().getDefaultFeatures(updateOfferingJob)));
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)this.getFeatures().size());
        ArrayList closure = new ArrayList();
        this.addRequiredFeature(closure, this.getOffering().getFeatureGroup());
        for (IFeature feature : this.getFeatures()) {
            try {
                IStatus st2 = this.computeRequiredFeatureClosure(closure, feature, this);
                if (StatusUtil.isErrorOrCancel((IStatus)st2)) {
                    return st2;
                }
            }
            catch (IllegalFeatureStateException e) {
                throw new AssertionError((Object)("Internal error: " + (Object)((Object)e)));
            }
            sm.worked(1);
        }
        this.encloseCurrentFeatures(closure);
        this.setFeatures(closure);
        return Status.OK_STATUS;
    }

    private void encloseCurrentFeatures(List closure) {
        List currentFeatures = this.getFeatures();
        for (Object oFeature : currentFeatures) {
            IFeature feature = (IFeature)oFeature;
            IFeatureGroup featureParent = feature.getParent();
            this.addRequiredFeaturesUpstream(featureParent, closure);
        }
    }

    private void addRequiredFeaturesUpstream(IFeatureGroup featureGroup, List closure) {
        if (featureGroup != null) {
            this.addRequiredFeature(closure, featureGroup);
            this.addRequiredFeaturesUpstream(featureGroup.getParent(), closure);
        }
    }

    private void addRequiredFeature(List closure, IFeatureGroup featureGroup) {
        List children = featureGroup.getChildren();
        for (IFeatureBase child : children) {
            if (closure.contains(child) || !child.isRequired() || !this.isApplicable(child)) continue;
            if (child instanceof IFeatureGroup) {
                this.addRequiredFeature(closure, (IFeatureGroup)child);
                continue;
            }
            if (!(child instanceof IFeature)) continue;
            closure.add(child);
        }
    }

    private IStatus computeRequiredFeatureClosure(List closure, IFeature feature, ISelectionExpression.EvaluationContext ev) throws IllegalFeatureStateException {
        IFeature[] requiredFeatures;
        if (closure.contains(feature)) {
            return Status.OK_STATUS;
        }
        closure.add(feature);
        IStatus applicability = this.getFeatureOrGroupApplicabilityStatus((IFeatureBase)feature);
        if (StatusUtil.isErrorOrCancel((IStatus)applicability) && !feature.hasApplicabilityFlag(applicability, 2) && !feature.hasApplicabilityFlag(applicability, 4)) {
            String failureMsg = MultiStatusUtil.getFailureMessage((IStatus)applicability);
            if (failureMsg == null || failureMsg.length() < 1) {
                failureMsg = NLS.bind((String)Messages.InstallCommand_NotApplicableFeatureId, (Object)feature.getIdentity(), (Object)this.getOfferingOrFix().getName());
                return Statuses.ERROR.get(failureMsg, new Object[0]);
            }
            return applicability;
        }
        IFeature[] iFeatureArray = requiredFeatures = feature.getRequiredFeatures();
        int n = requiredFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            IFeature requiredFeature = iFeatureArray[n2];
            IStatus status = this.computeRequiredFeatureClosure(closure, requiredFeature, ev);
            if (!status.isOK()) {
                return status;
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    private boolean isApplicable(IFeatureBase featureOrGroup, Map checkedFeatureOrGroups) {
        Boolean isApplicable = (Boolean)checkedFeatureOrGroups.get(featureOrGroup);
        if (isApplicable != null) {
            return isApplicable;
        }
        IStatus status = this.getFeatureOrGroupApplicabilityStatus(featureOrGroup);
        isApplicable = status.isOK() || status.matches(2) || featureOrGroup.hasApplicabilityFlag(status, 2);
        checkedFeatureOrGroups.put(featureOrGroup, isApplicable);
        if (!isApplicable.booleanValue()) {
            return false;
        }
        if (featureOrGroup instanceof IFeature) {
            IFeature[] requiredFeatures;
            IFeature feature = (IFeature)featureOrGroup;
            try {
                requiredFeatures = feature.getRequiredFeatures();
            }
            catch (IllegalFeatureStateException e) {
                ExceptionUtil.debugLogToReview((Throwable)e);
                checkedFeatureOrGroups.put(featureOrGroup, Boolean.FALSE);
                return false;
            }
            int i = 0;
            while (i < requiredFeatures.length) {
                if (!this.isApplicable((IFeatureBase)requiredFeatures[i], checkedFeatureOrGroups)) {
                    checkedFeatureOrGroups.put(featureOrGroup, Boolean.FALSE);
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean isApplicable(IFeatureBase featureOrGroup) {
        HashMap checkedFeatureOrGroups = new HashMap();
        return this.isApplicable(featureOrGroup, checkedFeatureOrGroups);
    }

    public void setFeatureIds(String featureIds) {
        assert (this.features == null);
        this.featureIds = featureIds;
    }

    public void setRelatedJobs(AgentJob[] jobs, boolean ignoreProfile) {
        if (jobs == null) {
            this.allJobs = new IAgentJob[0];
            this.relatedJobs = new IAgentJob[0];
            return;
        }
        this.allJobs = (IAgentJob[])jobs.clone();
        AgentJob[] jobsInThisProfile = null;
        if (!this.isError()) {
            ArrayList<AgentJob> realJobs = new ArrayList<AgentJob>();
            int i = 0;
            while (i < jobs.length) {
                if (!jobs[i].isError()) {
                    realJobs.add(jobs[i]);
                }
                ++i;
            }
            jobs = realJobs.toArray(new AgentJob[realJobs.size()]);
            if (ignoreProfile) {
                jobsInThisProfile = jobs;
            } else {
                Collection groupedJobs = AgentUtil.groupByProfile(jobs, false);
                for (AgentJob[] jobsInOneGroup : groupedJobs) {
                    Profile profileInJob = jobsInOneGroup[0].getProfile();
                    if (!profileInJob.getProfileId().equals(this.getProfile().getProfileId())) continue;
                    jobsInThisProfile = jobsInOneGroup;
                    break;
                }
            }
        }
        this.relatedJobs = jobsInThisProfile == null ? new IAgentJob[0] : (IAgentJob[])jobsInThisProfile.clone();
    }

    public void setRelatedJobs(AgentJob[] jobs) {
        this.setRelatedJobs(jobs, false);
    }

    public IOffering getPEKOffering() {
        return this.pekOffering;
    }

    public void setPEKOffering(IOffering offering) {
        this.pekOffering = offering;
    }

    public boolean isAcceptLicense() {
        return this.isAcceptLicense;
    }

    public void setAcceptLicense(boolean isAcceptLicense) {
        this.isAcceptLicense = isAcceptLicense;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public IStatus getFeatureSelectionStatus() {
        return this.featureSelectionStatus;
    }

    public Boolean expandFeatureTree() {
        return this.expandFeatureTree;
    }

    public void setExpandFeatureTree(Boolean expand) {
        this.expandFeatureTree = expand;
    }

    public static Set getOfferingSetFromJobs(AgentJob[] jobs) {
        HashSet<IOffering> offeringSet = new HashSet<IOffering>();
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            IOffering offering = job.getOffering();
            if (offering != null) {
                offeringSet.add(offering);
            }
            ++n2;
        }
        return offeringSet;
    }

    public Collection getOfferingsForPreReqCheck(Set offeringsSeenBefore) {
        IOffering offering = this.getOffering();
        if (offering != null) {
            return Collections.singleton(offering);
        }
        IFix fix = this.getFix();
        LinkedHashSet<IOffering> offerings = new LinkedHashSet<IOffering>();
        for (IFixApplicableOffering applicableOffering : fix.getApplicableOfferings()) {
            offering = this.getProfile().getInstallRegistry().getInstalledOffering(applicableOffering.getIdentity());
            if (offering == null || !applicableOffering.getTolerance().isIncluded(offering.getVersion()) || !this.offeringPrerequisiteChecksRequiredForIFix((IOfferingOrFix)offering) && !this.offeringPrerequisiteChecksRequiredForIFix((IOfferingOrFix)fix) || offeringsSeenBefore.contains(offering)) continue;
            offerings.add(offering);
            offeringsSeenBefore.add(offering);
        }
        return Collections.unmodifiableCollection(offerings);
    }

    private boolean offeringPrerequisiteChecksRequiredForIFix(IOfferingOrFix oof) {
        String prop = oof.getProperties().getProperty("offering.prerequisite.checks.required.for.ifix.installation", "false");
        return Boolean.parseBoolean(prop);
    }

    public boolean isFeatureOrGroupRecommended(IFeatureBase featureOrGroup) {
        return featureOrGroup.isSelectedByDefault((ISelectionExpression.EvaluationContext)this);
    }

    public IStatus getFeatureOrGroupAuxiliaryApplicabilityStatus(IFeatureBase featureOrGroup) {
        return this.m_featureAuxiliaryApplicabilityStatus.get(featureOrGroup);
    }

    public final IStatus getFeatureOrGroupApplicabilityStatus(IFeatureBase featureOrGroup) {
        return this.getFeatureOrGroupApplicabilityStatus(featureOrGroup, new HashSet<IFeatureBase>());
    }

    private final IStatus getFeatureOrGroupApplicabilityStatus(IFeatureBase featureOrGroup, HashSet<IFeatureBase> processedFeatures) {
        IStatus applicabilityStatus = this.m_featureBaseApplicabilityStatus.get(featureOrGroup);
        if (applicabilityStatus != null) {
            return applicabilityStatus;
        }
        processedFeatures.add(featureOrGroup);
        applicabilityStatus = featureOrGroup.evaluateApplicability((ISelectionExpression.EvaluationContext)this);
        if ((applicabilityStatus.isOK() || applicabilityStatus.getSeverity() == 2) && featureOrGroup instanceof IFeature) {
            IFeature feature = (IFeature)featureOrGroup;
            try {
                IFeature[] requiredFeatures;
                IFeature[] iFeatureArray = requiredFeatures = feature.getRequiredFeatures();
                int n = requiredFeatures.length;
                int n2 = 0;
                while (n2 < n) {
                    IFeature requiredFeature = iFeatureArray[n2];
                    if (!processedFeatures.contains(requiredFeature)) {
                        if (!this.canBeSelected((IFeatureBase)requiredFeature, processedFeatures)) {
                            applicabilityStatus = this.getFeatureOrGroupApplicabilityStatus((IFeatureBase)requiredFeature, processedFeatures);
                            break;
                        }
                    } else {
                        Agent.getLogger().warning(Messages.Feature_Recursive_Dependency, new Object[]{OfferingUtil.getFeatureNameId((IFeature)feature), OfferingUtil.getFeatureNameId((IFeature)requiredFeature), OfferingUtil.getOfferingOrFixLabelA((IOfferingOrFix)this.offeringOrFix, (boolean)true)});
                    }
                    ++n2;
                }
            }
            catch (IllegalFeatureStateException e) {
                ExceptionUtil.debugLogToReview((Throwable)e);
            }
        }
        this.m_featureBaseApplicabilityStatus.put(featureOrGroup, applicabilityStatus);
        processedFeatures.remove(featureOrGroup);
        return applicabilityStatus;
    }

    public final boolean canBeSelected(IFeatureBase featureOrGroup) {
        return this.canBeSelected(featureOrGroup, new HashSet<IFeatureBase>());
    }

    private final boolean canBeSelected(IFeatureBase featureOrGroup, HashSet<IFeatureBase> processedFeatures) {
        boolean canSelect;
        Boolean returnValue = this.m_canFeatureOrGroupSelected.get(featureOrGroup);
        if (returnValue != null) {
            return returnValue;
        }
        IStatus status = this.getFeatureOrGroupApplicabilityStatus(featureOrGroup, processedFeatures);
        boolean bl = canSelect = status.isOK() || status.getSeverity() == 2 || featureOrGroup.hasApplicabilityFlag(status, 2);
        if (!canSelect) {
            this.m_canFeatureOrGroupSelected.put(featureOrGroup, Boolean.FALSE);
            return false;
        }
        IFeatureGroup parentNode = featureOrGroup.getParent();
        if (parentNode != null && !this.canBeSelected((IFeatureBase)parentNode, processedFeatures)) {
            this.m_canFeatureOrGroupSelected.put(featureOrGroup, Boolean.FALSE);
            return false;
        }
        this.m_canFeatureOrGroupSelected.put(featureOrGroup, Boolean.TRUE);
        return true;
    }

    public boolean canBeRemoved(IFeatureBase featureOrGroup) {
        Boolean canRemove = this.m_canFeatureOrGroupRemoved.get(featureOrGroup);
        if (canRemove == null) {
            IStatus status = this.getFeatureOrGroupApplicabilityStatus(featureOrGroup);
            canRemove = status.getSeverity() != 4 || !featureOrGroup.hasApplicabilityFlag(status, 4);
            this.m_canFeatureOrGroupRemoved.put(featureOrGroup, canRemove);
        }
        return canRemove;
    }

    public boolean isFeatureOrGroupVisible(IFeatureBase featureOrGroup) {
        Boolean isVisible = this.m_isFeatureOrGroupVisible.get(featureOrGroup);
        if (isVisible == null) {
            if (!featureOrGroup.isVisible()) {
                this.m_isFeatureOrGroupVisible.put(featureOrGroup, Boolean.FALSE);
                return false;
            }
            IStatus status = this.getFeatureOrGroupApplicabilityStatus(featureOrGroup);
            if (!status.isOK() && status.getSeverity() != 2 && !featureOrGroup.hasApplicabilityFlag(status, 1)) {
                this.m_isFeatureOrGroupVisible.put(featureOrGroup, Boolean.FALSE);
                return false;
            }
            IFeatureGroup parent = featureOrGroup.getParent();
            if (parent != null) {
                if (!this.isFeatureOrGroupVisible((IFeatureBase)parent)) {
                    this.m_isFeatureOrGroupVisible.put(featureOrGroup, Boolean.FALSE);
                    return false;
                }
            } else {
                this.m_isFeatureOrGroupVisible.put(featureOrGroup, Boolean.TRUE);
                return true;
            }
            this.m_isFeatureOrGroupVisible.put(featureOrGroup, Boolean.TRUE);
            return true;
        }
        return isVisible;
    }

    private boolean allParentsAreRequired(IFeatureBase featureOrGroup) {
        IFeatureGroup parent = featureOrGroup.getParent();
        if (parent != null) {
            return OfferingUtil.isFeatureRequired((IFeatureBase)parent);
        }
        return true;
    }

    private boolean isFeatureSelected(IFeature feature) {
        return this.features != null && this.features.contains(feature);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasFeaturesSelected(IFeatureGroup group, boolean onlyOptional) {
        List children = group.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFeatureBase child = (IFeatureBase)children.get(i);
            if (child instanceof IFeature) {
                if (this.isFeatureSelected((IFeature)child)) {
                    if (!onlyOptional) return true;
                    if (!child.isRequired()) {
                        return true;
                    }
                }
            } else if (child instanceof IFeatureGroup && this.hasFeaturesSelected((IFeatureGroup)child, onlyOptional)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public List findClosure(IFeatureGroup group, boolean check, Set uncheckDepedentFeature, int selectMode) {
        ArrayList closure = new ArrayList();
        ArrayList cannotRemoveList = new ArrayList();
        HashSet processedElements = new HashSet();
        if (check) {
            this.addForwardClosure(group, true, processedElements, closure, selectMode);
            this.addDependsOnFeatures(processedElements, closure);
        } else {
            this.addReverseClosure(group, processedElements, closure, cannotRemoveList);
            uncheckDepedentFeature.addAll(this.removeDependentFeatures(processedElements, closure));
            this.removeDependsOnFeatures(processedElements, closure);
        }
        return closure;
    }

    public List findClosure(IFeature featureNode, boolean forward, Set dependentFeaturesToUncheck, int selectMode) {
        ArrayList closure = new ArrayList();
        HashSet processedElements = new HashSet();
        ArrayList cannotRemoveList = new ArrayList();
        if (forward) {
            this.addForwardClosure(featureNode, processedElements, closure, selectMode);
            this.addDependsOnFeatures(processedElements, closure);
        } else {
            this.addReverseClosure(featureNode, processedElements, closure, cannotRemoveList);
            if (cannotRemoveList.size() > 0) {
                closure.clear();
            } else {
                dependentFeaturesToUncheck.addAll(this.removeDependentFeatures(processedElements, closure));
                this.removeDependsOnFeatures(processedElements, closure);
            }
        }
        return closure;
    }

    private void addForwardClosure(IFeatureBase baseNode, Set processedElements, List resultList, int selectMode) {
        IFeature featureNode;
        if (baseNode instanceof IFeatureGroup) {
            this.addForwardClosure((IFeatureGroup)baseNode, false, processedElements, resultList, selectMode);
        } else if (baseNode instanceof IFeature && ((featureNode = (IFeature)baseNode).isRequired() || selectMode == 2 || selectMode == 1 && this.isFeatureOrGroupRecommended(baseNode))) {
            this.addForwardClosure(featureNode, processedElements, resultList, selectMode);
        }
    }

    private void addForwardClosure(IFeatureGroup featureGroupNode, boolean forceSelection, Set processedElements, List resultList, int selectMode) {
        if (featureGroupNode != null && !processedElements.contains(featureGroupNode) && this.canBeSelected((IFeatureBase)featureGroupNode) && (forceSelection || featureGroupNode.isRequired() || selectMode == 2 || selectMode == 1 && this.isFeatureOrGroupRecommended((IFeatureBase)featureGroupNode))) {
            processedElements.add(featureGroupNode);
            if (featureGroupNode.hasMutuallyExclusiveChildren()) {
                if (!this.hasFeaturesSelected(featureGroupNode, false)) {
                    List children = featureGroupNode.getChildren();
                    IFeatureBase selectedChild = null;
                    int i = 0;
                    while (i < children.size()) {
                        IFeatureBase child = (IFeatureBase)children.get(i);
                        if (this.isFeatureOrGroupRecommended(child)) {
                            selectedChild = child;
                            break;
                        }
                        ++i;
                    }
                    if (selectedChild == null) {
                        selectedChild = (IFeatureBase)children.get(0);
                    }
                    this.addForwardClosure(selectedChild, processedElements, resultList, selectMode);
                }
            } else {
                List children = featureGroupNode.getChildren();
                int i = 0;
                while (i < children.size()) {
                    this.addForwardClosure((IFeatureBase)children.get(i), processedElements, resultList, selectMode);
                    ++i;
                }
            }
            this.addParentForwardClosure((IFeatureBase)featureGroupNode, processedElements, resultList);
        }
    }

    private void addForwardClosure(IFeature featureNode, Set processedElements, List resultList, int selectionMode) {
        if (processedElements.add(featureNode) && this.canBeSelected((IFeatureBase)featureNode)) {
            resultList.add(featureNode);
            this.addParentForwardClosure((IFeatureBase)featureNode, processedElements, resultList);
        }
    }

    private void addParentForwardClosure(IFeatureBase featureBase, Set processedElements, List resultList) {
        IFeatureGroup parentNode = featureBase.getParent();
        if (parentNode != null && !parentNode.hasMutuallyExclusiveChildren()) {
            this.addForwardClosure(parentNode, true, processedElements, resultList, 0);
        }
    }

    public void addDependsOnFeatures(Set processedElements, List resultList) {
        this.userSelectedElements.addAll(resultList);
        List dependsOnFeatures = this.findAllDependsOnFeatures(resultList, 0);
        for (Object element : dependsOnFeatures) {
            this.dependencySelectedElements.add(element);
            if (!processedElements.add(element)) continue;
            resultList.add(element);
        }
    }

    private List findAllDependsOnFeatures(Collection featureList, int selectMode) {
        ArrayList closure = new ArrayList();
        HashSet processedElements = new HashSet();
        for (IFeature featureNode : featureList) {
            this.addDependsOnFeatures(featureNode, processedElements, closure, selectMode);
        }
        return closure;
    }

    private void addDependsOnFeatures(IFeature featureNode, Set processedElements, List closure, int selectMode) {
        ArrayList dependsOn = new ArrayList();
        try {
            IFeature[] iFeatureArray = featureNode.getRequiredFeatures();
            int n = iFeatureArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFeature requiredFeature = iFeatureArray[n2];
                this.addForwardClosure(requiredFeature, processedElements, dependsOn, selectMode);
                ++n2;
            }
        }
        catch (IllegalFeatureStateException requiredFeature) {
            // empty catch block
        }
        for (IFeature dependOnFeature : dependsOn) {
            closure.add(dependOnFeature);
            this.addDependsOnFeatures(dependOnFeature, processedElements, closure, selectMode);
        }
    }

    private void addReverseClosure(IFeatureGroup featureGroupNode, Set processedElements, List resultList, List cannotRemoveList) {
        if (featureGroupNode != null && processedElements.add(featureGroupNode)) {
            IFeatureGroup parent;
            List children = featureGroupNode.getChildren();
            int i = 0;
            while (i < children.size()) {
                IFeature featureNode;
                IFeatureBase child = (IFeatureBase)children.get(i);
                if (child instanceof IFeatureGroup) {
                    this.addReverseClosure((IFeatureGroup)child, processedElements, resultList, cannotRemoveList);
                } else if (!(!(child instanceof IFeature) || this.allParentsAreRequired((IFeatureBase)(featureNode = (IFeature)child)) && featureNode.isRequired())) {
                    this.addReverseClosure(featureNode, processedElements, resultList, cannotRemoveList);
                }
                ++i;
            }
            if (featureGroupNode.isRequired() && !this.allParentsAreRequired((IFeatureBase)featureGroupNode) && resultList.size() > 0 && (parent = featureGroupNode.getParent()) != null) {
                this.addReverseClosure(parent, processedElements, resultList, cannotRemoveList);
            }
        }
    }

    private void addReverseClosure(IFeature featureNode, Set processedElements, List resultList, List cannotRemoveList) {
        if (processedElements.add(featureNode)) {
            if (featureNode.isRequired() || !this.canBeRemoved((IFeatureBase)featureNode)) {
                if (this.canBeRemoved((IFeatureBase)featureNode) && !this.allParentsAreRequired((IFeatureBase)featureNode)) {
                    resultList.add(featureNode);
                    this.addReverseClosure(featureNode.getParent(), processedElements, resultList, cannotRemoveList);
                } else {
                    cannotRemoveList.add(featureNode);
                }
            } else {
                IFeature[] dependentFeatures;
                try {
                    dependentFeatures = featureNode.getDependentFeatures();
                }
                catch (IllegalFeatureStateException e) {
                    dependentFeatures = null;
                }
                if (dependentFeatures != null) {
                    boolean found = false;
                    IFeature[] iFeatureArray = dependentFeatures;
                    int n = dependentFeatures.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFeature dependentFeature = iFeatureArray[n2];
                        this.addReverseClosure(dependentFeature, processedElements, resultList, cannotRemoveList);
                        if (cannotRemoveList.contains(dependentFeature)) {
                            IStatus dependentNodeStatus = this.m_featureBaseApplicabilityStatus.get(dependentFeature);
                            if (dependentNodeStatus != null) {
                                IStatus auxiliaryStatus;
                                IStatus iStatus = auxiliaryStatus = dependentNodeStatus.isOK() ? this.m_featureAuxiliaryApplicabilityStatus.get(dependentFeature) : dependentNodeStatus;
                                if (auxiliaryStatus != null) {
                                    this.m_featureAuxiliaryApplicabilityStatus.put(featureNode, auxiliaryStatus);
                                }
                            }
                            cannotRemoveList.add(featureNode);
                            found = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!found) {
                        resultList.add(featureNode);
                    }
                } else {
                    resultList.add(featureNode);
                }
            }
        }
    }

    private Set removeDependentFeatures(Set processedElements, List uncheckedClosure) {
        HashSet return_result = new HashSet();
        List dependents = this.findAllDependentFeatures(uncheckedClosure);
        for (Object element : dependents) {
            if (!processedElements.add(element)) continue;
            uncheckedClosure.add(element);
            return_result.add(element);
        }
        return return_result;
    }

    private void removeDependsOnFeatures(Set processedElements, List resultList) {
        if (resultList == null || resultList.isEmpty()) {
            return;
        }
        this.userSelectedElements.removeAll(resultList);
        Set oldDependencyElements = this.dependencySelectedElements;
        this.dependencySelectedElements = new HashSet();
        this.dependencySelectedElements.addAll(this.findAllDependsOnFeatures(this.userSelectedElements, 0));
        for (Object element : oldDependencyElements) {
            if (this.userSelectedElements.contains(element)) continue;
            processedElements.add(element);
            resultList.add(element);
        }
    }

    private List findAllDependentFeatures(List featureList) {
        ArrayList closure = new ArrayList();
        HashSet processedElements = new HashSet();
        for (IFeature featureNode : featureList) {
            this.addDependentFeatures(featureNode, processedElements, closure);
        }
        return closure;
    }

    private void addDependentFeatures(IFeature featureNode, Set processedElements, List closure) {
        ArrayList dependents = new ArrayList();
        try {
            ArrayList cannotRemoveList = new ArrayList();
            IFeature[] iFeatureArray = featureNode.getDependentFeatures();
            int n = iFeatureArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFeature dependentFeature = iFeatureArray[n2];
                this.addReverseClosure(dependentFeature, processedElements, dependents, cannotRemoveList);
                ++n2;
            }
        }
        catch (IllegalFeatureStateException e) {
            Agent.getLogger().error((Throwable)e);
        }
        for (IFeature dependentFeature : dependents) {
            closure.add(dependentFeature);
            this.addDependentFeatures(dependentFeature, processedElements, closure);
        }
    }

    public List findExclusionFeatures(List featureNodes) {
        ArrayList closure = new ArrayList();
        HashSet processedElements = new HashSet(featureNodes);
        boolean cannotRemove = false;
        Iterator iterator = featureNodes.iterator();
        while (iterator.hasNext()) {
            ArrayList innerClosure = new ArrayList();
            ArrayList innerCannotRemoveList = new ArrayList();
            IFeature featureNode = (IFeature)iterator.next();
            IFeatureGroup groupNode = featureNode.getParent();
            if (!groupNode.hasMutuallyExclusiveChildren()) continue;
            this.addReverseClosure(groupNode, processedElements, innerClosure, innerCannotRemoveList);
            if (innerCannotRemoveList.size() > 0) {
                cannotRemove = true;
                break;
            }
            this.removeDependsOnFeatures(processedElements, innerClosure);
            closure.addAll(innerClosure);
        }
        if (cannotRemove) {
            featureNodes.clear();
            closure.clear();
        }
        return closure;
    }

    public void resetFeatureSelectionSet() {
        this.userSelectedElements.clear();
        this.dependencySelectedElements.clear();
    }

    public Set getUserSelectedFeatures() {
        return this.userSelectedElements;
    }

    public Set getDependencySelectedFeatures() {
        return this.dependencySelectedElements;
    }

    public void resetFeatureStatus() {
        this.m_canFeatureOrGroupSelected.clear();
        this.m_canFeatureOrGroupRemoved.clear();
        this.m_isFeatureOrGroupVisible.clear();
        this.m_featureBaseApplicabilityStatus.clear();
        this.m_featureAuxiliaryApplicabilityStatus.clear();
        this.predefinedSelectorOverrides = null;
    }

    public String getBaseId() {
        return this.baseId;
    }

    public void setBaseId(String baseId) {
        this.baseId = baseId;
    }

    public static class AgentJobType
    implements IAgentJobType {
        public static final AgentJobType INSTALL_JOB = new AgentJobType("InstallJob");
        public static final AgentJobType UNINSTALL_JOB = new AgentJobType("UninstallJob");
        public static final AgentJobType UPDATE_JOB = new AgentJobType("UpdateJob");
        public static final AgentJobType MODIFY_JOB = new AgentJobType("ModifyJob");
        public static final AgentJobType RECORD_JOB = new AgentJobType("RecordJob");
        public static final AgentJobType ROLLBACK_JOB = new AgentJobType("RollbackJob");
        public static final AgentJobType ERROR_JOB = new AgentJobType("ErrorJob");
        private final String jobType;

        protected AgentJobType(String jobType) {
            this.jobType = jobType;
        }

        public String toString() {
            return this.jobType;
        }

        public boolean equals(Object object) {
            return object instanceof AgentJobType && this.jobType.equals(object.toString());
        }

        public int hashCode() {
            return this.jobType.hashCode();
        }

        public String getJobType() {
            return this.jobType;
        }

        @Override
        public boolean isInstall() {
            return INSTALL_JOB.equals(this);
        }

        @Override
        public boolean isUninstall() {
            return UNINSTALL_JOB.equals(this);
        }

        @Override
        public boolean isModify() {
            return MODIFY_JOB.equals(this);
        }

        @Override
        public boolean isRollback() {
            return ROLLBACK_JOB.equals(this);
        }

        @Override
        public boolean isUpdate() {
            return UPDATE_JOB.equals(this);
        }

        public boolean isError() {
            return ERROR_JOB.equals(this);
        }
    }

    private static class JobsComparator
    extends Agent.OfferingComparator {
        private final boolean ascending;

        public JobsComparator(boolean ascending) {
            this.ascending = ascending;
        }

        @Override
        public int compare(Object arg1, Object arg2) {
            AgentJob job1 = (AgentJob)arg1;
            AgentJob job2 = (AgentJob)arg2;
            int cmp = job1.getProfile().getProfileId().compareTo(job2.getProfile().getProfileId());
            if (cmp == 0) {
                IOffering o1 = job1.getOffering();
                IOffering o2 = job2.getOffering();
                cmp = o1 == null && o2 == null ? 0 : (o1 == null ? 1 : (o2 == null ? -1 : super.compare(o1, o2)));
            }
            return this.ascending ? cmp : -cmp;
        }
    }
}

