/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.state;

import com.ibm.ut.help.common.event.ProgressMonitor;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class State {
    public static final String ID = "id";
    public static final String STATE = "state";
    public static final String JOB = "job";
    public static final String MESSAGE = "message";
    public static final String PERCENT = "percent";
    public static final String ERROR = "error";
    public static final String STACK = "stack";
    private int id = -1;
    private String job = "";
    private String message = "";
    private int percent = 0;
    private String error = "";
    private String stack = "";
    public static final State NULL = new State(-1, "", "", 0);
    public static final State IDLE = new State(0, "", "", 0);

    public State(int id, String job, String message, int percentage) {
        this(id, job, message, percentage, "");
    }

    public State(int id, String job, String message, int percentage, String error) {
        this.id = id;
        this.job = job;
        this.message = message;
        this.percent = percentage;
        this.error = error;
    }

    public State(int id, String job, String message, int percentage, Throwable e) {
        this.id = id;
        this.job = job;
        this.message = message;
        this.percent = percentage;
        this.setException(e);
    }

    public State(ProgressMonitor monitor) {
        this(1, monitor.getTitle(), monitor.getSubtitle(), monitor.getProgressPercent(), "");
        if (monitor.isIndeterminate()) {
            this.percent = -1;
        }
        if (monitor.exceptionThrown() != null) {
            this.setException(monitor.exceptionThrown());
        }
    }

    public State(InputStream in) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            SAXParser parser = factory.newSAXParser();
            StateParser sp = new StateParser();
            parser.parse(in, (DefaultHandler)sp);
            in.close();
            sp = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getJob() {
        return this.job;
    }

    public void setJob(String job) {
        this.job = job;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getPercent() {
        return this.percent;
    }

    public void setPercent(int percent) {
        this.percent = percent;
    }

    public void setException(Throwable e) {
        this.error = e.getLocalizedMessage();
        this.stack = State.exceptionToString(e);
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getStack() {
        return this.stack;
    }

    public void setStack(String stack) {
        this.stack = stack;
    }

    public String toXML() {
        Object xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        xml = (String)xml + "<state>\n";
        xml = (String)xml + "\t<id>" + this.getId() + "</id>\n";
        xml = (String)xml + "\t<job>" + this.getJob() + "</job>\n";
        xml = (String)xml + "\t<message>" + this.getMessage() + "</message>\n";
        xml = (String)xml + "\t<percent>" + this.getPercent() + "</percent>\n";
        xml = (String)xml + "\t<error>" + this.getError() + "</error>\n";
        xml = (String)xml + "\t<stack>" + this.getStack() + "</stack>\n";
        xml = (String)xml + "</state>\n";
        return xml;
    }

    public String toString() {
        String str = this.getJob() + "#" + this.getMessage() + "#" + this.getPercent() + "#ID: " + this.getId();
        if (!this.getError().equals("")) {
            str = str + "\n" + this.getError();
        }
        return str;
    }

    public static String stack(Throwable e) {
        StringBuffer buffer = new StringBuffer();
        StackTraceElement[] stack = e.getStackTrace();
        int s = 0;
        while (s < stack.length) {
            buffer.append(stack[s].toString());
            buffer.append("\n");
            ++s;
        }
        return buffer.toString();
    }

    public static String exceptionToString(Throwable e) {
        StringBuffer buffer = new StringBuffer();
        try {
            String line;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(out));
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
                buffer.append("\n");
            }
            reader.close();
            out.close();
        }
        catch (Exception exception) {}
        return buffer.toString();
    }

    private class StateParser
    extends DefaultHandler {
        private Stack tags = new Stack();

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.tags.push(qName);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.tags.pop();
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            String name = (String)this.tags.peek();
            String chars = new String(ch, start, length);
            if (State.MESSAGE.equals(name)) {
                State.this.message = chars;
            } else if (State.PERCENT.equals(name)) {
                State.this.percent = Integer.parseInt(chars);
            } else if (State.JOB.equals(name)) {
                State.this.job = chars;
            } else if (State.ERROR.equals(name)) {
                State.this.error = chars;
            } else if (State.STACK.equals(name)) {
                State.this.stack = chars;
            } else if (State.ID.equals(name)) {
                State.this.id = Integer.parseInt(chars);
            }
        }
    }
}

