/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.parser;

import com.ibm.ut.help.parser.ITagHandler;
import com.ibm.ut.help.parser.TagElement;
import com.ibm.ut.help.parser.TagInputStreamReader;
import com.ibm.ut.help.parser.TextElement;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Stack;

public class TagParser {
    private ITagHandler handler;
    private Stack elementStack;
    private boolean stop = false;
    private TagElement root;
    private boolean addReferences = true;
    private boolean selfCorrecting = true;
    private String charset = Charset.defaultCharset().name();

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public TagElement parse(InputStream in, ITagHandler handler) throws IOException {
        String chunk;
        TagInputStreamReader reader = new TagInputStreamReader(in, this.charset);
        this.handler = handler;
        this.elementStack = new Stack();
        this.root = new TagElement(null);
        this.elementStack.push(this.root);
        while ((chunk = reader.readNextChunk()) != null && !this.stop) {
            this.processChunk(chunk);
        }
        reader.close();
        in.close();
        return this.getRoot();
    }

    public void setSelfCorrecting(boolean val) {
        this.selfCorrecting = val;
    }

    public void setAddReferences(boolean val) {
        this.addReferences = val;
    }

    public TagElement getRoot() {
        return this.root;
    }

    public void forceStop() {
        this.stop = true;
    }

    private void processChunk(String chunk) {
        this.appendCodeToStack(chunk);
        if (chunk.startsWith("<!--")) {
            TagElement parent = (TagElement)this.elementStack.peek();
            TextElement comment = new TextElement(chunk);
            comment.setInline(false);
            if (this.addReferences) {
                parent.addChild(comment);
            }
            this.handler.comment(chunk);
            return;
        }
        if (chunk.startsWith("<![CDATA[")) {
            this.characters(chunk.substring("<![CDATA[".length(), chunk.indexOf("]]>")));
            return;
        }
        if (chunk.startsWith("<")) {
            TagElement element;
            String name = this.getName(chunk);
            if (!chunk.startsWith("</")) {
                if (chunk.startsWith("<!")) {
                    TagElement parent = (TagElement)this.elementStack.peek();
                    TextElement spec = new TextElement(chunk);
                    spec.setInline(false);
                    if (this.addReferences) {
                        parent.addChild(spec);
                    }
                    this.handler.comment(chunk);
                } else {
                    Properties props = this.makeProps(chunk);
                    element = new TagElement(name, props);
                    element.appendCode(chunk);
                    if (chunk.endsWith("/>")) {
                        element.setEndTag(true);
                    }
                    if (chunk.startsWith("<?") || chunk.startsWith("<!")) {
                        element.setSpecialTag(true);
                    }
                    TagElement parent = (TagElement)this.elementStack.peek();
                    if (this.addReferences) {
                        parent.addChild(element);
                    }
                    if (!element.isSpecialTag()) {
                        this.elementStack.push(element);
                    }
                    this.handler.startElement(element);
                }
            }
            if (chunk.startsWith("</") || chunk.endsWith("/>")) {
                Stack tempStack = (Stack)this.elementStack.clone();
                if (tempStack.isEmpty()) {
                    element = new TagElement(name.replaceAll("/", ""), new Properties());
                } else {
                    element = (TagElement)tempStack.pop();
                    String endTag = name.replaceAll("/", "");
                    String stackTag = element.getTag();
                    while (stackTag != null && !stackTag.equals(endTag) && tempStack.size() != 1 && this.selfCorrecting) {
                        element = (TagElement)tempStack.pop();
                        stackTag = element.getTag();
                    }
                    if (tempStack.isEmpty()) {
                        element = new TagElement(name.replaceAll("/", ""), new Properties());
                    } else {
                        this.elementStack = tempStack;
                    }
                }
                element.setEndTag(true);
                this.handler.endElement(element);
            }
        } else {
            this.characters(chunk);
        }
    }

    private void appendCodeToStack(String chunk) {
        int e = 0;
        while (e < this.elementStack.size()) {
            ((TagElement)this.elementStack.get(e)).appendCode(chunk);
            ++e;
        }
    }

    private boolean isInline(String name) {
        if (name.equalsIgnoreCase("span")) {
            return true;
        }
        if (name.equalsIgnoreCase("strong")) {
            return true;
        }
        if (name.equalsIgnoreCase("b")) {
            return true;
        }
        return name.equalsIgnoreCase("em");
    }

    private void characters(String chunk) {
        boolean inline;
        String cleanChunk;
        if (!(chunk.contains("\n") || chunk.contains("\r") || chunk.startsWith("<!--"))) {
            cleanChunk = chunk;
            inline = true;
        } else {
            inline = false;
            cleanChunk = chunk.replaceAll("\n", "");
            cleanChunk.replaceAll("\r", "");
        }
        if (chunk.contains("\u2019")) {
            cleanChunk = chunk = chunk.replaceAll("\u2019", "'");
        }
        if (chunk.contains("\ufffd")) {
            cleanChunk = chunk.replaceAll("\ufffd", "'");
        }
        if (!cleanChunk.trim().equals("") && !this.elementStack.isEmpty()) {
            TextElement textElement = new TextElement(cleanChunk);
            textElement.setInline(inline);
            TagElement element = (TagElement)this.elementStack.peek();
            if (this.addReferences) {
                element.addChild(textElement);
            }
            this.handler.characters(element, cleanChunk);
        }
    }

    public Stack getElementStack() {
        return this.elementStack;
    }

    public TagElement getCurrentTag() {
        return (TagElement)this.elementStack.peek();
    }

    public TagElement getParentTag() {
        if (this.elementStack.size() >= 2) {
            return (TagElement)this.elementStack.get(this.elementStack.size() - 2);
        }
        return null;
    }

    public TagElement getAncestorTag(String tag) {
        int e = this.elementStack.size() - 1;
        while (e >= 0) {
            TagElement elem = (TagElement)this.elementStack.get(e);
            if (elem.getTag() != null && elem.getTag().equals(tag)) {
                return elem;
            }
            --e;
        }
        return null;
    }

    public TagElement getAncestorTag(String tag, String property, String value) {
        int e = this.elementStack.size() - 1;
        while (e >= 0) {
            TagElement elem = (TagElement)this.elementStack.get(e);
            if (elem.getTag().equals(tag) && elem.getProps().getProperty(property) != null && elem.getProps().getProperty(property).equals(value)) {
                return elem;
            }
            --e;
        }
        return null;
    }

    private String getName(String tag) {
        int index = this.getFirstSpace(tag = tag.substring(1));
        if (index > -1) {
            tag = tag.substring(0, index).trim();
        } else {
            if (tag.endsWith(">")) {
                tag = tag.substring(0, tag.length() - 1);
            }
            if (tag.endsWith("/")) {
                tag = tag.substring(0, tag.length() - 1);
            }
            if (tag.endsWith("?")) {
                tag = tag.substring(0, tag.length() - 1);
            }
        }
        return tag;
    }

    private int getFirstSpace(String tag) {
        int r;
        int n;
        ArrayList<Integer> list = new ArrayList<Integer>();
        int s = tag.indexOf(" ");
        if (s > -1) {
            list.add(new Integer(s));
        }
        if ((n = tag.indexOf("\n")) > -1) {
            list.add(new Integer(n));
        }
        if ((r = tag.indexOf("\r")) > -1) {
            list.add(new Integer(r));
        }
        if (list.isEmpty()) {
            return -1;
        }
        int min = (Integer)list.get(0);
        int l = 1;
        while (l < list.size()) {
            if ((Integer)list.get(l) < min) {
                min = (Integer)list.get(l);
            }
            ++l;
        }
        return min;
    }

    private Properties makeProps(String tag) {
        Object line = tag.replaceAll("\n", " ").replaceAll("\r", " ");
        Properties props = new Properties();
        if (!((String)line).contains(" ")) {
            return props;
        }
        if (((String)(line = ((String)line).substring(((String)line).indexOf(" ")).trim())).endsWith(">")) {
            line = ((String)line).substring(0, ((String)line).length() - 1);
        }
        if (((String)line).endsWith("/")) {
            line = ((String)line).substring(0, ((String)line).length() - 1);
        }
        if (((String)line).endsWith("?")) {
            line = ((String)line).substring(0, ((String)line).length() - 1);
        }
        String[] tmp = ((String)line).split("=");
        line = "";
        int t = 0;
        while (t < tmp.length) {
            line = (String)line + tmp[t].trim() + "=";
            ++t;
        }
        line = ((String)line).substring(0, ((String)line).length() - 1);
        Object prop = "";
        Object val = "";
        boolean isName = true;
        int isQuote = 0;
        int t2 = 0;
        while (t2 < ((String)line).length()) {
            char c = ((String)line).charAt(t2);
            if (c == '=' && isQuote == 0) {
                isName = false;
            } else if (c == '\'') {
                if (isQuote == 0) {
                    isQuote = 1;
                } else if (isQuote == 1) {
                    isQuote = 0;
                } else if (isQuote == 2) {
                    val = (String)val + c;
                }
            } else if (c == '\"') {
                if (isQuote == 0) {
                    isQuote = 2;
                } else if (isQuote == 2) {
                    isQuote = 0;
                } else if (isQuote == 1) {
                    val = (String)val + c;
                }
            } else if (c == ' ' && isQuote == 0) {
                isName = true;
                if (!((String)prop).equals("")) {
                    props.put(((String)prop).trim(), val);
                }
                prop = "";
                val = "";
            } else if (isName) {
                prop = (String)prop + c;
            } else {
                val = (String)val + c;
            }
            ++t2;
        }
        props.put(((String)prop).trim(), val);
        return props;
    }
}

