/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.web;

import com.ibm.ut.help.common.web.HTTPSUtil;
import com.ibm.ut.help.common.web.JSONProxy;
import com.ibm.ut.help.parser.json.JSONElement;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.internal.net.ProxyManager;
import org.eclipse.core.net.proxy.IProxyChangeListener;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.CoreException;

public class ProxyUtil {
    private static IProxyService manager = ProxyManager.getProxyManager();

    public static void addProxyChangeListener(IProxyChangeListener listener) {
        manager.addProxyChangeListener(listener);
    }

    public static void removeProxyChangeListener(IProxyChangeListener listener) {
        if (listener != null) {
            try {
                manager.removeProxyChangeListener(listener);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public static boolean isAuthConnSupported() {
        try {
            Class.forName("org.eclipse.core.net.proxy.IProxyService");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static IProxyData getProxy(URL url) {
        URI uri;
        IProxyService service;
        block6: {
            if (!ProxyUtil.isAuthConnSupported()) {
                return null;
            }
            service = manager;
            if (!service.isProxiesEnabled()) {
                return null;
            }
            try {
                uri = url.toURI();
                if (!ProxyUtil.shouldBypass(uri)) break block6;
                return null;
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return null;
            }
        }
        IProxyData[] data = service.select(uri);
        if (data.length == 0) {
            return null;
        }
        return data[0];
    }

    public static boolean shouldBypass(URI uri) {
        String host = uri.getHost();
        if (host == null) {
            return true;
        }
        List<String> hosts = ProxyUtil.getProxyBypassHosts();
        if (hosts.contains(host)) {
            return true;
        }
        return (host.equals("localhost") || host.equals("127.0.0.1")) && hosts.contains("<local>");
    }

    public static void setProxy(IProxyData proxy) {
        if (!ProxyUtil.isAuthConnSupported()) {
            return;
        }
        IProxyService service = manager;
        IProxyData[] data = service.getProxyData();
        int d = 0;
        while (d < data.length) {
            if (data[d].getType().equalsIgnoreCase(proxy.getType())) {
                data[d] = proxy;
            }
            ++d;
        }
        try {
            service.setProxyData(data);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void setProvider(JSONElement element) {
        if (element.get((Object)"items") != null) {
            element = (JSONElement)((List)element.get((Object)"items")).get(0);
        }
        ProxyUtil.setProvider(element.getProperty("isEnabled").equals("true"), element.getProperty("isSysEnabled").equals("true"));
    }

    public static void setProvider(boolean isEnabled, boolean isSysEnabled) {
        manager.setProxiesEnabled(isEnabled);
        manager.isProxiesEnabled();
        manager.setSystemProxiesEnabled(isSysEnabled);
    }

    public static void setProxy(JSONElement element) {
        if (element.get((Object)"items") != null) {
            element = (JSONElement)((List)element.get((Object)"items")).get(0);
        }
        boolean auth = element.getProperty("requiresAuthentication").equals("true");
        int port = element.getProperty("port").equals("") ? -1 : Integer.parseInt(element.getProperty("port"));
        ProxyData proxy = new ProxyData(element.getProperty("type"), element.getProperty("host"), port, auth, null);
        if (auth) {
            proxy.setUserid(element.getProperty("userid"));
            proxy.setPassword(element.getProperty("password"));
        }
        ProxyUtil.setProxy((IProxyData)proxy);
    }

    public static void setProxy(String type, String host, int port, String source) {
        ProxyUtil.setProxy((IProxyData)new ProxyData(type, host, port, false, source));
    }

    public static void setProxy(String type, String host, int port, String user, String password, String source) {
        ProxyData proxy = new ProxyData(type, host, port, true, source);
        proxy.setUserid(user);
        proxy.setPassword(password);
        ProxyUtil.setProxy((IProxyData)proxy);
    }

    public static List<String> getProxyBypassHosts() {
        ArrayList<String> hosts = new ArrayList<String>();
        if (!ProxyUtil.isAuthConnSupported()) {
            return hosts;
        }
        IProxyService service = manager;
        String[] manuals = service.getNonProxiedHosts();
        String[] natives = null;
        if (service instanceof ProxyManager) {
            natives = ((ProxyManager)service).getNativeNonProxiedHosts();
        }
        int m = 0;
        while (m < manuals.length) {
            hosts.add(manuals[m]);
            ++m;
        }
        if (natives != null) {
            int n = 0;
            while (n < natives.length) {
                hosts.add(natives[n]);
                ++n;
            }
        }
        return hosts;
    }

    private static URLConnection followRedirects(URL url, Proxy proxy) throws IOException {
        URLConnection c = url.openConnection(proxy);
        while (c instanceof HttpURLConnection && (((HttpURLConnection)c).getResponseCode() == 301 || ((HttpURLConnection)c).getResponseCode() == 302)) {
            url = new URL(c.getHeaderField("Location"));
            c = url.openConnection(proxy);
        }
        return url.openConnection(proxy);
    }

    public static URLConnection getConnection(URL url) throws IOException {
        Proxy proxy = Proxy.NO_PROXY;
        IProxyData data = ProxyUtil.getProxy(url);
        if (data != null) {
            if (data.isRequiresAuthentication()) {
                Authenticator.setDefault(new ProxyAuthenticator(data.getUserId(), data.getPassword()));
            } else {
                Authenticator.setDefault(null);
            }
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(data.getHost(), data.getPort()));
        }
        if (url.toString().startsWith("https")) {
            return HTTPSUtil.getConnection(url, proxy);
        }
        return ProxyUtil.followRedirects(url, proxy);
    }

    public static InputStream getStream(URL url) throws IOException {
        return ProxyUtil.getConnection(url).getInputStream();
    }

    public static boolean isProxiesEnabled() {
        return manager.isProxiesEnabled();
    }

    public static boolean isSystemProxiesEnabled() {
        return manager.isSystemProxiesEnabled();
    }

    public static JSONElement serializeProxyBypassHostsJSON(Locale locale) {
        IProxyService service = manager;
        String[] manuals = service.getNonProxiedHosts();
        String[] natives = null;
        if (service instanceof ProxyManager) {
            natives = ((ProxyManager)service).getNativeNonProxiedHosts();
        }
        ArrayList<JSONElement> elements = new ArrayList<JSONElement>();
        if (ProxyUtil.isAuthConnSupported()) {
            JSONElement element;
            int m = 0;
            while (m < manuals.length) {
                element = new JSONElement();
                element.setProperty("host", manuals[m]);
                element.setProperty("provider", "Manual");
                element.setProperty("id", manuals[m] + "-Manual");
                elements.add(element);
                ++m;
            }
            if (natives != null) {
                int n = 0;
                while (n < natives.length) {
                    element = new JSONElement();
                    element.setProperty("host", natives[n]);
                    element.setProperty("provider", "Native");
                    element.setProperty("id", natives[n] + "-Native");
                    elements.add(element);
                    ++n;
                }
            }
        }
        JSONElement root = new JSONElement();
        root.setProperty("label", "host");
        root.setProperty("identifier", "id");
        root.put((Object)"items", elements);
        return root;
    }

    public static JSONElement serializeProxiesJSON() {
        IProxyService service = manager;
        IProxyData[] manuals = service.getProxyData();
        IProxyData[] natives = new IProxyData[]{};
        if (service instanceof ProxyManager) {
            natives = ((ProxyManager)service).getNativeProxyData();
        }
        JSONProxy[] proxies = new JSONProxy[manuals.length + natives.length];
        int m = 0;
        while (m < manuals.length) {
            proxies[m] = new JSONProxy(manuals[m], "Manual");
            ++m;
        }
        int n = 0;
        while (n < natives.length) {
            proxies[manuals.length + n] = new JSONProxy(natives[n], "Native");
            ++n;
        }
        return ProxyUtil.serializeProxiesJSON(proxies);
    }

    public static JSONElement serializeProxiesJSON(JSONProxy[] proxies) {
        ArrayList<JSONElement> elements = new ArrayList<JSONElement>();
        if (!ProxyUtil.isAuthConnSupported()) {
            return null;
        }
        int p = 0;
        while (p < proxies.length) {
            elements.add(proxies[p].toJSON());
            ++p;
        }
        JSONElement root = new JSONElement();
        root.setProperty("label", "type");
        root.setProperty("identifier", "id");
        root.put((Object)"isEnabled", (Object)new Boolean(ProxyUtil.isProxiesEnabled()));
        root.put((Object)"isSysEnabled", (Object)new Boolean(ProxyUtil.isSystemProxiesEnabled()));
        root.put((Object)"items", elements);
        return root;
    }

    public static JSONElement serializeProxyJSON(String type) {
        IProxyService service = manager;
        IProxyData[] proxies = service.getProxyData();
        int p = 0;
        while (p < proxies.length) {
            if (proxies[p].getType().equalsIgnoreCase(type)) {
                return ProxyUtil.serializeProxiesJSON(new JSONProxy[]{new JSONProxy(proxies[p], "Manual")});
            }
            ++p;
        }
        return null;
    }

    public static void setProxies(JSONElement root) {
        if (!ProxyUtil.isAuthConnSupported()) {
            return;
        }
        if (root == null) {
            return;
        }
        IProxyService service = manager;
        if (root.getProperty("isEnabled") != null) {
            service.setProxiesEnabled(Boolean.parseBoolean(root.getProperty("isEnabled")));
        }
        if (root.getProperty("isSysEnabled") != null) {
            service.setSystemProxiesEnabled(Boolean.parseBoolean(root.getProperty("isSysEnabled")));
        }
        if (root.get((Object)"items") != null) {
            ArrayList elements = (ArrayList)root.get((Object)"items");
            int e = 0;
            while (e < elements.size()) {
                JSONElement element = (JSONElement)elements.get(e);
                ProxyUtil.setProxy(element);
                ++e;
            }
        }
    }

    public static void setProxyBypassHost(JSONElement element) {
        if (!ProxyUtil.isAuthConnSupported()) {
            return;
        }
        if (element.get((Object)"items") != null) {
            element = (JSONElement)((List)element.get((Object)"items")).get(0);
        }
        IProxyService service = manager;
        String[] hosts = service.getNonProxiedHosts();
        int h = 0;
        while (h < hosts.length) {
            if (hosts[h].equals(element.getProperty("id"))) {
                hosts[h] = element.getProperty("host");
            }
            ++h;
        }
        try {
            service.setNonProxiedHosts(hosts);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void addProxyBypassHost(JSONElement element) {
        if (element.get((Object)"items") != null) {
            element = (JSONElement)((List)element.get((Object)"items")).get(0);
        }
        ProxyUtil.addProxyBypassHost(element.getProperty("host"));
    }

    public static void addProxyBypassHost(String host) {
        if (!ProxyUtil.isAuthConnSupported()) {
            return;
        }
        IProxyService service = manager;
        String[] hosts = service.getNonProxiedHosts();
        String[] newHosts = new String[hosts.length + 1];
        int h = 0;
        while (h < hosts.length) {
            if (hosts[h].equals(host)) {
                return;
            }
            newHosts[h] = hosts[h];
            ++h;
        }
        newHosts[hosts.length] = host;
        try {
            service.setNonProxiedHosts(newHosts);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void removeProxyBypassHost(JSONElement element) {
        if (element.get((Object)"items") != null) {
            element = (JSONElement)((List)element.get((Object)"items")).get(0);
        }
        ProxyUtil.removeProxyBypassHost(element.getProperty("host"));
    }

    public static void removeProxyBypassHost(int index) {
        if (!ProxyUtil.isAuthConnSupported()) {
            return;
        }
        IProxyService service = manager;
        String[] hosts = service.getNonProxiedHosts();
        if (hosts.length <= index) {
            return;
        }
        ArrayList<String> newHosts = new ArrayList<String>();
        int h = 0;
        while (h < hosts.length) {
            if (h != index) {
                newHosts.add(hosts[h]);
            }
            ++h;
        }
        try {
            service.setNonProxiedHosts(newHosts.toArray(new String[newHosts.size()]));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void removeProxyBypassHost(String host) {
        if (!ProxyUtil.isAuthConnSupported()) {
            return;
        }
        IProxyService service = manager;
        String[] hosts = service.getNonProxiedHosts();
        if (hosts.length == 0) {
            return;
        }
        ArrayList<String> newHosts = new ArrayList<String>();
        int h = 0;
        while (h < hosts.length) {
            if (!hosts[h].equals(host)) {
                newHosts.add(hosts[h]);
            }
            ++h;
        }
        try {
            service.setNonProxiedHosts(newHosts.toArray(new String[newHosts.size()]));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void setProxyBypassHosts(JSONElement root) {
        if (!ProxyUtil.isAuthConnSupported()) {
            return;
        }
        if (root != null && root.get((Object)"items") != null) {
            ArrayList elements = (ArrayList)root.get((Object)"items");
            String[] hosts = new String[elements.size()];
            int e = 0;
            while (e < elements.size()) {
                JSONElement element = (JSONElement)elements.get(e);
                hosts[e] = element.getProperty("host");
                ++e;
            }
            IProxyService service = manager;
            try {
                service.setNonProxiedHosts(hosts);
            }
            catch (CoreException e2) {
                e2.printStackTrace();
            }
        }
    }

    public static void fixNativeLocal() {
        if (!ProxyUtil.isAuthConnSupported()) {
            return;
        }
        IProxyService service = manager;
        boolean cfr_ignored_0 = service instanceof ProxyManager;
    }

    private static class ProxyAuthenticator
    extends Authenticator {
        private String user;
        private String password;

        public ProxyAuthenticator(String user, String password) {
            this.user = user;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password.toCharArray());
        }
    }
}

