/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.topic.modifiers;

import com.ibm.ut.help.common.ITopicModifier;
import com.ibm.ut.help.common.MessageLibrary;
import com.ibm.ut.help.common.prefs.Preferences;
import com.ibm.ut.help.common.web.LocaleUtil;
import com.ibm.ut.help.parser.TagElement;
import com.ibm.ut.help.parser.TagParser;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class VersionTopicModifier
implements ITopicModifier {
    private IConfigurationElement[] configs;
    private Preferences prefs = new Preferences("com.ibm.ut.help.common");
    private String version = null;
    private Locale locale;
    private boolean modified = false;

    public VersionTopicModifier() {
        this.configs = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.ut.help.common.topicVersion");
    }

    public String getICVersion() {
        if (this.version != null) {
            return this.version;
        }
        Version[] versions = new Version[this.configs.length];
        int c = 0;
        while (c < this.configs.length) {
            String pluginID = this.configs[c].getAttribute("productPlugin");
            Bundle bundle = Platform.getBundle((String)pluginID);
            versions[c] = bundle != null ? bundle.getVersion() : new Version(0, 0, 0);
            ++c;
        }
        Arrays.sort(versions, new VersionComparator());
        boolean includeQualifier = this.configs.length == 1 ? this.configs[0].getAttribute("includeQualifier").equals("true") : false;
        this.version = versions[versions.length - 1].toString();
        this.version = includeQualifier ? this.version : this.version.substring(0, this.version.lastIndexOf("."));
        return this.version;
    }

    public void startElement(TagElement element) {
    }

    public void endElement(TagElement element) {
        if (element.getTag().equals("span") && element.getProperty("class").contains("runningfooter") && !this.alreadyHasVersion(element)) {
            Properties props = new Properties();
            props.setProperty("class", "topicVersionDescription");
            TagElement span = new TagElement("span", props);
            span.addChild((Object)(MessageLibrary.getString("Version", this.locale) + ": " + this.getICVersion()));
            element.addChild((Object)span);
            this.modified = true;
        }
    }

    private boolean alreadyHasVersion(TagElement element) {
        List kids = element.getChildren();
        int k = 0;
        while (k < kids.size()) {
            if (((TagElement)kids.get(k)).getTag() != null && ((TagElement)kids.get(k)).getTag().equals("span") && ((TagElement)kids.get(k)).getProperty("class").contains("topicVersionDescription")) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public void characters(TagElement element, String chars) {
    }

    public void comment(String chunk) {
    }

    @Override
    public boolean isEnabled() {
        return this.prefs.get("topicVersionsEnabled").equals("true");
    }

    @Override
    public boolean shouldModify(HttpServletRequest request) {
        this.locale = LocaleUtil.getLocale(request);
        return this.configs.length > 0;
    }

    @Override
    public void setParser(TagParser parser) {
    }

    @Override
    public boolean didModify() {
        return this.modified;
    }

    private class VersionComparator
    implements Comparator {
        private VersionComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            return ((Version)arg0).compareTo((Version)arg1);
        }
    }
}

