/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.topic.modifiers;

import com.ibm.ut.help.common.ITopicModifier;
import com.ibm.ut.help.common.io.MutableHTMLOutputStream;
import com.ibm.ut.help.common.prefs.Preferences;
import com.ibm.ut.help.common.web.LocaleUtil;
import com.ibm.ut.help.parser.TagElement;
import com.ibm.ut.help.parser.TagParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class BannerTopicModifier
implements ITopicModifier {
    private IConfigurationElement[] configs;
    private IConfigurationElement current;
    private Preferences prefs = new Preferences("com.ibm.ut.help.common");
    private Locale locale;
    private TagParser parser;
    private String baseURL;
    private boolean modified = false;

    public IConfigurationElement[] getConfigs() {
        if (this.configs == null) {
            this.configs = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.ut.help.common.topicBanner");
        }
        return this.configs;
    }

    public void startElement(TagElement element) {
    }

    public void endElement(TagElement element) {
        if (element.getTag().equals("body")) {
            boolean showBreadcrumbs = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "showBreadcrumbs", false, null);
            IConfigurationElement config = this.current;
            Properties props = new Properties();
            element.setProperty("src", this.baseURL + "/topic/" + config.getContributor().getName() + "/" + config.getAttribute("image"));
            TagElement img = new TagElement("img", props);
            if (showBreadcrumbs) {
                this.addBeforeStart(element, img);
            } else {
                MutableHTMLOutputStream.addToStart(element, img);
            }
            this.modified = true;
        }
    }

    public void characters(TagElement element, String chars) {
    }

    public void comment(String chunk) {
    }

    @Override
    public boolean isEnabled() {
        return this.prefs.get("topicBannersEnabled").equals("true");
    }

    @Override
    public boolean shouldModify(HttpServletRequest req) {
        this.locale = LocaleUtil.getLocale(req);
        String path = req.getRequestURI();
        IConfigurationElement[] configs = this.getConfigs();
        int c = 0;
        while (c < configs.length) {
            String regex = configs[c].getAttribute("regex");
            if (path.matches(regex)) {
                this.current = configs[c];
                return true;
            }
            ++c;
        }
        return false;
    }

    @Override
    public void setParser(TagParser parser) {
        this.parser = parser;
    }

    private void addBeforeStart(TagElement element, TagElement insert) {
        Stack elements = this.parser.getElementStack();
        if (elements.size() >= 2) {
            TagElement parent = (TagElement)elements.get(elements.size() - 1);
            List kids = parent.getChildren();
            ArrayList<Object> newKids = new ArrayList<Object>();
            int k = 0;
            while (k < kids.size()) {
                if (kids.get(k) == element) {
                    newKids.add(insert);
                }
                newKids.add(kids.get(k));
                ++k;
            }
            parent.setChildren(newKids);
        }
    }

    @Override
    public boolean didModify() {
        return this.modified;
    }
}

