/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.site;

import com.ibm.ut.help.common.MessageLibrary;
import com.ibm.ut.help.common.error.ErrorStatus;
import com.ibm.ut.help.common.site.FavoritesService;
import com.ibm.ut.help.common.site.Site;
import com.ibm.ut.help.common.site.SiteManager;
import com.ibm.ut.help.common.web.LocaleUtil;
import com.ibm.ut.help.parser.util.HTML;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SiteService
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Site site;
        String service = "/" + ((Object)((Object)this)).getClass().getCanonicalName();
        String uri = req.getRequestURL().toString();
        String id = uri.substring(uri.indexOf(service) + service.length());
        if (id.startsWith("/")) {
            id = id.substring(1);
        }
        if ((site = SiteManager.getSite(id)) == null) {
            return;
        }
        resp.getWriter().print(site.toJSON());
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text; charset=UTF-8");
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        String service = "/" + ((Object)((Object)this)).getClass().getCanonicalName();
        String uri = req.getRequestURL().toString();
        String id = uri.substring(uri.indexOf(service) + service.length());
        if (id.startsWith("/")) {
            id = id.substring(1);
        }
        String name = req.getParameter("name");
        String href = req.getParameter("href");
        List<Site> sites = SiteManager.getSites();
        int s = 0;
        while (s < sites.size()) {
            if (sites.get(s).getName().equals(name)) {
                ErrorStatus error = new ErrorStatus("CRRHS0105I", MessageLibrary.getErrorFormat("CRRHS0105I", name, LocaleUtil.getLocale(req)), "com.ibm.ut.help.common");
                resp.getWriter().print(error.toJSON().toString());
                resp.getWriter().close();
                return;
            }
            ++s;
        }
        Site site = new Site(href, name, "internal", true);
        SiteManager.addSite(site);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String name = req.getParameter("name");
        String newName = req.getParameter("newName");
        String href = req.getParameter("href");
        String newHref = req.getParameter("newHref");
        if (href.startsWith("http")) {
            List<Site> prefSites = SiteManager.getPrefSites();
            int p = prefSites.size() - 1;
            while (p >= 0) {
                if (prefSites.get(p).getName().equals(name) && prefSites.get(p).getURI().equals(href)) {
                    boolean fav = prefSites.get(p).isFavorite();
                    if (fav) {
                        FavoritesService.removeFavorite(prefSites.get(p));
                    }
                    prefSites.get(p).setName(newName);
                    prefSites.get(p).setURI(newHref);
                    if (fav) {
                        FavoritesService.addFavorite(prefSites.get(p));
                    }
                }
                --p;
            }
            SiteManager.setPrefSites(prefSites);
        } else {
            File siteDir = new File(SiteManager.UPLOADS_DIRECTORY, name);
            if (siteDir.exists()) {
                Site site = SiteManager.getUploadSite(name);
                boolean fav = site.isFavorite();
                if (fav) {
                    FavoritesService.removeFavorite(site);
                }
                siteDir.renameTo(new File(SiteManager.UPLOADS_DIRECTORY, newName));
                site = SiteManager.getUploadSite(newName);
                if (fav) {
                    FavoritesService.addFavorite(site);
                }
            }
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String service = "/" + ((Object)((Object)this)).getClass().getCanonicalName();
        String uri = req.getRequestURL().toString();
        String id = uri.substring(uri.indexOf(service) + service.length());
        if (id.startsWith("/")) {
            id = id.substring(1);
        }
        String[] names = HTML.decode((String)req.getParameter("names")).split(",");
        List<Site> prefSites = SiteManager.getPrefSites();
        int p = prefSites.size() - 1;
        while (p >= 0) {
            int r = 0;
            while (r < names.length) {
                if (prefSites.get(p).getName().equals(names[r])) {
                    FavoritesService.removeFavorite(prefSites.get(p).getUID(), prefSites.get(p).getURI());
                    prefSites.remove(p);
                    break;
                }
                ++r;
            }
            --p;
        }
        SiteManager.setPrefSites(prefSites);
        List<Site> uploadSites = SiteManager.getUploadSites();
        int u = uploadSites.size() - 1;
        while (u >= 0) {
            int r = 0;
            while (r < names.length) {
                if (uploadSites.get(u).getName().equals(names[r])) {
                    FavoritesService.removeFavorite(uploadSites.get(u).getUID(), uploadSites.get(u).getURI());
                    SiteManager.deleteUploadSite(uploadSites.get(u));
                    break;
                }
                ++r;
            }
            --u;
        }
    }
}

