/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.site;

import com.ibm.ut.help.common.Activator;
import com.ibm.ut.help.common.site.Site;
import com.ibm.ut.help.common.web.HTMLUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.Platform;

public class FavoritesService
extends HttpServlet {
    private static final File FAVORITES = new File(Platform.getConfigurationLocation().getURL().getFile(), "com.ibm.ut.help.common/favorites.ini");

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String service = "/" + ((Object)((Object)this)).getClass().getCanonicalName();
        String uri = req.getRequestURL().toString();
        String id = uri.substring(uri.indexOf(service) + service.length());
        if (id.startsWith("/")) {
            id = id.substring(1);
        }
        id = HTMLUtil.decode(id);
        FavoritesService.addFavorite(new Favorite(id));
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String service = "/" + ((Object)((Object)this)).getClass().getCanonicalName();
        String uri = req.getRequestURL().toString();
        String id = uri.substring(uri.indexOf(service) + service.length());
        if (id.startsWith("/")) {
            id = id.substring(1);
        }
        id = HTMLUtil.decode(id);
        FavoritesService.removeFavorite(new Favorite(id));
    }

    public static boolean isFavorite(String name, String href) {
        List<Favorite> favorites;
        href = href.replaceAll("\\\\", "/");
        Favorite candidate = new Favorite(name, href);
        try {
            favorites = FavoritesService.loadFavorites();
        }
        catch (IOException e) {
            Activator.logError("Could not load favorites: " + String.valueOf(FAVORITES), e);
            return false;
        }
        return favorites.contains(candidate);
    }

    public static void addFavorite(Site site) {
        FavoritesService.addFavorite(site.getUID(), site.getURI());
    }

    public static void addFavorite(String uid, String href) {
        href = href.replaceAll("\\\\", "/");
        FavoritesService.addFavorite(new Favorite(uid, href));
    }

    public static void addFavorite(Favorite candidate) {
        List<Object> favorites = new ArrayList();
        try {
            favorites = FavoritesService.loadFavorites();
        }
        catch (IOException iOException) {}
        if (favorites.contains(candidate)) {
            return;
        }
        favorites.add(candidate);
        try {
            FavoritesService.saveFavorites(favorites);
        }
        catch (IOException e) {
            Activator.logError("Could not save favorites: " + String.valueOf(FAVORITES), e);
        }
    }

    public static void removeFavorite(Site site) {
        FavoritesService.removeFavorite(site.getUID(), site.getURI());
    }

    public static void removeFavorite(String uid, String href) {
        href = href.replaceAll("\\\\", "/");
        FavoritesService.removeFavorite(new Favorite(uid, href));
    }

    public static void removeFavorite(Favorite candidate) {
        List<Favorite> favorites;
        try {
            favorites = FavoritesService.loadFavorites();
        }
        catch (IOException iOException) {
            return;
        }
        if (!favorites.contains(candidate)) {
            return;
        }
        favorites.remove(candidate);
        try {
            FavoritesService.saveFavorites(favorites);
        }
        catch (IOException e) {
            Activator.logError("Could not save favorites: " + String.valueOf(FAVORITES), e);
        }
    }

    public static void saveFavorites(List<Favorite> favorites) throws IOException {
        FAVORITES.delete();
        FAVORITES.getParentFile().mkdirs();
        FAVORITES.createNewFile();
        PrintWriter pw = new PrintWriter(new FileWriter(FAVORITES));
        int f = 0;
        while (f < favorites.size()) {
            pw.println(favorites.get(f));
            ++f;
        }
        pw.close();
    }

    public static List<Favorite> loadFavorites() throws IOException {
        String line;
        ArrayList<Favorite> favorites = new ArrayList<Favorite>();
        if (!FAVORITES.exists()) {
            return favorites;
        }
        BufferedReader br = new BufferedReader(new FileReader(FAVORITES));
        while ((line = br.readLine()) != null) {
            favorites.add(new Favorite(line));
        }
        br.close();
        return favorites;
    }

    public static class Favorite {
        public String uid;
        public String href;

        public Favorite(String line) {
            if (line.indexOf("=") == -1) {
                return;
            }
            this.uid = line.split("=")[0];
            this.href = line.split("=")[1];
        }

        public Favorite(String uid, String href) {
            this.uid = uid;
            this.href = href;
        }

        public String toString() {
            return this.uid + "=" + this.href;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Favorite)) {
                return false;
            }
            return this.toString().equals(o.toString());
        }
    }
}

