/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.site;

import com.ibm.ut.help.common.site.Feature;
import com.ibm.ut.help.common.site.Site;
import com.ibm.ut.help.parser.json.JSONElement;
import java.util.ArrayList;
import java.util.List;

public class Category {
    public static final String CATEGORY = "category";
    private String name;
    private String label;
    private String description;
    private List<Feature> features = new ArrayList<Feature>();
    private List<Category> requirements = new ArrayList<Category>();

    public Category(String name) {
        this(name, name);
    }

    public Category(String name, String label) {
        this.name = name;
        this.label = label;
    }

    public boolean isTranslation() {
        int f = 0;
        while (f < this.features.size()) {
            if (this.features.get(f).isTranslation()) {
                return true;
            }
            ++f;
        }
        return false;
    }

    public List getFeatures() {
        return this.features;
    }

    public void addFeature(Feature feature) {
        this.features.add(feature);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return this.name;
    }

    public void dependOn(Category category) {
        if (!this.requirements.contains(category)) {
            this.requirements.add(category);
        }
    }

    public List<Category> getRequirements() {
        return this.requirements;
    }

    public String getReqString() {
        return this.requirements.toString().substring(1, this.requirements.toString().length() - 1);
    }

    public boolean equals(Object candidate) {
        if (!(candidate instanceof Category)) {
            return false;
        }
        return this.getName().equals(((Category)candidate).getName());
    }

    public JSONElement toJSON(Site parent) {
        JSONElement json = new JSONElement();
        json.setProperty("title", this.getName());
        json.setProperty("link", parent.getURI());
        json.setProperty("uid", parent.getUID() + "->" + this.getName());
        json.setProperty("type", CATEGORY);
        json.setProperty("dependency", this.requirements.toString().substring(1, this.requirements.toString().length() - 1));
        return json;
    }
}

