/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.security;

import com.ibm.ut.help.common.Activator;
import com.ibm.ut.help.common.prefs.Preferences;
import com.ibm.ut.help.common.security.AuthDetails;
import com.ibm.ut.help.common.security.AuthException;
import com.ibm.ut.help.common.security.Crypto;
import com.ibm.ut.help.common.security.IAuthenticator;
import com.ibm.ut.help.parser.json.JSONElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.useradmin.Group;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.User;
import org.osgi.service.useradmin.UserAdmin;

public class UserAdminAuthenticator
implements IAuthenticator {
    public static final String WAR_ADMINS = "waradmins";
    public static final String CHNAGED_OK = "Password changed successfully";
    public static final String ERROR = "ERROR";
    private static UserAdmin service;
    private static List<Role> groups;

    static {
        groups = UserAdminAuthenticator.loadGroups();
    }

    private static List<Role> loadGroups() {
        UserAdmin service = UserAdminAuthenticator.getUserAdminService();
        ArrayList<Role> groups = new ArrayList<Role>();
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.ut.help.common.security");
        int c = 0;
        while (c < configs.length) {
            Role group = service.getRole(configs[c].getAttribute("name"));
            if (group == null) {
                group = service.createRole(configs[c].getAttribute("name"), 2);
            }
            if (!groups.contains(group)) {
                groups.add(group);
            }
            ++c;
        }
        return groups;
    }

    public static List<Role> getGroups() {
        return groups;
    }

    public static UserAdmin getUserAdminService() {
        if (service != null) {
            return service;
        }
        try {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.equinox.useradmin");
            bundle.start();
            Bundle webAppBundle = Activator.getDefault().getBundle();
            ServiceReference ref = webAppBundle.getBundleContext().getServiceReference("org.osgi.service.useradmin.UserAdmin");
            service = (UserAdmin)webAppBundle.getBundleContext().getService(ref);
            if (UserAdminAuthenticator.getUserAdminService().getRole(WAR_ADMINS) == null) {
                service.createRole(WAR_ADMINS, 2);
            }
            UserAdminAuthenticator.ensureAdmin();
            return service;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void addDefaultUser() throws Exception {
        UserAdmin service = UserAdminAuthenticator.getUserAdminService();
        User admin = (User)service.getRole("warupdateadmin");
        if (admin == null) {
            admin = UserAdminAuthenticator.createUser("warupdateadmin", "warupdateadmin", "warupdateadmin", new String[]{WAR_ADMINS});
        } else if (!UserAdminAuthenticator.isMember(admin, WAR_ADMINS)) {
            UserAdminAuthenticator.makeMember(admin, WAR_ADMINS);
        }
    }

    public static void fromJSON(JSONElement json) throws Exception {
        JSONElement newUser;
        UserAdmin service = UserAdminAuthenticator.getUserAdminService();
        ArrayList users = (ArrayList)json.get((Object)"items");
        int u = 0;
        while (u < users.size()) {
            newUser = (JSONElement)users.get(u);
            String xword = newUser.getProperty("xword");
            if (xword == null || xword.equals("")) {
                User user = service.getUser("name", newUser.getProperty("title"));
                xword = user != null ? Crypto.decrypt((String)user.getCredentials().get("password")) : "pass";
                newUser.setProperty("xword", xword);
            }
            ++u;
        }
        UserAdminAuthenticator.removeAllUsers();
        u = 0;
        while (u < users.size()) {
            newUser = (JSONElement)users.get(u);
            String name = newUser.getProperty("title");
            String xword = newUser.getProperty("xword");
            String[] groups = newUser.getProperty("groups") == null ? new String[]{} : newUser.getProperty("groups").split(",");
            UserAdminAuthenticator.createUser(newUser.getProperty("uid"), name, xword, groups);
            ++u;
        }
        UserAdminAuthenticator.ensureAdmin();
    }

    private static void ensureAdmin() throws Exception {
        boolean admin = false;
        List newUsers = UserAdminAuthenticator.getUsers();
        int n = 0;
        while (n < newUsers.size()) {
            if (UserAdminAuthenticator.isMember((User)newUsers.get(n), WAR_ADMINS)) {
                admin = true;
                break;
            }
            ++n;
        }
        if (!admin && newUsers.size() > 0) {
            UserAdminAuthenticator.makeAdmin((User)newUsers.get(0));
        } else if (!admin) {
            UserAdminAuthenticator.addDefaultUser();
        }
    }

    public static User createUser(JSONElement element) throws Exception {
        if (element.get((Object)"items") != null) {
            element = (JSONElement)((List)element.get((Object)"items")).get(0);
        }
        return UserAdminAuthenticator.createUser(element.getProperty("uid"), element.getProperty("name"), element.getProperty("xword"), UserAdminAuthenticator.getGroups(element));
    }

    public static User createUser(String uid, String name, String pass, String[] groups) throws Exception {
        UserAdmin service = UserAdminAuthenticator.getUserAdminService();
        User user = service.getUser("uid", uid);
        if (user != null) {
            throw new AuthException("User already exist");
        }
        user = (User)service.createRole(name, 1);
        user.getProperties().put("name", name);
        user.getProperties().put("uid", uid);
        if (pass != null && !pass.equals("")) {
            user.getCredentials().put("password", Crypto.encrypt(pass));
        }
        int g = 0;
        while (g < groups.length) {
            UserAdminAuthenticator.makeMember(user, groups[g]);
            ++g;
        }
        return user;
    }

    private static String[] getGroups(JSONElement element) {
        ArrayList<String> groups = new ArrayList<String>();
        Enumeration keys = element.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.endsWith("_group") || !element.get((Object)key).equals("true")) continue;
            groups.add(key.substring(0, key.lastIndexOf("_group")));
        }
        return groups.toArray(new String[groups.size()]);
    }

    public static void editUser(JSONElement element) throws Exception {
        if (element.get((Object)"items") != null) {
            element = (JSONElement)((List)element.get((Object)"items")).get(0);
        }
        User user = service.getUser("uid", element.getProperty("uid"));
        String xword = element.getProperty("xword").equals("") && user != null ? Crypto.decrypt((String)user.getCredentials().get("password")) : element.getProperty("xword");
        String[] groups = UserAdminAuthenticator.getGroups(element);
        UserAdminAuthenticator.removeUserById(element.getProperty("uid"));
        UserAdminAuthenticator.createUser(element.getProperty("uid"), element.getProperty("name"), xword, groups);
        UserAdminAuthenticator.ensureAdmin();
    }

    public static void editUser(String id, String newName, String[] groups) throws Exception {
        UserAdminAuthenticator.editUser(id, newName, groups, null);
    }

    public static void editUser(String id, String newName, String[] groups, String newPass) throws Exception {
        UserAdminAuthenticator.removeUserById(id);
        UserAdminAuthenticator.createUser(id, newName, newPass, groups);
        UserAdminAuthenticator.ensureAdmin();
    }

    public static void makeAdmin(User user) {
        ((Group)UserAdminAuthenticator.getUserAdminService().getRole(WAR_ADMINS)).addMember((Role)user);
    }

    public static void removeAllUsers() {
        List users = UserAdminAuthenticator.getUsers();
        int u = 0;
        while (u < users.size()) {
            UserAdminAuthenticator.removeUser((String)((User)users.get(u)).getProperties().get("name"));
            ++u;
        }
    }

    public static void removeUser(String name) {
        UserAdminAuthenticator.getUserAdminService().removeRole(name);
        try {
            UserAdminAuthenticator.ensureAdmin();
        }
        catch (Exception exception) {}
    }

    public static void removeUserById(String id) {
        Role user = UserAdminAuthenticator.getUser(id);
        UserAdminAuthenticator.getUserAdminService().removeRole(user.getName());
        try {
            UserAdminAuthenticator.ensureAdmin();
        }
        catch (Exception exception) {}
    }

    @Override
    public boolean isMember(AuthDetails user, String group) {
        return UserAdminAuthenticator.isMember(user.getUser(), group);
    }

    public static boolean isMember(String user, String groupName) {
        if (user == null) {
            return false;
        }
        return UserAdminAuthenticator.isMember(UserAdminAuthenticator.getUserAdminService().getUser("name", user), groupName);
    }

    public static boolean isMember(User user, String groupName) {
        if (user == null) {
            return false;
        }
        if (UserAdminAuthenticator.getUserAdminService().getRole(groupName) == null) {
            return false;
        }
        return service.getAuthorization(user).hasRole(groupName);
    }

    public static void makeMember(User user, String groupName) {
        if (UserAdminAuthenticator.getUserAdminService().getRole(groupName) == null) {
            service.createRole(groupName, 2);
        }
        ((Group)UserAdminAuthenticator.getUserAdminService().getRole(groupName)).addMember((Role)user);
    }

    public static void makeMember(String userID, String groupName) {
        UserAdminAuthenticator.makeMember((User)UserAdminAuthenticator.getUser(userID), groupName);
    }

    public static List getUsers() {
        UserAdmin service = UserAdminAuthenticator.getUserAdminService();
        Role[] roles = new Role[]{};
        try {
            roles = service.getRoles(null);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        ArrayList<Role> list = new ArrayList<Role>();
        int r = 0;
        while (r < roles.length) {
            if (!(roles[r] instanceof Group) && roles[r] instanceof User) {
                list.add(roles[r]);
            }
            ++r;
        }
        return list;
    }

    public static Role getUser(String uid) {
        List users = UserAdminAuthenticator.getUsers();
        int u = 0;
        while (u < users.size()) {
            Role user = (Role)users.get(u);
            String tmpID = (String)user.getProperties().get("uid");
            if (tmpID != null && tmpID.equals(uid)) {
                return user;
            }
            ++u;
        }
        return null;
    }

    public static JSONElement serializeUsersJSON() {
        List users = UserAdminAuthenticator.getUsers();
        ArrayList<JSONElement> elements = new ArrayList<JSONElement>();
        int u = 0;
        while (u < users.size()) {
            String name = (String)((User)users.get(u)).getProperties().get("name");
            String uid = (String)((User)users.get(u)).getProperties().get("uid");
            uid = uid != null ? uid : UUID.randomUUID().toString();
            JSONElement element = new JSONElement();
            element.setProperty("name", name);
            element.setProperty("uid", uid);
            element.setProperty("xword", "");
            new StringBuffer();
            int g = 0;
            while (g < groups.size()) {
                String group = groups.get(g).getName();
                element.put((Object)(group + "_group"), (Object)new Boolean("" + UserAdminAuthenticator.isMember((User)users.get(u), group)));
                ++g;
            }
            elements.add(element);
            ++u;
        }
        JSONElement root = new JSONElement();
        root.put((Object)"items", elements);
        root.setProperty("identifier", "uid");
        root.setProperty("label", "name");
        return root;
    }

    public static String getAccessType() {
        String type = Preferences.get("com.ibm.ut.help.common", "help.war.security");
        if (type.equals("")) {
            type = Activator.getDefault().getBundle().getBundleContext().getProperty("help.war.security");
        }
        if (type == null) {
            type = "local";
        }
        return type;
    }

    public static void setAccessType(String type) {
        Preferences.set("com.ibm.ut.help.common", "help.war.security", type);
    }

    @Override
    public AuthDetails authenticate(String user, String password) throws AuthException {
        try {
            Platform.getBundle((String)"org.eclipse.equinox.useradmin").start();
        }
        catch (BundleException e1) {
            throw new AuthException(e1.getLocalizedMessage());
        }
        UserAdmin service = UserAdminAuthenticator.getUserAdminService();
        User regUser = service.getUser("name", user);
        if (regUser == null) {
            throw new AuthException("Invalid Authentication");
        }
        try {
            String regPass = Crypto.decrypt((String)regUser.getCredentials().get("password"));
            if (regPass == null || !regPass.equals(password)) {
                throw new IOException("Invalid Authentication");
            }
        }
        catch (Exception exception) {
            throw new AuthException("Invalid Authentication");
        }
        AuthDetails details = new AuthDetails(user);
        details.setUser(user);
        return details;
    }
}

