/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.security;

import com.ibm.ut.help.common.MessageLibrary;
import com.ibm.ut.help.common.error.ErrorStatus;
import com.ibm.ut.help.common.security.AuthDetails;
import com.ibm.ut.help.common.security.AuthException;
import com.ibm.ut.help.common.security.IAuthenticator;
import com.ibm.ut.help.common.web.LocaleUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.UUID;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthenticationService
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Hashtable<String, AuthDetails> sessions = new Hashtable();

    static {
        Thread cleaner = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(3600000L);
                    }
                    catch (Exception exception) {}
                    AuthenticationService.cleanSessions();
                }
            }
        };
        cleaner.start();
    }

    private static void cleanSessions() {
        long time = new Date().getTime();
        Enumeration<String> keys = sessions.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Properties props = sessions.get(key);
            long tstamp = (Long)props.get("tstamp");
            if (time - tstamp <= 1800000L) continue;
            sessions.remove(key);
        }
    }

    public void init() throws ServletException {
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        resp.setCharacterEncoding("UTF-8");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        IAuthenticator auth = (IAuthenticator)req.getAttribute("aux");
        String desc = (String)req.getAttribute("description");
        AuthenticationService.login(auth, req, resp, desc);
    }

    public static AuthDetails getAuthenticationDetails(IAuthenticator auth, HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies == null) {
            return null;
        }
        int c = 0;
        while (c < cookies.length) {
            if (cookies[c].getName().equals(auth.getClass().getName())) {
                return sessions.get(cookies[c].getValue());
            }
            ++c;
        }
        return null;
    }

    public static String[] getCredentials(HttpServletRequest req) {
        StringTokenizer st;
        String authHeader;
        String password;
        String username = req.getParameter("user") != null ? req.getParameter("user") : "";
        String string = password = req.getParameter("password") != null ? req.getParameter("password") : "";
        if (username.equals("")) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)req.getInputStream()));
                String line = br.readLine();
                br.close();
                if (line != null) {
                    String[] split = line.split("&");
                    Properties props = new Properties();
                    int s = 0;
                    while (s < split.length) {
                        props.setProperty(split[s].substring(0, split[s].indexOf("=")), split[s].substring(split[s].indexOf("=") + 1));
                        ++s;
                    }
                    username = props.getProperty("user") != null ? props.getProperty("user") : "";
                    password = props.getProperty("password") != null ? props.getProperty("password") : "";
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((authHeader = req.getHeader("Authorization")) != null && (st = new StringTokenizer(authHeader)).hasMoreTokens()) {
            String basic = st.nextToken();
            String userPass = "";
            if (basic.equalsIgnoreCase("Basic")) {
                String credentials = st.nextToken();
                try {
                    userPass = new String(Base64.getMimeDecoder().decode(credentials));
                }
                catch (Exception exception) {
                    return new String[]{username, password};
                }
                int p = userPass.indexOf(":");
                if (p != -1) {
                    username = userPass.substring(0, p);
                    password = userPass.substring(p + 1);
                }
            }
        }
        return new String[]{username, password};
    }

    public static AuthDetails login(IAuthenticator auth, HttpServletRequest req, HttpServletResponse resp, String description) throws IOException {
        try {
            return AuthenticationService.authenticate(auth, req, resp);
        }
        catch (AuthException authException) {
            req.setAttribute("description", (Object)description);
            if (req.getParameter("dispatch") == null) {
                AuthenticationService.loginDialog(req, resp);
            } else {
                resp.setContentType("application/json; charset=UTF-8");
                resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
                ErrorStatus status = new ErrorStatus("CRRHS0101I", MessageLibrary.getError("CRRHS0101I", LocaleUtil.getLocale(req)), "com.ibm.ut.help.common");
                resp.getWriter().append(status.toJSON().toString());
                resp.flushBuffer();
                resp.getWriter().close();
            }
            return null;
        }
    }

    public static AuthDetails authenticate(IAuthenticator auth, HttpServletRequest req, HttpServletResponse resp) throws AuthException {
        AuthDetails details = AuthenticationService.getAuthenticationDetails(auth, req);
        if (details != null) {
            return details;
        }
        String[] creds = AuthenticationService.getCredentials(req);
        details = auth.authenticate(creds[0], creds[1]);
        if (details != null) {
            AuthenticationService.createToken(auth, req.getContextPath(), resp, details);
        }
        return details;
    }

    private static String createToken(IAuthenticator auth, String path, HttpServletResponse resp, AuthDetails details) {
        String token = UUID.randomUUID().toString();
        Cookie cookie = new Cookie(auth.getClass().getName(), token);
        cookie.setMaxAge(-1);
        cookie.setPath(path);
        resp.addCookie(cookie);
        details.put("tstamp", (Object)new Date().getTime());
        details.put("token", token);
        sessions.put(token, details);
        return token;
    }

    public static void loginDialog(HttpServletRequest req, HttpServletResponse resp) {
        AuthenticationService.loginDialog(req, resp, null);
    }

    public static void loginDialog(HttpServletRequest req, HttpServletResponse resp, ErrorStatus error) {
        req.setAttribute("requester", (Object)(req.getRequestURL().toString() + "?" + req.getQueryString()));
        if (error != null) {
            req.setAttribute("error", (Object)error);
        }
        try {
            RequestDispatcher rd = req.getRequestDispatcher("/com.ibm.ut.help.common/login.jsp");
            rd.forward((ServletRequest)req, (ServletResponse)resp);
            resp.flushBuffer();
            resp.getWriter().close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void error(HttpServletRequest req, HttpServletResponse resp, ErrorStatus status) {
        req.setAttribute("error", (Object)status);
        req.setAttribute("requester", (Object)req.getRequestURL().toString());
        try {
            RequestDispatcher rd = req.getRequestDispatcher("/com.ibm.ut.help.common/error.jsp");
            rd.forward((ServletRequest)req, (ServletResponse)resp);
            resp.flushBuffer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void error(HttpServletRequest req, HttpServletResponse resp, ErrorStatus status, IAuthenticator auth) {
        req.setAttribute("error", (Object)status);
        req.setAttribute("aux", (Object)auth);
        req.setAttribute("requester", (Object)req.getRequestURL().toString());
        try {
            RequestDispatcher rd = req.getRequestDispatcher("/com.ibm.ut.help.common/error.jsp");
            rd.forward((ServletRequest)req, (ServletResponse)resp);
            resp.flushBuffer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fail(HttpServletResponse response) {
        String s = "Basic realm=\"Help System Login\"";
        response.setHeader("WWW-Authenticate", s);
        try {
            response.getWriter().println("Uh oh");
            response.getWriter().close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void logout(String key) {
        sessions.remove(key);
    }

    public static void logout(IAuthenticator auth, HttpServletRequest req, HttpServletResponse resp) {
        Cookie[] cookies = req.getCookies();
        int c = 0;
        while (c < cookies.length) {
            if (cookies[c].getName().equals(auth.getClass().getName())) {
                AuthenticationService.logout(cookies[c].getValue());
                break;
            }
            ++c;
        }
    }
}

