/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.reflect;

import com.ibm.ut.help.common.reflect.BundleClassLoader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class Reflect {
    private BundleClassLoader loader;
    private String id;

    public Reflect(String pluginID) {
        this.id = pluginID;
        this.loader = new BundleClassLoader(pluginID);
    }

    public Class getClass(String name) throws ClassNotFoundException {
        return Class.forName(name, true, this.loader);
    }

    public static Class getClass(Object o) {
        if (o instanceof Integer) {
            return Integer.TYPE;
        }
        if (o instanceof Long) {
            return Long.TYPE;
        }
        if (o instanceof Double) {
            return Double.TYPE;
        }
        return o.getClass();
    }

    public Object init(String clsName, Object ... args) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> cls = Class.forName(clsName, true, this.loader);
        cls.getConstructors();
        Class[] argClasses = new Class[args.length];
        int a = 0;
        while (a < args.length) {
            argClasses[a] = Reflect.getClass(args[a]);
            ++a;
        }
        Constructor<?> cons = cls.getConstructor(argClasses);
        return cons.newInstance(args);
    }

    public static Object call(Object o, String method, Object ... args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> cls = o.getClass();
        new ArrayList();
        Method[] methods = cls.getMethods();
        int m = 0;
        while (m < methods.length) {
            if (methods[m].getName().equals(method) && Reflect.argsMatch(methods[m].getParameterTypes(), args)) {
                return methods[m].invoke(o, args);
            }
            ++m;
        }
        throw new NoSuchMethodException(method);
    }

    private static boolean argsMatch(Class<?>[] mArgs, Object[] cArgs) {
        if (mArgs.length != cArgs.length) {
            return false;
        }
        int a = 0;
        while (a < mArgs.length) {
            if (mArgs[a].isPrimitive()) {
                mArgs[a] = Reflect.primitiveToObject(mArgs[a]);
            }
            if (!mArgs[a].isInstance(cArgs[a])) {
                return false;
            }
            ++a;
        }
        return true;
    }

    public static Class<?> primitiveToObject(Class<?> p) {
        if (p == Integer.TYPE) {
            return Integer.class;
        }
        if (p == Boolean.TYPE) {
            return Boolean.class;
        }
        if (p == Long.TYPE) {
            return Long.class;
        }
        if (p == Float.TYPE) {
            return Float.class;
        }
        if (p == Double.TYPE) {
            return Double.class;
        }
        return p;
    }

    public static Object staticCall(Class cls, String method, Object ... args) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method[] methods = cls.getMethods();
        int m = 0;
        while (m < methods.length) {
            if (methods[m].getName().equals(method) && methods[m].getParameterTypes().length == args.length) {
                return methods[m].invoke(null, args);
            }
            ++m;
        }
        throw new NoSuchMethodException(method);
    }

    public Object staticCall(String clsName, String method, Object ... args) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class cls = this.getClass(clsName);
        Method[] methods = cls.getMethods();
        int m = 0;
        while (m < methods.length) {
            if (methods[m].getName().equals(method) && methods[m].getParameterTypes().length == args.length) {
                return methods[m].invoke(null, args);
            }
            ++m;
        }
        throw new NoSuchMethodException(method);
    }

    public static Object getField(Object obj, String field) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields = obj.getClass().getFields();
        int f = 0;
        while (f < fields.length) {
            if (fields[f].getName().equals(field)) {
                return fields[f].get(obj);
            }
            ++f;
        }
        return null;
    }

    public static Object getStaticField(Class cls, String field) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields = cls.getFields();
        int f = 0;
        while (f < fields.length) {
            if (fields[f].getName().equals(field)) {
                return fields[f].get(null);
            }
            ++f;
        }
        return null;
    }

    public static Class getNestedClass(Class cls, String simpleName) {
        Class<?>[] cs = cls.getDeclaredClasses();
        int c = 0;
        while (c < cs.length) {
            if (cs[c].getSimpleName().equals(simpleName)) {
                return cs[c];
            }
            ++c;
        }
        return null;
    }

    public String toString() {
        return this.id;
    }
}

