/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.prefs;

import com.ibm.ut.help.common.Activator;
import com.ibm.ut.help.common.ic.IC;
import com.ibm.ut.help.common.prefs.Preferences;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.HelpPlugin;

public class ICPreferences
extends Preferences {
    public static final String DELIMITER = ",";
    private static final File COMMON_IC_FILE = new File(Platform.getConfigurationLocation().getURL().getFile(), "com.ibm.ut.help.common/common.ics");
    private static final File ADDED_IC_FILE = new File(Platform.getConfigurationLocation().getURL().getFile(), "com.ibm.ut.help.common/added.ics");

    public ICPreferences() {
        super("org.eclipse.help.base");
    }

    public static void setICs(List ics) {
        Object name = "";
        Object host = "";
        Object path = "";
        Object protocol = "";
        Object port = "";
        Object enabled = "";
        int i = 0;
        while (i < ics.size()) {
            name = (String)name + ((IC)ics.get(i)).getName() + DELIMITER;
            protocol = (String)protocol + ((IC)ics.get(i)).getProtocol() + DELIMITER;
            host = (String)host + ((IC)ics.get(i)).getHost() + DELIMITER;
            port = (String)port + ((IC)ics.get(i)).getPort() + DELIMITER;
            path = (String)path + ((IC)ics.get(i)).getPath() + DELIMITER;
            enabled = (String)enabled + ((IC)ics.get(i)).isEnabled() + DELIMITER;
            ++i;
        }
        if (ics.size() != 0) {
            name = ((String)name).substring(0, ((String)name).length() - 1);
            protocol = ((String)protocol).substring(0, ((String)protocol).length() - 1);
            host = ((String)host).substring(0, ((String)host).length() - 1);
            port = ((String)port).substring(0, ((String)port).length() - 1);
            path = ((String)path).substring(0, ((String)path).length() - 1);
            enabled = ((String)enabled).substring(0, ((String)enabled).length() - 1);
        }
        ICPreferences.set("org.eclipse.help.base", "remoteHelpName", (String)name);
        ICPreferences.set("org.eclipse.help.base", "remoteHelpHost", (String)host);
        ICPreferences.set("org.eclipse.help.base", "remoteHelpPath", (String)path);
        ICPreferences.set("org.eclipse.help.base", "remoteHelpProtocol", (String)protocol);
        ICPreferences.set("org.eclipse.help.base", "remoteHelpPort", (String)port);
        ICPreferences.set("org.eclipse.help.base", "remoteHelpICEnabled", (String)enabled);
        try {
            ICPreferences.setCommonICs(ics);
        }
        catch (IOException e) {
            Activator.logError("Could not set common IC List", e);
        }
        HelpPlugin.getTocManager().clearCache();
    }

    public static List getICs() {
        return ICPreferences.prefsToICs(ICPreferences.get("org.eclipse.help.base", "remoteHelpName").split(DELIMITER), ICPreferences.get("org.eclipse.help.base", "remoteHelpProtocol").split(DELIMITER), ICPreferences.get("org.eclipse.help.base", "remoteHelpHost").split(DELIMITER), ICPreferences.get("org.eclipse.help.base", "remoteHelpPort").split(DELIMITER), ICPreferences.get("org.eclipse.help.base", "remoteHelpPath").split(DELIMITER), ICPreferences.get("org.eclipse.help.base", "remoteHelpICEnabled").split(DELIMITER));
    }

    public static List getEnabledICs() {
        ArrayList enabled = new ArrayList();
        List ics = ICPreferences.getICs();
        int i = 0;
        while (i < ics.size()) {
            if (((IC)ics.get(i)).isEnabled()) {
                enabled.add(ics.get(i));
            }
            ++i;
        }
        return enabled;
    }

    public static List getConfigICs() {
        return ICPreferences.prefsToICs(ICPreferences.getConfig("org.eclipse.help.base", "remoteHelpName").split(DELIMITER), ICPreferences.getConfig("org.eclipse.help.base", "remoteHelpProtocol").split(DELIMITER), ICPreferences.getConfig("org.eclipse.help.base", "remoteHelpHost").split(DELIMITER), ICPreferences.getConfig("org.eclipse.help.base", "remoteHelpPort").split(DELIMITER), ICPreferences.getConfig("org.eclipse.help.base", "remoteHelpPath").split(DELIMITER), ICPreferences.getConfig("org.eclipse.help.base", "remoteHelpICEnabled").split(DELIMITER));
    }

    public static List getDefaultICs() {
        return ICPreferences.prefsToICs(ICPreferences.getDefault("org.eclipse.help.base", "remoteHelpName").split(DELIMITER), ICPreferences.getDefault("org.eclipse.help.base", "remoteHelpProtocol").split(DELIMITER), ICPreferences.getDefault("org.eclipse.help.base", "remoteHelpHost").split(DELIMITER), ICPreferences.getDefault("org.eclipse.help.base", "remoteHelpPort").split(DELIMITER), ICPreferences.getDefault("org.eclipse.help.base", "remoteHelpPath").split(DELIMITER), ICPreferences.getDefault("org.eclipse.help.base", "remoteHelpICEnabled").split(DELIMITER));
    }

    public static List getCommonICs() throws IOException {
        return ICPreferences.getICsFromFile(COMMON_IC_FILE);
    }

    public static void setCommonICs(List ics) throws IOException {
        ICPreferences.saveICsToFile(ics, COMMON_IC_FILE);
    }

    public static List getAddedICs() throws IOException {
        return ICPreferences.getICsFromFile(ADDED_IC_FILE);
    }

    public static void setAddedICs(List ics) throws IOException {
        ICPreferences.saveICsToFile(ics, ADDED_IC_FILE);
    }

    public static void saveICsToFile(List<IC> ics, File file) throws IOException {
        file.delete();
        file.getParentFile().mkdirs();
        file.createNewFile();
        Properties props = new Properties();
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
        int i = 0;
        while (i < ics.size()) {
            IC ic = ics.get(i);
            props.setProperty(ic.getName(), ic.getHref() + DELIMITER + ic.isEnabled());
            ++i;
        }
        try (ByteArrayOutputStream byteArray = new ByteArrayOutputStream();){
            props.store(byteArray, null);
        }
        output.write(byteArray.toByteArray());
        output.flush();
        output.close();
    }

    public static List<IC> getICsFromFile(File file) throws IOException {
        ArrayList<IC> ics = new ArrayList<IC>();
        if (!file.exists()) {
            return ics;
        }
        Properties props = new Properties();
        props.load(new BufferedInputStream(new FileInputStream(file)));
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            String href = props.getProperty(name).split(DELIMITER)[0];
            boolean enabled = Boolean.parseBoolean(props.getProperty(name).split(DELIMITER)[1]);
            ics.add(new IC(name, href, enabled));
        }
        return ics;
    }

    public static List prefsToICs(String[] names, String[] protocols, String[] hosts, String[] ports, String[] paths, String[] states) {
        ArrayList<IC> ics = new ArrayList<IC>();
        int i = 0;
        while (i < names.length) {
            if (!names[i].equals("")) {
                try {
                    IC ic = new IC(names[i], (protocols.length > i ? protocols[i] : "http") + "://" + hosts[i] + ":" + ports[i] + paths[i], Boolean.parseBoolean(states[i]));
                    ics.add(ic);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (ArrayIndexOutOfBoundsException e2) {
                    System.out.println(names);
                    System.out.println(hosts);
                    System.out.println(ports);
                    System.out.println(paths);
                    System.out.println(states);
                    e2.printStackTrace();
                }
            }
            ++i;
        }
        return ics;
    }

    public static List getContributedICs() {
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.ccl.help.preferenceharvester.harvester");
        ArrayList<IC> ics = new ArrayList<IC>();
        int c = 0;
        while (c < configs.length) {
            try {
                IC ic = new IC(configs[c].getAttribute("name"), (configs[c].getAttribute("protocol") != null ? configs[c].getAttribute("protocol") : "http") + "://" + configs[c].getAttribute("host") + ":" + configs[c].getAttribute("port") + configs[c].getAttribute("path"), true);
                ics.add(ic);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (InvalidRegistryObjectException e) {
                e.printStackTrace();
            }
            ++c;
        }
        return ics;
    }

    public static void setDefaultICs(List ics) {
        Object name = "";
        Object host = "";
        Object path = "";
        Object protocol = "";
        Object port = "";
        Object enabled = "";
        int i = 0;
        while (i < ics.size()) {
            name = (String)name + ((IC)ics.get(i)).getName() + DELIMITER;
            protocol = (String)protocol + ((IC)ics.get(i)).getProtocol() + DELIMITER;
            host = (String)host + ((IC)ics.get(i)).getHost() + DELIMITER;
            port = (String)port + ((IC)ics.get(i)).getPort() + DELIMITER;
            path = (String)path + ((IC)ics.get(i)).getPath() + DELIMITER;
            enabled = (String)enabled + ((IC)ics.get(i)).isEnabled() + DELIMITER;
            ++i;
        }
        if (ics.size() != 0) {
            name = ((String)name).substring(0, ((String)name).length() - 1);
            protocol = ((String)protocol).substring(0, ((String)protocol).length() - 1);
            host = ((String)host).substring(0, ((String)host).length() - 1);
            port = ((String)port).substring(0, ((String)port).length() - 1);
            path = ((String)path).substring(0, ((String)path).length() - 1);
            enabled = ((String)enabled).substring(0, ((String)enabled).length() - 1);
        }
        Preferences prefs = new Preferences("org.eclipse.help.base");
        prefs.setDefault("remoteHelpName", (String)name);
        prefs.setDefault("remoteHelpHost", (String)host);
        prefs.setDefault("remoteHelpPath", (String)path);
        prefs.setDefault("remoteHelpProtocol", (String)protocol);
        prefs.setDefault("remoteHelpPort", (String)port);
        prefs.setDefault("remoteHelpICEnabled", (String)enabled);
    }

    public static void setRemoteHelp(boolean enabled) {
        ICPreferences.set("org.eclipse.help.base", "remoteHelpOn", "" + enabled);
        HelpPlugin.getTocManager().clearCache();
    }

    public static void setRemoteHelpPreferred(boolean remotePreferred) {
        ICPreferences.set("org.eclipse.help.base", "remoteHelpPreferred", "" + remotePreferred);
        HelpPlugin.getTocManager().clearCache();
    }
}

