/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.io;

import com.ibm.ut.help.common.Activator;
import com.ibm.ut.help.common.event.ProgressMonitor;
import com.ibm.ut.help.common.io.FileHandler;
import com.ibm.ut.help.common.web.URLUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ZipFileUtility {
    static final int BUFFER = 2048;

    public static void handleZipFileExtraction(String watchedFolder) {
        String destinationName = "";
        ArrayList newZipFiles = ZipFileUtility.getNewZipFiles(watchedFolder);
        int i = 0;
        while (i < newZipFiles.size()) {
            String currZipPath = (String)newZipFiles.get(i);
            destinationName = ZipFileUtility.getDestinationPathForZip(watchedFolder, currZipPath);
            ZipFileUtility.extractZipFile(currZipPath, destinationName);
            ++i;
        }
    }

    public static void extractZip(File zip, File dest) throws ZipException, IOException {
        ZipFileUtility.extractZip(zip, dest, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void extractZip(File zip, File dest, IProgressMonitor monitor) throws ZipException, IOException {
        if (!dest.exists()) {
            dest.mkdirs();
        }
        ZipFile zipFile = new ZipFile(zip);
        monitor.beginTask("Extracting " + zip.getName(), (int)zip.length());
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            Object path = dest.getAbsolutePath() + File.separator + entry.getName();
            path = FileHandler.replaceAll((String)path, "/", File.separator);
            path = FileHandler.replaceAll((String)path, "\\\\", File.separator);
            File tmpDest = new File((String)path);
            if (entry.isDirectory()) {
                tmpDest.mkdirs();
                continue;
            }
            ZipFileUtility.extractFromZip(zip, entry, tmpDest, monitor);
        }
        monitor.done();
    }

    public static void downloadAndExtract(URL url, File dest, IProgressMonitor monitor) throws IOException {
        ZipFileUtility.downloadAndExtract(URLUtil.getConnection(url), dest, monitor);
    }

    public static void downloadAndExtract(URLConnection c, File dest, IProgressMonitor monitor) throws IOException {
        int read;
        monitor.beginTask("", 1000);
        URL url = c.getURL();
        int length = c.getContentLength();
        InputStream in = c.getInputStream();
        String name = url.toString().substring(url.toString().lastIndexOf("/") + 1);
        ProgressMonitor downMonitor = new ProgressMonitor(monitor, 900);
        downMonitor.beginTask("Downloading " + name + " " + ZipFileUtility.formatLength(length), length);
        File tmp = new File(dest.getParentFile(), name);
        tmp.getParentFile().mkdirs();
        tmp.delete();
        tmp.createNewFile();
        FileOutputStream out = new FileOutputStream(tmp);
        byte[] buffer = new byte[16384];
        while ((read = in.read(buffer)) > 0 && !monitor.isCanceled()) {
            out.write(buffer, 0, read);
            downMonitor.worked(read);
        }
        in.close();
        out.close();
        downMonitor.done();
        if (monitor.isCanceled()) {
            tmp.delete();
            return;
        }
        ProgressMonitor unzipMonitor = new ProgressMonitor(monitor, 100);
        ZipFileUtility.extractZip(tmp, dest, unzipMonitor);
        tmp.delete();
        monitor.done();
    }

    private static String formatLength(int length) {
        Object x = "" + length;
        Object res = "";
        while (((String)x).length() > 3) {
            res = "," + ((String)x).substring(((String)x).length() - 3) + (String)res;
            x = ((String)x).substring(0, ((String)x).length() - 3);
        }
        res = (String)x + (String)res;
        return (String)res + " KB";
    }

    public static void extractFromZip(File zip, ZipEntry entry, File dest, IProgressMonitor monitor) throws ZipException, IOException {
        int nBytes;
        File parent = dest.getParentFile();
        parent.mkdirs();
        if (dest.exists()) {
            dest.delete();
        }
        dest.createNewFile();
        ZipFile zipFile = new ZipFile(zip);
        BufferedInputStream in = new BufferedInputStream(zipFile.getInputStream(entry));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
        byte[] buffer = new byte[8192];
        while ((nBytes = ((InputStream)in).read(buffer)) > 0) {
            ((OutputStream)out).write(buffer, 0, nBytes);
            monitor.worked(nBytes);
        }
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
        ((InputStream)in).close();
    }

    public static void extractZipFile(String filePath, String destinationName) {
        try {
            byte[] buf = new byte[1024];
            ZipInputStream zipInputStream = null;
            zipInputStream = new ZipInputStream(new FileInputStream(filePath));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                int n;
                Object entryName = destinationName + zipEntry.getName();
                entryName = ((String)entryName).replace('/', File.separatorChar);
                entryName = ((String)entryName).replace('\\', File.separatorChar);
                File newFile = new File((String)entryName);
                if (zipEntry.isDirectory()) {
                    if (!newFile.mkdirs()) break;
                    zipEntry = zipInputStream.getNextEntry();
                    continue;
                }
                FileOutputStream fileOutputStream = new FileOutputStream((String)entryName);
                while ((n = zipInputStream.read(buf, 0, 1024)) > -1) {
                    fileOutputStream.write(buf, 0, n);
                }
                fileOutputStream.close();
                zipInputStream.closeEntry();
                zipEntry = zipInputStream.getNextEntry();
            }
            zipInputStream.close();
        }
        catch (Exception e) {
            Activator.logError("Unable to extract zip file", e);
        }
    }

    public static ArrayList getNewZipFiles(String watchedFolder) {
        ArrayList newZipFiles = new ArrayList();
        ArrayList<String> fileNames = new ArrayList<String>();
        ArrayList<String> fileFolders = new ArrayList<String>();
        try {
            File fileFolder = new File(watchedFolder);
            File[] folderFiles = fileFolder.listFiles();
            int i = 0;
            while (i < folderFiles.length) {
                File currFile = folderFiles[i];
                if (currFile.isDirectory()) {
                    fileFolders.add(currFile.getPath());
                } else {
                    fileNames.add(currFile.getPath());
                }
                ++i;
            }
            newZipFiles = ZipFileUtility.checkForNewZips(newZipFiles, fileNames, fileFolders);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newZipFiles;
    }

    public static ArrayList checkForNewZips(ArrayList newZipList, ArrayList fileList, ArrayList folderList) {
        int i = 0;
        while (i < fileList.size()) {
            int zipIndex;
            String folderToken;
            String currFile = (String)fileList.get(i);
            if (currFile.endsWith(".zip") && !folderList.contains(folderToken = currFile.substring(0, zipIndex = currFile.lastIndexOf(".zip")))) {
                newZipList.add(currFile);
            }
            ++i;
        }
        return newZipList;
    }

    public static String getDestinationPathForZip(String destinationName, String zipPath) {
        Object updatedDestination = "";
        int endPathIndex = zipPath.lastIndexOf(File.separator);
        int zipIndex = zipPath.lastIndexOf(".zip");
        String zipFolderName = zipPath.substring(endPathIndex + 1, zipIndex);
        updatedDestination = destinationName + File.separator + zipFolderName + File.separator;
        return updatedDestination;
    }

    public static void zip(File source, File dest) throws IOException {
        dest.delete();
        dest.getParentFile().mkdirs();
        dest.createNewFile();
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(dest));
        File[] list = source.listFiles();
        int l = 0;
        while (l < list.length) {
            ZipFileUtility.zipEntry(list[l], "", out);
            ++l;
        }
        out.closeEntry();
        out.close();
    }

    private static void zipEntry(File file, String path, ZipOutputStream out) throws IOException {
        if (!file.isDirectory()) {
            int read;
            ZipEntry entry = new ZipEntry(path + "/" + file.getName());
            out.putNextEntry(entry);
            FileInputStream in = new FileInputStream(file);
            byte[] bytes = new byte[8192];
            while ((read = in.read(bytes)) > -1) {
                out.write(bytes, 0, read);
            }
            in.close();
        } else {
            File[] list = file.listFiles();
            Object subPath = path + "/" + file.getName();
            if (((String)subPath).startsWith("/")) {
                subPath = ((String)subPath).substring(1);
            }
            int l = 0;
            while (l < list.length) {
                ZipFileUtility.zipEntry(list[l], (String)subPath, out);
                ++l;
            }
        }
    }
}

