/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.io;

import com.ibm.ut.help.common.web.URLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class Resource {
    private File file;
    private URL url;

    public Resource(Resource parent, String child) {
        this(parent.toString() + "/" + child);
    }

    public Resource(String uri) {
        if (uri.startsWith("http") || uri.startsWith("ftp")) {
            try {
                this.url = new URL(uri);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        } else {
            this.file = new File(uri);
        }
    }

    public Resource(File file) {
        this.file = file;
    }

    public Resource(URL url) {
        this.url = url;
    }

    public boolean isFile() {
        return this.file != null;
    }

    public InputStream getStream() throws IOException {
        if (this.isFile()) {
            return new FileInputStream(this.file);
        }
        return URLUtil.getStream(this.url);
    }

    public Resource getParent() {
        if (this.isFile()) {
            return new Resource(this.file.getParentFile());
        }
        try {
            URL parent = new URL(this.url.toString().substring(0, this.url.toString().lastIndexOf("/")));
            return new Resource(parent);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return this.isFile() ? this.file.getAbsolutePath() : this.url.toString();
    }

    public URI toURI() throws URISyntaxException {
        return this.isFile() ? this.file.toURI() : this.url.toURI();
    }
}

