/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.io;

import com.ibm.ut.help.parser.ITagHandler;
import com.ibm.ut.help.parser.TagElement;
import com.ibm.ut.help.parser.TagParser;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class HelpParser
implements ITagHandler {
    public static final int SUMMARY_LENGTH = 175;
    private TagParser parser;
    private Properties metaprops;
    private String title = "";
    private String summary = "";
    private Date date = null;
    private boolean inSummary = false;

    public void parse(InputStream in) throws IOException {
        this.metaprops = new Properties();
        this.parser = new TagParser();
        this.parser.parse(in, (ITagHandler)this);
    }

    public void startElement(TagElement element) {
        if (element.getTag().equals("meta")) {
            String mName = element.getProps().getProperty("name");
            String mContent = element.getProps().getProperty("content");
            if (mName != null && mContent != null) {
                this.metaprops.setProperty(mName, mContent);
            }
        } else if (element.getTag().equals("div") && element.getProperty("class").contains("body")) {
            this.inSummary = true;
        }
    }

    public void endElement(TagElement element) {
    }

    public void comment(String chunk) {
        if (chunk.contains("Generated date: ")) {
            String dateStr = chunk.substring(chunk.indexOf("Generated date: ") + "Generated date: ".length(), chunk.lastIndexOf("-->"));
            try {
                SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
                this.date = format.parse(dateStr);
            }
            catch (ParseException parseException) {}
        }
    }

    public void characters(TagElement element, String chars) {
        if (element.getTag().equals("title")) {
            this.title = chars;
        } else if (this.inSummary && this.summary.length() < 175) {
            this.summary = chars.length() <= 175 - this.summary.length() ? String.valueOf(this.summary) + chars : String.valueOf(this.summary) + chars.substring(0, 175 - this.summary.length());
            if (this.summary.length() >= 175) {
                this.inSummary = false;
                this.parser.forceStop();
                this.summary = this.truncate(this.summary);
            }
        }
    }

    private String truncate(String text) {
        if (text.contains(". ")) {
            text = text.substring(0, text.indexOf(". ") + 1);
        }
        if (text.contains(".\r")) {
            text = text.substring(0, text.indexOf(".\r") + 1);
        }
        if (text.contains(".\n")) {
            text = text.substring(0, text.indexOf(".\n") + 1);
        }
        text = text.replaceAll("\r", "");
        text = text.replaceAll("\n", "");
        return text;
    }

    public String getMetaProperty(String name) {
        return this.metaprops.getProperty(name);
    }

    public String getTitle() {
        return this.title;
    }

    public String getSummary() {
        return this.summary;
    }

    public Date getDate() {
        return this.date;
    }
}

