/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.io;

import com.ibm.ut.help.common.io.ByteArrayBufferedStream;
import com.ibm.ut.help.common.web.StateTagElement;
import com.ibm.ut.help.parser.TagElement;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;

public class HTMLOutputStream
extends OutputStream {
    public static final int BEFORE_START = 1;
    public static final int AFTER_START = 2;
    public static final int BEFORE_END = 3;
    public static final int AFTER_END = 4;
    private OutputStream out;
    private List insertList = new ArrayList();
    private Stack elements = new Stack();
    private StateTagElement current;
    private int prev = 32;
    private int prev2 = 32;
    private ByteArrayBufferedStream buffer = new ByteArrayBufferedStream();
    private String charset = "UTF-8";

    public HTMLOutputStream() {
        this(new ByteArrayOutputStream());
    }

    public HTMLOutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public void close() throws IOException {
        this.out.write(this.buffer.toByteArray());
        this.buffer.close();
        this.out.close();
        super.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.write(this.buffer.toByteArray());
        this.buffer = new ByteArrayBufferedStream();
        this.out.flush();
        super.flush();
    }

    public void insertText(TagElement toCompare, String toInsert, int location) {
        InsertableElement e = new InsertableElement(toInsert, toCompare, location);
        this.insertList.add(e);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int i = 0;
        while (i < len) {
            this.write(b[off + i]);
            ++i;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.write(b);
        if (this.current != null && this.current.getState() == 5 && b != 34 && b != 39) {
            this.current.appendProp((char)b);
        } else {
            switch (b) {
                case 62: {
                    if (this.current.getState() == 8 && this.prev == 45) {
                        this.current.setState(7);
                        this.fireBeginElement(this.current);
                        this.fireEndElement(this.current);
                        break;
                    }
                    if (this.prev == 47) {
                        this.current.setState(7);
                        this.fireBeginElement(this.current);
                        this.fireEndElement(this.current);
                        break;
                    }
                    if (this.current.getState() == 7) {
                        this.fireEndElement(this.current);
                        break;
                    }
                    this.current.setState(6);
                    this.fireBeginElement(this.current);
                    break;
                }
                case 47: {
                    if (this.prev != 60) break;
                    this.current.setState(7);
                    break;
                }
                case 61: {
                    if (this.current == null || this.current.getState() != 3) break;
                    this.current.setState(4);
                    break;
                }
                case 32: {
                    if (this.current == null) break;
                    if (this.current.getState() == 4) {
                        this.current.setState(2);
                        break;
                    }
                    if (this.current.getState() != 1) break;
                    this.current.setState(3);
                    break;
                }
                case 34: 
                case 39: {
                    if (this.current == null) break;
                    if (this.current.getState() == 4) {
                        this.current.setState(5);
                        break;
                    }
                    if (this.current.getState() != 5) break;
                    this.current.setState(3);
                    break;
                }
                case 45: {
                    if (this.prev == 33 && this.prev2 == 60) {
                        this.current.setState(8);
                    }
                }
                default: {
                    if (this.prev == 60) {
                        this.current = new StateTagElement();
                    }
                    if (this.current == null) break;
                    if (this.current.getState() == 3 || this.current.getState() == 4 || this.current.getState() == 5) {
                        this.current.appendProp((char)b);
                        break;
                    }
                    if (this.current.getState() != 1) break;
                    this.current.appendTag((char)b);
                }
            }
        }
        this.prev2 = this.prev;
        this.prev = b;
    }

    private void fireBeginElement(TagElement element) throws IOException {
        this.elements.push(this.current);
        int i = 0;
        while (i < this.insertList.size()) {
            InsertableElement insertable = (InsertableElement)this.insertList.get(i);
            if (insertable.matches(element)) {
                switch (insertable.getLocation()) {
                    case 1: {
                        this.buffer.insert(this.buffer.lastIndexOf((byte)60), insertable.getInsert().getBytes(this.charset));
                        break;
                    }
                    case 2: {
                        this.buffer.write(insertable.getInsert().getBytes(this.charset));
                    }
                }
            }
            ++i;
        }
    }

    private void fireEndElement(TagElement element) throws IOException {
        ((StateTagElement)element).flush();
        if (element.getTag().equalsIgnoreCase("meta")) {
            this.discoverCharset(element);
        }
        int i = 0;
        while (i < this.insertList.size()) {
            InsertableElement insertable = (InsertableElement)this.insertList.get(i);
            if (insertable.matches(element)) {
                switch (insertable.getLocation()) {
                    case 3: {
                        this.buffer.insert(this.buffer.lastIndexOf((byte)60), insertable.getInsert().getBytes(this.charset));
                        break;
                    }
                    case 4: {
                        this.buffer.write(insertable.getInsert().getBytes(this.charset));
                    }
                }
            }
            ++i;
        }
        this.elements.pop();
        this.current = this.elements.isEmpty() ? null : (StateTagElement)((Object)this.elements.peek());
    }

    private void discoverCharset(TagElement meta) {
        if (meta.getProperty("HTTP-EQUIV").contains("content-type")) {
            // empty if block
        }
    }

    private class InsertableElement {
        private String insert;
        private TagElement element;
        private int location;

        private InsertableElement(String insert, TagElement element, int location) {
            this.insert = insert;
            this.element = element;
            this.location = location;
        }

        public String getInsert() {
            return this.insert;
        }

        public TagElement getElement() {
            return this.element;
        }

        public int getLocation() {
            return this.location;
        }

        public boolean matches(TagElement candidate) {
            if (!this.element.getTag().equals(candidate.getTag())) {
                return false;
            }
            if (this.element.getProps() == null) {
                return true;
            }
            Enumeration<Object> keys = this.element.getProps().keys();
            while (keys.hasMoreElements()) {
                String name = (String)keys.nextElement();
                String val = this.element.getProps().getProperty(name);
                if (candidate.getProps().getProperty(name) == null) {
                    return false;
                }
                if (candidate.getProps().getProperty(name).contains(val)) continue;
                return false;
            }
            return true;
        }
    }
}

