/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.io;

import com.ibm.ut.help.common.connector.PlatformXMLParser;
import com.ibm.ut.help.common.io.FileHandler;
import com.ibm.ut.help.common.io.JarHandler;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;

public class BundleHandler {
    private static final String JAR_FILE_EXTN = ".jar";
    private static File[] bundleRoots = null;

    public static File[] getBundleRoots() {
        File p2DataRoot;
        if (bundleRoots != null) {
            return bundleRoots;
        }
        ArrayList<File> roots = new ArrayList<File>();
        File p2Data = BundleHandler.getP2DataArea();
        if (p2Data != null && (p2DataRoot = p2Data.getParentFile()).exists()) {
            roots.add(p2DataRoot);
        }
        File eclipseRoot = new File(Platform.getInstallLocation().getURL().getFile());
        roots.add(eclipseRoot);
        PlatformXMLParser parser = new PlatformXMLParser();
        List<File> links = parser.getLinks();
        roots.addAll(links);
        bundleRoots = roots.toArray(new File[roots.size()]);
        return bundleRoots;
    }

    public static File getLocalBundleLocation(String location) {
        String unJarredName = location;
        Object jarredName = location;
        if (location.endsWith(JAR_FILE_EXTN)) {
            unJarredName = location.substring(0, location.lastIndexOf(JAR_FILE_EXTN));
        } else {
            jarredName = location + JAR_FILE_EXTN;
        }
        File[] roots = BundleHandler.getBundleRoots();
        int r = 0;
        while (r < roots.length) {
            File unJarred = new File(roots[r], unJarredName);
            File jarred = new File(roots[r], (String)jarredName);
            File parentUnJarred = new File(roots[r], unJarred.getName());
            File parentJarred = new File(roots[r], jarred.getName());
            if (unJarred.exists()) {
                return unJarred;
            }
            if (jarred.exists()) {
                return jarred;
            }
            if (parentUnJarred.exists()) {
                return parentUnJarred;
            }
            if (parentJarred.exists()) {
                return parentJarred;
            }
            ++r;
        }
        return null;
    }

    public static int writeBundle(File bundle, OutputStream out) throws IOException {
        int contentLength = 0;
        contentLength = bundle.getName().endsWith(JAR_FILE_EXTN) ? FileHandler.writeFile(bundle, out) : JarHandler.writeNewJarOut(bundle, out);
        return contentLength;
    }

    public static File getP2DataArea() {
        String p2data = System.getProperty("eclipse.p2.data.area");
        if (p2data == null) {
            return null;
        }
        return new File(FileHandler.resolvePath(p2data));
    }
}

