/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.contentfilter.impl;

import com.ibm.ut.help.common.IContentReplacer;
import com.ibm.ut.help.common.contentreplace.impl.DeliverableReplacer;
import com.ibm.ut.help.common.web.LocaleUtil;
import com.ibm.ut.help.common.web.ReplacerOutputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.webapp.IFilter;

public abstract class ContentReplaceFilter
implements IFilter {
    private IConfigurationElement[] replaceConfigs;
    private IConfigurationElement[] replaceDeliverableConfigs;

    public IConfigurationElement[] loadReplaceConfigs() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.ut.help.common.contentReplace");
    }

    public IConfigurationElement[] loadReplaceDeliverableConfigs() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.ut.help.common.contentReplaceDeliverable");
    }

    public OutputStream filter(HttpServletRequest req, OutputStream out) {
        IContentReplacer replacer;
        String regex;
        if (this.replaceConfigs == null) {
            this.replaceConfigs = this.loadReplaceConfigs();
        }
        if (this.replaceDeliverableConfigs == null) {
            this.replaceDeliverableConfigs = this.loadReplaceDeliverableConfigs();
        }
        if (this.replaceConfigs.length == 0 && this.replaceDeliverableConfigs.length == 0) {
            return out;
        }
        ReplacerOutputStream newStream = new ReplacerOutputStream(out);
        int r = 0;
        while (r < this.replaceConfigs.length) {
            regex = this.replaceConfigs[r].getAttribute("regex");
            if (this.replaceConfigs[r].getChildren()[0].getName().equals("newString")) {
                newStream.replaceAll(regex, this.replaceConfigs[r].getChildren()[0].getAttribute("string"));
            } else {
                try {
                    replacer = (IContentReplacer)this.replaceConfigs[r].getChildren()[0].createExecutableExtension("class");
                    replacer.setLocale(LocaleUtil.getLocale(req));
                    newStream.replaceAll(regex, replacer);
                }
                catch (InvalidRegistryObjectException e) {
                    e.printStackTrace();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++r;
        }
        r = 0;
        while (r < this.replaceDeliverableConfigs.length) {
            regex = this.replaceDeliverableConfigs[r].getAttribute("regex");
            replacer = new DeliverableReplacer(this.replaceDeliverableConfigs[r].getAttribute("RCP"), this.replaceDeliverableConfigs[r].getAttribute("IDE"), this.replaceDeliverableConfigs[r].getAttribute("IC"));
            ((DeliverableReplacer)replacer).setLocale(LocaleUtil.getLocale(req));
            newStream.replaceAll(regex, replacer);
            ++r;
        }
        return newStream;
    }

    public String replaceAll(String s, String find, String replace) {
        Object tmp = s;
        int index = 0;
        while ((index = s.indexOf(find, index)) > -1) {
            tmp = s.substring(0, index) + replace + s.substring(index + find.length());
        }
        return tmp;
    }
}

