/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.connector;

import com.ibm.ut.help.common.Activator;
import com.ibm.ut.help.common.connector.ConnectorServlet;
import com.ibm.ut.help.common.connector.impl.QueueConnector;
import com.ibm.ut.help.common.ic.IC;
import com.ibm.ut.help.common.prefs.ICPreferences;
import com.ibm.ut.help.common.web.URLUtil;
import com.ibm.ut.help.parser.json.JSONElement;
import com.ibm.ut.help.parser.json.JSONParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.server.WebappManager;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;

public class PlatformConnector {
    private static String ideBaseURL = null;
    public static final int STANDALONE_WAR = 1;
    public static final int RCP = 2;
    public static final int EMBEDDED_RCP = 3;
    public static final int IDE = 4;
    public static final int SPAWNED_WAR = 5;

    public static void checkQueue() throws NumberFormatException, MalformedURLException {
        String queue = PlatformConnector.send("checkQueue", new Properties());
        if (queue == null) {
            return;
        }
        JSONParser parser = new JSONParser();
        parser.parse(queue, null);
        JSONElement root = parser.getRoot();
        if (root == null) {
            return;
        }
        Object items = root.get((Object)"items");
        if (items != null && items instanceof ArrayList) {
            ArrayList elements = (ArrayList)root.get((Object)"items");
            int e = 0;
            while (e < elements.size()) {
                Properties props = (Properties)elements.get(e);
                String op = props.getProperty("op");
                ConnectorServlet.exec(op, props, null);
                ++e;
            }
        }
    }

    public static int getPlatform() {
        Location config = Platform.getConfigurationLocation();
        File ideIni = new File("ide.ini");
        if (config != null) {
            URL configURL = config.getURL();
            ideIni = new File(configURL.getFile(), "ide.ini");
        }
        if (Platform.getBundle((String)"com.ibm.ccl.help.webapp.war.updater") != null && Platform.getBundle((String)"com.ibm.ut.ic.server") == null && !ideIni.exists()) {
            return 1;
        }
        if (Platform.getBundle((String)"com.ibm.ccl.help.webapp.war.updater") != null && Platform.getBundle((String)"com.ibm.ut.ic.server") == null && ideIni.exists()) {
            return 5;
        }
        if (Platform.getBundle((String)"com.ibm.ccl.help.webapp.war.updater") != null && Platform.getBundle((String)"com.ibm.ccl.ut.help") != null) {
            return 3;
        }
        if (Platform.getBundle((String)"com.ibm.ccl.help.webapp.war.updater") == null && Platform.getBundle((String)"com.ibm.ccl.ut.help") != null) {
            return 2;
        }
        return 4;
    }

    public static boolean isWAR() {
        return PlatformConnector.getPlatform() == 1 || PlatformConnector.getPlatform() == 5;
    }

    public static boolean isRCP() {
        return PlatformConnector.getPlatform() == 2;
    }

    public static boolean isIDE() {
        return PlatformConnector.getPlatform() == 4;
    }

    public static boolean isEmbeddedRCP() {
        return PlatformConnector.getPlatform() == 3;
    }

    public static boolean isIC() {
        return Platform.getBundle((String)"org.eclipse.ui") == null;
    }

    public static String send(String operation, Properties args) {
        if (PlatformConnector.isWAR()) {
            return PlatformConnector.sendToIDE(operation, args);
        }
        return PlatformConnector.sendToWAR(operation, args);
    }

    public static String sendToIDE(String operation, Properties args) {
        if (PlatformConnector.getIDEBaseURL() != null) {
            return PlatformConnector.send(PlatformConnector.getIDEBaseURL(), operation, args);
        }
        return null;
    }

    public static String sendToWAR(String operation, Properties args) {
        return PlatformConnector.send(PlatformConnector.getWARBaseURL(), operation, args);
    }

    public static String send(String baseURL, String operation, Properties args) {
        args.setProperty("op", operation);
        try {
            URL[] urls = new URL[]{new URL(baseURL + "/com.ibm.ut.help.common.connector.ConnectorServlet"), new URL(baseURL + "/com.ibm.ut.common.connector.ConnectorServlet")};
            int u = 0;
            while (u < urls.length) {
                InputStream in = URLUtil.postStream(urls[u], args);
                if (in != null) {
                    String line;
                    BufferedReader br = new BufferedReader(new InputStreamReader(in));
                    Object content = "";
                    while ((line = br.readLine()) != null) {
                        content = (String)content + line + "\n";
                    }
                    return content;
                }
                ++u;
            }
        }
        catch (IOException iOException) {
            QueueConnector.add(args);
        }
        return null;
    }

    public static String getBaseURL() {
        BaseHelpSystem.ensureWebappRunning();
        return "http://" + WebappManager.getHost() + ":" + WebappManager.getPort() + "/help";
    }

    public static String getWARBaseURL() {
        if (PlatformConnector.isWAR()) {
            return PlatformConnector.getBaseURL();
        }
        List ics = ICPreferences.getICs();
        int i = 0;
        while (i < ics.size()) {
            if (((IC)ics.get(i)).getName().equals("Local") && ((IC)ics.get(i)).getHost().equals("127.0.0.1")) {
                return ((IC)ics.get(i)).getHref();
            }
            ++i;
        }
        return null;
    }

    public static String getIDEBaseURL() {
        if (!PlatformConnector.isWAR()) {
            return PlatformConnector.getBaseURL();
        }
        if (ideBaseURL != null) {
            return ideBaseURL;
        }
        try {
            String line;
            File ideIni = new File(Platform.getConfigurationLocation().getURL().getFile(), "ide.ini");
            BufferedReader br = new BufferedReader(new FileReader(ideIni));
            while ((line = br.readLine()) != null) {
                if (!line.contains("=")) continue;
                String key = line.substring(0, line.indexOf("="));
                String val = line.substring(line.indexOf("=") + 1);
                if (!key.equals("eclipse.helpURL")) continue;
                ideBaseURL = val;
                return ideBaseURL;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static String getInfrastructureVersion() {
        try {
            PropertyResourceBundle props = new PropertyResourceBundle(FileLocator.openStream((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("plugin.properties"), (boolean)false));
            return props.getString("base.version");
        }
        catch (IOException iOException) {
            return "Alpha";
        }
    }

    public static String getConfigurationLocation() {
        Object configLocation = null;
        try {
            configLocation = Platform.getConfigurationLocation().getDataArea("").getFile();
            File configFile = new File((String)configLocation);
            configLocation = configFile.getAbsolutePath();
            if (!((String)configLocation).endsWith(File.separator)) {
                configLocation = (String)configLocation + File.separator;
            }
        }
        catch (IOException e) {
            Activator.logError("Exception getting configuration location", e);
        }
        return configLocation;
    }
}

