/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.debugtool.internal.migration;

import com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.MvsBatchLaunchPlugin;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.ftt.common.logging.LogUtil;
import com.ibm.ftt.debug.ui.DebugMessages;
import com.ibm.ftt.debug.ui.Labels;
import com.ibm.pdtools.debugtool.internal.migration.AbstractDTProfileMigratorMessageHandler;
import java.io.File;
import java.io.FileNotFoundException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JCLMessageHandler
extends AbstractDTProfileMigratorMessageHandler {
    private static final String EMPTY = "";
    private static final String JCLMessageHandler_KEY = "JCLMessageHandler";
    private Document fDocument;

    @Override
    public boolean isApplicableView(IWorkbenchPartReference workbenchPartReference) {
        return workbenchPartReference.getId().equals("com.ibm.pdtools.bjfd.ui.views.CustSettingsView");
    }

    @Override
    protected String getMessage() {
        return DebugMessages.CRRDG8037;
    }

    @Override
    protected String getActivityId() {
        return "com.ibm.pdtools.debugtool.dtcommon.jcl";
    }

    @Override
    protected String getPreferenceKey() {
        return JCLMessageHandler_KEY;
    }

    @Override
    protected String getViewToOpenID() {
        return null;
    }

    @Override
    protected String getMessageTitle() {
        return Labels.WARNING;
    }

    public void doMigration() {
        Document doc = this.getDocument();
        if (doc != null) {
            NodeList nodeList = doc.getElementsByTagName("setting");
            int i = 0;
            while (i < nodeList.getLength()) {
                this.migrateSettings(nodeList.item(i));
                ++i;
            }
        }
    }

    private void migrateSettings(Node node) {
        IPreferenceStore store = MvsBatchLaunchPlugin.getDefault().getPreferenceStore();
        NamedNodeMap map = node.getAttributes();
        String value = this.getAttribute(map, "jobCard");
        store.setValue("com.ibm.debug.pdt.idz.launches.mvs.jobCard", value == null ? EMPTY : value.replace("\\", EMPTY));
        value = this.getAttribute(map, "testType");
        store.setValue("com.ibm.debug.pdt.idz.launches.mvs.test", value == null ? "TEST" : value.toUpperCase());
        value = this.getAttribute(map, "testLevel");
        store.setValue("com.ibm.debug.pdt.idz.launches.mvs.error", value == null ? "ALL" : value.toUpperCase());
        value = this.getAttribute(map, "prompt");
        store.setValue("com.ibm.debug.pdt.idz.launches.mvs.prompt", value == null || !value.toUpperCase().equals("PROMPT") && !value.toUpperCase().equals("NOPROMPT") ? "PROMPT" : value.toUpperCase());
        value = this.getAttribute(map, "prefDataset");
        store.setValue("com.ibm.debug.pdt.idz.launches.mvs.preference", value == null ? EMPTY : value);
        value = this.getAttribute(map, "commandDataset");
        store.setValue("com.ibm.debug.pdt.idz.launches.mvs.command", value == null ? EMPTY : value);
        value = this.getAttribute(map, "loadModuleDataset");
        store.setValue("com.ibm.debug.pdt.idz.launches.mvs.debugLib", value == null ? EMPTY : value);
        String ds1 = this.getAttribute(map, "userLevelFileDataset");
        String ds2 = this.getAttribute(map, "installFileDataset");
        StringBuilder sb = new StringBuilder();
        if (ds1 != null && !ds1.trim().isEmpty()) {
            sb.append(ds1);
            sb.append(':');
            sb.append(0);
        }
        if (ds2 != null && !ds2.trim().isEmpty()) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(ds2);
            sb.append(':');
            sb.append(0);
        }
        store.setValue("com.ibm.debug.pdt.idz.launches.mvs.sourceLookup", sb.length() == 0 ? EMPTY : sb.toString());
    }

    protected String getAttribute(NamedNodeMap map, String attributeName) {
        Node attributeNode = map.getNamedItem(attributeName);
        return attributeNode != null ? attributeNode.getNodeValue() : EMPTY;
    }

    private Document getDocument() {
        if (this.fDocument == null) {
            Document doc;
            block4: {
                String filePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString() + File.separator + "BJFDConfig.xml";
                doc = null;
                try {
                    DocumentBuilderFactory factory = PDTCoreUtils.getSecureDocumentBuilderFactory();
                    if (factory != null) {
                        DocumentBuilder docBuilder = factory.newDocumentBuilder();
                        doc = docBuilder.parse(filePath);
                        doc.getDocumentElement().normalize();
                    }
                }
                catch (Exception e) {
                    if (e instanceof FileNotFoundException) break block4;
                    LogUtil.log((int)4, (String)e.getMessage(), (String)"com.ibm.pdtools.debugtool.migration", (Throwable)e);
                }
            }
            this.fDocument = doc;
        }
        return this.fDocument;
    }

    @Override
    protected void handleYesButton() {
        this.doMigration();
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"com.ibm.debug.pdt.idz.launches.jclGeneration", null, null);
        dialog.open();
    }
}

