/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.debugtool.internal.migration;

import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTSP;
import com.ibm.pdtools.debugtool.internal.migration.AbstractDTProfileMigrator;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.w3c.dom.NamedNodeMap;

public class DTSPProfileMigrator
extends AbstractDTProfileMigrator {
    private static final String STEP_NAME = "stepName";
    private static final String DB2_CLIENT_ID = "db2ClientId";
    private static final String IMS_TRANSACTION_ID = "imsTransactionID";
    private static final String IMS_SUBSYSTEM_ID = "imsSubsystemID";
    private static final String JOB_NAME = "jobName";
    private static final String XML_FILENAME = "DTSPProfiles.xml";

    @Override
    protected String getProfileFileName() {
        return XML_FILENAME;
    }

    @Override
    protected DebugProfile createProfile(String name) {
        return new DebugProfileDTSP(name);
    }

    @Override
    protected void migrateProfileSpecifics(DebugProfile profile, NamedNodeMap map) {
        if (profile instanceof DebugProfileDTSP) {
            DebugProfileDTSP dtspProfile = (DebugProfileDTSP)profile;
            IEclipsePreferences dtspNode = InstanceScope.INSTANCE.getNode("com.ibm.pdtools.debugtool.dtsp");
            if (dtspNode != null) {
                dtspProfile.setLocation(dtspNode.get("com.ibm.pdtools.debugtool.dtsp.USEREXIT", "&USERID.DLAYDBG.EQAUOPTS"));
            } else {
                dtspProfile.setLocation("&USERID.DLAYDBG.EQAUOPTS");
            }
            String db2ClientID = this.getAttribute(map, DB2_CLIENT_ID);
            if (db2ClientID != null) {
                DebugProfileDTSP.DB2Options db2Options = new DebugProfileDTSP.DB2Options(db2ClientID);
                dtspProfile.setDB2Options(db2Options);
            }
            String jobName = this.getAttribute(map, JOB_NAME);
            String stepName = this.getAttribute(map, STEP_NAME);
            if (jobName != null || stepName != null) {
                DebugProfileDTSP.JobInfo jobInfo = new DebugProfileDTSP.JobInfo(jobName, stepName);
                dtspProfile.setJobInfo(jobInfo);
            }
            String subsystemID = this.getAttribute(map, IMS_SUBSYSTEM_ID);
            String attributeName = IMS_TRANSACTION_ID;
            String transactionID = this.getAttribute(map, attributeName);
            if (subsystemID != null || transactionID != null) {
                DebugProfileDTSP.IMSOptions imsOptions = new DebugProfileDTSP.IMSOptions(subsystemID, transactionID);
                dtspProfile.setIMSOptions(imsOptions);
            }
        }
    }

    @Override
    protected String getConnectionTypeID() {
        return "com.ibm.pdtools.comms.cics.connection";
    }

    @Override
    protected String getProfileType() {
        return "DTSP";
    }
}

