/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.debugtool.internal.migration;

import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.debug.pdt.profile.IAdditionalCICSFilters;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionUtilities;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTCN;
import com.ibm.pdtools.debugtool.internal.migration.AbstractDTProfileMigrator;
import java.util.ArrayList;
import org.w3c.dom.NamedNodeMap;

public class DTCNProfileMigrator
extends AbstractDTProfileMigrator {
    private static final String TRANSACTION_ID = "transactionId";
    private static final String TERMINAL_ID = "terminalId";
    private static final String USER_ID = "userId";
    private static final String NET_NAME = "netName";
    private static final String CLIENT_IP = "clientIP";
    private static final String SYS_ID = "sysID";
    private static final String CA_OFFSET = "commareaOffset";
    private static final String CA_DATA = "commareaData";
    private static final String CONTAINER_NAME = "containerName";
    private static final String CONTAINER_OFFSET = "containerOffset";
    private static final String CONTAINER_DATA = "containerData";
    private static final String PLATFORM_NAME = "platformName";
    private static final String APPLICATION_NAME = "applicationName";
    private static final String OPERATION_NAME = "operationName";
    private static final String VERSION_MAJ = "applicationVersionMaj";
    private static final String VERSION_MIN = "applicationVersionMin";
    private static final String VERSION_MIC = "applicationVersionMic";
    private static final String URM = "urmDebugging";
    private static final String XML_FILENAME = "DTCNProfiles.xml";

    @Override
    protected String getProfileFileName() {
        return XML_FILENAME;
    }

    @Override
    protected DebugProfile createProfile(String name) {
        return new DebugProfileDTCN(name);
    }

    @Override
    protected void migrateProfileSpecifics(DebugProfile profile, NamedNodeMap map) {
        if (profile instanceof DebugProfileDTCN) {
            String transaction;
            DebugProfileDTCN dtcnProfile = (DebugProfileDTCN)profile;
            int port = this.getConnectionPort();
            boolean isRegionNameFound = false;
            Connection c = ConnectionUtilities.getConnection((String)dtcnProfile.getConnectionName(), (boolean)true);
            if (c != null) {
                Connection.RegionPortPair[] regionInfo;
                Connection.RegionPortPair[] regionPortPairArray = regionInfo = c.getCICSRegionAndPorts();
                int n = regionInfo.length;
                int n2 = 0;
                while (n2 < n) {
                    Connection.RegionPortPair r = regionPortPairArray[n2];
                    if (r.port == port) {
                        dtcnProfile.setRegion(r.regionName);
                        isRegionNameFound = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!isRegionNameFound) {
                dtcnProfile.setPort(port);
            }
            if (!(transaction = this.getAttribute(map, TRANSACTION_ID)).isEmpty()) {
                dtcnProfile.setTransaction(transaction);
            }
            String userID = this.getAttribute(map, USER_ID);
            String netName = this.getAttribute(map, NET_NAME);
            String ip = this.getAttribute(map, CLIENT_IP);
            String cicsSysID = this.getAttribute(map, SYS_ID);
            String terminalID = this.getAttribute(map, TERMINAL_ID);
            if (!(userID.isEmpty() && netName.isEmpty() && ip.isEmpty() && cicsSysID.isEmpty() && terminalID.isEmpty())) {
                DebugProfileDTCN.AdditionalCICSFilters additionalCICSFilters = new DebugProfileDTCN.AdditionalCICSFilters(userID, netName, ip, cicsSysID, terminalID);
                dtcnProfile.setAdditionalCICSFilters((IAdditionalCICSFilters)additionalCICSFilters);
            }
            String name = this.getAttribute(map, CONTAINER_NAME);
            String offset = this.getAttribute(map, CONTAINER_OFFSET);
            String data = this.getAttribute(map, CONTAINER_DATA);
            DebugProfileDTCN.ContainerInfo containerInfo = null;
            if (!name.isEmpty() || !offset.isEmpty() && !offset.equals("0") || !data.isEmpty()) {
                containerInfo = new DebugProfileDTCN.ContainerInfo(name, offset, data);
            }
            String platformName = this.getAttribute(map, PLATFORM_NAME);
            String applicationName = this.getAttribute(map, APPLICATION_NAME);
            String operationName = this.getAttribute(map, OPERATION_NAME);
            String applicationVersion = this.getInt(this.getAttribute(map, VERSION_MAJ)) + "." + this.getInt(this.getAttribute(map, VERSION_MIN)) + "." + this.getInt(this.getAttribute(map, VERSION_MIC));
            DebugProfileDTCN.ApplicationInfo applicationInfo = null;
            if (!(platformName.isEmpty() && applicationName.isEmpty() && operationName.isEmpty() && applicationVersion.equals(".."))) {
                applicationInfo = new DebugProfileDTCN.ApplicationInfo(platformName, applicationName, operationName, applicationVersion);
            }
            String ca_offset = this.getAttribute(map, CA_OFFSET);
            String ca_data = this.getAttribute(map, CA_DATA);
            DebugProfileDTCN.CommAreaInfo commAreaInfo = null;
            if (!(containerInfo != null || ca_data.isEmpty() && (ca_offset.isEmpty() || ca_offset.equals("0")))) {
                commAreaInfo = new DebugProfileDTCN.CommAreaInfo(ca_offset, ca_data);
            }
            String urm = this.getAttribute(map, URM);
            boolean isURM = urm.equalsIgnoreCase("YES");
            if (containerInfo != null || applicationInfo != null || commAreaInfo != null || !urm.isEmpty()) {
                containerInfo = containerInfo == null ? new DebugProfileDTCN.ContainerInfo("", "", "") : containerInfo;
                applicationInfo = applicationInfo == null ? new DebugProfileDTCN.ApplicationInfo("", "", "", "") : applicationInfo;
                commAreaInfo = commAreaInfo == null ? new DebugProfileDTCN.CommAreaInfo("", "") : commAreaInfo;
                DebugProfileDTCN.AdvancedProgramInterruptionCriteria advancedCriteria = new DebugProfileDTCN.AdvancedProgramInterruptionCriteria(containerInfo, applicationInfo, commAreaInfo, isURM);
                dtcnProfile.setAdvancedProgramInterruptionCriteria(advancedCriteria);
            }
        }
    }

    private String getInt(String attribute) {
        try {
            return Integer.toString(Integer.parseInt(attribute));
        }
        catch (NumberFormatException e) {
            return "";
        }
    }

    @Override
    protected String getConnectionTypeID() {
        return "com.ibm.pdtools.debugtool.dtcn.connection";
    }

    @Override
    protected String getProfileType() {
        return "DTCN";
    }

    private int getConnectionPort() {
        ArrayList<ConnectionProfile> matchingProfiles = new ArrayList<ConnectionProfile>();
        for (ConnectionProfile p : ConnectionsPlugin.getDefault().getConnectionManager().getConnectionProfiles()) {
            if (!p.getConnectionDescriptor().getId().equals(this.getConnectionTypeID())) continue;
            matchingProfiles.add(p);
        }
        return matchingProfiles.size() == 1 ? ((ConnectionProfile)matchingProfiles.get(0)).getConnectionConfiguration().getPort() : -1;
    }
}

