/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.debugtool.internal.migration;

import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionUtilities;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileNameUtils;
import com.ibm.debug.pdt.ui.profile.internal.migration.IDebugProfileMigrator;
import com.ibm.ftt.common.logging.LogUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractDTProfileMigrator
implements IDebugProfileMigrator {
    private static final String PROGRAM = "program";
    private static final String PGMNAME = "pgmname";
    private static final String LOADNAME = "loadname";
    private static final String PORT_NUM = "portNum";
    private static final String SESSION_ADDRESS = "sessionAddr";
    private static final String PREFERENCE_FILE = "preferenceFile";
    private static final String OTHER_LE_OPTIONS = "otherLEOptions";
    private static final String EQA_OPTS_FILE = "eqaOptsFile";
    private static final String SESSION_TYPE = "sessionType";
    private static final String TCP = "TCP";
    private static final String COMMANDS_FILE = "commandsFile";
    private static final String DESCRIPTION = "description";
    private static final String PROMPT_LEVEL = "promptLevel";
    private static final String TEST_LEVEL = "testLevel";
    private static final String TEST_TYPE = "testType";
    private static final String PROFILE = "profile";
    private static final String NAME = "name";
    protected static final String EMPTY = "";
    private int fSuccessful = 0;
    private Document fDocument = null;
    private String fImportDirectory;

    protected abstract String getProfileFileName();

    public void migrateProfiles(IProgressMonitor monitor) {
        this.migrateProfiles(monitor, null);
    }

    public void migrateProfiles(final IProgressMonitor monitor, String filename) {
        NodeList nodes;
        Document document;
        Document document2 = document = filename == null ? this.getDocument() : this.getDocument(filename);
        if (document != null && (nodes = document.getElementsByTagName(PROFILE)).getLength() > 0) {
            monitor.beginTask(EMPTY, nodes.getLength());
            int i = 0;
            while (i < nodes.getLength()) {
                this.fSuccessful += this.migrateProfile(nodes.item(i)) ? 1 : 0;
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        monitor.worked(1);
                    }
                });
                ++i;
            }
        }
    }

    protected abstract DebugProfile createProfile(String var1);

    private boolean migrateProfile(Node node) {
        boolean isImporting = this.fImportDirectory != null;
        NamedNodeMap map = node.getAttributes();
        String sessionType = this.getAttribute(map, SESSION_TYPE);
        if (sessionType != null && TCP.equals(sessionType)) {
            String preferenceDataSet;
            String languageEnvironmentOptions;
            String eqaOptsFile;
            String name = map.getNamedItem(NAME).getNodeValue();
            DebugProfile profile = this.createProfile(this.ensureUniqueName(name));
            String connection = this.getConnectionName();
            if (connection != null) {
                profile.setConnectionName(connection);
                connection = this.ensureRSEConnection(connection);
                if (connection != null) {
                    profile.setConnectionName(connection);
                }
            }
            profile.setDescription(this.getAttribute(map, DESCRIPTION));
            String testLevel = this.getAttribute(map, TEST_TYPE);
            String errorLevel = this.getAttribute(map, TEST_LEVEL);
            String promptLevel = this.getAttribute(map, PROMPT_LEVEL);
            DebugProfile.DebuggerOptions debuggerOptions = new DebugProfile.DebuggerOptions(testLevel, errorLevel, promptLevel);
            profile.setDebuggerOptions(debuggerOptions);
            String commandDataSet = this.getAttribute(map, COMMANDS_FILE);
            if (!commandDataSet.isEmpty()) {
                debuggerOptions.setCommandDataSet(commandDataSet);
            }
            if (!(eqaOptsFile = this.getAttribute(map, EQA_OPTS_FILE)).isEmpty()) {
                debuggerOptions.setEqaOptsFile(eqaOptsFile);
            }
            if (!(languageEnvironmentOptions = this.getAttribute(map, OTHER_LE_OPTIONS)).isEmpty()) {
                debuggerOptions.setLanguageEnvironmentOptions(languageEnvironmentOptions);
            }
            if (!(preferenceDataSet = this.getAttribute(map, PREFERENCE_FILE)).isEmpty()) {
                debuggerOptions.setPreferenceDataSet(preferenceDataSet);
            }
            String ip = this.getAttribute(map, SESSION_ADDRESS);
            String port = this.getAttribute(map, PORT_NUM);
            if (ip != null && !ip.isEmpty() && port != null && !port.isEmpty()) {
                DebugProfile.AdvancedConnectionOptions advancedConnectionOptions = new DebugProfile.AdvancedConnectionOptions(EMPTY, ip, port);
                profile.setAdvancedConnectionOptions(advancedConnectionOptions);
            }
            this.addLoadModules(profile, node.getChildNodes());
            this.migrateProfileSpecifics(profile, map);
            try {
                profile.save();
                if (profile.isValid()) {
                    LogUtil.log((int)1, (String)String.format("Debug Tool %s profile '%s' is successfully migrated to a z/OS Debugger profile (%s).", this.getProfileType(), name, profile.getName()), (String)"com.ibm.pdtools.debugtool.migration");
                } else {
                    LogUtil.log((int)1, (String)String.format("Debug Tool %s profile '%s' is migrated to a z/OS Debugger profile (%s) with missing information.", this.getProfileType(), name, profile.getName()), (String)"com.ibm.pdtools.debugtool.migration");
                }
            }
            catch (Exception e) {
                LogUtil.log((int)1, (String)String.format("Debug Tool %s profile '%s' was not successfully migrated to a z/OS Debugger profile.", this.getProfileType(), name), (String)"com.ibm.pdtools.debugtool.migration");
                LogUtil.log((int)4, (String)e.getMessage(), (String)"com.ibm.pdtools.debugtool.migration", (Throwable)e);
            }
            return profile.isValid() || isImporting;
        }
        if (sessionType != null) {
            LogUtil.log((int)1, (String)String.format("Debug Tool %s profile '%s' ignored for migration to a z/OS Debugger profile. Type %s is not supported.", this.getProfileType(), map.getNamedItem(NAME).getNodeValue(), sessionType), (String)"com.ibm.pdtools.debugtool.migration");
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private String ensureRSEConnection(String hostname) {
        systemRegistry = RSECorePlugin.getTheSystemRegistry();
        profile = systemRegistry.getSystemProfileManager().getDefaultPrivateSystemProfile();
        if (profile == null) {
            try {
                profile = systemRegistry.createSystemProfile(null, true);
            }
            catch (Exception e) {
                LogUtil.log((int)4, (String)e.getMessage(), (String)"com.ibm.pdtools.debugtool.migration", (Throwable)e);
                return hostname;
            }
        }
        profileName = profile.getName();
        cr = RSECorePlugin.getTheCoreRegistry();
        systemType = cr.getSystemTypeById("com.ibm.etools.zos.system");
        connection = systemRegistry.getHost(profile, hostname);
        if (connection != null) ** GOTO lbl27
        try {
            connection = systemRegistry.createHost(profileName, systemType, hostname, hostname, null, null, 2, null);
            if (true) ** GOTO lbl27
        }
        catch (Exception e) {
            LogUtil.log((int)4, (String)e.getMessage(), (String)"com.ibm.pdtools.debugtool.migration", (Throwable)e);
            return hostname;
        }
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                break;
            }
lbl27:
            // 3 sources

        } while (ConnectionUtilities.getConnection((String)connection.getName(), (boolean)false) == null);
        return connection.getName();
    }

    private String ensureUniqueName(String name) {
        if (name.length() > 25) {
            name = name.substring(0, 25);
        }
        return DebugProfileNameUtils.isNameInUse((String)name) ? DebugProfileNameUtils.generateNewName((String)name) : name;
    }

    protected abstract String getProfileType();

    private String getConnectionName() {
        ArrayList<ConnectionProfile> matchingProfiles = new ArrayList<ConnectionProfile>();
        for (ConnectionProfile p : ConnectionsPlugin.getDefault().getConnectionManager().getConnectionProfiles()) {
            if (!p.getConnectionDescriptor().getId().equals(this.getConnectionTypeID())) continue;
            matchingProfiles.add(p);
        }
        return matchingProfiles.size() == 1 ? ((ConnectionProfile)matchingProfiles.get(0)).getConnectionConfiguration().getHost() : null;
    }

    protected abstract String getConnectionTypeID();

    protected abstract void migrateProfileSpecifics(DebugProfile var1, NamedNodeMap var2);

    private void addLoadModules(DebugProfile profile, NodeList nodelist) {
        int i = 0;
        while (i < nodelist.getLength()) {
            this.addLoadModule(profile, nodelist.item(i));
            ++i;
        }
    }

    private void addLoadModule(DebugProfile profile, Node node) {
        if (node.getNodeName().equals(PROGRAM)) {
            NamedNodeMap map = node.getAttributes();
            String loadModule = this.getAttribute(map, LOADNAME);
            String compilationUnit = this.getAttribute(map, PGMNAME);
            profile.addLoadModulePair(loadModule, compilationUnit);
        }
    }

    protected String getAttribute(NamedNodeMap map, String attributeName) {
        Node attributeNode = map.getNamedItem(attributeName);
        return attributeNode != null ? attributeNode.getNodeValue() : EMPTY;
    }

    private Document getDocument(String filePath) {
        if (this.fDocument == null) {
            Document doc;
            block4: {
                doc = null;
                try {
                    DocumentBuilderFactory factory = PDTCoreUtils.getSecureDocumentBuilderFactory();
                    if (factory != null) {
                        DocumentBuilder docBuilder = factory.newDocumentBuilder();
                        doc = docBuilder.parse(filePath);
                        doc.getDocumentElement().normalize();
                    }
                }
                catch (Exception e) {
                    if (e instanceof FileNotFoundException) break block4;
                    LogUtil.log((int)4, (String)e.getMessage(), (String)"com.ibm.pdtools.debugtool.migration", (Throwable)e);
                }
            }
            this.fDocument = doc;
        }
        return this.fDocument;
    }

    private Document getDocument() {
        if (this.fDocument == null) {
            String filePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString() + File.separator + this.getProfileFileName();
            return this.getDocument(filePath);
        }
        return this.fDocument;
    }

    public int getNumberOfProfilesToMigrate() {
        return this.getNumberOfProfiles(null);
    }

    private int getNumberOfProfiles(String filename) {
        NodeList nodes;
        Document document;
        Document document2 = document = filename == null ? this.getDocument() : this.getDocument(filename);
        if (document != null && (nodes = document.getElementsByTagName(PROFILE)) != null) {
            return nodes.getLength();
        }
        return 0;
    }

    public int getNumberOfProfilesSuccessfullyMigrated() {
        return this.fSuccessful;
    }

    public void setImportDirectory(String dir) {
        this.fImportDirectory = dir;
    }

    public int getNumberOfProfilesToImport() {
        return this.getNumberOfProfiles(this.fImportDirectory + File.separator + this.getProfileFileName());
    }

    public void importProfiles(IProgressMonitor monitor) {
        this.migrateProfiles(monitor, this.fImportDirectory + File.separator + this.getProfileFileName());
    }

    public int getNumberOfProfilesSuccessfullyImported() {
        return this.getNumberOfProfilesSuccessfullyMigrated();
    }
}

