/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.samples;

import com.ibm.lpex.core.LpexBaseAction;
import com.ibm.lpex.core.LpexView;

public class ZoomAction
extends LpexBaseAction {
    @Override
    public void doAction(LpexView lpexView) {
        if (!lpexView.queryOn("block.inView")) {
            int zoomMark = lpexView.queryInt("markId.@ZoomAction");
            if (zoomMark > 0) {
                boolean wasZoomedIn = lpexView.queryOn("markIncluded.@ZoomAction");
                if (wasZoomedIn) {
                    ZoomAction.restoreExpandHide(lpexView);
                } else {
                    ZoomAction.hideExpandHide(lpexView);
                }
                lpexView.doCommand("set markIncluded.@ZoomAction " + (wasZoomedIn ? "off" : "on"));
            }
            return;
        }
        ZoomAction.zoomIn(lpexView, lpexView.queryInt("block.topElement"), lpexView.queryInt("block.bottomElement"));
        lpexView.doCommand("block clear");
    }

    @Override
    public String getToolTipText(LpexView lpexView) {
        return "Zoom in / out a segment of the document";
    }

    static void zoomIn(LpexView lpexView, int topElement, int bottomElement) {
        ZoomAction.hideExpandHide(lpexView);
        lpexView.doCommand("set mark.@ZoomAction sticky element " + topElement + " " + bottomElement);
        lpexView.doCommand("set markIncluded.@ZoomAction on");
    }

    static void hideExpandHide(LpexView lpexView) {
        if (!lpexView.queryOn("markIncluded.@ZoomAction")) {
            lpexView.doCommand("set userParameter.view.ZoomAction.expandHide " + lpexView.query("current.expandHide"));
            String classes = lpexView.query("includedClasses");
            if (classes != null) {
                lpexView.doCommand("set userParameter.view.ZoomAction.includedClasses " + classes);
            }
            if ((classes = lpexView.query("excludedClasses")) != null) {
                lpexView.doCommand("set userParameter.view.ZoomAction.excludedClasses " + classes);
            }
        }
        lpexView.doCommand("set expandHide off");
        lpexView.doAction(lpexView.actionId("showAll"));
    }

    static void restoreExpandHide(LpexView lpexView) {
        lpexView.doCommand("set expandHide " + lpexView.query("userParameter.view.ZoomAction.expandHide"));
        String classes = lpexView.query("userParameter.view.ZoomAction.includedClasses");
        if (classes != null) {
            lpexView.doCommand("set includedClasses " + classes);
        }
        if ((classes = lpexView.query("userParameter.view.ZoomAction.excludedClasses")) != null) {
            lpexView.doCommand("set excludedClasses " + classes);
        }
    }
}

