/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.samples;

import com.ibm.lpex.core.LpexAction;
import com.ibm.lpex.core.LpexCommand;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.samples.ComposeAction;
import com.ibm.lpex.samples.FindTextContextCommand;
import com.ibm.lpex.samples.MouseReselect;
import com.ibm.lpex.samples.ZoomAction;

public class TestUserProfile {
    private TestUserProfile() {
    }

    public static void userProfile(LpexView lpexView) {
        String baseProfile = lpexView.query("baseProfile");
        if ("vi".equals(baseProfile)) {
            lpexView.doDefaultCommand("set messageText Base profile NOT modified by TestUserProfile.");
            return;
        }
        lpexView.defineAction("myBlockMarkElement", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                view.doCommand("block clear");
                view.doCommand("block set element");
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        lpexView.defineAction("myDeleteLine", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                int displayPosition = view.queryInt("displayPosition");
                if (displayPosition > 0) {
                    view.doAction(view.actionId("deleteLine"));
                    view.doCommand("set displayPosition " + displayPosition);
                }
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        lpexView.defineAction("closeJoin", new CloseJoin());
        lpexView.defineAction("findNextSelection", new FindNextSelection());
        lpexView.defineAction("myPropCompare", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                view.doCommand("compare ignoredStyles \"a\" prompt");
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        lpexView.defineCommand("findText", new FindTextContextCommand());
        lpexView.defineCommand("diff", new LpexCommand(){

            @Override
            public boolean doCommand(LpexView view, String parameters) {
                return view.doCommand("compare " + parameters);
            }
        });
        lpexView.defineCommand("k", new LpexCommand(){

            @Override
            public boolean doCommand(LpexView view, String parameters) {
                return view.doCommand("calc " + parameters);
            }
        });
        lpexView.defineCommand("reload", new LpexCommand(){

            @Override
            public boolean doCommand(LpexView view, String parameters) {
                return view.doCommand("load " + parameters);
            }
        });
        lpexView.defineCommand("pre", new LpexCommand(){

            @Override
            public boolean doCommand(LpexView view, String parameters) {
                return parameters.trim().length() == 0 ? view.doCommand("set messageText prefixArea " + view.query("current.prefixArea")) : view.doCommand("set prefixArea " + parameters);
            }
        });
        boolean isEmacs = "emacs".equals(baseProfile);
        lpexView.doDefaultCommand("set keyAction.backSpace backSpaceInLine");
        lpexView.doDefaultCommand("set keyAction.delete deleteInLine");
        lpexView.doDefaultCommand("set keyAction.enter newLine");
        lpexView.doDefaultCommand("set keyAction.numpadEnter newLine");
        lpexView.doDefaultCommand("set keyAction.home contextHome");
        lpexView.doDefaultCommand("set keyAction.end contextEnd");
        lpexView.defineAction("zoom", new ZoomAction());
        lpexView.doDefaultCommand("set keyAction.a-period zoom");
        lpexView.defineCommand("compose", ComposeAction.composeCommand);
        lpexView.defineAction("compose", ComposeAction.composeAction);
        lpexView.doDefaultCommand("set keyAction.a-f1 compose");
        lpexView.doDefaultCommand("set keyAction.a-j closeJoin");
        lpexView.doDefaultCommand("set actionClass.blockTransfer com.ibm.lpex.samples.BlockTransferAction");
        if (!isEmacs) {
            lpexView.doDefaultCommand("set keyAction.a-t blockTransfer");
        }
        lpexView.doDefaultCommand("set keyAction.c-backSpace.t.p.c myDeleteLine");
        if (!isEmacs) {
            lpexView.doDefaultCommand("set keyAction.c-n.t.p.c findNextSelection");
        }
        lpexView.doDefaultCommand("set keyAction.c-s-v.t pasteOverlay");
        lpexView.doDefaultCommand("set mouseAction.1-pressed.2 myBlockMarkElement");
        lpexView.doDefaultCommand("set block.defaultType character");
        lpexView.doDefaultCommand("set commandClass.detab com.ibm.lpex.samples.DetabCommand");
        lpexView.doDefaultCommand("set commandClass.entab com.ibm.lpex.samples.EntabCommand");
        MouseReselect.install(lpexView);
        StringBuilder sb = new StringBuilder(lpexView.query("current.popup"));
        String transferSubmenu = " \"&Transfer selection\" blockTransfer ";
        int i = sb.indexOf("popup.blockDelete ");
        if (i >= 0) {
            sb.insert(i, transferSubmenu);
        } else {
            sb.append(" separator" + transferSubmenu);
        }
        if ("prop".equals(TestUserProfile.parser(lpexView))) {
            String compareSubmenu = " \"Compare w/o &mnemonics...\" myPropCompare ";
            i = sb.indexOf("popup.sourceMenu");
            if (i >= 0) {
                sb.insert(i + "popup.sourceMenu".length(), compareSubmenu);
            } else {
                sb.append(" separator beginSubmenu popup.sourceMenu" + compareSubmenu + "endSubmenu");
            }
        }
        lpexView.doDefaultCommand("set popup " + sb.toString());
        lpexView.doDefaultCommand("set messageText * TestUserProfile settings in effect.");
    }

    public static String parser(LpexView lpexView) {
        String parserName = null;
        if (lpexView != null && !lpexView.queryOn("current.updateProfile.noParser") && "associated".equals(parserName = lpexView.query("current.updateProfile.parser"))) {
            String extension;
            parserName = null;
            Object baseName = TestUserProfile.baseName(lpexView);
            if (baseName != null) {
                if (((String)baseName).indexOf(46) == -1) {
                    baseName = (String)baseName + ".";
                }
                parserName = lpexView.query("current.updateProfile.parserAssociation." + (String)baseName);
            }
            if ((parserName == null || parserName.length() == 0) && (extension = TestUserProfile.nameExtension(lpexView)) != null) {
                parserName = lpexView.query("current.updateProfile.parserAssociation." + extension);
            }
        }
        return parserName;
    }

    private static String baseName(LpexView lpexView) {
        int i;
        String baseName = lpexView.query("name");
        if (baseName != null && (i = baseName.lastIndexOf(System.getProperty("file.separator"))) >= 0 && i < baseName.length() - 1) {
            baseName = baseName.substring(i + 1);
        }
        return baseName;
    }

    private static String nameExtension(LpexView lpexView) {
        String extension = lpexView.query("name");
        if (extension != null) {
            int i = extension.lastIndexOf(46);
            extension = i >= 0 ? extension.substring(i + 1) : null;
        }
        return extension;
    }

    public static class CloseJoin
    implements LpexAction {
        @Override
        public void doAction(LpexView lpexView) {
            LpexDocumentLocation joinLocation = lpexView.documentLocation();
            if (joinLocation.element > 0) {
                int displayPosition = lpexView.queryInt("displayPosition");
                joinLocation.position = lpexView.queryInt("length") + 1;
                lpexView.doAction(lpexView.actionId("join"));
                lpexView.doCommand(joinLocation, "action oneSpace");
                lpexView.doCommand("set displayPosition " + displayPosition);
            }
        }

        @Override
        public boolean available(LpexView lpexView) {
            return lpexView.currentElement() != 0 && !lpexView.queryOn("readonly");
        }
    }

    public static class FindNextSelection
    implements LpexAction {
        @Override
        public void doAction(LpexView lpexView) {
            if (lpexView.actionAvailable(lpexView.actionId("findSelection"))) {
                String findText = lpexView.query("findText.findText");
                String regex = lpexView.query("findText.regularExpression");
                String defaultFindText = lpexView.query("default.findText.findText");
                String defaultRegex = lpexView.query("default.findText.regularExpression");
                String mark = lpexView.query("findText.mark");
                lpexView.doCommand("set findText.mark on");
                lpexView.doAction(lpexView.actionId("findSelection"));
                lpexView.doCommand("set findText.findText " + findText);
                lpexView.doCommand("set findText.regularExpression " + regex);
                lpexView.doCommand("set default.findText.findText " + defaultFindText);
                lpexView.doCommand("set default.findText.regularExpression " + defaultRegex);
                lpexView.doCommand("set findText.mark " + mark);
            } else {
                lpexView.doAction(lpexView.actionId("findNext"));
            }
        }

        @Override
        public boolean available(LpexView lpexView) {
            return lpexView.actionAvailable(lpexView.actionId("findSelection")) || lpexView.actionAvailable(lpexView.actionId("findNext"));
        }
    }
}

