/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.samples;

import com.ibm.lpex.core.LpexView;

final class PreserveBlock {
    LpexView blockView;
    String blockType;
    String forceAllVisible;
    String cursorRow;
    int blockTopElement;
    int blockTopPosition;
    int blockBottomElement;
    int blockBottomPosition;

    PreserveBlock(LpexView lpexView) {
        this.blockView = lpexView.getBlockView();
        if (this.blockView != null) {
            this.cursorRow = this.blockView.query("cursorRow");
            this.forceAllVisible = this.blockView.query("forceAllVisible");
            this.blockView.doCommand("set forceAllVisible on");
            this.blockType = this.blockView.query("block.type");
            this.blockTopElement = this.blockView.queryInt("block.topElement");
            this.blockBottomElement = this.blockView.queryInt("block.bottomElement");
            this.blockTopPosition = this.blockView.queryInt("block.topPosition");
            this.blockBottomPosition = this.blockView.queryInt("block.bottomPosition");
        }
    }

    void restore() {
        if (this.blockView != null) {
            int currentElement = this.blockView.currentElement();
            int currentPosition = this.blockView.currentPosition();
            if (currentElement == this.blockTopElement && currentPosition == this.blockTopPosition) {
                this.blockView.jump(this.blockBottomElement, this.blockBottomPosition);
                this.blockView.doCommand("block set " + this.blockType);
                this.blockView.jump(this.blockTopElement, this.blockTopPosition);
                this.blockView.doCommand("block set");
            } else {
                this.blockView.jump(this.blockTopElement, this.blockTopPosition);
                this.blockView.doCommand("block set " + this.blockType);
                this.blockView.jump(this.blockBottomElement, this.blockBottomPosition);
                this.blockView.doCommand("block set");
                if (currentElement != this.blockBottomElement || currentPosition != this.blockBottomPosition) {
                    this.blockView.jump(currentElement, currentPosition);
                }
            }
            this.blockView.doCommand("set forceAllVisible " + this.forceAllVisible);
            this.blockView.doCommand("set cursorRow " + this.cursorRow);
            this.blockView = null;
        }
    }
}

