/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.samples;

import com.ibm.lpex.core.LpexCommand;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexViewAdapter;
import com.ibm.lpex.core.LpexWindow;
import java.io.File;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public final class MinLpex {
    private Shell _shell;
    private LpexWindow _lpexWindow;
    private LpexView _lpexView;

    public static void main(String[] args) {
        new MinLpex(args.length == 0 ? null : args[0], new Rectangle(10, 10, 648, 711)).run();
    }

    public MinLpex(String filename, Rectangle bounds) {
        if (filename != null) {
            if (filename.trim().length() == 0) {
                filename = null;
            } else {
                try {
                    filename = new File(filename).getCanonicalPath();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this._lpexView = new LpexView(filename, "", false);
        this._shell = new Shell();
        Object name = this._lpexView.query("name");
        if (name == null) {
            name = "Untitled Document " + this._lpexView.query("documentId");
        }
        this._shell.setText("SWT MinLpex - " + (String)name);
        this._lpexWindow = new LpexWindow((Composite)this._shell);
        this._lpexView.setWindow(this._lpexWindow);
        this._lpexView.addLpexViewListener(new LpexViewAdapter(){

            @Override
            public void updateProfile(LpexView lpexView) {
                MinLpex.this.updateProfile(lpexView);
            }

            @Override
            public void disposed(LpexView lpexView) {
                MinLpex.this._lpexView = null;
            }
        });
        this._lpexView.doDefaultCommand("updateProfile");
        this._shell.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                MinLpex.this.disposeShell(event);
            }
        });
        this._shell.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                MinLpex.this.resizeShell(event);
            }
        });
        this._shell.setBounds(bounds);
        this._shell.open();
    }

    private void run() {
        Display display = this._shell.getDisplay();
        while (!this._shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this._shell = null;
    }

    private void updateProfile(LpexView lpexView) {
        lpexView.defineCommand("e", new LpexCommand(){

            @Override
            public boolean doCommand(LpexView view, String parameters) {
                return MinLpex.this.newWindow(parameters);
            }
        });
        lpexView.defineCommand("quit", new LpexCommand(){

            @Override
            public boolean doCommand(LpexView view, String parameters) {
                view.dispose();
                MinLpex.this._shell.dispose();
                return true;
            }
        });
    }

    private boolean newWindow(final String filename) {
        this._shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Rectangle newBounds = MinLpex.this._shell.getBounds();
                newBounds.x += 20;
                newBounds.y += 20;
                new MinLpex(filename, newBounds).run();
            }
        });
        return true;
    }

    private void disposeShell(Event event) {
        if (this._lpexView != null) {
            this._lpexView.dispose();
        }
    }

    private void resizeShell(Event event) {
        Rectangle rect = this._shell.getClientArea();
        this._lpexWindow.setBounds(0, 0, rect.width, rect.height);
    }
}

