/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.samples;

import com.ibm.lpex.core.LpexCommand;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.samples.FindsCommand;
import java.util.HashSet;

public class MatchesCommand
extends FindsCommand {
    private static final char _matchStyleChar = '`';
    private static final String _matchStyle = "-1 -1 -1 255 255 0";
    private HashSet<String> _marks = new HashSet();
    private int _foundTextLength;
    private LpexCommand _oldFindTextCommand;
    private LpexCommand _findTextCommand = new LpexCommand(){

        @Override
        public boolean doCommand(LpexView lpexView, String parameters) {
            return MatchesCommand.this.doFindTextCommand(lpexView, parameters);
        }
    };

    @Override
    public boolean doCommand(LpexView lpexView, String parameters) {
        if (lpexView == null) {
            return true;
        }
        if ("?".equals(parameters.trim())) {
            lpexView.doCommand("set messageText Syntax: matches [<text>]");
            this.clearMatches(lpexView);
            return true;
        }
        lpexView.doCommand("set styleAttributes.` -1 -1 -1 255 255 0");
        this._oldFindTextCommand = lpexView.defineCommand("findText", this._findTextCommand);
        this.clearMatches(lpexView);
        this.doFinds(lpexView, parameters);
        lpexView.defineCommand("findText", this._oldFindTextCommand);
        return true;
    }

    boolean doFindTextCommand(LpexView lpexView, String parameters) {
        boolean rc = this._oldFindTextCommand != null ? this._oldFindTextCommand.doCommand(lpexView, parameters) : lpexView.doDefaultCommand("findText " + parameters);
        this._foundTextLength = lpexView.queryInt("emphasisLength");
        return rc;
    }

    void clearMatches(LpexView lpexView) {
        if (!this._marks.isEmpty()) {
            for (String markId : this._marks) {
                lpexView.doCommand("set mark.#" + markId + " clear");
            }
            this._marks.clear();
        }
    }

    @Override
    String basicFindTextParms() {
        return "quiet noBeep noWrap ";
    }

    @Override
    void found(LpexView lpexView, LpexDocumentLocation loc) {
        lpexView.doCommand("set mark. " + loc.element + " " + loc.position + " " + loc.element + " " + (loc.position + this._foundTextLength - 1));
        String markId = lpexView.query("markId.");
        lpexView.doCommand("set markHighlight.#" + markId + " on");
        lpexView.doCommand("set markStyle.#" + markId + " `");
        this._marks.add(markId);
    }
}

