/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.samples;

import com.ibm.lpex.core.LpexAction;
import com.ibm.lpex.core.LpexCommand;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexViewAdapter;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.samples.LpexParameters;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public final class Lpex {
    private Shell _shell;
    private boolean _browse;
    private LpexWindow _lpexWindow;
    private LpexView _lpexView;
    LpexViewNode _lpexViewNode;
    private Shell _papaShell;
    private Listener _papaShellListener;
    private static ArrayList<LpexViewNode> _viewChains = new ArrayList();

    public static void main(String[] args) {
        new Lpex(args, null, false, null);
    }

    public Lpex(String[] parms, Rectangle bounds, boolean browse, Shell papaShell) {
        LpexParameters p = new LpexParameters(parms);
        String filename = p.filename();
        if (filename != null) {
            if (filename.trim().length() == 0) {
                filename = null;
            } else {
                try {
                    filename = new File(filename).getCanonicalPath();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this._lpexView = new LpexView(filename, p.encoding(), false);
        this._lpexViewNode = new LpexViewNode(this);
        if (p.documentType() != null) {
            if ("none".equals(p.documentType())) {
                this._lpexView.doCommand("set updateProfile.noParser on");
            } else {
                this._lpexView.doCommand("set updateProfile.parser " + this._lpexView.query("current.updateProfile.parserAssociation." + p.documentType()));
            }
        }
        if (papaShell != null) {
            this._papaShell = papaShell;
            this._papaShellListener = new Listener(){

                public void handleEvent(Event event) {
                    if (event.type == 21) {
                        if (Lpex.this._lpexView.queryInt("changes") == 0 && !Lpex.this._lpexView.queryOn("dirty")) {
                            Lpex.this._lpexView.doCommand("exit");
                        } else if (Lpex.this._shell != null) {
                            Lpex.this._shell.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if ((this).Lpex.this._lpexView != null) {
                                        (this).Lpex.this._lpexView.doCommand("exit");
                                    }
                                }
                            });
                        }
                    } else if (event.type == 12) {
                        Lpex.this._papaShell = null;
                        Lpex.this._papaShellListener = null;
                    }
                }
            };
            this._papaShell.addListener(21, this._papaShellListener);
            this._papaShell.addListener(12, this._papaShellListener);
        }
        this.setUpView(bounds, browse, null);
    }

    public Lpex(LpexView lpexView, Delegate delegate, Rectangle bounds, boolean browse) throws LpexView.ViewInstantiationException {
        this(LpexViewNode.getLpexViewNode(lpexView, delegate), bounds, browse);
    }

    private Lpex(LpexViewNode lpexViewNode, Rectangle bounds, boolean browse) throws LpexView.ViewInstantiationException {
        LpexView lpexView = lpexViewNode.lpexView();
        this._lpexView = new LpexView(lpexView, false);
        this._lpexViewNode = new LpexViewNode(this, lpexViewNode);
        this.setUpView(bounds, browse, lpexView);
    }

    private void setUpView(Rectangle bounds, boolean browse, LpexView fromView) {
        this._browse = browse;
        this._shell = new Shell();
        if (fromView != null) {
            if (fromView.queryOn("updateProfile.noParser")) {
                this._lpexView.doCommand("set updateProfile.noParser on");
            } else {
                this._lpexView.doCommand("set updateProfile.parser " + fromView.query("updateProfile.parser"));
            }
        }
        this._lpexWindow = new LpexWindow((Composite)this._shell);
        this._lpexView.setWindow(this._lpexWindow);
        this._lpexView.addLpexViewListener(new LpexViewAdapter(){

            @Override
            public void renamed(LpexView lpexView) {
                Lpex.this.renamed(lpexView);
            }

            @Override
            public void updateProfile(LpexView lpexView) {
                Lpex.this.updateProfile(lpexView);
            }

            @Override
            public void disposed(LpexView lpexView) {
                Lpex.this._lpexViewNode.remove();
            }
        });
        this._lpexView.doDefaultCommand("updateProfile");
        if (this._lpexView.queryOn("readonly")) {
            if (!this._browse && this.hasUnderlyingFile()) {
                this._lpexView.window().textWindow().addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent e) {
                        if (Lpex.this._lpexView != null && !Lpex.this.isFileReadonly()) {
                            Lpex.this._lpexView.doCommand("set readonly off");
                            Lpex.this._lpexView.doCommand("screenShow view");
                            Lpex.this._lpexView.window().textWindow().removeFocusListener((FocusListener)this);
                        }
                    }

                    public void focusLost(FocusEvent e) {
                    }
                });
            }
        } else if (fromView != null && fromView.queryOn("readonly")) {
            this._lpexView.doCommand("set readonly on");
        }
        this._shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                Lpex.this.closeShell(event);
            }
        });
        this._shell.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                Lpex.this.disposeShell(event);
            }
        });
        this._shell.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Lpex.this.resizeShell(event);
            }
        });
        if (fromView != null) {
            this._lpexView.doCommand("set includedClasses " + fromView.query("includedClasses"));
            this._lpexView.doCommand("set excludedClasses " + fromView.query("excludedClasses"));
            String element = fromView.query("element");
            if (element != null) {
                this._lpexView.doCommand("locate element " + element);
                this._lpexView.doCommand("set cursorRow " + fromView.query("cursorRow"));
                this._lpexView.doCommand("set position " + fromView.query("position"));
            }
        }
        if (bounds == null) {
            int width = this._lpexView.queryInt("userParameter.SwtLpex.width");
            int height = this._lpexView.queryInt("userParameter.SwtLpex.height");
            bounds = new Rectangle(10, 10, width <= 0 ? 674 : width, height <= 0 ? 683 : height);
        }
        this._shell.setBounds(bounds);
        this._shell.open();
        this.setWindowTitle();
        Display display = this._shell.getDisplay();
        while (!this._shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this._shell = null;
    }

    private String documentName() {
        String name = this._lpexView.query("name");
        return name != null ? name : LpexResources.message("untitledDocument", this._lpexView.query("documentId"));
    }

    private boolean hasUnderlyingFile() {
        boolean hasFile = false;
        String name = this._lpexView.query("name");
        if (name != null && name.length() > 0) {
            try {
                hasFile = new File(name).exists();
            }
            catch (SecurityException e) {
                hasFile = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return hasFile;
    }

    private boolean isFileReadonly() {
        boolean readonly = false;
        String name = this._lpexView.query("name");
        if (name != null && name.length() > 0) {
            try {
                File file = new File(name);
                readonly = file.exists() && !file.canWrite();
            }
            catch (SecurityException e) {
                readonly = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return readonly;
    }

    private void renamed(LpexView lpexView) {
        String name = lpexView.query("name");
        if (name != null) {
            try {
                String canonicalPath = new File(name).getCanonicalPath();
                if (canonicalPath != null && !canonicalPath.equals(name)) {
                    lpexView.doDefaultCommand("set name " + canonicalPath);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setWindowTitle();
    }

    private void updateProfile(LpexView lpexView) {
        if (this._browse && !lpexView.queryOn("readonly")) {
            lpexView.doCommand("set readonly on");
        }
        lpexView.defineCommand("Lpex", new LpexCommand(){

            @Override
            public boolean doCommand(LpexView view, String parameters) {
                return Lpex.this.newWindow(parameters, false, false);
            }
        });
        lpexView.defineCommand("e", new LpexCommand(){

            @Override
            public boolean doCommand(LpexView view, String parameters) {
                return view.doCommand("Lpex " + parameters);
            }
        });
        lpexView.defineCommand("quit", new LpexCommand(){

            @Override
            public boolean doCommand(LpexView view, String parameters) {
                Lpex.this.quit();
                return true;
            }
        });
        lpexView.defineCommand("exit", new LpexCommand(){

            @Override
            public boolean doCommand(LpexView view, String parameters) {
                Lpex.this._lpexViewNode.disposeAllLpex();
                return true;
            }
        });
        lpexView.defineCommand("openNewView", new LpexCommand(){

            @Override
            public boolean doCommand(LpexView view, String parameters) {
                if (view != null) {
                    view.doAction(view.actionId("openNewView"));
                }
                return true;
            }
        });
        lpexView.defineAction("close", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                Lpex.this.close();
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        this.assignKey("f3", "close");
        lpexView.defineAction("openNewView", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                Lpex.this.newWindow(Lpex.this, Lpex.this._browse);
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        this.assignKey("c-o", "openNewView");
        lpexView.defineAction("nextView", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                LpexView v = Lpex.this._lpexViewNode.nextLpexView();
                if (v != null && v.window() != null) {
                    v.window().setFocus();
                }
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        this.assignKey("a-s-right", "nextView");
        lpexView.defineAction("prevView", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                LpexView v = Lpex.this._lpexViewNode.prevLpexView();
                if (v != null && v.window() != null) {
                    v.window().setFocus();
                }
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        this.assignKey("a-s-left", "prevView");
        lpexView.defineCommand("view", new LpexCommand(){

            @Override
            public boolean doCommand(LpexView view, String parameters) {
                if ("log".equals(parameters)) {
                    return Lpex.this.newWindow("\"" + LpexView.globalQuery("editorLog") + "\"", true, true);
                }
                if ("profile".equals(parameters)) {
                    LpexView.doGlobalCommand("profile flush");
                    return Lpex.this.newWindow("\"" + LpexView.globalQuery("defaultProfile") + "\"", true, true);
                }
                return view != null ? view.doCommand("set messageText Syntax: view { log | profile }") : true;
            }
        });
        lpexView.defineCommand("test", new LpexCommand(){

            @Override
            public boolean doCommand(LpexView view, String parameters) {
                return view != null ? view.doCommand("set messageText test: " + parameters) : true;
            }
        });
        lpexView.defineAction("test", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                view.doCommand("set messageText test action");
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        Delegate delegate = this._lpexViewNode.findDelegate();
        if (delegate != null) {
            delegate.delegate(lpexView);
        }
    }

    private void assignKey(String key, String actionName) {
        if (!this._lpexView.keyAssigned(key + ".t")) {
            this._lpexView.doCommand("set keyAction." + key + ".t " + actionName);
        }
        if (!this._lpexView.keyAssigned(key + ".p")) {
            this._lpexView.doCommand("set keyAction." + key + ".p " + actionName);
        }
        if (!this._lpexView.keyAssigned(key + ".c")) {
            this._lpexView.doCommand("set keyAction." + key + ".c " + actionName);
        }
    }

    private void quit() {
        this._lpexView.dispose();
        this._shell.dispose();
    }

    private void close() {
        this._shell.close();
    }

    void setWindowTitle() {
        String title = "SWT Lpex - " + this.documentName();
        if (this._lpexView.queryInt("documentViews") > 1) {
            title = title + ": " + this._lpexView.query("viewId");
        }
        this._shell.setText(title);
    }

    private boolean newWindow(String parameters, final boolean browse, boolean refresh) {
        LpexView lpexView;
        final String[] parms = LpexStringTokenizer.split(parameters);
        String filename = new LpexParameters(parms).filename();
        if (filename != null && (lpexView = this._lpexView.lpexView(filename)) != null && lpexView.window() != null) {
            if (refresh) {
                lpexView.doAction(lpexView.actionId("reload"));
            }
            if (browse) {
                lpexView.doCommand("set readonly on");
            }
            lpexView.window().setFocus();
            lpexView.doAction(lpexView.actionId("textWindow"));
            return true;
        }
        this._shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                new Lpex(parms, Lpex.this.newWindowBounds(), browse, null);
            }
        });
        return true;
    }

    private boolean newWindow(final Lpex lpex, final boolean browse) {
        this._shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    new Lpex(lpex._lpexViewNode, Lpex.this.newWindowBounds(), browse);
                }
                catch (LpexView.ViewInstantiationException viewInstantiationException) {
                    // empty catch block
                }
            }
        });
        return true;
    }

    private Rectangle newWindowBounds() {
        if (this._shell.getMaximized()) {
            return new Rectangle(5, 5, this._lpexView.queryInt("userParameter.SwtLpex.width"), this._lpexView.queryInt("userParameter.SwtLpex.height"));
        }
        Rectangle newBounds = this._shell.getBounds();
        Rectangle shellTrim = this._shell.computeTrim(0, 0, 0, 0);
        newBounds.x -= shellTrim.x - 3;
        newBounds.y -= shellTrim.y + 2;
        Rectangle displayBounds = this._shell.getDisplay().getBounds();
        if (newBounds.y + newBounds.height > displayBounds.height) {
            newBounds.y = 5;
        }
        return newBounds;
    }

    private void disposeShell(Event event) {
        if (this._papaShellListener != null) {
            this._papaShell.removeListener(21, this._papaShellListener);
            this._papaShell.removeListener(12, this._papaShellListener);
            this._papaShellListener = null;
        }
        if (this._lpexView != null) {
            this._lpexView.dispose();
        }
    }

    private void resizeShell(Event event) {
        Rectangle rect = this._shell.getClientArea();
        this._lpexWindow.setBounds(0, 0, rect.width, rect.height);
        rect = this._shell.getBounds();
        if (!this._shell.getMaximized()) {
            this._lpexView.doCommand("set userParameter.SwtLpex.width " + rect.width);
            this._lpexView.doCommand("set userParameter.SwtLpex.height " + rect.height);
        }
    }

    private void closeShell(Event event) {
        event.doit = this.closeWindow();
    }

    private boolean closeWindow() {
        boolean close = true;
        if (this._lpexView != null && this._lpexView.queryInt("documentViews") == 1 && (this._lpexView.queryInt("changes") != 0 || this._lpexView.queryOn("dirty"))) {
            MessageBox box = new MessageBox(this._shell, 452);
            box.setText(this._shell.getText());
            box.setMessage(LpexResources.message("file.saveChanges", this.documentName()));
            int rc = box.open();
            if (rc == 64) {
                this._lpexView.doCommand("save");
                if (this._lpexView.query("status") != null) {
                    close = false;
                }
            } else if (rc == 256) {
                close = false;
            }
        }
        return close;
    }

    public static interface Delegate {
        public void delegate(LpexView var1);
    }

    static final class LpexViewNode {
        private LpexViewNode _prev;
        private LpexViewNode _next;
        private LpexView _lpexView;
        private Lpex _lpex;
        private Delegate _delegate;

        LpexViewNode(Lpex lpex) {
            this._lpex = lpex;
            this._lpexView = lpex._lpexView;
            _viewChains.add(this);
        }

        LpexViewNode(Lpex newLpex, LpexViewNode oldNode) {
            this._lpex = newLpex;
            this._lpexView = newLpex._lpexView;
            this._prev = oldNode;
            this._next = oldNode._next;
            if (oldNode._next != null) {
                oldNode._next._prev = this;
            }
            oldNode._next = this;
        }

        private LpexViewNode(LpexView lpexView, Delegate delegate) {
            this._lpexView = lpexView;
            this._delegate = delegate;
            _viewChains.add(this);
            this._lpexView.addLpexViewListener(new LpexViewAdapter(){

                @Override
                public void disposed(LpexView view) {
                    this.disposeAllLpex();
                    this.remove();
                }
            });
        }

        static LpexViewNode getLpexViewNode(LpexView lpexView, Delegate delegate) {
            int i = 0;
            while (i < _viewChains.size()) {
                LpexViewNode lpexViewNode = _viewChains.get(i);
                if (lpexViewNode._lpexView == lpexView) {
                    return lpexViewNode;
                }
                ++i;
            }
            return new LpexViewNode(lpexView, delegate);
        }

        void disposeAllLpex() {
            LpexViewNode node = this;
            while (node != null && node._lpex != null && node._prev != null) {
                node = node._prev;
            }
            while (node._next != null) {
                node._next._lpex.quit();
            }
            while (node._prev != null) {
                node._prev._lpex.quit();
            }
            if (node._lpex != null) {
                node._lpex.close();
            }
        }

        void remove() {
            int i;
            if (this._prev != null) {
                this._prev._next = this._next;
            }
            if (this._next != null) {
                this._next._prev = this._prev;
            }
            if (this._lpex != null) {
                this._lpex._lpexView = null;
                this._lpex._lpexViewNode = null;
            }
            if ((i = _viewChains.indexOf(this)) >= 0) {
                _viewChains.remove(i);
            }
        }

        LpexView lpexView() {
            return this._lpexView;
        }

        LpexView nextLpexView() {
            LpexViewNode node = this._next;
            if (node == null) {
                node = this._prev;
                while (node != null && node._prev != null) {
                    node = node._prev;
                }
            }
            return node != null ? node._lpexView : null;
        }

        LpexView prevLpexView() {
            LpexViewNode node = this._prev;
            if (node == null) {
                node = this._next;
                while (node != null && node._next != null) {
                    node = node._next;
                }
            }
            return node != null ? node._lpexView : null;
        }

        Delegate findDelegate() {
            LpexViewNode node = this._prev;
            while (node != null) {
                if (node._lpex == null) {
                    return node._delegate;
                }
                node = node._prev;
            }
            return null;
        }
    }
}

