/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.samples;

import com.ibm.lpex.core.LpexCommand;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexView;

public class LongestCommand
implements LpexCommand {
    @Override
    public boolean doCommand(LpexView lpexView, String parameters) {
        if (lpexView != null) {
            if ("?".equals(parameters = parameters.trim())) {
                lpexView.doCommand("set messageText Syntax: longest [next]");
                return true;
            }
            int longestElement = "next".equals(parameters) ? lpexView.currentElement() : 1;
            int longestLength = 0;
            int elements = lpexView.elements();
            LpexDocumentLocation loc = new LpexDocumentLocation(longestElement, 1);
            while (loc.element < elements) {
                int len;
                if (!lpexView.show(loc.element) && lpexView.queryOn("visible", loc) && (len = this.elementLength(lpexView, loc.element)) > longestLength) {
                    longestLength = len;
                    longestElement = loc.element;
                }
                ++loc.element;
            }
            if (longestElement != lpexView.currentElement()) {
                int elementOfRow1 = lpexView.elementOfRow(1);
                lpexView.jump(longestElement, 1);
                lpexView.doCommand("screenShow view");
                if (elementOfRow1 != lpexView.elementOfRow(1)) {
                    lpexView.doCommand("set cursorRow " + lpexView.queryInt("rows") / 2);
                }
            }
            lpexView.doCommand("set emphasisPosition 1");
            lpexView.doCommand("set emphasisLength " + longestLength);
        }
        return true;
    }

    int elementLength(LpexView lpexView, int element) {
        String text = lpexView.elementText(element);
        if (text == null) {
            return 0;
        }
        int len = text.length();
        while (len > 0 && (text.charAt(len - 1) == ' ' || text.charAt(len - 1) == '\t')) {
            --len;
        }
        return len;
    }
}

