/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.samples;

import com.ibm.lpex.core.LpexCommand;
import com.ibm.lpex.core.LpexNls;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.samples.TestCommand;

public class DetabCommand
implements LpexCommand {
    @Override
    public boolean doCommand(LpexView lpexView, String parameters) {
        if ("?".equals(parameters = parameters.trim())) {
            if (lpexView != null) {
                lpexView.doCommand("set messageText Syntax: detab [<tab stop> .. [every <increment>]]");
            }
            return true;
        }
        if (lpexView == null) {
            return DetabCommand.validSettings(parameters);
        }
        Settings currentSettings = new Settings();
        if (!DetabCommand.initSettings(lpexView, parameters, currentSettings, TestCommand.commandName(this, lpexView))) {
            return false;
        }
        boolean changes = this.expandTabs(lpexView, currentSettings);
        DetabCommand.message(lpexView, changes ? "Tabs in document expanded." : "No tabs found in document.");
        return true;
    }

    boolean expandTabs(LpexView lpexView, Settings currentSettings) {
        int originalElement = lpexView.currentElement();
        int originalPosition = lpexView.queryInt("displayPosition");
        boolean changes = false;
        int elements = lpexView.elements();
        int element = 1;
        while (element <= elements) {
            if (!lpexView.show(element) && this.expandTabs(element, currentSettings)) {
                changes = true;
            }
            ++element;
        }
        if (changes && (lpexView.currentElement() != originalElement || lpexView.queryInt("displayPosition") != originalPosition)) {
            lpexView.jump(originalElement, originalPosition);
        }
        return changes;
    }

    boolean expandTabs(int element, Settings currentSettings) {
        LpexView lpexView = currentSettings._lpexView;
        String text = lpexView.elementText(element);
        if (text.indexOf(9) < 0) {
            return false;
        }
        StringBuilder buffer = new StringBuilder(text.length() + 32);
        int tc = 0;
        int lastTabVal = 0;
        int i = 0;
        int pos = 1;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '\t') {
                while (tc < currentSettings._tabStops.length && lastTabVal <= pos) {
                    lastTabVal = currentSettings._tabStops[tc++];
                }
                while (lastTabVal <= pos) {
                    lastTabVal += currentSettings._tabIncrement;
                }
                int tabLen = lastTabVal - pos;
                int j = 0;
                while (j < tabLen) {
                    buffer.append(' ');
                    ++j;
                }
                pos = lastTabVal;
            } else {
                buffer.append(c);
                pos += this.getSourceWidth(lpexView, c);
            }
            ++i;
        }
        lpexView.setElementText(element, buffer.toString());
        return true;
    }

    int getSourceWidth(LpexView lpexView, char c) {
        if (LpexNls.isBidiMark(c)) {
            return 0;
        }
        if (c >= '\ud800' && c <= '\udbff' || c >= '\udc00' && c <= '\udfff') {
            return 1;
        }
        int len = 1;
        if (lpexView.nls().isSourceMbcs() && (len = lpexView.nls().sourceLength(c)) > 2) {
            return 2;
        }
        return len;
    }

    static boolean validSettings(String tabs) {
        return tabs != null && tabs.length() != 0 ? DetabCommand.initSettings(null, tabs, null, null) : true;
    }

    static boolean initSettings(LpexView lpexView, String tabs, Settings settings, String command) {
        int tabIncrement = 1;
        int lastTabStop = 0;
        int count = 1;
        if (tabs == null || tabs.length() == 0) {
            tabs = lpexView.query("current.tabs");
        }
        LpexStringTokenizer st = new LpexStringTokenizer(tabs);
        String token = null;
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            try {
                int tabStop = Integer.parseInt(token);
                if (tabStop <= lastTabStop) {
                    return DetabCommand.incorrectParameter(lpexView, token, command);
                }
                if (tabStop != 1) {
                    ++count;
                }
                lastTabStop = tabStop;
                token = null;
            }
            catch (NumberFormatException e) {
                break;
            }
        }
        if (token != null) {
            if (!token.equals("every")) {
                return DetabCommand.incorrectParameter(lpexView, token, command);
            }
            if (!st.hasMoreTokens()) {
                return DetabCommand.missingParameter(lpexView, command);
            }
            token = st.nextToken();
            try {
                tabIncrement = Integer.parseInt(token);
                if (tabIncrement < 1) {
                    return DetabCommand.incorrectParameter(lpexView, token, command);
                }
            }
            catch (NumberFormatException e) {
                return DetabCommand.incorrectParameter(lpexView, token, command);
            }
            if (st.hasMoreTokens()) {
                return DetabCommand.incorrectParameter(lpexView, st.nextToken(), command);
            }
        }
        int[] tabStops = new int[count];
        tabStops[0] = 1;
        int i = 1;
        st = new LpexStringTokenizer(tabs);
        try {
            while (st.hasMoreTokens() && i < count) {
                int tabStop = Integer.parseInt(st.nextToken());
                if (tabStop == 1) continue;
                tabStops[i] = tabStop;
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (settings != null) {
            settings._tabStops = tabStops;
            settings._tabIncrement = tabIncrement;
            settings._lpexView = lpexView;
        }
        return true;
    }

    static boolean incorrectParameter(LpexView lpexView, String parm, String command) {
        DetabCommand.message(lpexView, "\"" + parm + "\" is not a correct parameter for the \"" + command + "\" command.");
        return false;
    }

    static boolean missingParameter(LpexView lpexView, String command) {
        DetabCommand.message(lpexView, "Additional parameters are required for the \"" + command + "\" command.");
        return false;
    }

    static void message(LpexView lpexView, String message) {
        if (lpexView != null) {
            lpexView.doCommand("set messageText " + message);
        }
    }

    static class Settings {
        int[] _tabStops;
        int _tabIncrement;
        LpexView _lpexView;

        Settings() {
        }
    }
}

