/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.Block;
import com.ibm.lpex.core.BlockCommand;
import com.ibm.lpex.core.DocumentPosition;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ElementIterator;
import com.ibm.lpex.core.View;

final class WordActions {
    WordActions() {
    }

    static boolean nextWord(View view, Element element, int position) {
        if (element != null) {
            Element newElement = element;
            int newPosition = position;
            if (newElement.show() && (newElement = newElement.nextVisibleNonShow(view)) != null) {
                newPosition = 0;
            }
            while (newElement != null) {
                if ((newPosition = WordActions.nextWordPosition(view, newElement, newPosition)) != 0) {
                    view.documentPosition().jump(newElement, newPosition);
                    return true;
                }
                newElement = newElement.nextVisibleNonShow(view);
                newPosition = 0;
            }
        }
        return false;
    }

    static boolean nextWordEnd(View view, Element element, int position, int offset) {
        if (element != null) {
            Element newElement = element;
            int newPosition = position - offset;
            if (newElement.show() && (newElement = newElement.nextVisibleNonShow(view)) != null) {
                newPosition = -1;
            }
            while (newElement != null) {
                if ((newPosition = WordActions.nextWordEndPosition(view, newElement, newPosition)) >= 0) {
                    if ((newPosition += offset) == 0) {
                        newPosition = 1;
                    }
                    view.documentPosition().jump(newElement, newPosition);
                    return true;
                }
                newElement = newElement.nextVisibleNonShow(view);
                newPosition = -1;
            }
        }
        return false;
    }

    static boolean prevWord(View view, Element element, int position) {
        if (element != null) {
            Element newElement = element;
            int newPosition = position;
            if (newElement.show() && (newElement = newElement.prevVisibleNonShow(view)) != null) {
                newPosition = newElement.end() + 1;
            }
            while (newElement != null) {
                if ((newPosition = WordActions.prevWordPosition(view, newElement, newPosition)) != 0) {
                    view.documentPosition().jump(newElement, newPosition);
                    return true;
                }
                if ((newElement = newElement.prevVisibleNonShow(view)) == null) continue;
                newPosition = newElement.end() + 1;
            }
        }
        return false;
    }

    static boolean prevWordEnd(View view, Element element, int position, int offset) {
        if (element != null) {
            Element newElement = element;
            int newPosition = position - offset;
            if (newElement.show() && (newElement = newElement.prevVisibleNonShow(view)) != null) {
                newPosition = newElement.end() + 1;
            }
            while (newElement != null) {
                if ((newPosition = WordActions.prevWordEndPosition(view, newElement, newPosition)) >= 0) {
                    if ((newPosition += offset) == 0) {
                        newPosition = 1;
                    }
                    view.documentPosition().jump(newElement, newPosition);
                    return true;
                }
                if ((newElement = newElement.prevVisibleNonShow(view)) == null) continue;
                newPosition = newElement.end() + 1;
            }
        }
        return false;
    }

    static void doBlockMarkWordAction(View view, int count, boolean next) {
        DocumentPosition documentPosition = view.documentPosition();
        Element element = documentPosition.element();
        if (element == null) {
            return;
        }
        Block block = view.block();
        if (block.type() == 4 || block.view() != view) {
            block.clear();
        }
        if (block.type() == 0 && BlockCommand.DefaultTypeParameter.getParameter().currentValue(view) == 4) {
            block.set(1, view);
        } else {
            block.set(view);
        }
        int i = 0;
        while (i < count) {
            element = documentPosition.element();
            int position = documentPosition.position();
            Element anchorElement = block.anchorElement();
            int anchorPosition = block.anchorPosition();
            if (next) {
                boolean belowAnchor = block.anchorAtTop();
                if (anchorElement == element && anchorPosition == position) {
                    belowAnchor = true;
                }
                if (belowAnchor) {
                    if (block.type() == 1) {
                        WordActions.nextWordEnd(view, element, position, 1);
                    } else {
                        WordActions.nextWordEnd(view, element, position, 0);
                    }
                    block.set(view);
                } else {
                    WordActions.nextWord(view, element, position);
                    if (block.anchorAtTop() || anchorElement == documentPosition.element() && anchorPosition == documentPosition.position()) {
                        documentPosition.jump(anchorElement, anchorPosition);
                        block.set(view);
                    }
                    block.set(view);
                }
            } else {
                boolean aboveAnchor;
                boolean bl = aboveAnchor = !block.anchorAtTop();
                if (anchorElement == element && anchorPosition == position) {
                    aboveAnchor = true;
                }
                if (aboveAnchor) {
                    WordActions.prevWord(view, element, position);
                    block.set(view);
                } else {
                    if (block.type() == 1) {
                        WordActions.prevWordEnd(view, element, position, 1);
                    } else {
                        WordActions.prevWordEnd(view, element, position, 0);
                    }
                    block.set(view);
                    if (!block.anchorAtTop() || element == documentPosition.element() && position == documentPosition.position()) {
                        documentPosition.jump(anchorElement, anchorPosition);
                        block.set(view);
                    }
                }
            }
            ++i;
        }
    }

    static int nextWordPosition(View view, Element element, int position) {
        ElementIterator ei = new ElementIterator(view, element, view.wordIterOptions());
        position = ei.nextWord(position);
        ei.dispose();
        return position;
    }

    static int nextWordEndPosition(View view, Element element, int position) {
        ElementIterator ei = new ElementIterator(view, element, view.wordIterOptions());
        position = ei.nextWordEnd(position);
        ei.dispose();
        return position;
    }

    static int prevWordPosition(View view, Element element, int position) {
        ElementIterator ei = new ElementIterator(view, element, view.wordIterOptions());
        position = ei.prevWord(position);
        ei.dispose();
        return position;
    }

    static int prevWordEndPosition(View view, Element element, int position) {
        ElementIterator ei = new ElementIterator(view, element, view.wordIterOptions());
        position = ei.prevWordEnd(position);
        ei.dispose();
        return position;
    }
}

