/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.LpexAction;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.core.Screen;
import com.ibm.lpex.core.VisualField;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

final class VisualElement
implements FocusListener {
    private LpexWindow _lpexWindow;
    private Shell _shell;
    VisualField _visualField;

    VisualElement(LpexWindow lpexWindow) {
        this._lpexWindow = lpexWindow;
        this._lpexWindow.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                VisualElement.this.hide();
                VisualElement.this._lpexWindow = null;
            }
        });
    }

    LpexView getMainDocLpexView() {
        return this._lpexWindow.getLpexView();
    }

    private void createVisualElement() {
        if (LpexUtilities.okToUse((Widget)this._shell)) {
            return;
        }
        this._shell = new Shell(16396);
        this._visualField = new VisualField((Composite)this._shell, 2);
        this._visualField.getLpexWindow().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                VisualElement.this._visualField.dispose();
                VisualElement.this._visualField = null;
            }
        });
        this._visualField.getLpexWindow().textWindow().addFocusListener((FocusListener)this);
        LpexView lpexView = this._visualField.getLpexView();
        lpexView.defineAction("enter", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                VisualElement.this.handleOk();
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        lpexView.defineAction("esc", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                VisualElement.this.handleEsc();
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        lpexView.doCommand("set keyAction.up up");
        lpexView.defineAction("up", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                VisualElement.this.handleScrolling(206);
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        lpexView.doCommand("set keyAction.down down");
        lpexView.defineAction("down", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                VisualElement.this.handleScrolling(94);
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        lpexView.doCommand("set keyAction.pageUp pageUp");
        lpexView.defineAction("pageUp", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                VisualElement.this.handleScrolling(152);
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        lpexView.doCommand("set keyAction.pageDown pageDown");
        lpexView.defineAction("pageDown", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                VisualElement.this.handleScrolling(149);
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
    }

    void display() {
        this.createVisualElement();
        Point size = new Point(this.getMainDocLpexView()._view.screen().textAreaWidth(), this._visualField.getLpexWindow().computeSize((int)-1, (int)-1, (boolean)true).y);
        size.x -= this._visualField.getLpexWindow().computeTrim((int)0, (int)0, (int)0, (int)0).x;
        this._shell.setSize(size);
        this._visualField.getLpexWindow().setSize(this._shell.getSize());
        this._visualField.getLpexWindow().setLocation(0, 0);
        this._visualField.initializeField(this.getMainDocLpexView());
        this._shell.setLocation(this.getLocation());
        this._shell.setVisible(true);
        this._visualField.getLpexWindow().setFocus();
    }

    private boolean newElement() {
        if (this.getMainDocLpexView()._view.documentPosition().element() == null) {
            return false;
        }
        if (this._shell != null) {
            this.hide();
        }
        this.display();
        return true;
    }

    private void hide() {
        if (LpexUtilities.okToUse((Widget)this._shell)) {
            if (LpexUtilities.okToUse((Widget)this._visualField.getLpexWindow().textWindow())) {
                this._visualField.getLpexWindow().textWindow().removeFocusListener((FocusListener)this);
            }
            this._shell.setVisible(false);
            this._shell.dispose();
            this._shell = null;
        }
    }

    private Point getLocation() {
        Screen screen = this.getMainDocLpexView()._view.screen();
        Point p = new Point(screen.expandHideAreaWidth() + screen.prefixAreaWidth(), (screen.cursorRow() - 1) * screen.textFontMetrics().textHeight());
        p = this._lpexWindow.textWindow().toDisplay(p);
        Rectangle trim = this._visualField.getLpexWindow().computeTrim(0, 0, 0, 0);
        p.x += trim.x;
        p.y += trim.y;
        return p;
    }

    void handleScrolling(int actionId) {
        this._visualField.commit();
        this.getMainDocLpexView()._view.actionHandler().triggerAction(actionId);
        if (!this.newElement()) {
            this.hide();
        }
    }

    void handleOk() {
        this._visualField.commit();
        this.hide();
    }

    void handleEsc() {
        this._visualField.abandon();
        this.hide();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.handleOk();
    }
}

