/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandLine;
import com.ibm.lpex.core.LpexAction;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.VisualField;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

final class VisualEditLine
extends Composite {
    CommandLine _commandLine;
    VisualField _visualField;
    private boolean _visible;
    private String _highlightCurrentLine;

    VisualEditLine(CommandLine commandLine) {
        super((Composite)commandLine, 0);
        this._commandLine = commandLine;
        this._visualField = new VisualField(this, 1);
        this._visualField.getLpexWindow().setData("ID", "editLine_visual");
        LpexUtilities.setHelp((Control)this._visualField.getLpexWindow().textWindow(), "com.ibm.lpex.editLine_visual");
        this._visualField.getLpexWindow().textWindow().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                e.widget = VisualEditLine.this._visualField.getLpexWindow();
                VisualEditLine.this._commandLine.focusGained(e);
            }

            public void focusLost(FocusEvent e) {
                e.widget = VisualEditLine.this._visualField.getLpexWindow();
                VisualEditLine.this._commandLine.focusLost(e);
            }
        });
        LpexView lpexView = this._visualField.getLpexView();
        lpexView.defineAction("enter", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                VisualEditLine.this.handleOk();
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        lpexView.defineAction("esc", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                VisualEditLine.this.handleEsc();
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        this.setLayout(new EditLineLayout());
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                VisualEditLine.this._visualField.dispose();
            }
        });
    }

    LpexView getMainDocLpexView() {
        return this._commandLine._lpexWindow.getLpexView();
    }

    void setEditLine() {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        LpexView mainLpexView = this.getMainDocLpexView();
        if (visible) {
            if (!this._visible) {
                mainLpexView._view.parsePendingList().parse();
                this._highlightCurrentLine = mainLpexView.query("highlightCurrentLine");
                mainLpexView.doCommand("set highlightCurrentLine on");
                this._visualField.initializeField(mainLpexView);
            }
        } else if (this._visible && mainLpexView != null) {
            mainLpexView.doCommand("set highlightCurrentLine " + this._highlightCurrentLine);
        }
        this._visible = visible;
    }

    void handleOk() {
        this._visualField.commit();
        this._commandLine._lpexWindow.textWindowRequestFocus();
    }

    void handleEsc() {
        this._commandLine._lpexWindow.textWindowRequestFocus();
    }

    final class EditLineLayout
    extends Layout {
        EditLineLayout() {
        }

        protected Point computeSize(Composite parent, int wHint, int hHint, boolean flushCache) {
            return new Point(1000, VisualEditLine.this._visualField.getLpexWindow().computeSize((int)-1, (int)-1, (boolean)flushCache).y);
        }

        protected void layout(Composite parent, boolean flushCache) {
            VisualEditLine.this._visualField.getLpexWindow().setBounds(0, 0, parent.getClientArea().width, VisualEditLine.this._visualField.getLpexWindow().computeSize((int)-1, (int)-1, (boolean)flushCache).y);
        }
    }
}

