/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.alef.preferences.HostCharacterMapping;
import com.ibm.lpex.alef.preferences.HostCharacterUtil;
import com.ibm.lpex.alef.preferences.WhitespaceCharacterMapping;
import com.ibm.lpex.alef.preferences.WhitespaceCharacterUtil;
import com.ibm.lpex.core.ActionHandler;
import com.ibm.lpex.core.BeepParameter;
import com.ibm.lpex.core.Block;
import com.ibm.lpex.core.BlockCommand;
import com.ibm.lpex.core.ClassLoaderList;
import com.ibm.lpex.core.Classes;
import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.CompareCommand;
import com.ibm.lpex.core.CursorListenerList;
import com.ibm.lpex.core.CursorParameters;
import com.ibm.lpex.core.DisplayTextLayout;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.DocumentPosition;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ElementList;
import com.ibm.lpex.core.ElementView;
import com.ibm.lpex.core.ExpandTabsParameter;
import com.ibm.lpex.core.FindTextCommand;
import com.ibm.lpex.core.FindTextOptions;
import com.ibm.lpex.core.HostCharMappingParameter;
import com.ibm.lpex.core.HtmlWriter;
import com.ibm.lpex.core.KillRing;
import com.ibm.lpex.core.LineNumbersParameters;
import com.ibm.lpex.core.LogMessagesParameter;
import com.ibm.lpex.core.LpexDocumentListener;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexFieldsProvider;
import com.ibm.lpex.core.LpexLog;
import com.ibm.lpex.core.LpexNls;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.core.MarkList;
import com.ibm.lpex.core.ParseAfterEveryKeyParameter;
import com.ibm.lpex.core.ParsePending;
import com.ibm.lpex.core.ParsePendingList;
import com.ibm.lpex.core.PrefixAreaParameter;
import com.ibm.lpex.core.PrefixAreaTextParameter;
import com.ibm.lpex.core.PrintCommand;
import com.ibm.lpex.core.SaveCommand;
import com.ibm.lpex.core.Screen;
import com.ibm.lpex.core.SequenceNumbersFormatParameter;
import com.ibm.lpex.core.ShiftInCharacterParameter;
import com.ibm.lpex.core.ShiftOutCharacterParameter;
import com.ibm.lpex.core.ShowHostCharParameter;
import com.ibm.lpex.core.ShowSosiParameter;
import com.ibm.lpex.core.ShowWhitespaceCharParameter;
import com.ibm.lpex.core.SourceCcsidParameter;
import com.ibm.lpex.core.StyleAttributesList;
import com.ibm.lpex.core.TabsParameter;
import com.ibm.lpex.core.TextFontMetrics;
import com.ibm.lpex.core.TextWindow;
import com.ibm.lpex.core.UpdateProfileCommand;
import com.ibm.lpex.core.ViHandler;
import com.ibm.lpex.core.ViewListenerList;
import com.ibm.lpex.core.WhitespaceCharMappingParameter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class View {
    View _next = null;
    static final int INSERT_TEXT_NONE = 0;
    static final int INSERT_TEXT_NONE_FIELDS = 1;
    static final int INSERT_TEXT_OK = 2;
    static final int INSERT_TEXT_TRUNCATE_FIELDS = 4;
    static final int INSERT_TEXT_OVERFLOW = 8;
    static final int PREFIX_AREA_TEXT_NULL = 0;
    static final int PREFIX_AREA_TEXT_LINENUMBERS = 1;
    static final int PREFIX_AREA_TEXT_SEQUENCENUMBERS = 2;
    static final int PREFIX_AREA_TEXT_NONE = 3;
    private Document _document;
    private LpexView _lpexView;
    private LpexWindow _lpexWindow;
    private DocumentPosition _documentPosition;
    private StyleAttributesList _styleAttributesList;
    private LpexNls _nls;
    private Screen _screen;
    private ActionHandler _actionHandler;
    private CommandHandler _commandHandler;
    private ParsePendingList _parsePendingList;
    private ViewListenerList _viewListenerList;
    private CursorListenerList _cursorListenerList;
    private String _baseProfile;
    private String _popup;
    private Block _block;
    private int _showSosiParm = 2;
    private int _showWhitespaceCharParm = 2;
    private Hashtable<Character, Character> _whitespaceCharMapping;
    private int _splitWindowParm = 2;
    private int _parseAfterEveryKeyParm = 2;
    int _prefixAreaTextParm = 0;
    private int _logMessagesParm = 2;
    private boolean _logMessages;
    private int _expandTabsParm = 2;
    private boolean _expandTabs;
    private TabsParameter.Settings _tabsParm;
    private TabsParameter.Settings _currentTabs;
    String _sequenceNumbersFormatParm;
    private String _sequenceNumbersFormat;
    private String _sequenceNumbersFormatStyle;
    int _prefixAreaMargin;
    boolean _useDefaultPrefixAreaMargin = true;
    int _cursorBlinkTimeParm;
    boolean _useDefaultCursorBlinkTime = true;
    int _cursorWidthParm;
    boolean _useDefaultCursorWidth = true;
    private int _cursorWidth;
    int _lineNumbersLengthParm;
    boolean _useDefaultLineNumbersLength = true;
    private int _lineNumbersLength;
    char _lineNumbersPadParm;
    private char _lineNumbersPad;
    private int _enforceTextLimitParm = 2;
    private boolean _enforceTextLimit;
    private int _boundsStartColumn;
    private int _boundsEndColumn;
    boolean _realColumnNumbers;
    boolean _traceKeys;
    String _keyTrace;
    boolean _traceMouseEvents;
    String _mouseTrace;
    private int _findTextIncremental = 2;
    private int _visualEditLineDialog = 2;
    private Classes _classes;
    private boolean _updateProfileIssued;
    private boolean _autoCheck = true;
    private ViHandler _viHandler;
    private boolean _vi;
    private boolean _maxElementWidthValid;
    private int _maxElementWidth;
    private boolean _maxPrefixAreaWidthValid;
    private int _maxPrefixAreaWidth;
    private boolean _topExpanded;
    private boolean _hiddenElements;
    private boolean _visibleElementOrdinalsValid;
    private Element _lastVisibleCharCountElementRequested;
    private int _lastVisibleCharCount;
    private boolean _insertMode = true;
    private boolean _scrollWhileAdjusting = true;
    private boolean _inPrefix;
    private boolean _prefixProtect;
    private Element _userActionElement;
    private long _includedClasses = -1L;
    private long _excludedClasses = 0L;
    private MarkList _markList;
    private boolean _readonly;
    private int _ignoreFieldsCount;
    private boolean _forceAllVisible;
    private Writer _saveWriter;
    private DocumentPosition.Preserve _findPositionPreserve;
    private BlockCommand.Settings _blockCommandSettings;
    private FindTextCommand.Settings _findTextCommandSettings;
    private PrintCommand.Settings _printCommandSettings;
    private UpdateProfileCommand.Settings _updateProfileCommandSettings;
    private CompareCommand.Settings _compareCommandSettings;
    private String _lastComparedTo;
    private String _lastComparedToEncoding;
    private String _lastComparedToSequenceNumbers;
    private boolean _compareSession;
    private int _documentSectionThreshold;
    private boolean _updateProfileInProgress;
    private FindTextOptions _findTextOptions;
    private int[] _fields = null;
    private LpexFieldsProvider _lpexFieldsProvider;
    private int[] _currentFields = null;
    private boolean _replaceText;
    private int _wordIterOptions;
    static final int NAV_DEFWORDCHAR = 1;
    static final int NAV_WHITESPACE = 2;
    static final int NAV_FIELDSTART = 4;
    static final int NAV_STYLECHANGE = 8;
    static final int NAV_CASECHANGE = 16;
    static final int NAV_NONWORDCHAR = 32;
    private HashMap<String, String> _parserProperties = new HashMap(10);
    private HashMap<String, String> _userParameters = new HashMap(10);
    private String _hexSubs;
    private List<HostCharacterMapping> _hostCharMapping;
    private int _showHostCharParm = 2;
    private boolean _bidiFormatted = false;

    View(LpexView lpexView, Document document, boolean updateProfile) {
        View view;
        if (document._firstView == null) {
            document._firstView = this;
        } else {
            view = document._firstView;
            while (view._next != null) {
                view = view._next;
            }
            view._next = this;
        }
        this._document = document;
        this._lpexView = lpexView;
        this._lpexView._view = this;
        this._nls = new LpexNls(lpexView);
        this._documentPosition = new DocumentPosition(this);
        this._screen = new Screen(this);
        this._styleAttributesList = new StyleAttributesList();
        this.setBuiltInStyleCharacters();
        this._classes = new Classes();
        this._actionHandler = new ActionHandler(this);
        this._commandHandler = new CommandHandler(this);
        this._parsePendingList = new ParsePendingList(this);
        this._viewListenerList = new ViewListenerList(this);
        this._logMessages = LogMessagesParameter.getParameter().currentValue(this);
        this._expandTabs = ExpandTabsParameter.getParameter().currentValue(this);
        this._currentTabs = TabsParameter.getParameter().currentValue(this);
        this.cacheSequenceNumbersFormat();
        this._cursorWidth = CursorParameters.WidthParameter.getParameter().currentValue(this);
        this._lineNumbersLength = LineNumbersParameters.LengthParameter.getParameter().currentValue(this);
        this._lineNumbersPad = LineNumbersParameters.PadParameter.getParameter().currentValue(this);
        this._enforceTextLimit = SaveCommand.EnforceTextLimitParameter.getParameter().currentValue(this);
        this.setDocumentSectionThreshold();
        this._block = Block.lpexBlock();
        if (updateProfile && this._document._firstView != this) {
            this.updateProfile();
        }
        if (this.documentViews() == 2) {
            view = this._document._firstView;
            while (view != null) {
                view.listenerList().renamed();
                view = view._next;
            }
        }
    }

    private void setBuiltInStyleCharacters() {
        this._styleAttributesList.set('\u0001', this._screen.styleAttributes(15));
        this._styleAttributesList.set('\u0002', this._screen.styleAttributes(16));
        this._styleAttributesList.set('\u0003', this._screen.styleAttributes(0), this._screen.backgroundOnly(0));
        this._styleAttributesList.set('\u0004', this._screen.styleAttributes(5), this._screen.backgroundOnly(5));
        this._styleAttributesList.set('\u0005', this._screen.styleAttributes(2), this._screen.backgroundOnly(2));
    }

    String baseProfile() {
        return this._baseProfile;
    }

    boolean updateProfileIssued() {
        return this._updateProfileIssued;
    }

    void updateProfile() {
        boolean killOldPrefix;
        if (this._updateProfileInProgress) {
            return;
        }
        this._updateProfileInProgress = true;
        boolean originalReadonly = this._readonly;
        this._readonly = false;
        this.setIncludedClasses(-1L);
        this.setExcludedClasses(0L);
        this._classes = new Classes();
        this.setPopup(null);
        this.setExpandTabs(2);
        this.setTabs(new TabsParameter.Settings());
        this.setFields(null);
        String oldBaseProfile = this._baseProfile;
        boolean oldBaseProfileHasPrefixArea = "seu".equals(oldBaseProfile) || "ispf".equals(oldBaseProfile) || "xedit".equals(oldBaseProfile);
        this._baseProfile = UpdateProfileCommand.BaseProfileParameter.getParameter().currentValue(this);
        if (this._baseProfile == null) {
            this._baseProfile = "lpex";
        }
        if ("seu".equals(this._baseProfile) || "ispf".equals(this._baseProfile) || "xedit".equals(this._baseProfile)) {
            this.setPrefixProtect(false);
            this._screen.setPrefixArea(1);
        } else {
            this.setPrefixProtect(true);
            if (oldBaseProfile == null || oldBaseProfileHasPrefixArea) {
                this._screen.setPrefixArea(2);
            }
        }
        boolean bl = killOldPrefix = oldBaseProfileHasPrefixArea && !this._baseProfile.equals(oldBaseProfile);
        if (killOldPrefix) {
            this.markList().removePrefixExcludeMarks();
            this.screen().setPendingCommand(null, null);
        }
        Element next = null;
        Element element = this.firstElement();
        while (element != null) {
            ElementView elementView = element.elementView(this);
            next = element.next();
            if (elementView.show()) {
                this.deleteElement(element);
            } else {
                if (killOldPrefix) {
                    elementView.setPrefixText(null);
                }
                if (!element.show()) {
                    elementView.setStyle(null);
                    elementView.setClasses(1L);
                }
            }
            element = next;
        }
        this.document().undo().setDefaults(this);
        if ("vi".equals(this._baseProfile)) {
            this.setAutoCheck(false);
            this.viHandler().setCommandMode();
            this._vi = true;
            this._screen.setCommandLine(0);
        } else {
            this.setAutoCheck(true);
            this._vi = false;
            this._screen.setCommandLine(2);
        }
        this._styleAttributesList.clear();
        this._screen.updateProfile();
        this.setBuiltInStyleCharacters();
        this._actionHandler.updateProfile();
        this._commandHandler.updateProfile();
        String userProfile = UpdateProfileCommand.UserProfileParameter.getParameter().currentValue(this);
        if (userProfile != null && userProfile.length() > 0) {
            Class<?> userProfileClass = null;
            boolean invalidUserProfileClass = false;
            try {
                userProfileClass = Class.forName(userProfile);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Throwable e) {
                invalidUserProfileClass = true;
            }
            if (userProfileClass == null && !invalidUserProfileClass) {
                userProfileClass = ClassLoaderList.loadClass(userProfile, this);
            }
            if (userProfileClass == null) {
                this.setLpexMessageText(invalidUserProfileClass ? "userProfile.invalid" : "class.notFound", userProfile);
            } else {
                Class[] parameterTypes = new Class[]{LpexView.class};
                try {
                    Method userProfileMethod = userProfileClass.getMethod("userProfile", parameterTypes);
                    Object[] arguments = new Object[]{this.lpexView()};
                    userProfileMethod.invoke(null, arguments);
                }
                catch (InvocationTargetException e) {
                    String errorText = LpexResources.message("exception.profile", userProfile);
                    this.screen().setMessageText(errorText);
                    LpexLog.log(this, errorText, e.getTargetException());
                    UpdateProfileCommand.UserProfileParameter.getParameter().setValue(this, null);
                }
                catch (Exception e) {
                    this.setLpexMessageText("userProfile.invalid", userProfile);
                }
            }
        }
        this._parsePendingList.updateProfile();
        String name = this._document.name();
        if (name != null && name.length() > 0) {
            try {
                File file = new File(name);
                this._readonly = file.exists() && !file.canWrite();
            }
            catch (SecurityException e) {
                this._readonly = true;
            }
            catch (Exception e) {
                this._readonly = false;
            }
        }
        this._viewListenerList.updateProfile();
        this._parsePendingList.postUpdateProfile();
        if (this._vi && this._lpexWindow != null) {
            this._lpexWindow.textWindowRequestFocus();
        }
        this._updateProfileIssued = true;
        this._updateProfileInProgress = false;
        if (originalReadonly != this._readonly) {
            this.readonlyChanged();
        }
    }

    void dispose() {
        this._viewListenerList.disposed();
        this._parsePendingList.dispose();
        if (this.block().view() == this) {
            this.block().clear();
        }
        this.setWindow(null);
        View prevView = null;
        View view22 = this._document._firstView;
        while (view22 != null) {
            if (view22 == this) {
                if (prevView == null) {
                    this._document._firstView = this._next;
                    break;
                }
                prevView._next = this._next;
                break;
            }
            prevView = view22;
            view22 = view22._next;
        }
        if (this._document._firstView == null) {
            this._document.dispose();
        } else {
            this._document.elementList().disposeView(this);
        }
        this._actionHandler.clearActionLists();
        this._parserProperties.clear();
        this._userParameters.clear();
        this._lpexView._view = null;
        try {
            KillRing.disposeView(this);
        }
        catch (Throwable view22) {
            // empty catch block
        }
        view22 = prevView == null || prevView._next == null && this.documentViews() == 1 ? this._document._firstView : prevView._next;
        while (view22 != null) {
            view22.listenerList().renamed();
            view22 = view22._next;
        }
    }

    LpexView lpexView() {
        return this._lpexView;
    }

    LpexView lpexView(String name) {
        if (name != null && name.trim().length() != 0) {
            try {
                name = new File(name).getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (name != null) {
                if (name.equals(this.document().name())) {
                    return this._lpexView;
                }
                Document document = Document._firstDocument;
                while (document != null) {
                    if (name.equals(document.name())) {
                        return document._firstView._lpexView;
                    }
                    document = document._next;
                }
            }
        }
        return null;
    }

    Document document() {
        return this._document;
    }

    private Element firstElement() {
        return this._document.elementList().first();
    }

    int id() {
        int id = 1;
        View view = this._document._firstView;
        while (view != null && view != this) {
            view = view._next;
            ++id;
        }
        return id;
    }

    int documentViews() {
        int count = 0;
        View view = this._document._firstView;
        while (view != null) {
            ++count;
            view = view._next;
        }
        return count;
    }

    LpexView[] getLpexViews() {
        LpexView[] lpexViews = new LpexView[this.documentViews()];
        int i = 0;
        View view = this._document._firstView;
        while (view != null) {
            lpexViews[i++] = view._lpexView;
            view = view._next;
        }
        return lpexViews;
    }

    Screen screen() {
        return this._screen;
    }

    CommandHandler commandHandler() {
        return this._commandHandler;
    }

    ActionHandler actionHandler() {
        return this._actionHandler;
    }

    DocumentPosition documentPosition() {
        return this._documentPosition;
    }

    void setWindow(LpexWindow lpexWindow) {
        if (lpexWindow == this._lpexWindow) {
            return;
        }
        if (this._lpexWindow != null) {
            this._lpexWindow.setLpexView(null);
            this._lpexWindow.dissociate();
        }
        if (lpexWindow != null) {
            if (lpexWindow.getLpexView() != null) {
                View view = lpexWindow.getLpexView()._view;
                view._lpexWindow = null;
                view.screen().setWindow(null);
            }
            lpexWindow.setLpexView(this._lpexView);
        }
        this._lpexWindow = lpexWindow;
        this.screen().setWindow(this._lpexWindow);
    }

    LpexWindow window() {
        return this._lpexWindow;
    }

    HashMap<String, String> parserProperties() {
        return this._parserProperties;
    }

    HashMap<String, String> userParameters() {
        return this._userParameters;
    }

    int maxElementWidth() {
        if (!this._maxElementWidthValid) {
            this._maxElementWidth = 0;
            Element element = this._document.elementList().firstVisible(this);
            while (element != null) {
                int width = element.elementView(this).roughWidth();
                if (width > this._maxElementWidth) {
                    this._maxElementWidth = width;
                }
                element = element.nextVisible(this);
            }
            this._maxElementWidthValid = true;
        }
        return this._maxElementWidth;
    }

    void setMaxElementWidthInvalid() {
        this._maxElementWidthValid = false;
    }

    boolean maxElementWidthValid() {
        return this._maxElementWidthValid;
    }

    void setElementWidthsInvalid() {
        Element element = this.firstElement();
        while (element != null) {
            element.elementView(this).setWidthInvalid();
            element = element.next();
        }
        this.setMaxElementWidthInvalid();
    }

    int maxPrefixAreaWidth() {
        if (!this._maxPrefixAreaWidthValid) {
            this._maxPrefixAreaWidth = 0;
            Element element = this._document.elementList().firstVisible(this);
            while (element != null) {
                int width = element.elementView(this).prefixAreaWidth();
                if (width > this._maxPrefixAreaWidth) {
                    this._maxPrefixAreaWidth = width;
                }
                element = element.nextVisible(this);
            }
            this._maxPrefixAreaWidthValid = true;
        }
        return this._maxPrefixAreaWidth;
    }

    void setMaxPrefixAreaWidthInvalid() {
        this._maxPrefixAreaWidthValid = false;
    }

    boolean maxPrefixAreaWidthValid() {
        return this._maxPrefixAreaWidthValid;
    }

    void setPrefixAreaWidthsInvalid() {
        Element element = this.firstElement();
        while (element != null) {
            element.elementView(this).setPrefixAreaWidthInvalid();
            element = element.next();
        }
        this.setMaxPrefixAreaWidthInvalid();
    }

    boolean topExpandHideHeader() {
        if (this._forceAllVisible) {
            return false;
        }
        Element element = this.firstElement();
        while (element != null) {
            ElementView elementView = element.elementView(this);
            if (elementView.expandHideVisible()) {
                return false;
            }
            if (!element.show() || elementView.show()) {
                return true;
            }
            element = element.next();
        }
        return false;
    }

    String topExpandHideText() {
        if (this.topExpandHideHeader()) {
            return this.topExpanded() ? "-" : "+";
        }
        return "";
    }

    boolean topExpanded() {
        return this._topExpanded;
    }

    void setTopExpanded(boolean topExpanded) {
        if (this._topExpanded != topExpanded) {
            this._topExpanded = topExpanded;
            this.setVisibleElementOrdinalsInvalid();
            this.setMaxElementWidthInvalid();
            this.setMaxPrefixAreaWidthInvalid();
        }
    }

    boolean hiddenElements() {
        this.validateVisibleElements();
        return this._hiddenElements;
    }

    void setVisibleElementOrdinalsInvalid() {
        this._visibleElementOrdinalsValid = false;
        this._lastVisibleCharCountElementRequested = null;
    }

    void setLastVisibleCharCountElementInvalid() {
        this._lastVisibleCharCountElementRequested = null;
    }

    void validateVisibleElements() {
        if (!this._visibleElementOrdinalsValid) {
            this._hiddenElements = false;
            int count = 0;
            boolean withinExpanded = this.topExpanded();
            if (this._screen != null && this._screen.currentExpandHide() && this.topExpandHideHeader()) {
                count = 1;
            }
            Element element = this.firstElement();
            while (element != null) {
                ElementView elementView = element.elementView(this);
                if (this._forceAllVisible || elementView.expandHideVisible()) {
                    ++count;
                    elementView.setExpandedVisible(false);
                    withinExpanded = elementView.expanded();
                } else if (!element.show() || elementView.show()) {
                    elementView.setExpandedVisible(withinExpanded);
                    if (withinExpanded) {
                        ++count;
                    }
                    this._hiddenElements = true;
                }
                elementView.setVisibleOrdinal(count);
                element = element.next();
            }
            this._visibleElementOrdinalsValid = true;
        }
    }

    int visibleElementOrdinalOf(Element element) {
        this.validateVisibleElements();
        return element.elementView(this).visibleOrdinal();
    }

    Element visibleElementAt(int visibleOrdinal) {
        this.validateVisibleElements();
        Element startElement = this._document.elementList().firstVisible(this);
        if (visibleOrdinal == 1 && startElement.elementView(this).visibleOrdinal() > 1) {
            return null;
        }
        Element element = startElement;
        while (element != null) {
            if (visibleOrdinal == element.elementView(this).visibleOrdinal()) {
                return element;
            }
            element = element.nextVisible(this);
        }
        return null;
    }

    int visibleElementCount() {
        Element last = this._document.elementList().last();
        return last != null ? this.visibleElementOrdinalOf(last) : 0;
    }

    void expandAll(boolean on) {
        this.setTopExpanded(on);
        this.document().elementList().expandAll(this, on);
        this.document().undo().expandAll(this, on);
    }

    void resetDisplayTextFont() {
        Element element = this.firstElement();
        while (element != null) {
            element.elementView(this).resetDisplayTextFont();
            element = element.next();
        }
    }

    int displayPosition(ElementView elementView, int textPosition, boolean charPosition) {
        boolean expandTabs;
        Element element = elementView.element();
        boolean bl = expandTabs = element.tabs() && this.currentExpandTabs();
        if (!expandTabs) {
            if (!this.nls().displayingSosi()) {
                return textPosition;
            }
            return charPosition ? this.nls().emulationCharIndex(element.text(), textPosition - 1) + 1 : this.nls().emulationIndex(element.text(), textPosition - 1) + 1;
        }
        String fullDisplayText = element.text();
        if (this.nls().displayingSosi()) {
            textPosition = charPosition ? this.nls().emulationCharIndex(fullDisplayText, textPosition - 1) + 1 : this.nls().emulationIndex(fullDisplayText, textPosition - 1) + 1;
            fullDisplayText = this.nls().addSourceSosi(fullDisplayText);
        }
        if (!expandTabs) {
            return textPosition;
        }
        int tc = 0;
        int lastTabVal = 0;
        int columnPosition = 1;
        int displayPosition = 0;
        int i = 1;
        while (i < textPosition) {
            char c;
            char c2 = c = i <= fullDisplayText.length() ? (char)fullDisplayText.charAt(i - 1) : (char)' ';
            if (c == '\t') {
                while (tc < this._currentTabs._tabStops.length && lastTabVal <= columnPosition) {
                    lastTabVal = this._currentTabs._tabStops[tc++];
                }
                while (lastTabVal <= columnPosition) {
                    lastTabVal += this._currentTabs._tabIncrement == 0 ? 1 : this._currentTabs._tabIncrement;
                }
                int tabLen = lastTabVal - columnPosition;
                displayPosition += tabLen;
                columnPosition = lastTabVal;
                ++i;
                continue;
            }
            ++displayPosition;
            columnPosition += this.nls().getSourceWidth(c);
            ++i;
        }
        return displayPosition + 1;
    }

    int displayColumn(ElementView elementView, int position) {
        int column = this.displayPosition(elementView, position, true);
        if (this.nls().usingSourceColumns() || this.nls().isIgnoringBidiMarks()) {
            column = this.nls().columnFromDisplayIndex(elementView.displayText(), column - 1) + 1;
        }
        return column;
    }

    int currentColumn(ElementView elementView) {
        DocumentPosition docPos = this.documentPosition();
        int position = docPos == null ? 1 : docPos.position();
        int column = this.displayPosition(elementView, position, true);
        String displayText = elementView.displayText();
        if (this.nls().usingSourceColumns()) {
            column = this.nls().sourceColumnFromDisplayIndex(displayText, column - 1) + 1;
        }
        return column;
    }

    int positionFromDisplayPosition(ElementView elementView, int displayPosition) {
        Element element;
        boolean expandTabs;
        if (this.nls().isSourceMbcs()) {
            displayPosition = this.nls().displayIndexFromColumn(elementView.displayText(), displayPosition - 1) + 1;
        }
        boolean bl = expandTabs = (element = elementView.element()).tabs() && this.currentExpandTabs();
        if (!expandTabs) {
            if (this.nls().displayingSosi()) {
                displayPosition = this.nls().indexFromEmulationIndex(element.text(), displayPosition - 1) + 1;
            }
            return displayPosition;
        }
        String fullDisplayText = element.text();
        int textPosition = displayPosition;
        if (expandTabs) {
            String text = fullDisplayText;
            if (this.nls().displayingSosi()) {
                text = this.nls().addSourceSosi(text);
            }
            int tc = 0;
            int lastTabVal = 0;
            int columnPosition = 1;
            int iText = 0;
            int i = 1;
            while (i < displayPosition) {
                char c;
                char c2 = c = iText < text.length() ? (char)text.charAt(iText) : (char)' ';
                if (c == '\t') {
                    while (tc < this._currentTabs._tabStops.length && lastTabVal <= columnPosition) {
                        lastTabVal = this._currentTabs._tabStops[tc++];
                    }
                    while (lastTabVal <= columnPosition) {
                        lastTabVal += this._currentTabs._tabIncrement == 0 ? 1 : this._currentTabs._tabIncrement;
                    }
                    int tabLen = lastTabVal - columnPosition;
                    i += tabLen;
                    columnPosition = lastTabVal;
                } else {
                    ++i;
                    columnPosition += this.nls().getSourceWidth(c);
                }
                ++iText;
            }
            textPosition = ++iText;
        }
        if (this.nls().displayingSosi()) {
            textPosition = this.nls().indexFromEmulationIndex(fullDisplayText, textPosition - 1) + 1;
        }
        return textPosition;
    }

    int cursorPixelPosition(Element element, int textPosition, boolean insertMode) {
        int prevCharWidth;
        int prevCharPixelPosition;
        boolean prevRTL;
        int cursorWidth;
        if (textPosition <= 0) {
            return 0;
        }
        int currCharWidth = this.charWidth(element, textPosition);
        boolean insertCursor = false;
        boolean streamSelectionCursor = false;
        if (insertMode && !this.vi()) {
            insertCursor = true;
            cursorWidth = this._cursorWidth;
        } else if (this.block().view() == this && this.block().type() == 1 && this.block().anythingSelected()) {
            streamSelectionCursor = true;
            cursorWidth = this._cursorWidth;
        } else {
            cursorWidth = currCharWidth;
        }
        ElementView elementView = element.elementView(this);
        int cursorPixelPosition = elementView.pixelCharPosition(textPosition);
        if (!insertCursor && !streamSelectionCursor || !LpexUtilities.isBidi() || !element.hasBidi()) {
            return cursorPixelPosition;
        }
        int direction = this.documentPosition().direction();
        int displayPosition = this.displayPosition(elementView, textPosition, true);
        boolean currRTL = DisplayTextLayout.isRTLCharacter(elementView, displayPosition);
        boolean bl = prevRTL = displayPosition == 1 ? false : DisplayTextLayout.isRTLCharacter(elementView, displayPosition - 1);
        if (textPosition == 1) {
            prevCharPixelPosition = DisplayTextLayout.pixelPosition(elementView, displayPosition - 1);
            prevCharWidth = DisplayTextLayout.charWidth(elementView, displayPosition - 1);
        } else {
            prevCharPixelPosition = elementView.pixelCharPosition(textPosition - 1);
            prevCharWidth = this.charWidth(element, textPosition - 1);
        }
        if (currRTL != prevRTL) {
            if (direction == 0) {
                if (currRTL) {
                    cursorPixelPosition = prevCharPixelPosition + prevCharWidth;
                }
            } else if (currRTL) {
                cursorPixelPosition += currCharWidth - cursorWidth;
            } else {
                cursorPixelPosition = prevCharPixelPosition - cursorWidth;
                if (cursorPixelPosition < 0) {
                    cursorPixelPosition = 0;
                }
            }
        } else {
            boolean prevRTLcontext;
            boolean currRTLcontext = DisplayTextLayout.isRTLContext(elementView, displayPosition);
            boolean bl2 = prevRTLcontext = displayPosition == 1 ? false : DisplayTextLayout.isRTLContext(elementView, displayPosition - 1);
            if (prevRTLcontext && !currRTLcontext && direction == 0 && LpexUtilities.getKeyboardLanguage() == 1) {
                cursorPixelPosition = prevCharPixelPosition + prevCharWidth;
            } else if (currRTL) {
                cursorPixelPosition += currCharWidth - cursorWidth;
            }
        }
        return cursorPixelPosition;
    }

    int cursorPixelWidth(Element element, int textPosition) {
        if (!this.vi() && this.insertMode() || this.block().view() == this && this.block().type() == 1 && this.block().anythingSelected()) {
            return this._cursorWidth;
        }
        int charWidth = this.charWidth(element, textPosition);
        if (charWidth < 1) {
            return this._cursorWidth == 1 ? 1 : 2;
        }
        return charWidth;
    }

    int prefixPixelPosition(ElementView elementView, int prefixPosition) {
        String prefixText;
        int prefixPixelPosition = 0;
        TextFontMetrics textFontMetrics = this.screen().textFontMetrics();
        if (textFontMetrics != null && prefixPosition > 1 && (prefixText = elementView.prefixText()) != null && prefixText.length() > 0) {
            if (prefixPosition > prefixText.length() + 1) {
                prefixPosition = prefixText.length() + 1;
            }
            prefixPixelPosition = textFontMetrics.substringWidth(prefixText, 0, prefixPosition - 1);
        }
        return prefixPixelPosition;
    }

    int charWidth(Element element, int position) {
        int charWidth = 0;
        TextFontMetrics textFontMetrics = this.screen().textFontMetrics();
        if (textFontMetrics != null && position > 0) {
            charWidth = textFontMetrics.spaceWidth();
            String text = element.text();
            if (text.length() >= position) {
                char c = text.charAt(position - 1);
                if (c == '\t' && this.currentExpandTabs()) {
                    ElementView elementView = element.elementView(this);
                    int displayPos = this.displayPosition(elementView, position + 1, false);
                    int displayCharPos = this.displayPosition(elementView, position, true);
                    int totalDisplayPos = displayPos - displayCharPos;
                    charWidth *= totalDisplayPos;
                } else if (LpexUtilities.isBidi() && element.hasBidi()) {
                    ElementView elementView = element.elementView(this);
                    int displayPosition = this.displayPosition(elementView, position, true);
                    charWidth = DisplayTextLayout.charWidth(elementView, displayPosition);
                } else {
                    int end = DisplayTextLayout.getClusterOffsetNext(text, position - 1);
                    charWidth = textFontMetrics.stringWidth(text.substring(position - 1, end));
                }
            }
        }
        return charWidth;
    }

    int prefixCharWidth(ElementView elementView, int prefixPosition) {
        String prefixText;
        int prefixCharWidth = 0;
        TextFontMetrics textFontMetrics = this.screen().textFontMetrics();
        if (textFontMetrics != null && (prefixText = elementView.prefixText()) != null && prefixText.length() > 0 && prefixText.length() > prefixPosition - 1) {
            prefixCharWidth = textFontMetrics.charWidth(prefixText.charAt(prefixPosition - 1));
        }
        return prefixCharWidth;
    }

    int position(ElementView elementView, int pixelPosition) {
        return LpexUtilities.isBidi() ? DisplayTextLayout.textPosition(elementView, pixelPosition) : this.textPosition(elementView, pixelPosition);
    }

    /*
     * Unable to fully structure code
     */
    int textPosition(ElementView elementView, int pixelPosition) {
        block2: {
            block3: {
                textPosition = 1;
                textFontMetrics = this.screen().textFontMetrics();
                if (textFontMetrics == null || (spaceWidth = textFontMetrics.spaceWidth()) == 0) break block2;
                textPosition = pixelPosition / spaceWidth + 1;
                x = elementView.pixelPosition(textPosition, false);
                if (x > pixelPosition) ** GOTO lbl13
                while ((x = elementView.pixelPosition(textPosition + 1, false)) <= pixelPosition) {
                    ++textPosition;
                }
                break block3;
                while ((x = elementView.pixelPosition(textPosition, false)) > pixelPosition) {
                    --textPosition;
lbl13:
                    // 2 sources

                    if (textPosition > 1) continue;
                }
            }
            textPosition = DisplayTextLayout.getClusterOffset(elementView.element().text(), textPosition - 1) + 1;
        }
        return textPosition;
    }

    /*
     * Unable to fully structure code
     */
    int positionAtMouse(ElementView elementView, int pixelPosition) {
        block4: {
            block6: {
                block5: {
                    textPosition = 1;
                    textFontMetrics = this.screen().textFontMetrics();
                    if (textFontMetrics == null || (spaceWidth = textFontMetrics.spaceWidth()) == 0) break block4;
                    if (!LpexUtilities.isBidi() || !elementView.element().hasBidi()) break block5;
                    width = elementView.width();
                    if (pixelPosition > width) {
                        textPosition = elementView.element().length() + (pixelPosition - width) / spaceWidth + 1;
                    } else {
                        displayPosition = DisplayTextLayout.displayPosition(elementView, pixelPosition);
                        textPosition = this.positionFromDisplayPosition(elementView, displayPosition);
                    }
                    break block4;
                }
                textPosition = pixelPosition / spaceWidth + 1;
                x = elementView.pixelPosition(textPosition, false);
                if (x > pixelPosition) ** GOTO lbl24
                while (x + ((xNext = elementView.pixelPosition(textPosition + 1, false)) - x) / 2 <= pixelPosition) {
                    ++textPosition;
                    x = xNext;
                }
                break block6;
                while ((xPrev = elementView.pixelPosition(textPosition - 1, false)) + (x - xPrev) / 2 > pixelPosition) {
                    --textPosition;
                    x = xPrev;
lbl24:
                    // 2 sources

                    if (textPosition > 1) continue;
                }
            }
            textPosition = DisplayTextLayout.getClusterOffset(elementView.element().text(), textPosition - 1) + 1;
        }
        return textPosition;
    }

    LpexDocumentLocation getTextLocationAtPoint(int x, int y) {
        int row;
        Screen screen = this.screen();
        Element element = screen.element(row = y / screen.textFontMetrics().textHeight() + 1);
        if (element == null) {
            return null;
        }
        int leftMarginWidth = screen.expandHideAreaWidth() + screen.prefixAreaWidth();
        if (x < leftMarginWidth || x > this.screen().width()) {
            return null;
        }
        int position = this.positionAtMouse(element.elementView(this), screen.scroll() + x - leftMarginWidth);
        if (position < 1) {
            return null;
        }
        if (position > element.length() + 1) {
            return null;
        }
        return new LpexDocumentLocation(this.document().elementList().ordinalOf(element), position);
    }

    LpexDocumentLocation getLocationAtPoint(int x, int y) {
        int position;
        Screen screen = this.screen();
        int row = y / screen.textFontMetrics().textHeight() + 1;
        Element element = screen.element(row);
        while (element == null && row > 1) {
            element = screen.element(--row);
        }
        if (element == null) {
            return null;
        }
        int leftMarginWidth = screen.expandHideAreaWidth() + screen.prefixAreaWidth();
        if (x >= screen.width()) {
            x = Math.max(0, screen.width() - screen.cursorWidth());
            position = this.position(element.elementView(this), screen.scroll() + x - leftMarginWidth);
        } else {
            if (x < leftMarginWidth) {
                x = leftMarginWidth;
            }
            position = this.positionAtMouse(element.elementView(this), screen.scroll() + x - leftMarginWidth);
        }
        if (position < 1) {
            position = 1;
        }
        return new LpexDocumentLocation(this.document().elementList().ordinalOf(element), position);
    }

    int[] getPointAtLocation(LpexDocumentLocation lpexDocumentLocation) {
        Element element;
        if (lpexDocumentLocation == null || lpexDocumentLocation.position < 1) {
            return null;
        }
        Screen screen = this.screen();
        int row = screen.row(element = this.document().elementList().elementAt(lpexDocumentLocation.element));
        if (row == 0) {
            return null;
        }
        int y = (row - 1) * screen.textFontMetrics().textHeight();
        ElementView elementView = element.elementView(this);
        int leftMarginWidth = screen.expandHideAreaWidth() + screen.prefixAreaWidth();
        int x = leftMarginWidth - screen.scroll() + elementView.pixelCharPosition(lpexDocumentLocation.position);
        if (x < leftMarginWidth || x > screen.width()) {
            return null;
        }
        return new int[]{x, y};
    }

    /*
     * Unable to fully structure code
     */
    int prefixPosition(ElementView elementView, int prefixPixelPosition) {
        block4: {
            prefixPosition = 1;
            textFontMetrics = this.screen().textFontMetrics();
            if (textFontMetrics == null || (spaceWidth = textFontMetrics.spaceWidth()) == 0) break block4;
            prefixPosition = prefixPixelPosition / textFontMetrics.spaceWidth() + 1;
            if (prefixPosition > (maxPosition = elementView.prefixEnd())) {
                prefixPosition = maxPosition;
            }
            if ((x = this.prefixPixelPosition(elementView, prefixPosition)) > prefixPixelPosition) ** GOTO lbl17
            while (prefixPosition < maxPosition) {
                x = this.prefixPixelPosition(elementView, prefixPosition + 1);
                if (x <= prefixPixelPosition) {
                    ++prefixPosition;
                    continue;
                }
                break block4;
            }
            break block4;
            while ((x = this.prefixPixelPosition(elementView, prefixPosition)) > prefixPixelPosition) {
                --prefixPosition;
lbl17:
                // 2 sources

                if (prefixPosition > 1) continue;
            }
        }
        return prefixPosition;
    }

    void setInsertMode(boolean insertMode) {
        this._insertMode = insertMode;
        this.documentPosition().insertModeChanged();
    }

    boolean insertMode() {
        return this._insertMode;
    }

    void setScrollWhileAdjusting(boolean scrollWhileAdjusting) {
        this._scrollWhileAdjusting = scrollWhileAdjusting;
    }

    boolean scrollWhileAdjusting() {
        return this._scrollWhileAdjusting;
    }

    void setInPrefix(boolean inPrefix) {
        boolean oldInPrefix = this._inPrefix;
        if (!inPrefix || !this._prefixProtect) {
            this._inPrefix = inPrefix;
        }
        if (this._inPrefix != oldInPrefix) {
            this.documentPosition().inPrefixChanged();
        }
    }

    boolean inPrefix() {
        return this._inPrefix;
    }

    void setPrefixProtect(boolean prefixProtect) {
        this._prefixProtect = prefixProtect;
        if (this._inPrefix && this._prefixProtect) {
            this.setInPrefix(false);
        }
    }

    boolean prefixProtect() {
        return this._prefixProtect;
    }

    boolean tracing() {
        return this._traceKeys || this._traceMouseEvents;
    }

    boolean tryToDeleteStreamBlock() {
        if (this.block().view() == this && this.block().type() == 1 && this.block().anythingUnprotectedSelected()) {
            this.block().delete();
            this.block().clear();
            return true;
        }
        return false;
    }

    void receiveCharacter(char character) {
        this.receiveCharacter(this.insertMode(), character);
    }

    void receiveCharacter(boolean insertMode, char character) {
        Element element = this.documentPosition().element();
        if (element == null) {
            return;
        }
        boolean insert = insertMode;
        boolean entireTextSelected = this.entireTextSelected();
        if (this._inPrefix) {
            if (insert) {
                this.insertPrefixText(String.valueOf(character));
            } else {
                this.replacePrefixText(String.valueOf(character));
            }
        } else if (!element.show() && !this.markList().protect(element) && this.changeAllowed() || element.show() && entireTextSelected) {
            if (this.tryToDeleteStreamBlock()) {
                insert = true;
            }
            if (element.show() && entireTextSelected) {
                this._documentPosition.top();
            }
            if (insert) {
                this.insertText(String.valueOf(character));
            } else {
                this.replaceText(String.valueOf(character));
            }
        }
    }

    private boolean entireTextSelected() {
        return this._block != null && this._block.anchorAtTop() && this._block.type() == 1 && this._block.bottomElement() == this.document().elementList().last() && this._block.bottomPosition() == this.document().elementList().last().end();
    }

    public void resetText(String text) {
        ElementList elementList = this.document().elementList();
        int currentLine = elementList.nonShowOrdinalOf(this.documentPosition().element());
        int currentPosition = this.documentPosition().position();
        int cursorRow = this.screen().cursorRow();
        int emphasisLength = this.documentPosition().emphasisLength();
        int blockType = this.block().type();
        View blockView = this.block().view();
        int blockTopLine = elementList.nonShowOrdinalOf(this.block().topElement());
        int blockBottomLine = elementList.nonShowOrdinalOf(this.block().bottomElement());
        int blockTopPosition = this.block().topPosition();
        int blockBottomPosition = this.block().bottomPosition();
        this.document().setText(this, text);
        Element currentElement = elementList.nonShowElementAt(currentLine);
        if (blockType != 0 && blockView != null) {
            Element topElement = elementList.nonShowElementAt(blockTopLine);
            Element bottomElement = elementList.nonShowElementAt(blockBottomLine);
            if (topElement != null && bottomElement != null) {
                if (topElement == currentElement && blockTopPosition == currentPosition) {
                    this.block().set(blockType, blockView, bottomElement, blockBottomPosition);
                    this.block().set(blockType, blockView, topElement, blockTopPosition);
                } else {
                    this.block().set(blockType, blockView, topElement, blockTopPosition);
                    this.block().set(blockType, blockView, bottomElement, blockBottomPosition);
                }
            }
        }
        this.documentPosition().jump(currentElement, currentPosition);
        this.screen().setCursorRow(cursorRow);
        this.documentPosition().setEmphasisLength(emphasisLength);
    }

    /*
     * Unable to fully structure code
     */
    public boolean updateText(int line, int position, int deleteToLine, int deleteToPosition, String text) {
        block22: {
            block23: {
                rc = true;
                elementList = this.document().elementList();
                e1 = elementList.nonShowElementAt(line);
                prefixAreaTextValue = PrefixAreaTextParameter.getParameter().currentValue(this);
                sequenceText = "";
                if (prefixAreaTextValue != 3) {
                    if (prefixAreaTextValue == 2) {
                        sequenceText = this.document().elementList().getSequenceNumbersDisplayString(e1, this);
                    }
                    if (sequenceText.length() == 0) {
                        sequenceText = this.lineNumbersText(e1);
                    }
                }
                if (sequenceText.length() != 0 && text.contains(sequenceText)) {
                    text = text.replaceFirst(sequenceText, "");
                }
                if (e1 == null) {
                    return false;
                }
                sequenceNumbers = elementList.sequenceNumbersWidth() != 0;
                this.setIgnoreFields();
                forceAllVisible = this.setForceAllVisible(true);
                if (sequenceNumbers) break block22;
                if (deleteToLine == 0) break block23;
                e2 = elementList.nonShowElementAt(deleteToLine);
                if (e2 != null) ** GOTO lbl29
                this.setForceAllVisible(forceAllVisible);
                this.resetIgnoreFields();
                return false;
lbl-1000:
                // 1 sources

                {
                    e1Next = e1.nextNonShow();
                    this.deleteElement(e1);
                    e1 = e1Next;
lbl29:
                    // 2 sources

                    ** while (e1 != e2 && position == 1)
                }
lbl30:
                // 1 sources

                v0 = len = e1 == e2 ? deleteToPosition - position : e1.length() - position + 1;
                if (len > 0) {
                    this.deleteText(e1, position, len, true, false);
                }
                if (e1 != e2 && e1.nextNonShow() != e2) {
                    eDel = e1.nextNonShow();
                    while (eDel != e2) {
                        eDelNext = eDel.nextNonShow();
                        this.deleteElement(eDel);
                        eDel = eDelNext;
                    }
                }
                if (e1 != e2 && (len = deleteToPosition - 1) > 0) {
                    this.deleteText(e2, 1, len, true, false);
                }
                if (e1 != e2) {
                    this.markList().joinElements(e1, e2);
                    this.markList().setIgnoreChanges(true);
                    this.documentPosition().joinElements(e1, e2);
                    this.documentPosition().setIgnoreChanges(true);
                    this.insertText(e1, e1.end(), e2.text(), true);
                    this.deleteElement(e2);
                    this.documentPosition().setIgnoreChanges(false);
                    this.markList().setIgnoreChanges(false);
                }
            }
            if (text != null && text.length() != 0) {
                originalElement = this.documentPosition().element();
                originalPosition = this.documentPosition().position();
                originalCursorRow = this.screen().cursorRow();
                this.documentPosition().jump(e1, position);
                this.updateTextInsert(text);
                this.documentPosition().jump(originalElement, originalPosition);
                this.screen().setCursorRow(originalCursorRow);
            }
            this.setForceAllVisible(forceAllVisible);
            this.resetIgnoreFields();
            return true;
        }
        sequenceNumbersColumn = elementList.sequenceNumbersColumn();
        fullTextPosition = position;
        position = elementList.fullTextToTextPosition(e1, position);
        v1 = atCursor = e1 == this.documentPosition().element() && position == this.documentPosition().position();
        if (deleteToLine != 0) {
            e2 = elementList.nonShowElementAt(deleteToLine);
            if (e1 == e2) {
                oldSequenceText = e1.sequenceText();
                this.deleteText(e1, position, deleteToPosition - fullTextPosition, true, true);
                if (sequenceNumbersColumn == 1) {
                    if (!e1.sequenceText().equals(oldSequenceText)) {
                        this._document.seqTextAdjusted(this, e1);
                    }
                } else if (text == null || text.length() == 0) {
                    this._document.elementAdjusted(this, e1);
                }
            } else {
                rc = false;
            }
        }
        if (rc && text != null && text.length() != 0) {
            if (atCursor) {
                this.updateTextInsert(text);
            } else {
                originalElement = this.documentPosition().element();
                originalPosition = this.documentPosition().position();
                this.documentPosition().jump(e1, position);
                this.updateTextInsert(text);
                this.documentPosition().jump(originalElement, originalPosition);
            }
        }
        this.setForceAllVisible(forceAllVisible);
        this.resetIgnoreFields();
        return rc;
    }

    private void updateTextInsert(String insertText) {
        if (insertText.length() == 0) {
            return;
        }
        Element element = this.documentPosition().element();
        boolean sequenceNumbers = this.document().elementList().sequenceNumbersWidth() != 0;
        int sequenceNumbersColumn = this.document().elementList().sequenceNumbersColumn();
        int i = 0;
        int indexOfLF = insertText.indexOf(10);
        int indexOfCR = insertText.indexOf(13);
        if (indexOfLF < 0 && indexOfCR < 0) {
            String oldSequenceText = element.sequenceText();
            this.insertText(element, this.documentPosition().position(), insertText, true);
            if (sequenceNumbers) {
                if (sequenceNumbersColumn == 1) {
                    if (!element.sequenceText().equals(oldSequenceText)) {
                        this._document.seqTextAdjusted(this, element);
                    }
                } else {
                    this._document.elementAdjusted(this, element);
                }
            }
        } else {
            Element firstElement = element;
            Element postElement = element.next();
            this._document.resetUserActionElements();
            do {
                if (indexOfCR < indexOfLF && indexOfCR != -1 || indexOfLF == -1) {
                    if (i < indexOfCR) {
                        this.insertText(element, this.documentPosition().position(), insertText.substring(i, indexOfCR), true);
                    }
                    i = indexOfCR + (indexOfLF == indexOfCR + 1 ? 2 : 1);
                } else {
                    if (i < indexOfLF) {
                        this.insertText(element, this.documentPosition().position(), insertText.substring(i, indexOfLF), true);
                    }
                    i = indexOfLF + 1;
                }
                this.splitElement(true);
                element = this.documentPosition().element();
                postElement = element.next();
                if (indexOfLF != -1) {
                    indexOfLF = insertText.indexOf(10, i);
                }
                if (indexOfCR == -1) continue;
                indexOfCR = insertText.indexOf(13, i);
            } while (indexOfLF >= 0 || indexOfCR >= 0);
            if (i < insertText.length()) {
                this.insertText(element, this.documentPosition().position(), insertText.substring(i), true);
            }
            if (sequenceNumbers) {
                Element e = firstElement;
                while (e != null && e != postElement) {
                    this._document.elementAdjusted(this, e);
                    e = e.next();
                }
            }
        }
    }

    int insertText(String insertText) {
        if (insertText.length() == 0) {
            return 0;
        }
        Element element = this.documentPosition().element();
        int i = 0;
        int indexOfLF = insertText.indexOf(10);
        int indexOfCR = insertText.indexOf(13);
        int rc = 0;
        if (element == null || this.markList().protect(element) || !element.show() && !this.changeAllowed()) {
            return rc;
        }
        boolean ignoreFieldsSet = false;
        boolean documentListenerInsertingTextSet = false;
        if (indexOfLF >= 0 || indexOfCR >= 0) {
            this.setIgnoreFields();
            ignoreFieldsSet = true;
            this._document.setDocumentListenerInsertingText(true);
            documentListenerInsertingTextSet = true;
            this._document.resetUserActionElements();
            boolean forceAllVisible = this.setForceAllVisible(true);
            do {
                if (indexOfCR < indexOfLF && indexOfCR != -1 || indexOfLF == -1) {
                    rc |= this.insertText(element, this.documentPosition().position(), insertText.substring(i, indexOfCR), false);
                    i = indexOfCR + (indexOfLF == indexOfCR + 1 ? 2 : 1);
                } else {
                    rc |= this.insertText(element, this.documentPosition().position(), insertText.substring(i, indexOfLF), false);
                    i = indexOfLF + 1;
                }
                if (this.splitElement()) {
                    rc |= 2;
                }
                element = this.documentPosition().element();
                if (indexOfLF != -1) {
                    indexOfLF = insertText.indexOf(10, i);
                }
                if (indexOfCR == -1) continue;
                indexOfCR = insertText.indexOf(13, i);
            } while (indexOfLF >= 0 || indexOfCR >= 0);
            this.setForceAllVisible(forceAllVisible);
        }
        if (i < insertText.length()) {
            rc |= this.insertText(element, this.documentPosition().position(), insertText.substring(i), false);
        }
        if (documentListenerInsertingTextSet) {
            this._document.setDocumentListenerInsertingText(false);
        }
        if (ignoreFieldsSet) {
            this.resetIgnoreFields();
        }
        return rc;
    }

    int insertText(Element element, int position, String insertText) {
        return this.insertText(element, position, insertText, false);
    }

    int insertText(Element element, int position, String insertText, boolean force) {
        int[] fields;
        if (element == null || insertText.length() == 0 || position < 1) {
            return 0;
        }
        if (!force && (this.markList().protect(element) || !element.show() && !this.changeAllowed())) {
            return 0;
        }
        int rc = 2;
        int spacesToDelete = 0;
        int fieldLimit = 0;
        if (!this.ignoreFields() && (fields = this.currentFields(element)) != null) {
            String text = element.text();
            boolean usingSourceColumns = this.nls().usingSourceColumns();
            int bytesPosition = position;
            if (usingSourceColumns) {
                bytesPosition = this.nls().encodingIndex(text, position - 1) + 1;
            }
            if ((fieldLimit = this.fieldLimit(fields, bytesPosition)) != 0) {
                int bytesFieldLimit = fieldLimit;
                if (usingSourceColumns) {
                    fieldLimit = LpexNls.indexFromEncodingIndex(text, bytesFieldLimit, this.nls().getSourceEncoding(), SourceCcsidParameter.getParameter().currentValue(this));
                }
                int fieldSpace = 0;
                int i = fieldLimit;
                while (i >= position) {
                    if (i <= text.length() && text.charAt(i - 1) != ' ') break;
                    ++fieldSpace;
                    --i;
                }
                if (fieldSpace == 0) {
                    return 1;
                }
                if (fieldSpace < insertText.length()) {
                    insertText = insertText.substring(0, fieldSpace);
                    rc |= 4;
                }
                spacesToDelete = insertText.length();
                if (usingSourceColumns) {
                    String afterText;
                    Object beforeText;
                    if (text.length() < position) {
                        beforeText = text + View.spaces(position - text.length() - 1);
                        afterText = "";
                    } else {
                        beforeText = text.substring(0, position - 1);
                        afterText = text.length() < fieldLimit - fieldSpace ? text.substring(position - 1) : text.substring(position - 1, fieldLimit - fieldSpace);
                    }
                    while (insertText.length() > 0) {
                        int newBytesLen = this.nls().sourceLength((String)beforeText + insertText + afterText);
                        if (newBytesLen <= bytesFieldLimit) {
                            spacesToDelete = newBytesLen - this.nls().sourceLength((String)beforeText + afterText);
                            break;
                        }
                        insertText = insertText.substring(0, insertText.length() - 1);
                        rc |= 4;
                    }
                    if (insertText.length() == 0) {
                        return 1;
                    }
                }
            }
        }
        this._document.undo().recordChange(this, element, position);
        if (spacesToDelete > 0) {
            this.setIgnoreFields();
            String deleted = this.deleteText(element, fieldLimit - spacesToDelete + 1, spacesToDelete, force);
            this.resetIgnoreFields();
            int stylesToDelete = spacesToDelete - deleted.length();
            if (stylesToDelete > 0) {
                int stylesDeleteOffset = fieldLimit - stylesToDelete;
                ElementView elementView = element._firstElementView;
                while (elementView != null) {
                    String style = elementView.style();
                    if (style.length() > stylesDeleteOffset) {
                        StringBuilder buffer = new StringBuilder(style);
                        int i = 0;
                        while (i < stylesToDelete && buffer.length() > stylesDeleteOffset) {
                            buffer.deleteCharAt(stylesDeleteOffset);
                            ++i;
                        }
                        elementView.setStyle(buffer.toString());
                    }
                    elementView = elementView._next;
                }
            }
        }
        int insertLength = insertText.length();
        if (element.length() >= position) {
            this.notifyMarksTextInserted(element, position, insertLength);
            this.block().textInserted(this, element, position, insertLength);
        } else if (position == element.length() + 1) {
            this.block().textInserted(this, element, position, insertLength);
            if (this._replaceText) {
                this.notifyMarksTextReplaced(element, position, insertLength);
            } else {
                this.notifyMarksTextInserted(element, position, insertLength);
            }
        } else {
            this.notifyMarksTextReplaced(element, position, insertLength);
        }
        this.padTextTo(element, position, force);
        StringBuilder buffer = new StringBuilder(element.text());
        buffer.insert(position - 1, insertText);
        boolean sequenceTextChanged = element.setText(this, buffer.toString());
        if (!element.show()) {
            this._document.textInserted(this, element, position, insertLength);
            if (sequenceTextChanged) {
                this._document.seqTextReplaced(this, element);
            }
        }
        ElementView elementView = element._firstElementView;
        while (elementView != null) {
            String style = elementView.style();
            if (style.length() >= position) {
                buffer = new StringBuilder(style);
                int i = 0;
                while (i < insertLength) {
                    buffer.insert(position - 1, '!');
                    ++i;
                }
                elementView.setStyle(buffer.toString());
            }
            elementView = elementView._next;
        }
        this.documentPosition().textInserted(element, position, insertLength);
        this._document.undo().recordPosition(element, position + insertLength);
        return rc;
    }

    boolean insertTextRectangle(String insertText) {
        Element element = this.documentPosition().element();
        if (this.markList().protect(element) || !this.changeAllowed()) {
            return false;
        }
        boolean someInsertDone = false;
        if (element == null && insertText.length() > 0 && insertText.charAt(0) == '\n') {
            element = new Element(this.document());
            if (this.insertElement(element)) {
                someInsertDone = true;
            }
            insertText = insertText.substring(1);
        }
        if (element != null) {
            ElementView elementView = element.elementView(this);
            int pixelPosition = elementView.pixelPosition(this.documentPosition().position());
            int indexOfLineSeparator = insertText.indexOf(10);
            if (indexOfLineSeparator >= 0) {
                this._document.resetUserActionElements();
            }
            if (element.show()) {
                Element nextVisibleNonShow = element.nextVisibleNonShow(this);
                element = nextVisibleNonShow != null && this.markList().protect(nextVisibleNonShow) ? null : nextVisibleNonShow;
                if (element == null && this.insertElement(element = new Element(this.document()))) {
                    someInsertDone = true;
                }
                this.documentPosition().jump(element, this.position(element.elementView(this), pixelPosition));
            }
            while (indexOfLineSeparator >= 0) {
                if ((2 & this.insertText(insertText.substring(0, indexOfLineSeparator))) != 0) {
                    someInsertDone = true;
                }
                insertText = insertText.substring(indexOfLineSeparator + 1);
                Element next = element.nextVisibleNonShow(this);
                if (next != null && !this.markList().protect(next)) {
                    element = next;
                } else {
                    Element newElement = new Element(this.document());
                    if (this.insertElement(newElement)) {
                        someInsertDone = true;
                    }
                    element = newElement;
                }
                this.documentPosition().jump(element, this.position(element.elementView(this), pixelPosition));
                indexOfLineSeparator = insertText.indexOf(10);
            }
            if ((2 & this.insertText(insertText)) != 0) {
                someInsertDone = true;
            }
        }
        return someInsertDone;
    }

    void replaceText(String replaceText) {
        this.replaceText(replaceText, false);
    }

    void replaceText(String replaceText, boolean transparent) {
        this.replaceText(replaceText, transparent, false);
    }

    void replaceText(String replaceText, boolean transparent, boolean checkBounds) {
        Element element = this.documentPosition().element();
        if (element == null || this.markList().protect(element) || !element.show() && !this.changeAllowed()) {
            return;
        }
        int position = this.documentPosition().position();
        checkBounds &= this.getBoundsStartCol() > 0 && this.getBoundsEndCol() > 0;
        boolean newLines = false;
        int i = 0;
        while (i < replaceText.length()) {
            if (replaceText.charAt(i) == '\n' || replaceText.charAt(i) == '\r') {
                newLines = true;
                break;
            }
            ++i;
        }
        if (newLines) {
            this._document.resetUserActionElements();
            String text = element.text();
            if (text.length() >= position) {
                this.deleteText(text.length() - position + 1);
            }
            this.insertText(replaceText);
            return;
        }
        this._document.undo().recordChange(this, element, 1);
        String text = element.text();
        if (text.length() < position) {
            this.block().setIgnoreTextInserted();
            this._replaceText = true;
            this.insertText(replaceText);
            this._replaceText = false;
            this.block().resetIgnoreTextInserted();
        } else {
            this.notifyMarksTextReplaced(element, position, replaceText.length());
            if (transparent) {
                String originalText = text.substring(position - 1);
                if (checkBounds) {
                    originalText = text.substring(position, Math.min(this.getBoundsEndCol(), originalText.length()));
                }
                StringBuilder buffer = new StringBuilder(replaceText);
                int i2 = 0;
                while (i2 < buffer.length() && i2 < originalText.length()) {
                    if (originalText.charAt(i2) != ' ') {
                        buffer.setCharAt(i2, originalText.charAt(i2));
                    }
                    ++i2;
                }
                replaceText = buffer.toString();
            }
            StringBuilder newText = new StringBuilder(text.length());
            if (position > 1) {
                newText.append(text.substring(0, position - 1));
            }
            newText.append(replaceText);
            if (text.length() > newText.length()) {
                newText.append(text.substring(newText.length()));
            }
            boolean sequenceTextChanged = element.setText(this, newText.toString());
            if (!element.show()) {
                int replaceLength = text.length() - position + 1;
                if (replaceText.length() < replaceLength) {
                    replaceLength = replaceText.length();
                }
                this._document.textReplaced(this, element, position, replaceLength);
                int insertLength = position + replaceText.length() - 1 - text.length();
                if (insertLength > 0) {
                    this._document.textInserted(this, element, text.length() + 1, insertLength);
                }
                if (sequenceTextChanged) {
                    this._document.seqTextReplaced(this, element);
                }
            }
            ElementView elementView = element._firstElementView;
            while (elementView != null) {
                String style = elementView.style();
                if (style.length() >= position) {
                    StringBuilder buffer = new StringBuilder(style.length());
                    if (position > 1) {
                        buffer.append(style.substring(0, position - 1));
                    }
                    int i3 = 0;
                    while (i3 < replaceText.length()) {
                        buffer.append('!');
                        ++i3;
                    }
                    if (style.length() > buffer.length()) {
                        buffer.append(style.substring(buffer.length()));
                    }
                    elementView.setStyle(buffer.toString());
                }
                elementView = elementView._next;
            }
            this.documentPosition().right(replaceText.length());
        }
        this._document.undo().recordPosition(this);
    }

    public int getFieldLimit(int position, Element element) {
        int[] fields = this.currentFields(element);
        int fieldLimit = 0;
        if (fields != null) {
            String text = element.text();
            boolean usingSourceColumns = this.nls().usingSourceColumns();
            int bytesPosition = position;
            if (usingSourceColumns) {
                bytesPosition = this.nls().encodingIndex(text, position - 1) + 1;
            }
            if ((fieldLimit = this.fieldLimit(fields, bytesPosition)) != 0) {
                int bytesFieldLimit = fieldLimit;
                if (usingSourceColumns) {
                    fieldLimit = LpexNls.indexFromEncodingIndex(text, bytesFieldLimit, this.nls().getSourceEncoding(), SourceCcsidParameter.getParameter().currentValue(this));
                }
            }
        }
        return fieldLimit;
    }

    boolean clearColumns7380NoNotify(Element element, boolean usingSourceColumns) {
        String text = element.text();
        int position = 73;
        if (usingSourceColumns) {
            position = this._nls.indexFromEncodingIndex(text, 72);
            if (LpexNls.isLigature(text, position - 1)) {
                ++position;
            }
            if (LpexNls.isBidiMark(text.charAt(position))) {
                ++position;
            }
            ++position;
        }
        if (text.length() < position) {
            return false;
        }
        this._document.undo().recordChange(this, element, position);
        String replaceText = "        ";
        this.notifyMarksTextReplaced(element, position, replaceText.length());
        StringBuilder newText = new StringBuilder(text.length());
        newText.append(text.substring(0, position - 1));
        newText.append(replaceText);
        if (text.length() > newText.length()) {
            newText.append(text.substring(newText.length()));
        }
        element.setText(this, newText.toString(), false);
        return true;
    }

    String deleteText(int len) {
        return this.deleteText(this.documentPosition().element(), this.documentPosition().position(), len, false, true);
    }

    String deleteText(Element element, int position) {
        return this.deleteText(element, position, 1, false, true);
    }

    String deleteText(Element element, int position, int len) {
        return this.deleteText(element, position, len, false, true);
    }

    String deleteText(Element element, int position, int len, boolean force) {
        return this.deleteText(element, position, len, force, true);
    }

    String deleteText(Element element, int position, int len, boolean force, boolean maintainSequenceText) {
        if (element == null) {
            return "";
        }
        String deleteText = "";
        if (force || !this.markList().protect(element) && (element.show() || this.changeAllowed())) {
            Object newText;
            int[] fields;
            int positionNext;
            if (len == 1 && (positionNext = DisplayTextLayout.getClusterOffsetNext(element.text(), position - 1) + 1) - position > 1) {
                len = positionNext - position;
            }
            this.documentPosition().textDeleted(element, position, len);
            if (element.length() < position) {
                return "";
            }
            if (position + len - 1 > element.length()) {
                len = element.length() - position + 1;
            }
            if (!this.ignoreFields() && (fields = this.currentFields(element)) != null) {
                this.deleteTextPadField(element, fields, position, len);
            }
            this.notifyMarksTextDeleted(element, position, len);
            this.block().textDeleted(this, element, position, len);
            boolean easyDelete = true;
            if (!element.show()) {
                ElementList elementList = this.document().elementList();
                boolean bl = easyDelete = elementList.sequenceNumbersWidth() == 0 || elementList.sequenceNumbersColumn() == 1;
                if (easyDelete) {
                    this._document.textRemoved(this, element, position, len);
                }
            }
            this._document.undo().recordChange(this, element, position);
            String text = element.text();
            Object object = newText = position > 1 ? text.substring(0, position - 1) : "";
            if (position + len - 1 < text.length()) {
                newText = (String)newText + text.substring(position + len - 1);
                deleteText = text.substring(position - 1, position + len - 1);
            } else {
                deleteText = text.substring(position - 1);
            }
            boolean sequenceTextChanged = element.setText(this, (String)newText, maintainSequenceText);
            ElementView elementView = element._firstElementView;
            while (elementView != null) {
                String style = elementView.style();
                if (style.length() >= position) {
                    StringBuilder buffer = new StringBuilder(style.length());
                    if (position > 1) {
                        buffer.append(style.substring(0, position - 1));
                    }
                    if (position + len < style.length()) {
                        buffer.append(style.substring(position + len - 1));
                    }
                    elementView.setStyle(buffer.toString());
                }
                elementView = elementView._next;
            }
            this._document.undo().recordPosition(element, position);
            if (!element.show()) {
                if (!easyDelete) {
                    this._document.elementReplaced(this, element);
                } else if (sequenceTextChanged) {
                    this._document.seqTextReplaced(this, element);
                }
            }
        }
        return deleteText;
    }

    private void deleteTextPadField(Element element, int[] fields, int position, int len) {
        String text = element.text();
        int endDeletePos = position + len - 1;
        int blanks = len;
        boolean ignoringBidiMarks = this.nls().isIgnoringBidiMarks();
        if (ignoringBidiMarks && (blanks = this.nls().sourceLength(text.substring(position - 1, endDeletePos))) == 0) {
            return;
        }
        boolean usingSourceColumns = this.nls().usingSourceColumns();
        int startDeletePos = position;
        if (usingSourceColumns) {
            startDeletePos = this.nls().sourceLength(text.substring(0, startDeletePos - 1)) + 1;
            endDeletePos = this.nls().sourceLength(text.substring(0, endDeletePos));
        }
        this.skipFields(fields, startDeletePos, endDeletePos);
        int fieldLimit = this.fieldLimit(fields, endDeletePos);
        if (fieldLimit == 0) {
            return;
        }
        if (usingSourceColumns) {
            int bytesFieldLimit = fieldLimit;
            fieldLimit = LpexNls.indexFromEncodingIndex(text, bytesFieldLimit, this.nls().getSourceEncoding(), SourceCcsidParameter.getParameter().currentValue(this));
            blanks = text.length() > fieldLimit ? bytesFieldLimit - this.nls().sourceLength(text.substring(0, position - 1) + text.substring(position + len - 1, fieldLimit)) : bytesFieldLimit - this.nls().sourceLength(text.substring(0, position - 1) + text.substring(position + len - 1)) - (fieldLimit - text.length());
        }
        if (blanks <= 0) {
            return;
        }
        if (text.length() > fieldLimit) {
            this.setIgnoreFields();
            this.insertText(element, fieldLimit + 1, View.spaces(blanks), true);
            this.resetIgnoreFields();
        } else {
            ElementView elementView = element._firstElementView;
            while (elementView != null) {
                String style = elementView.style();
                if (style.length() > fieldLimit) {
                    StringBuilder buffer = new StringBuilder(style);
                    int i = 0;
                    while (i < blanks) {
                        buffer.insert(fieldLimit, '!');
                        ++i;
                    }
                    elementView.setStyle(buffer.toString());
                }
                elementView = elementView._next;
            }
        }
    }

    private void deleteTextForTrim(Element element, int position, int len) {
        boolean easyDelete;
        if (this._readonly || this.markList().protect(element)) {
            return;
        }
        this.documentPosition().textDeleted(element, position, len);
        this.notifyMarksTextDeleted(element, position, len);
        this.block().textDeleted(this, element, position, len);
        ElementList elementList = this.document().elementList();
        boolean bl = easyDelete = elementList.sequenceNumbersWidth() == 0 || elementList.sequenceNumbersColumn() == 1;
        if (easyDelete) {
            this._document.textRemoved(this, element, position, len);
        } else if (elementList.sequenceNumbersWidth() != 0) {
            int textLength = LpexNls.usingSourceColumns(this._document) ? LpexNls.sourceLength(element.text(), this._document) : element.length();
            easyDelete = elementList.sequenceNumbersColumn() > textLength;
        }
        this._document.undo().recordChange(this, element, position);
        element.setText(this, position > 1 ? element.text().substring(0, position - 1) : "", false);
        ElementView elementView = element._firstElementView;
        while (elementView != null) {
            String style = elementView.style();
            if (style.length() >= position) {
                elementView.setStyle(position > 1 ? style.substring(0, position - 1) : "");
            }
            elementView = elementView._next;
        }
        this._document.undo().recordPosition(element, position);
        if (!easyDelete) {
            this._document.elementReplaced(this, element);
        }
    }

    private boolean deleteTextForTrimNoNotify(Element element, int position, int len) {
        this.documentPosition().textDeleted(element, position, len);
        this.notifyMarksTextDeleted(element, position, len);
        this.block().textDeleted(this, element, position, len);
        this._document.undo().recordChange(this, element, position);
        element.setText(this, position > 1 ? element.text().substring(0, position - 1) : "", false);
        return true;
    }

    String deleteText(Element element1, int position1, Element element2, int position2) {
        StringBuilder deleteText = new StringBuilder();
        if (element1 != null && element2 != null && this.changeAllowed()) {
            Element topElement = null;
            Element bottomElement = null;
            int topPosition = 0;
            int bottomPosition = 0;
            if (element1 == element2) {
                topElement = bottomElement = element1;
                if (position1 > position2) {
                    topPosition = position2;
                    bottomPosition = position1;
                } else {
                    topPosition = position1;
                    bottomPosition = position2;
                }
            } else {
                ElementList elementList = this.document().elementList();
                if (elementList.ordinalOf(element1) > elementList.ordinalOf(element2)) {
                    topElement = element2;
                    topPosition = position2;
                    bottomElement = element1;
                    bottomPosition = position1;
                } else {
                    topElement = element1;
                    topPosition = position1;
                    bottomElement = element2;
                    bottomPosition = position2;
                }
            }
            if (topElement == bottomElement) {
                int len;
                if (!topElement.show() && !this.markList().protect(topElement) && (len = bottomPosition - topPosition) > 0) {
                    deleteText.append(this.deleteText(topElement, topPosition, len));
                }
            } else {
                boolean join = true;
                if (!topElement.show() && !this.markList().protect(topElement)) {
                    if (topElement.length() >= topPosition) {
                        deleteText.append(this.deleteText(topElement, topPosition, topElement.length() - topPosition + 1));
                    } else {
                        this.padTextTo(topElement, topPosition);
                    }
                    deleteText.append('\n');
                } else {
                    join = false;
                }
                Element element = topElement.next();
                Element next = null;
                while (element != bottomElement && element != null) {
                    next = element.next();
                    if (element.visible(this) && !this.markList().protect(element)) {
                        element.setDeletePending(true);
                    } else {
                        join = false;
                    }
                    element = next;
                }
                boolean forceAllVisible = this.setForceAllVisible(true);
                element = topElement.next();
                next = null;
                while (element != bottomElement && element != null) {
                    next = element.next();
                    if (element.deletePending()) {
                        element.setDeletePending(false);
                        if (!element.show()) {
                            deleteText.append(element.text() + "\n");
                        }
                        this.deleteElement(element);
                    }
                    element = next;
                }
                this.setForceAllVisible(forceAllVisible);
                if (!bottomElement.show() && !this.markList().protect(element)) {
                    int len = bottomPosition - 1;
                    if (len > 0) {
                        deleteText.append(this.deleteText(bottomElement, 1, len));
                    }
                } else {
                    join = false;
                }
                if (join) {
                    this.screen().build();
                    this.joinElements(topElement, bottomElement);
                }
            }
        }
        return deleteText.toString();
    }

    void padTextTo(Element element, int position) {
        this.padTextTo(element, position, false);
    }

    private void padTextTo(Element element, int position, boolean force) {
        if (element != null && (force || !this.markList().protect(element) && (element.show() || this.changeAllowed()))) {
            String text = element.text();
            if (position > 1 && text.length() < position - 1) {
                this._document.undo().recordChange(this, element, position);
                StringBuilder buffer = new StringBuilder(text);
                int originalLength = text.length();
                buffer.setLength(position - 1);
                int i = originalLength;
                while (i < position - 1) {
                    buffer.setCharAt(i, ' ');
                    ++i;
                }
                boolean sequenceTextChanged = element.setText(this, buffer.toString());
                if (!element.show()) {
                    this._document.textInserted(this, element, originalLength + 1, position - originalLength - 1);
                    if (sequenceTextChanged) {
                        this._document.seqTextReplaced(this, element);
                    }
                }
            }
        }
    }

    void toTitleCase() {
        Element element = this.documentPosition().element();
        if (element == null || this.markList().protect(element)) {
            return;
        }
        if (!element.show() && !this.changeAllowed()) {
            return;
        }
        String text = element.text();
        int position = this.documentPosition().position();
        if (position > text.length()) {
            return;
        }
        char ch = text.charAt(position - 1);
        int len = 1;
        char newCh = Character.toTitleCase(ch);
        if (newCh == ch) {
            return;
        }
        this._document.undo().recordChange(this, element, position);
        this.notifyMarksTextReplaced(element, position, len);
        StringBuilder buffer = new StringBuilder(text);
        buffer.setCharAt(position - 1, newCh);
        boolean sequenceTextChanged = element.setText(this, buffer.toString());
        if (!element.show()) {
            this._document.textReplaced(this, element, position, len);
            if (sequenceTextChanged) {
                this._document.seqTextReplaced(this, element);
            }
        }
    }

    void changeCase(int len, boolean upperCase) {
        this.changeCase(this.documentPosition().element(), this.documentPosition().position(), len, upperCase);
    }

    void changeCase(Element element, boolean upperCase) {
        this.changeCase(element, 1, upperCase);
    }

    void changeCase(Element element, int position, boolean upperCase) {
        if (element != null) {
            this.changeCase(element, position, element.end() - position, upperCase);
        }
    }

    void changeCase(Element element, int position, int len, boolean upperCase) {
        String newString;
        if (element == null || len <= 0 || this.markList().protect(element)) {
            return;
        }
        if (!element.show() && !this.changeAllowed()) {
            return;
        }
        String text = element.text();
        if (position > text.length()) {
            return;
        }
        if (position + len - 1 > text.length()) {
            len = text.length() - position + 1;
        }
        String orgString = text.substring(position - 1, position - 1 + len);
        String string = newString = upperCase ? orgString.toUpperCase() : orgString.toLowerCase();
        if (orgString.equals(newString)) {
            return;
        }
        this._document.undo().recordChange(this, element, position);
        String newText = text.substring(0, position - 1) + newString + text.substring(position - 1 + len);
        this.notifyMarksTextReplaced(element, position, len);
        boolean sequenceTextChanged = element.setText(this, newText);
        if (element.show()) {
            return;
        }
        if (len == newString.length()) {
            this._document.textReplaced(this, element, position, len);
            if (sequenceTextChanged) {
                this._document.seqTextReplaced(this, element);
            }
        } else {
            this._document.elementReplaced(this, element);
        }
    }

    void changeCase(Element element1, int position1, Element element2, int position2, boolean upperCase) {
        this.changeCase(element1, position1, element2, position2, upperCase, false);
    }

    void changeCase(Element element1, int position1, Element element2, int position2, boolean upperCase, boolean rectangle) {
        if (element1 == null || element2 == null || !this.changeAllowed()) {
            return;
        }
        Element topElement = null;
        Element bottomElement = null;
        int topPosition = 0;
        int bottomPosition = 0;
        if (element1 == element2) {
            topElement = bottomElement = element1;
            if (position1 > position2) {
                topPosition = position2;
                bottomPosition = position1;
            } else {
                topPosition = position1;
                bottomPosition = position2;
            }
        } else {
            ElementList elementList = this.document().elementList();
            if (elementList.ordinalOf(element1) > elementList.ordinalOf(element2)) {
                topElement = element2;
                topPosition = position2;
                bottomElement = element1;
                bottomPosition = position1;
            } else {
                topElement = element1;
                topPosition = position1;
                bottomElement = element2;
                bottomPosition = position2;
            }
        }
        int left = 0;
        int right = 0;
        if (rectangle) {
            int leftBottom;
            int leftTop = topElement.elementView(this).pixelPosition(topPosition);
            left = leftTop < (leftBottom = bottomElement.elementView(this).pixelPosition(bottomPosition)) ? leftTop : leftBottom;
            int rightTop = topElement.elementView(this).pixelCharPosition(topPosition + 1) - 1;
            int rightBottom = bottomElement.elementView(this).pixelCharPosition(bottomPosition + 1) - 1;
            right = rightBottom > rightTop ? rightBottom : rightTop;
        }
        Element lastElement = bottomElement.next();
        Element element = topElement;
        while (element != lastElement) {
            if (!element.show() && element.visible(this)) {
                if (rectangle) {
                    ElementView elementView = element.elementView(this);
                    int leftPosition = this.position(elementView, left);
                    int rightPosition = this.position(elementView, right);
                    this.changeCase(element, leftPosition, rightPosition - leftPosition + 1, upperCase);
                } else if (element == topElement && element == bottomElement) {
                    len = bottomPosition - topPosition;
                    this.changeCase(element, topPosition, len, upperCase);
                } else if (element == topElement) {
                    this.changeCase(element, topPosition, upperCase);
                } else if (element == bottomElement) {
                    len = bottomPosition - 1;
                    this.changeCase(element, 1, len, upperCase);
                } else {
                    this.changeCase(element, upperCase);
                }
            }
            element = element.next();
        }
    }

    void fill(Element element, String fillString) {
        this.fill(element, 1, fillString);
    }

    void fill(Element element, int position, String fillString) {
        if (element != null) {
            this.fill(element, position, element.end() - position, fillString);
        }
    }

    void fill(Element element, int position, int len, String fillString) {
        int fillLen;
        int n = fillLen = fillString != null ? fillString.length() : 0;
        if (fillLen > 0 && len > 0 && element != null && !this.markList().protect(element) && (element.show() || this.changeAllowed())) {
            StringBuilder buffer = new StringBuilder(element.text());
            int originalLength = buffer.length();
            if (originalLength < position + len - 1) {
                buffer.setLength(position + len - 1);
                int i = originalLength;
                while (i < position - 1) {
                    buffer.setCharAt(i, ' ');
                    ++i;
                }
            }
            int j = 0;
            int i = position - 1;
            while (i < position + len - 1) {
                buffer.setCharAt(i, fillString == null ? (char)' ' : fillString.charAt(j++));
                if (j >= fillLen) {
                    j = 0;
                }
                ++i;
            }
            this._document.undo().recordChange(this, element, position);
            boolean sequenceTextChanged = element.setText(this, buffer.toString());
            if (!element.show()) {
                if (originalLength < position + len - 1) {
                    if (originalLength >= position) {
                        this._document.textReplaced(this, element, position, originalLength + 1 - position);
                    }
                    this._document.textInserted(this, element, originalLength + 1, position + len - 1 - originalLength);
                } else {
                    this._document.textReplaced(this, element, position, len);
                }
                if (sequenceTextChanged) {
                    this._document.seqTextReplaced(this, element);
                }
            }
        }
    }

    void shift(Element element, int position, int count) {
        if (element != null && count != 0 && element.length() >= position && !this.markList().protect(element) && (element.show() || this.changeAllowed())) {
            if (count > 0) {
                this.insertText(element, position, View.spaces(count));
            } else {
                if ((position -= (count = -count)) <= 0) {
                    position = 1;
                }
                this.deleteText(element, position, count);
            }
        }
    }

    void shiftElement(Element element, int count, boolean truncate) {
        this.shiftElement(element, count, truncate, false);
    }

    void shiftElement(Element element, int count, boolean truncate, boolean checkBounds) {
        checkBounds &= this.getBoundsStartCol() > 0 && this.getBoundsEndCol() > 0;
        if (element != null && count != 0 && element.length() > 0 && !this.markList().protect(element) && (element.show() || this.changeAllowed())) {
            if (count > 0) {
                if (!truncate) {
                    if (checkBounds) {
                        String lineText = element.text();
                        if (this.getBoundsStartCol() < lineText.length()) {
                            int start = Math.min(this.getBoundsEndCol(), lineText.length());
                            while (lineText.charAt(start - 1) == ' ' && start > this.getBoundsStartCol()) {
                                --start;
                            }
                            if (this.getBoundsEndCol() - start < count) {
                                count = this.getBoundsEndCol() - start;
                            }
                        }
                    } else {
                        int spaceAtEnd;
                        int textLimit = this._document.elementList().textLimit();
                        if (textLimit > 0 && count > (spaceAtEnd = textLimit - this._document.elementList().saveLength(element, true))) {
                            count = spaceAtEnd;
                        }
                    }
                }
                if (count > 0) {
                    this.setIgnoreFields();
                    if (checkBounds) {
                        this.insertText(element, this.getBoundsStartCol(), View.spaces(count));
                        this.deleteText(element, this.getBoundsEndCol() + 1, count);
                    } else {
                        this.insertText(element, 1, View.spaces(count));
                    }
                    this.resetIgnoreFields();
                }
            } else {
                count = -count;
                if (!truncate) {
                    if (checkBounds) {
                        String lineText = element.text();
                        if (this.getBoundsStartCol() < lineText.length()) {
                            int adjustedRight = Math.min(this.getBoundsEndCol(), lineText.length());
                            int start = this.getBoundsStartCol();
                            while (lineText.charAt(start - 1) == ' ' && start < adjustedRight) {
                                ++start;
                            }
                            if (start - this.getBoundsStartCol() < count) {
                                count = start - this.getBoundsStartCol();
                            }
                        }
                    } else {
                        String text = element.text();
                        int spaceAtStart = 0;
                        int i = 0;
                        while (i < text.length() && text.charAt(i) == ' ') {
                            ++spaceAtStart;
                            ++i;
                        }
                        if (count > spaceAtStart) {
                            count = spaceAtStart;
                        }
                    }
                }
                if (count > 0) {
                    this.setIgnoreFields();
                    if (checkBounds) {
                        this.insertText(element, this.getBoundsEndCol() + 1, View.spaces(count));
                        this.deleteText(element, this.getBoundsStartCol(), count);
                    } else {
                        this.deleteText(element, 1, count);
                    }
                    this.resetIgnoreFields();
                }
            }
        }
    }

    void insertPrefixText(String insertText) {
        Element element = this.documentPosition().element();
        if (element != null && insertText != null && insertText.length() > 0) {
            int position = this.documentPosition().prefixPosition();
            ElementView elementView = element.elementView(this);
            Object prefixText = elementView.prefixText();
            if (prefixText == null) {
                prefixText = "";
            }
            if (position > ((String)prefixText).length() + 1) {
                position = ((String)prefixText).length() + 1;
            }
            prefixText = ((String)prefixText).substring(0, position - 1) + insertText + ((String)prefixText).substring(position - 1);
            elementView.setPrefixText((String)prefixText);
            this.documentPosition().prefixTextInserted(element, position, insertText.length());
        }
    }

    void replacePrefixText(String replaceText) {
        Element element = this.documentPosition().element();
        if (element != null && replaceText.length() > 0) {
            this.deletePrefixText(replaceText.length());
            this.insertPrefixText(replaceText);
        }
    }

    void deletePrefixText(int len) {
        Element element = this.documentPosition().element();
        if (element != null && len > 0) {
            ElementView elementView = element.elementView(this);
            Object prefixText = elementView.prefixText();
            int position = this.documentPosition().prefixPosition();
            if (prefixText != null && position <= ((String)prefixText).length()) {
                if (position + len - 1 > ((String)prefixText).length()) {
                    len = ((String)prefixText).length() - (position - 1);
                }
                prefixText = ((String)prefixText).substring(0, position - 1) + ((String)prefixText).substring(position + len - 1);
                elementView.setPrefixText((String)prefixText);
                this.documentPosition().prefixTextDeleted(element, position, len);
            }
        }
    }

    void deleteElement(Element element) {
        if (element != null && !this.markList().protect(element) && (element.show() || this.changeAllowed())) {
            Element prev = element.prev();
            Element next = element.next();
            this._document.undo().recordDelete(this, element);
            this._document.elementList().remove(this, element);
            this._document.undo().recordPosition(prev != null ? prev : next, 1);
        }
    }

    boolean insertElement(Element element) {
        if (element != null && !this.markList().insertElementProtect(this.documentPosition().element()) && (element.show() || this.changeAllowed())) {
            this._document.undo().recordInsert(this, element);
            this._document.elementList().addAfter(this, this.documentPosition().element(), element);
            this._document.undo().recordPosition(element, element.end());
            this.documentPosition().jump(element, element.end(), true, false);
            return true;
        }
        return false;
    }

    void insertShowElement(Element element, Element showElement) {
        if (element != null && showElement != null) {
            this._document.elementList().addAfter(this, element, showElement);
        }
    }

    void insertElement(Element element, boolean force) {
        if (!force) {
            this.insertElement(element);
            return;
        }
        if (element != null) {
            this._document.undo().recordInsert(this, element);
            this._document.elementList().addAfter(this, this.documentPosition().element(), element);
            this._document.undo().recordPosition(element, element.end());
            this.documentPosition().jump(element, element.end());
        }
    }

    void insertElementBefore(Element element) {
        if (element != null && !this.markList().insertElementBeforeProtect(this.documentPosition().element()) && (element.show() || this.changeAllowed())) {
            this._document.undo().recordInsert(this, element);
            this._document.elementList().addBefore(this, this.documentPosition().element(), element);
            this._document.undo().recordPosition(element, element.end());
            this.documentPosition().jump(element, element.end());
        }
    }

    void joinElements(Element element1, Element element2) {
        if (element1 == null || element2 == null) {
            return;
        }
        if (!(this.markList().protect(element1) || this.markList().protect(element2) || element1.show() || element2.show() || !this.changeAllowed())) {
            this._document.resetUserActionElements();
            this.markList().joinElements(element1, element2);
            this.markList().setIgnoreChanges(true);
            this.documentPosition().joinElements(element1, element2);
            this.documentPosition().setIgnoreChanges(true);
            this._document.resetUserActionElements();
            String text = element2.text();
            int position = element1.end();
            this.setIgnoreFields();
            this.insertText(element1, position, text);
            this.resetIgnoreFields();
            this.deleteElement(element2);
            this._document.undo().recordPosition(element1, position);
            this.documentPosition().setIgnoreChanges(false);
            this.markList().setIgnoreChanges(false);
        }
    }

    boolean splitElement() {
        Element element = this.documentPosition().element();
        if (element != null && !this.markList().insertElementProtect(element) && this.changeAllowed()) {
            boolean realSplit;
            boolean bl = realSplit = !element.show() && !this.markList().protect(element);
            if (!realSplit) {
                this.documentPosition().end();
            }
            int position = this.documentPosition().position();
            this._document.resetUserActionElements();
            this.markList().setIgnoreChanges(true);
            this.documentPosition().setIgnoreChanges(true);
            Element newElement = new Element(this._document);
            String text = element.text();
            if (text.length() >= position) {
                newElement.setText(this, text.substring(position - 1));
                this.setIgnoreFields();
                this.deleteText(element, position, text.length() - position + 1);
                this.resetIgnoreFields();
            }
            this.insertElement(newElement);
            if (realSplit) {
                this._document.undo().recordPosition(element, position);
            } else {
                this._document.undo().recordPosition(newElement, 1);
            }
            this.documentPosition().setIgnoreChanges(false);
            this.documentPosition().splitElement(element, position);
            this.markList().setIgnoreChanges(false);
            this.markList().splitElement(element, position);
            return true;
        }
        return false;
    }

    void splitElement(boolean force) {
        if (!force) {
            this.splitElement();
            return;
        }
        Element element = this.documentPosition().element();
        if (element != null) {
            boolean realSplit;
            boolean bl = realSplit = !element.show();
            if (!realSplit) {
                this.documentPosition().end();
            }
            int position = this.documentPosition().position();
            this._document.resetUserActionElements();
            this.markList().setIgnoreChanges(true);
            this.documentPosition().setIgnoreChanges(true);
            Element newElement = new Element(this._document);
            String text = element.text();
            if (text.length() >= position) {
                newElement.setText(this, text.substring(position - 1));
                this.setIgnoreFields();
                this.deleteText(element, position, text.length() - position + 1, true);
                this.resetIgnoreFields();
            }
            this.insertElement(newElement, true);
            if (realSplit) {
                this._document.undo().recordPosition(element, position);
            } else {
                this._document.undo().recordPosition(newElement, 1);
            }
            this.documentPosition().setIgnoreChanges(false);
            this.documentPosition().splitElement(element, position);
            this.markList().setIgnoreChanges(false);
            this.markList().splitElement(element, position);
        }
    }

    void overlayRectangle(String overlayText) {
        this.overlayRectangle(overlayText, false);
    }

    void overlayRectangle(String overlayText, boolean transparent) {
        if (overlayText.length() <= 0) {
            return;
        }
        Element element = this.documentPosition().element();
        if (element != null && (element.show() || this.markList().protect(element)) || !this.changeAllowed()) {
            return;
        }
        this._document.resetUserActionElements();
        if (element == null) {
            element = new Element(this.document());
            this.insertElement(element);
        }
        int pixelPosition = element.elementView(this).pixelPosition(this.documentPosition().position());
        int indexOfLineSeparator = overlayText.indexOf(10);
        while (indexOfLineSeparator >= 0) {
            this.replaceText(overlayText.substring(0, indexOfLineSeparator), transparent);
            overlayText = overlayText.substring(indexOfLineSeparator + 1);
            Element next = element.nextVisibleNonShow(this);
            if (next != null && !this.markList().protect(next)) {
                element = next;
            } else {
                Element newElement = new Element(this.document());
                this.insertElement(newElement);
                element = newElement;
            }
            this.documentPosition().jump(element, this.position(element.elementView(this), pixelPosition));
            indexOfLineSeparator = overlayText.indexOf(10);
        }
        this.replaceText(overlayText, transparent);
    }

    Element overlayElements(String overlayText) {
        return this.overlayElements(overlayText, false, -1);
    }

    Element overlayElements(String overlayText, boolean transparent) {
        return this.overlayElements(overlayText, transparent, -1);
    }

    Element overlayElements(String overlayText, boolean transparent, boolean checkBounds) {
        return this.overlayElements(overlayText, transparent, -1, checkBounds);
    }

    Element overlayElements(String overlayText, boolean transparent, int maxElements) {
        return this.overlayElements(overlayText, transparent, maxElements, false);
    }

    Element overlayElements(String overlayText, boolean transparent, int maxElements, boolean checkBounds) {
        Element element = this.documentPosition().element();
        if (element == null || element.show() || maxElements == 0 || this.markList().protect(element) || !this.changeAllowed()) {
            return element;
        }
        this._document.resetUserActionElements();
        if (overlayText == null) {
            overlayText = "";
        }
        this.setIgnoreFields();
        if (checkBounds &= this.getBoundsStartCol() > 0 && this.getBoundsEndCol() > 0) {
            this.documentPosition().jump(this.getBoundsStartCol());
        } else {
            this.documentPosition().goHome();
        }
        int indexOfLineSeparator = overlayText.indexOf(10);
        while (indexOfLineSeparator >= 0) {
            String elementOverlayText = overlayText.substring(0, indexOfLineSeparator);
            overlayText = overlayText.substring(indexOfLineSeparator + 1);
            if (checkBounds && this.getBoundsStartCol() < elementOverlayText.length()) {
                elementOverlayText = elementOverlayText.substring(this.getBoundsStartCol() - 1, Math.min(this.getBoundsEndCol(), elementOverlayText.length()));
            }
            if (transparent) {
                this.replaceText(elementOverlayText, true);
            } else {
                this.deleteText(element.length());
                this.insertText(elementOverlayText);
            }
            Element next = element.nextVisibleNonShow(this);
            if (maxElements != -1 && --maxElements == 0) {
                this.resetIgnoreFields();
                return next;
            }
            if (next != null && !this.markList().protect(next)) {
                element = next;
            } else {
                element = new Element(this.document());
                this.insertElement(element);
            }
            if (checkBounds) {
                this.documentPosition().jump(element, this.getBoundsStartCol());
            } else {
                this.documentPosition().jump(element, 1);
            }
            indexOfLineSeparator = overlayText.indexOf(10);
        }
        if (transparent) {
            if (checkBounds) {
                overlayText = overlayText.substring(this.getBoundsStartCol() - 1, Math.min(this.getBoundsEndCol(), overlayText.length()));
            }
            this.replaceText(overlayText, true);
        } else {
            this.deleteText(element.length());
            this.insertText(overlayText);
        }
        this.resetIgnoreFields();
        return element.nextVisibleNonShow(this);
    }

    String delete(int count) {
        StringBuilder deleteText = new StringBuilder();
        if (this.changeAllowed() && !this.tryToDeleteStreamBlock()) {
            int i = 0;
            while (i < count) {
                Element element = this.documentPosition().element();
                if (element != null && !element.show() && !this.markList().protect(element)) {
                    int position = this.documentPosition().position();
                    if (position <= element.length()) {
                        deleteText.append(this.deleteText(element, position));
                    } else {
                        Element nextElement = element.nextVisibleNonShow(this);
                        if (nextElement != null && !nextElement.show() && !this.markList().protect(nextElement)) {
                            this.padTextTo(element, position);
                            this.joinElements(element, nextElement);
                            deleteText.append('\n');
                        }
                    }
                }
                ++i;
            }
        }
        return deleteText.toString();
    }

    String backSpace(int count) {
        Object deleteText = "";
        if (this.changeAllowed() && !this.tryToDeleteStreamBlock()) {
            int i = 0;
            while (i < count) {
                Element element = this.documentPosition().element();
                if (element != null && !element.show() && !this.markList().protect(element)) {
                    if (this.documentPosition().position() > 1) {
                        this.documentPosition().left();
                        deleteText = this.deleteText(element, this.documentPosition().position(), 1) + (String)deleteText;
                    } else {
                        Element prevElement = element.prevVisibleNonShow(this);
                        if (prevElement != null) {
                            this.joinElements(prevElement, element);
                            deleteText = "\n" + (String)deleteText;
                        }
                    }
                }
                ++i;
            }
        }
        return deleteText;
    }

    void beginUserAction() {
        this.beginUserAction(0);
    }

    void beginUserAction(int actionId) {
        this.endUserAction();
        this._userActionElement = this.documentPosition().element();
        this._screen.resetNewMessage();
        this._actionHandler.setUserActionId(actionId);
    }

    void endUserAction() {
        if (this._userActionElement == null || this._userActionElement != this.documentPosition().element()) {
            this.ensureOneElement();
            this._document.resetUserActionElements();
            this._document.parse();
            if (this.ensureOneElement()) {
                this._document.parse();
            }
            if (this._autoCheck) {
                this._document.undo().check(this);
            }
            if (!this._screen.newMessage()) {
                this._screen.setMessageText(null);
            }
        }
    }

    private boolean ensureOneElement() {
        if (this._document.elementList().count() == 0) {
            this.insertElement(new Element(this._document));
            return true;
        }
        return false;
    }

    void endUserActionKey() {
        if (this._userActionElement == null || this._userActionElement != this.documentPosition().element()) {
            this.endUserAction();
        } else if (ParseAfterEveryKeyParameter.getParameter().currentValue(this)) {
            this.ensureIsParsed();
        }
    }

    void resetUserActionElement() {
        if (this._userActionElement != null) {
            this._userActionElement = null;
            if (this._autoCheck) {
                this._document.undo().check(this);
            }
        }
    }

    void verifyUserActionElement(Element element) {
        if (this._userActionElement != null && element != this._userActionElement) {
            this._document.resetUserActionElements();
        }
    }

    void get(String fileName, String encoding) {
        boolean forceAllVisible;
        block26: {
            CommandHandler.setStatus(null);
            Element element = this.documentPosition().element();
            if (element == null) {
                return;
            }
            boolean first = true;
            if (element.show()) {
                if (this.markList().insertElementProtect(element)) {
                    return;
                }
                first = false;
            } else if (this.markList().protect(element)) {
                return;
            }
            if (!this.changeAllowed()) {
                return;
            }
            forceAllVisible = this.setForceAllVisible(true);
            this.setIgnoreFields();
            BufferedReader bufferedReader = null;
            try {
                String text;
                this._document.resetUserActionElements();
                File f = new File(fileName);
                if ("".equals(encoding)) {
                    String bomEncoding;
                    encoding = bomEncoding = LpexNls.getBomEncoding(f);
                }
                FileInputStream fis = new FileInputStream(f);
                bufferedReader = new BufferedReader(encoding == null ? new InputStreamReader((InputStream)fis, Charset.defaultCharset()) : new InputStreamReader((InputStream)fis, encoding));
                while ((text = bufferedReader.readLine()) != null) {
                    if (!first) {
                        this.insertText("\n");
                    }
                    first = false;
                    this.insertText(text);
                }
            }
            catch (FileNotFoundException e) {
                this.setLpexMessageText("file.notFound", fileName);
                CommandHandler.setStatus("file.notFound");
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {}
                }
                break block26;
            }
            catch (Exception e) {
                try {
                    this.setLpexMessageText("file.errorReading", fileName);
                    CommandHandler.setStatus("file.errorReading");
                    break block26;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            if (bufferedReader == null) break block26;
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.resetIgnoreFields();
        this.setForceAllVisible(forceAllVisible);
    }

    void setSaveWriter(Writer writer) {
        this._saveWriter = writer;
    }

    Writer getSaveWriter() {
        return this._saveWriter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void save(Writer writer, String fileName, String fileEncoding, boolean visible, String eol, boolean trim, int textLimit) {
        boolean saveas = false;
        String saveEncoding = null;
        if (fileName == null || fileName.trim().length() == 0) {
            fileName = this.document().name();
        }
        if (fileName == null && writer == null) {
            this.setLpexMessageText("file.saveNoName");
            return;
        }
        if (fileName != null) {
            try {
                fileName = new File(fileName).getCanonicalPath();
            }
            catch (IOException e) {
                this.setLpexMessageText("file.errorWriting", fileName);
                CommandHandler.setStatus("save.failed");
                return;
            }
            if (this.document().name() == null) {
                this.document().setName(fileName);
            }
            boolean bl = saveas = !fileName.equals(this.document().name());
        }
        if (!saveas && this._viewListenerList.saving()) {
            return;
        }
        saveEncoding = writer instanceof OutputStreamWriter ? ((OutputStreamWriter)writer).getEncoding() : (writer != null ? LpexNls.getNativeEncoding() : (fileEncoding != null ? fileEncoding : (this.document().fileEncoding() != null ? this.document().fileEncoding() : Charset.defaultCharset().name())));
        try {
            Throwable e = null;
            Object var11_14 = null;
            try {
                FileOutputStream fos = writer == null ? null : new FileOutputStream(new File(fileName));
                try {
                    block46: {
                        Writer internalWriter = writer == null ? writer : new OutputStreamWriter((OutputStream)fos, saveEncoding);
                        try {
                            try (BufferedWriter bufferedWriter = new BufferedWriter(internalWriter);){
                                boolean usingSourceColumns = this._nls.usingSourceColumns();
                                boolean isSmartLogical = this._nls.isSmartLogical();
                                Element firstTruncatedElement = null;
                                boolean first = true;
                                Element element = this.firstElement();
                                while (true) {
                                    if (element == null) {
                                        if (firstTruncatedElement != null) {
                                            this.setLpexMessageText("file.saveTruncation");
                                            this.ensureVisible(firstTruncatedElement);
                                            this.documentPosition().jump(firstTruncatedElement, this._nls.sourceTruncate(firstTruncatedElement.text(), textLimit) + 1);
                                            this.documentPosition().setEmphasisPosition(1);
                                            this.documentPosition().setEmphasisLength(firstTruncatedElement.length());
                                            BeepParameter.getParameter().setValue(true);
                                        }
                                        if (!saveas) {
                                            this._viewListenerList.saved();
                                        }
                                        if (!saveas && !visible) {
                                            this.document().undo().resetChanges(this);
                                        }
                                        break;
                                    }
                                    if (!visible && !element.show() || visible && element.visible(this)) {
                                        String text;
                                        if (trim && !saveas && !visible) {
                                            this.trimElement(element);
                                        }
                                        String string = text = visible ? element.elementView(this).displayNetText() : this.document().elementList().fullText(element, usingSourceColumns, isSmartLogical);
                                        if (first) {
                                            boolean saveBom;
                                            String bomP = SaveCommand.ByteOrderMarkParameter.getParameter().currentValue(this);
                                            boolean bl = saveBom = (bomP == null || "asis".equals(bomP)) && this.document().bom() != null || "on".equals(bomP);
                                            if (saveBom && LpexNls.maySaveBom(saveEncoding)) {
                                                bufferedWriter.write(65279);
                                            }
                                        }
                                        if (text != null) {
                                            int textLength = text.length();
                                            if (!saveas && !visible && textLimit != 0) {
                                                int saveLength;
                                                int n = saveLength = usingSourceColumns ? this._nls.sourceLength(text) : textLength;
                                                if (saveLength > textLimit) {
                                                    if (usingSourceColumns) {
                                                        textLength = this._nls.sourceTruncate(text, textLimit);
                                                    } else {
                                                        textLength = textLimit;
                                                        if (Character.isHighSurrogate(text.charAt(textLength - 1))) {
                                                            --textLength;
                                                        }
                                                    }
                                                    if (firstTruncatedElement == null) {
                                                        firstTruncatedElement = element;
                                                    }
                                                }
                                            }
                                            if (textLength != 0) {
                                                bufferedWriter.write(text, 0, textLength);
                                            }
                                        }
                                        if (eol == null) {
                                            bufferedWriter.newLine();
                                        } else {
                                            bufferedWriter.write(eol, 0, eol.length());
                                        }
                                        first = false;
                                    }
                                    element = element.next();
                                }
                            }
                            if (internalWriter == null) break block46;
                        }
                        catch (Throwable throwable) {
                            if (e == null) {
                                e = throwable;
                            } else if (e != throwable) {
                                e.addSuppressed(throwable);
                            }
                            if (internalWriter == null) throw e;
                            internalWriter.close();
                            throw e;
                        }
                        internalWriter.close();
                    }
                    if (fos == null) return;
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    if (fos == null) throw e;
                    fos.close();
                    throw e;
                }
                fos.close();
                return;
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                    throw e;
                }
                if (e == throwable) throw e;
                e.addSuppressed(throwable);
                throw e;
            }
        }
        catch (IOException e) {
            this.setLpexMessageText("file.errorWriting", fileName);
            CommandHandler.setStatus("save.failed");
        }
    }

    void ensureVisible(Element element) {
        if (!element.visible(this)) {
            while ((element = element.prev()) != null) {
                if (!element.visible(this)) continue;
                element.elementView(this).setExpanded(true);
                return;
            }
            this.setTopExpanded(true);
        }
    }

    void saveAsHtml(String fileName, boolean visible, boolean block, boolean lineNumbers) {
        HtmlWriter html = new HtmlWriter(this);
        if (!html.writeFile(fileName, visible, block, lineNumbers)) {
            CommandHandler.setStatus("save.failed");
        }
    }

    String lineNumbersText(Element e) {
        return this.lineNumbersText(e, this._lineNumbersLength, false, this._lineNumbersPad);
    }

    String lineNumbersText(Element e, int len, boolean alignLeft, char padChar) {
        StringBuilder lineNumbersText = new StringBuilder(String.valueOf(e.nonShowOrdinal() + this.document().linesBeforeStart()));
        while (lineNumbersText.length() < len) {
            if (alignLeft) {
                lineNumbersText.append(padChar);
                continue;
            }
            lineNumbersText.insert(0, padChar);
        }
        if (lineNumbersText.length() > len) {
            lineNumbersText.setLength(len);
        }
        return lineNumbersText.toString();
    }

    private void trimElement(Element element) {
        int len = element.length();
        if (len > 0) {
            int trimmedLength = len;
            String text = element.text();
            int i = trimmedLength - 1;
            while (i >= 0 && text.charAt(i) == ' ') {
                --trimmedLength;
                --i;
            }
            if (trimmedLength < len) {
                this.deleteTextForTrim(element, trimmedLength + 1, len - trimmedLength);
            }
        }
    }

    boolean trimElementNoNotify(Element element) {
        int len = element.length();
        if (len > 0) {
            int trimmedLength = len;
            String text = element.text();
            int i = trimmedLength - 1;
            while (i >= 0 && text.charAt(i) == ' ') {
                --trimmedLength;
                --i;
            }
            if (trimmedLength < len) {
                return this.deleteTextForTrimNoNotify(element, trimmedLength + 1, len - trimmedLength);
            }
        }
        return false;
    }

    void trimDocument() {
        if (!this.changeAllowed()) {
            return;
        }
        boolean startChangesIssued = false;
        Element element = this.firstElement();
        while (element != null) {
            int len;
            if (!element.show() && (len = element.length()) > 0) {
                int trimmedLength = len;
                String text = element.text();
                int i = trimmedLength - 1;
                while (i >= 0 && text.charAt(i) == ' ') {
                    --trimmedLength;
                    --i;
                }
                if (trimmedLength < len) {
                    if (!startChangesIssued) {
                        this.document().startChanges(this);
                        startChangesIssued = true;
                    }
                    this.deleteTextForTrim(element, trimmedLength + 1, len - trimmedLength);
                }
            }
            element = element.next();
        }
        if (startChangesIssued) {
            this.document().endChanges(this);
        }
    }

    int notifyTruncateDocument(LpexDocumentListener listener, int textLimit) {
        if (listener == null || textLimit <= 0) {
            return 0;
        }
        boolean usingSourceColumns = this._nls.usingSourceColumns();
        boolean isSmartLogical = this._nls.isSmartLogical();
        ElementList elementList = this.document().elementList();
        int firstTruncatedElement = 0;
        boolean first = true;
        Element element = this.firstElement();
        while (element != null) {
            String text;
            int textLength;
            if (!element.show() && (textLength = (text = this.document().elementList().fullText(element, usingSourceColumns, isSmartLogical)).length()) > 0) {
                int saveLength;
                int n = saveLength = usingSourceColumns ? this._nls.sourceLength(text) : textLength;
                if (saveLength > textLimit) {
                    if (usingSourceColumns) {
                        saveLength = this._nls.sourceTruncate(text, textLimit);
                    } else {
                        saveLength = textLimit;
                        if (Character.isHighSurrogate(text.charAt(saveLength - 1))) {
                            --saveLength;
                        }
                    }
                    if (firstTruncatedElement == 0) {
                        firstTruncatedElement = elementList.ordinalOf(element);
                    }
                    if (first) {
                        listener.documentChanged(this._lpexView, 6, 0, 0, 0);
                        elementList.validateNonShowOrdinals();
                        first = false;
                    }
                    listener.documentChanged(this._lpexView, 0, element.nonShowOrdinal(), saveLength + 1, textLength - saveLength);
                }
            }
            element = element.next();
        }
        if (!first) {
            listener.documentChanged(this._lpexView, 7, 0, 0, 0);
        }
        return firstTruncatedElement;
    }

    void notifyTruncateDocumentRestore(LpexDocumentListener listener, int textLimit, int firstTruncatedElement) {
        if (listener == null || textLimit <= 0 || firstTruncatedElement <= 0) {
            return;
        }
        boolean usingSourceColumns = this._nls.usingSourceColumns();
        boolean isSmartLogical = this._nls.isSmartLogical();
        ElementList elementList = this.document().elementList();
        boolean first = true;
        Element element = this.document().elementList().elementAt(firstTruncatedElement);
        while (element != null) {
            String text;
            int textLength;
            if (!element.show() && (textLength = (text = this.document().elementList().fullText(element, usingSourceColumns, isSmartLogical)).length()) > 0) {
                int saveLength;
                int n = saveLength = usingSourceColumns ? this._nls.sourceLength(text) : textLength;
                if (saveLength > textLimit) {
                    if (usingSourceColumns) {
                        saveLength = this._nls.sourceTruncate(text, textLimit);
                    } else {
                        saveLength = textLimit;
                        if (Character.isHighSurrogate(text.charAt(saveLength - 1))) {
                            --saveLength;
                        }
                    }
                    if (first) {
                        listener.documentChanged(this._lpexView, 6, 0, 0, 0);
                        elementList.validateNonShowOrdinals();
                        first = false;
                    }
                    listener.documentChanged(this._lpexView, 2, element.nonShowOrdinal(), saveLength + 1, textLength - saveLength);
                }
            }
            element = element.next();
        }
        if (!first) {
            listener.documentChanged(this._lpexView, 7, 0, 0, 0);
        }
    }

    ParsePendingList parsePendingList() {
        return this._parsePendingList;
    }

    void ensureIsParsed() {
        if (this._parsePendingList.first() != null) {
            this.parse();
        }
    }

    void parse() {
        this._commandHandler.doCommand("parse");
    }

    int parsePending(Element element) {
        ParsePending parsePending = this._parsePendingList.find(element);
        return parsePending != null ? parsePending.type() : 0;
    }

    StyleAttributesList styleAttributesList() {
        return this._styleAttributesList;
    }

    void setIncludedClasses(long includedClasses) {
        this.clearClasses(0x4000000000000000L);
        this.setVisibleElementOrdinalsInvalid();
        this.setMaxElementWidthInvalid();
        this.setMaxPrefixAreaWidthInvalid();
        this.expandAll(false);
        this._includedClasses = includedClasses;
    }

    long includedClasses() {
        return this._includedClasses;
    }

    long queryIncludedClasses() {
        long classes = this.includedClasses();
        return classes == -1L ? 0L : this.classes().userMask(classes);
    }

    String queryIncludedClassesString() {
        long classes = this.includedClasses();
        return classes == -1L ? "" : this.classes().names(classes);
    }

    void setExcludedClasses(long excludedClasses) {
        if ((this._excludedClasses & 0x4000000000000000L) != 0L && (excludedClasses & 0x4000000000000000L) == 0L) {
            this.clearClasses(0x4000000000000000L);
        }
        this.setVisibleElementOrdinalsInvalid();
        this.setMaxElementWidthInvalid();
        this.setMaxPrefixAreaWidthInvalid();
        this.expandAll(false);
        this._excludedClasses = excludedClasses;
    }

    long excludedClasses() {
        return this._excludedClasses;
    }

    long queryExcludedClasses() {
        return this.classes().userMask(this.excludedClasses());
    }

    String queryExcludedClassesString() {
        return this.classes().names(this.excludedClasses());
    }

    private void clearTextClasses(long textClasses) {
        Element element = this.firstElement();
        while (element != null) {
            element.elementView(this).clearTextClasses(textClasses);
            element = element.next();
        }
    }

    void clearClasses(long clearClasses) {
        Element element = this.firstElement();
        while (element != null) {
            element.elementView(this).clearClasses(clearClasses);
            element = element.next();
        }
    }

    boolean findText(FindTextOptions options) {
        return this.findText(options, null);
    }

    boolean findText(FindTextOptions options, String caller) {
        int overflowedReplacements;
        int replaceRc;
        int replaceTextLength;
        boolean replaced;
        boolean wrapped;
        boolean found;
        int allCount;
        int startPosition;
        Element startElement;
        int position;
        Element element;
        boolean startedInFindAll;
        block87: {
            if (options._replace && !this.changeAllowed()) {
                CommandHandler.setStatus("findText.readOnly");
                return false;
            }
            if (options._all) {
                options._up = false;
            }
            startedInFindAll = this.includedClasses() == Long.MIN_VALUE;
            ElementList elementList = this.document().elementList();
            element = null;
            position = 1;
            if (options._all) {
                if (!options._exclude) {
                    this.setIncludedClasses(-1L);
                    this.clearTextClasses(-4611686018427387904L);
                }
                if ((element = elementList.first()) != null && (!element.visible(this) || element.show() && !this.markList().compareDeletedLine(element))) {
                    element = this.nextFindable(element);
                }
            } else {
                element = this.documentPosition().element();
                if (element != null) {
                    if (element.visible(this) && (!element.show() || this.markList().compareDeletedLine(element))) {
                        position = this.documentPosition().position();
                    } else if (options._up) {
                        element = this.prevFindable(element, options._wrap);
                        position = element.end();
                    } else {
                        element = this.nextFindable(element, options._wrap);
                    }
                }
            }
            startElement = element;
            int elementOrdinal = elementList.ordinalOf(element);
            startPosition = position--;
            CommandHandler.setStatus(null);
            allCount = 0;
            int lineCount = 0;
            found = false;
            wrapped = false;
            replaced = false;
            replaceTextLength = 0;
            replaceRc = 2;
            overflowedReplacements = 0;
            if (element != null && options._findText != null && options._findText.length() > 0) {
                if (options._up) {
                    if (!options._checkStart) {
                        // empty if block
                    }
                    while (true) {
                        if ((position = this.findText(element, position, options)) > 0) {
                            if (options._replace && !this.markList().protect(element)) {
                                String replaceText = this.getReplaceText(options);
                                if (CommandHandler.getStatus() == null) {
                                    replaceRc = this.replaceFoundText(element, position, options._foundTextLength, replaceText);
                                    replaced = true;
                                    replaceTextLength = replaceRc != 2 && replaceRc != 8 ? element.length() - position + 1 : replaceText.length();
                                }
                            }
                            this.documentPosition().jump(element, position);
                            found = true;
                            break block87;
                        }
                        if ((element = element.prevVisible(this, options._wrap)) == null) break block87;
                        int newElementOrdinal = elementList.ordinalOf(element);
                        if (newElementOrdinal >= elementOrdinal) {
                            if (wrapped) break block87;
                            wrapped = true;
                        }
                        elementOrdinal = newElementOrdinal;
                        position = element.end();
                    }
                }
                if (!options._checkStart && !options._all) {
                    ++position;
                }
                if (options._all && options._replace) {
                    this._document.resetUserActionElements();
                }
                while (true) {
                    if ((position = this.findText(element, position, options)) > 0) {
                        if (options._all) {
                            if (options._exclude) {
                                element.elementView(this).setTextClasses(0x4000000000000000L);
                            } else {
                                element.elementView(this).setTextClasses(Long.MIN_VALUE);
                                if (!options._replace) {
                                    elementPosition = position;
                                    while (elementPosition > 0) {
                                        ++allCount;
                                        ++lineCount;
                                        elementPosition += Math.max(1, options._foundTextLength);
                                        elementPosition = this.findText(element, elementPosition, options);
                                    }
                                } else if (!this.markList().protect(element)) {
                                    elementPosition = position;
                                    while (elementPosition > 0) {
                                        int[] tmp;
                                        String replaceText = this.getReplaceText(options);
                                        if (CommandHandler.getStatus() != null) break;
                                        replaceRc = this.replaceFoundText(element, elementPosition, options._foundTextLength, replaceText);
                                        replaced = true;
                                        if (replaceRc == 8) {
                                            ++allCount;
                                            ++lineCount;
                                            ++overflowedReplacements;
                                        } else {
                                            if (replaceRc != 2) {
                                                this.documentPosition().jump(element, elementPosition);
                                                replaceTextLength = element.length() - elementPosition + 1;
                                                found = true;
                                                break;
                                            }
                                            ++allCount;
                                            ++lineCount;
                                        }
                                        if (!found) {
                                            replaceTextLength = replaceText.length();
                                        }
                                        elementPosition += replaceText.length();
                                        elementPosition = this.findText(element, elementPosition, options);
                                        if (replaceTextLength != 0 || (tmp = this.fields(element)) == null || tmp.length <= 0 || elementPosition <= 0) continue;
                                        int end = elementPosition + 1;
                                        if (options._columns) {
                                            end = options._endColumn + 1;
                                        }
                                        boolean endAdjusted = false;
                                        int i = 1;
                                        while (i < tmp.length && !endAdjusted) {
                                            if (elementPosition >= tmp[i - 1] && elementPosition < tmp[i] && end > tmp[i]) {
                                                end = tmp[i];
                                                endAdjusted = true;
                                            } else if (end <= tmp[i]) {
                                                end = tmp[i];
                                                endAdjusted = true;
                                            }
                                            ++i;
                                        }
                                        if (!endAdjusted) {
                                            end = Math.max(element.length() + 2, end);
                                        }
                                        if ((!endAdjusted || elementPosition + lineCount <= end) && (endAdjusted || end != elementPosition)) continue;
                                        elementPosition = end;
                                        elementPosition = this.findText(element, elementPosition, options);
                                        lineCount = 0;
                                    }
                                }
                                if (!found && !"filterSelection".equals(caller)) {
                                    this.documentPosition().jump(element, position);
                                }
                            }
                            found = true;
                            if (CommandHandler.getStatus() != null || replaceRc != 2 && replaceRc != 8) {
                                break;
                            }
                        } else {
                            if (options._replace && !this.markList().protect(element)) {
                                String replaceText = this.getReplaceText(options);
                                if (CommandHandler.getStatus() == null) {
                                    replaceRc = this.replaceFoundText(element, position, options._foundTextLength, replaceText);
                                    replaced = true;
                                    replaceTextLength = replaceRc != 2 && replaceRc != 8 ? element.length() - position + 1 : replaceText.length();
                                }
                            }
                            this.documentPosition().jump(element, position);
                            found = true;
                            break;
                        }
                    }
                    element = element.nextVisible(this, options._wrap && !options._all);
                    lineCount = 0;
                    if (element == null) break;
                    int newElementOrdinal = elementList.ordinalOf(element);
                    if (newElementOrdinal <= elementOrdinal) {
                        if (wrapped) break;
                        wrapped = true;
                    }
                    elementOrdinal = newElementOrdinal;
                    position = 1;
                }
            }
        }
        if (options._all && !options._exclude && (startedInFindAll || !options._replace)) {
            this.setIncludedClasses(Long.MIN_VALUE);
        } else if (options._all && options._exclude) {
            this.setExcludedClasses(this.excludedClasses() | 0x4000000000000000L);
        }
        if (!found) {
            CommandHandler.setStatus("findText.notFound");
            if (!options._quiet) {
                this.setLpexMessageText("findText.notFound", options._originalFindText);
                if (!options._noBeep) {
                    BeepParameter.getParameter().setValue(true);
                }
            }
            if (options._emphasis) {
                this.documentPosition().setEmphasisLength(0);
            }
            if (options._mark) {
                this.block().clear();
            }
            return false;
        }
        if (!options._quiet && CommandHandler.getStatus() == null) {
            this.screen().setMessageText(null);
        }
        String messageKey = null;
        String messageArgument = null;
        boolean beep = true;
        if (replaced && (overflowedReplacements > 0 || replaceRc != 2) && CommandHandler.getStatus() == null) {
            if ((replaceRc & 4) != 0) {
                CommandHandler.setStatus("fields.truncate");
                messageKey = "fields.truncate";
            } else if ((replaceRc & 8) != 0 || overflowedReplacements > 0) {
                if (overflowedReplacements == 1) {
                    CommandHandler.setStatus("textLimit.overflowed1");
                    messageKey = "textLimit.overflowed1";
                } else if (overflowedReplacements > 1) {
                    CommandHandler.setStatus("textLimit.overflowedn");
                    messageKey = "textLimit.overflowedn";
                    messageArgument = String.valueOf(overflowedReplacements);
                } else {
                    CommandHandler.setStatus("textLimit.overflow");
                    messageKey = "textLimit.overflow";
                }
            }
        }
        if (wrapped && !options._all && CommandHandler.getStatus() == null) {
            if (element == startElement && position == startPosition) {
                CommandHandler.setStatus("findText.onlyOccurrence");
                messageKey = "findText.onlyOccurrence";
            } else {
                CommandHandler.setStatus("findText.wrapped");
                messageKey = "findText.wrapped";
            }
        }
        if (options._all && allCount > 0 && CommandHandler.getStatus() == null) {
            beep = false;
            if (allCount == 1) {
                messageKey = replaced ? "findText.1Replace" : "findText.1Find";
            } else {
                messageKey = replaced ? "findText.nReplaces" : "findText.nFinds";
                messageArgument = String.valueOf(allCount);
            }
        }
        if (messageKey != null && !options._quiet) {
            if (messageArgument == null) {
                this.screen().setMessageKey(messageKey);
            } else {
                this.screen().setMessageKey(messageKey, messageArgument);
            }
            if (!options._noBeep && beep) {
                BeepParameter.getParameter().setValue(true);
            }
        }
        if (options._exclude || "filterSelection".equals(caller)) {
            return true;
        }
        int emphasisLength = replaced ? replaceTextLength : options._foundTextLength;
        if (options._mark) {
            this.block().clear();
            this.documentPosition().setEmphasisLength(0);
            int currentBlockDefaultType = BlockCommand.DefaultTypeParameter.getParameter().currentValue(this);
            if (currentBlockDefaultType == 4 || currentBlockDefaultType == 1) {
                if (replaced) {
                    this.block().set(1, this);
                    this.documentPosition().right(emphasisLength);
                } else {
                    this.documentPosition().right(emphasisLength);
                    this.block().set(1, this);
                    this.documentPosition().left(emphasisLength);
                }
            } else if (replaced) {
                this.block().set(this);
                this.documentPosition().right(emphasisLength - 1);
            } else {
                this.documentPosition().right(emphasisLength - 1);
                this.block().set(this);
                this.documentPosition().left(emphasisLength - 1);
            }
            this.block().set(this);
        } else {
            if (options._emphasis) {
                this.documentPosition().setEmphasisPosition(replaced ? this.documentPosition().position() : 0);
                this.documentPosition().setEmphasisLength(emphasisLength);
            }
            if (replaced) {
                this.documentPosition().right(emphasisLength);
            }
        }
        this.findTextHowFoundReplacedInView(replaced, emphasisLength, options);
        return true;
    }

    private void findTextHowFoundReplacedInView(boolean replaced, int emphasisLength, FindTextOptions options) {
        int leftPixelPosition;
        if (options._subcommand) {
            return;
        }
        int position = this.documentPosition().position();
        ElementView elementView = this.documentPosition().element().elementView(this);
        int leftPos = replaced ? position - emphasisLength : position;
        int rightPos = replaced ? position : position + emphasisLength;
        this.screen().build();
        int scroll = this.screen().scroll();
        int textAreaWidth = this.screen().textAreaWidth();
        int scrollDelta = elementView.pixelPosition(rightPos) - (scroll + textAreaWidth);
        if (scrollDelta > 0) {
            int startPixelPosition = elementView.pixelPosition(leftPos);
            if (startPixelPosition < scroll + scrollDelta) {
                scrollDelta = startPixelPosition - scroll;
            }
            if (scrollDelta > 0) {
                this.screen().setScroll(scroll + scrollDelta);
            }
        } else if (scroll > 0 && (scrollDelta = scroll - (leftPixelPosition = elementView.pixelPosition(leftPos))) > 0) {
            int endPixelPosition = elementView.pixelPosition(rightPos);
            if (endPixelPosition - leftPixelPosition > textAreaWidth) {
                scrollDelta = endPixelPosition - textAreaWidth;
            }
            if (scrollDelta > 0) {
                this.screen().setScroll(scroll - scrollDelta);
            }
        }
    }

    private int replaceFoundText(Element element, int position, int foundTextLength, String replaceText) {
        if (replaceText.length() == 0) {
            this.deleteText(element, position, foundTextLength);
            return 2;
        }
        int textLimit = this.document().elementList().textLimit();
        this.saveCurrentFields(element);
        this.deleteText(element, position, foundTextLength);
        int rc = this.insertText(element, position, replaceText);
        this.saveCurrentFields(null);
        if (textLimit != 0 && rc == 2 && this.document().elementList().saveLength(element) > textLimit) {
            rc = 8;
        }
        return rc;
    }

    private String getReplaceText(FindTextOptions options) {
        String replaceText;
        block3: {
            String string = replaceText = options._replaceText != null ? options._replaceText : "";
            if (options._regularExpression && replaceText.length() != 0) {
                Pattern pattern = options._matcher.pattern();
                Matcher replaceMatcher = pattern.matcher(options._matcher.group());
                try {
                    replaceText = replaceMatcher.replaceFirst(replaceText);
                }
                catch (IndexOutOfBoundsException x) {
                    CommandHandler.setStatus("findText.invalidPattern");
                    if (options._quiet) break block3;
                    this.setLpexMessageText("findText.replacePattern", replaceText, x.getLocalizedMessage());
                    if (options._noBeep) break block3;
                    BeepParameter.getParameter().setValue(true);
                }
            }
        }
        return replaceText;
    }

    private int findText(Element element, int position, FindTextOptions options) {
        int startEndColumn;
        int startStartColumn;
        if (element.length() == 0 || options._findText == null || element.show() && !this.markList().compareDeletedLine(element)) {
            return 0;
        }
        int findTextLength = options._findText.length();
        if (findTextLength == 0) {
            return 0;
        }
        boolean isIgnoringBidiMarks = this.nls().isIgnoringBidiMarks();
        String text = element.text();
        if (isIgnoringBidiMarks) {
            text = LpexNls.stripBidiMarks(text);
        }
        int elementLength = text.length();
        if (!options._regularExpression && elementLength < findTextLength) {
            return 0;
        }
        options._foundTextLength = findTextLength;
        int endColumn = elementLength;
        if (options._up) {
            startStartColumn = 1;
            startEndColumn = position;
            if (!options._regularExpression && (endColumn = position + findTextLength - 1) > elementLength) {
                endColumn = elementLength;
            }
        } else {
            startStartColumn = position;
            startEndColumn = options._regularExpression ? elementLength : elementLength - findTextLength + 1;
        }
        if (options._block) {
            int blockStart = this.block().leftPosition(this, element);
            int blockEnd = this.block().rightPosition(this, element);
            if (startStartColumn < blockStart) {
                startStartColumn = blockStart;
            }
            if (options._regularExpression) {
                if (startEndColumn > blockEnd) {
                    startEndColumn = blockEnd;
                }
            } else if (startEndColumn > blockEnd - findTextLength + 1) {
                startEndColumn = blockEnd - findTextLength + 1;
            }
            if (endColumn > blockEnd) {
                endColumn = blockEnd;
            }
        }
        if (options._columns) {
            if (startStartColumn < options._startColumn) {
                startStartColumn = options._startColumn;
            }
            if (options._regularExpression) {
                if (startEndColumn > options._endColumn) {
                    startEndColumn = options._endColumn;
                }
            } else if (startEndColumn > options._endColumn - findTextLength + 1) {
                startEndColumn = options._endColumn - findTextLength + 1;
            }
            if (endColumn > options._endColumn) {
                endColumn = options._endColumn;
            }
        }
        if (!options._regularExpression && endColumn - startStartColumn + 1 < findTextLength || startEndColumn < startStartColumn) {
            return 0;
        }
        if (!options._asis && !options._regularExpression) {
            StringBuilder buffer = new StringBuilder(text);
            int i = 0;
            while (i < text.length()) {
                buffer.setCharAt(i, Character.toUpperCase(buffer.charAt(i)));
                ++i;
            }
            text = buffer.toString();
        }
        if (options._up) {
            if (!options._regularExpression) {
                if (options._wholeWord) {
                    while (true) {
                        if ((position = text.lastIndexOf(options._findText, startEndColumn - 1) + 1) < startStartColumn) {
                            position = 0;
                        }
                        if (position != 0 && !View.isWholeWord(text, position - 1, position - 1 + options._findText.length())) {
                            startEndColumn = position - 1;
                            continue;
                        }
                        break;
                    }
                } else {
                    position = text.lastIndexOf(options._findText, startEndColumn - 1) + 1;
                    if (position < startStartColumn) {
                        position = 0;
                    }
                }
            } else {
                options._matcher.reset(text);
                found = options._matcher.find(startStartColumn - 1);
                int start = -1;
                int end = -1;
                while (found && options._matcher.start() < startEndColumn && options._matcher.end() <= endColumn) {
                    start = options._matcher.start();
                    end = options._matcher.end();
                    found = options._matcher.find(start + 1);
                }
                if (start > -1) {
                    if (options._replace) {
                        options._matcher.find(start);
                    }
                    position = start + 1;
                    options._foundTextLength = end - start;
                } else {
                    position = 0;
                }
            }
        } else if (!options._regularExpression) {
            if (options._wholeWord) {
                while (true) {
                    if ((position = text.indexOf(options._findText, startStartColumn - 1) + 1) > startEndColumn) {
                        position = 0;
                    }
                    if (position != 0 && !View.isWholeWord(text, position - 1, position - 1 + options._findText.length())) {
                        startStartColumn = position + 1;
                        continue;
                    }
                    break;
                }
            } else {
                position = text.indexOf(options._findText, startStartColumn - 1) + 1;
                if (position > startEndColumn) {
                    position = 0;
                }
            }
        } else {
            options._matcher.reset(text);
            found = options._matcher.find(startStartColumn - 1);
            if (found && options._matcher.end() <= endColumn) {
                position = options._matcher.start() + 1;
                options._foundTextLength = options._matcher.end() - options._matcher.start();
            } else {
                position = 0;
            }
        }
        if (position != 0 && isIgnoringBidiMarks) {
            String elementText = element.text();
            int offset = position - 1;
            int endOffset = offset + options._foundTextLength - 1;
            int i = 0;
            while (i < elementText.length() && i <= endOffset) {
                if (LpexNls.isBidiMark(elementText.charAt(i))) {
                    if (i <= offset) {
                        ++offset;
                        ++endOffset;
                    } else {
                        ++endOffset;
                    }
                }
                ++i;
            }
            position = offset + 1;
            options._foundTextLength = endOffset - offset + 1;
        }
        return position;
    }

    private Element nextFindable(Element element) {
        return this.nextFindable(element, false);
    }

    private Element nextFindable(Element element, boolean wrap) {
        while ((element = element.nextVisible(this)) != null && element.show() && !this.markList().compareDeletedLine(element)) {
        }
        if (element == null && wrap && (!(element = this.document().elementList().first()).visible(this) || element.show() && !this.markList().compareDeletedLine(element))) {
            element = this.nextFindable(element, false);
        }
        return element;
    }

    private Element prevFindable(Element element, boolean wrap) {
        while ((element = element.prevVisible(this)) != null && element.show() && !this.markList().compareDeletedLine(element)) {
        }
        if (element == null && wrap && (!(element = this.document().elementList().last()).visible(this) || element.show() && !this.markList().compareDeletedLine(element))) {
            element = this.prevFindable(element, false);
        }
        return element;
    }

    private static boolean isWholeWord(String text, int startOffset, int endOffset) {
        char c;
        if (startOffset > 0 && (Character.isLetterOrDigit(c = text.charAt(startOffset - 1)) || c == '_')) {
            return false;
        }
        return endOffset >= text.length() || !Character.isLetterOrDigit(c = text.charAt(endOffset)) && c != '_';
    }

    String popup() {
        return this._popup;
    }

    void setPopup(String popup) {
        this._popup = popup;
    }

    void setBlockInstance(View view) {
        this._block = view == null ? Block.lpexBlock() : (view == this ? new Block() : view._block);
    }

    Block block() {
        return this._block;
    }

    MarkList markList() {
        if (this._markList == null) {
            this._markList = new MarkList(this);
        }
        return this._markList;
    }

    boolean readonly() {
        return this._readonly;
    }

    void setReadonly(boolean readonly) {
        if (this._readonly != readonly) {
            this._readonly = readonly;
            this.readonlyChanged();
        }
    }

    private void readonlyChanged() {
        if (this._lpexWindow != null) {
            ((TextWindow)this._lpexWindow.textWindow()).readonlyChanged();
        }
    }

    ViewListenerList listenerList() {
        return this._viewListenerList;
    }

    CursorListenerList cursorListenerList() {
        if (this._cursorListenerList == null) {
            this._cursorListenerList = new CursorListenerList(this);
        }
        return this._cursorListenerList;
    }

    void triggerCursorListeners() {
        if (this._cursorListenerList != null) {
            this._cursorListenerList.elementChanged();
        }
    }

    boolean changeAllowed() {
        if (this._readonly) {
            this._viewListenerList.setReadonlyChangeAttempted();
        }
        return !this._readonly;
    }

    void preserveFindPosition() {
        if (this._findPositionPreserve != null) {
            this.documentPosition().disposePreserve(this._findPositionPreserve);
        }
        this._findPositionPreserve = this.documentPosition().preserve();
    }

    void restoreFindPosition() {
        if (this._findPositionPreserve != null) {
            this._findPositionPreserve.restore();
        }
    }

    void setWordIterOptions(int wordIterOptions) {
        this._wordIterOptions = wordIterOptions;
    }

    int wordIterOptions() {
        return this._wordIterOptions;
    }

    void setFieldsProvider(LpexFieldsProvider fieldsProvider) {
        this._lpexFieldsProvider = fieldsProvider;
    }

    void setFields(int[] fields) {
        this._fields = fields;
    }

    int[] fields() {
        return this._fields;
    }

    int[] fields(Element element) {
        if (this._lpexFieldsProvider != null) {
            int[] fields = this._lpexFieldsProvider.getFields(this._lpexView, this.document().elementList().ordinalOf(element));
            return fields == null || fields.length == 0 ? null : fields;
        }
        return this._fields;
    }

    private int[] currentFields(Element element) {
        if (this._currentFields != null) {
            return this._currentFields.length == 0 ? null : this._currentFields;
        }
        int[] tmp = this.fields(element);
        if (tmp == null || tmp.length == 0) {
            return null;
        }
        int[] rc = new int[tmp.length];
        System.arraycopy(tmp, 0, rc, 0, tmp.length);
        return rc;
    }

    private void saveCurrentFields(Element element) {
        if (element == null) {
            this._currentFields = null;
            return;
        }
        int[] tmp = this.fields(element);
        if (tmp == null || tmp.length == 0) {
            this._currentFields = new int[0];
        } else {
            this._currentFields = new int[tmp.length];
            System.arraycopy(tmp, 0, this._currentFields, 0, tmp.length);
        }
    }

    private boolean ignoreFields() {
        return this._ignoreFieldsCount > 0;
    }

    void setIgnoreFields() {
        ++this._ignoreFieldsCount;
    }

    void resetIgnoreFields() {
        if (this._ignoreFieldsCount > 0) {
            --this._ignoreFieldsCount;
        }
    }

    private int fieldLimit(int[] fields, int position) {
        int fieldLimit = 0;
        if (fields != null && !this.ignoreFields()) {
            int i = 0;
            while (i < fields.length) {
                if (fields[i] > position) {
                    fieldLimit = fields[i] - 1;
                    break;
                }
                ++i;
            }
        }
        return fieldLimit;
    }

    private void skipFields(int[] fields, int startPosition, int endPosition) {
        int i = 0;
        while (i < fields.length) {
            if (fields[i] > startPosition) break;
            ++i;
        }
        while (i < fields.length) {
            if (fields[i] > endPosition) {
                return;
            }
            fields[i++] = 0;
        }
    }

    private static String spaces(int len) {
        if (len == 1) {
            return " ";
        }
        if (len <= 0) {
            return "";
        }
        StringBuilder spaces = new StringBuilder(len);
        while (len-- > 0) {
            spaces.append(' ');
        }
        return spaces.toString();
    }

    void setSplitWindow(int splitWindowParm) {
        this._splitWindowParm = splitWindowParm;
    }

    int splitWindow() {
        return this._splitWindowParm;
    }

    void setLogMessages(int logMessagesParm) {
        this._logMessagesParm = logMessagesParm;
        this._logMessages = LogMessagesParameter.getParameter().currentValue(this);
    }

    int logMessages() {
        return this._logMessagesParm;
    }

    boolean currentLogMessages() {
        return this._logMessages;
    }

    void expandTabsChanged() {
        this._expandTabs = ExpandTabsParameter.getParameter().currentValue(this);
        Element element = this.firstElement();
        while (element != null) {
            if (element.tabs()) {
                element.elementView(this).resetDisplayText();
            }
            element = element.next();
        }
    }

    void tabsChanged() {
        boolean tabsChanged;
        TabsParameter.Settings oldTabs = this._currentTabs;
        this._currentTabs = TabsParameter.getParameter().currentValue(this);
        if (!this._expandTabs) {
            return;
        }
        boolean bl = tabsChanged = oldTabs._tabIncrement != this._currentTabs._tabIncrement || oldTabs._tabStops.length != this._currentTabs._tabStops.length;
        if (!tabsChanged) {
            int i = 0;
            while (i < oldTabs._tabStops.length) {
                if (oldTabs._tabStops[i] != this._currentTabs._tabStops[i]) {
                    tabsChanged = true;
                    break;
                }
                ++i;
            }
        }
        if (tabsChanged) {
            Element element = this.firstElement();
            while (element != null) {
                if (element.tabs()) {
                    element.elementView(this).resetDisplayText();
                }
                element = element.next();
            }
        }
    }

    void setExpandTabs(int expandTabsParm) {
        this._expandTabsParm = expandTabsParm;
        if (this._expandTabs != ExpandTabsParameter.getParameter().currentValue(this)) {
            this.expandTabsChanged();
        }
    }

    int expandTabs() {
        return this._expandTabsParm;
    }

    boolean currentExpandTabs() {
        return this._expandTabs;
    }

    void setParseAfterEveryKeyParm(int parseAfterEveryKeyParm) {
        this._parseAfterEveryKeyParm = parseAfterEveryKeyParm;
    }

    int parseAfterEveryKeyParm() {
        return this._parseAfterEveryKeyParm;
    }

    void setTabs(TabsParameter.Settings tabsParm) {
        this._tabsParm = tabsParm;
        this.tabsChanged();
    }

    TabsParameter.Settings tabs() {
        if (this._tabsParm == null) {
            this._tabsParm = new TabsParameter.Settings();
        }
        return this._tabsParm;
    }

    TabsParameter.Settings currentTabs() {
        return this._currentTabs;
    }

    String expandTextTabs(String displayText) {
        StringBuilder buffer = new StringBuilder(displayText.length() + 32);
        int i = 0;
        int columnPosition = 1;
        while (i < displayText.length()) {
            char c = displayText.charAt(i);
            if (c == '\t') {
                int tabLen = this.getTabWidth(columnPosition);
                int j = 0;
                while (j < tabLen) {
                    buffer.append(' ');
                    ++j;
                }
                columnPosition += tabLen;
            } else {
                buffer.append(c);
                columnPosition += this.nls().getSourceWidth(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    void expandDisplayStyleTabs(StringBuilder foreground, StringBuilder background, String text) {
        int iText = 0;
        int i = 0;
        int columnPosition = 1;
        char bg = '\u0000';
        while (i < foreground.length()) {
            char c;
            char c2 = c = iText < text.length() ? (char)text.charAt(iText) : (char)' ';
            if (c == '\t') {
                int paddingStyleLen = this.getTabWidth(columnPosition) - 1;
                char fg = foreground.charAt(i);
                if (background != null) {
                    bg = background.charAt(i);
                }
                int j = 0;
                while (j < paddingStyleLen) {
                    foreground.insert(i, fg);
                    if (background != null) {
                        background.insert(i, bg);
                    }
                    ++i;
                    ++j;
                }
                columnPosition += paddingStyleLen + 1;
            } else {
                columnPosition += this.nls().getSourceWidth(c);
            }
            ++i;
            ++iText;
        }
    }

    public String convertWhitespaceChar(String displayText, boolean isExpandTab) {
        List<WhitespaceCharacterMapping> list = WhitespaceCharacterUtil.parseWhitespaceCharMappingTable(WhitespaceCharMappingParameter.getParameter().currentValue(this));
        Hashtable<Character, Character> mappingTable = new Hashtable<Character, Character>();
        for (WhitespaceCharacterMapping m : list) {
            mappingTable.put(Character.valueOf(m.getOriginal()), Character.valueOf(m.getSubstitute()));
        }
        StringBuffer res = new StringBuffer();
        int columnPosition = 1;
        int i = 0;
        while (i < displayText.length()) {
            char c = displayText.charAt(i);
            if (mappingTable.containsKey(Character.valueOf(c))) {
                res.append(mappingTable.get(Character.valueOf(c)));
            } else {
                res.append(c);
            }
            if (isExpandTab && c == '\t') {
                int tabWidth = this.getTabWidth(columnPosition);
                int padingSpace = tabWidth - 1;
                int j = 0;
                while (j < padingSpace) {
                    res.append(' ');
                    ++j;
                }
                columnPosition += tabWidth;
            } else {
                columnPosition += this.nls().getSourceWidth(c);
            }
            ++i;
        }
        return res.toString();
    }

    public String convertHostChar(String displayText, String codePage, boolean isExpandTab) {
        if (displayText == null || codePage == null) {
            return null;
        }
        boolean displayingSosi = this.nls().displayingSosi();
        boolean displayingWhitespaceChar = this.nls().displayingWhitespaceChar();
        List<HostCharacterMapping> hostCharMappingList = HostCharacterUtil.parseHostCharMappingString(HostCharMappingParameter.getParameter().currentValue(this));
        List<WhitespaceCharacterMapping> whitespaceCharMappingList = WhitespaceCharacterUtil.parseWhitespaceCharMappingTable(WhitespaceCharMappingParameter.getParameter().currentValue(this));
        HashSet<Character> whitespaceCharMappingTable = new HashSet<Character>();
        for (WhitespaceCharacterMapping m : whitespaceCharMappingList) {
            whitespaceCharMappingTable.add(Character.valueOf(m.getOriginal()));
        }
        StringBuffer buffer = new StringBuffer();
        char shiftOutChar = ShiftOutCharacterParameter.getParameter().currentValue(this);
        char shiftInChar = ShiftInCharacterParameter.getParameter().currentValue(this);
        String sourceEncoding = this.document()._sourceEncoding;
        Character replaceChar = null;
        Map<Integer, Integer> map = View.genHexMap(this.lpexView().query("sourceHexSubstitutes"));
        byte[] displayBytes = null;
        try {
            displayBytes = displayText.getBytes(codePage);
        }
        catch (Exception e) {
            LpexLog.log(this, e.getMessage(), e);
            return null;
        }
        int i = 0;
        while (i < displayText.length()) {
            Boolean isReplaceable = true;
            char c = displayText.charAt(i);
            int b = 0;
            char charValue = c;
            b = map.containsKey(charValue) ? map.get(charValue) & 0xFF : displayBytes[i] & 0xFF;
            replaceChar = Character.valueOf(c);
            isReplaceable = isReplaceable != false && (!displayingSosi || !LpexNls.isSosiEncoding(sourceEncoding) || c != shiftOutChar && c != shiftInChar);
            isReplaceable = isReplaceable != false && (!displayingWhitespaceChar || !whitespaceCharMappingTable.contains(Character.valueOf(c)));
            if ((isReplaceable = Boolean.valueOf(isReplaceable != false && c != '\t')).booleanValue() && (replaceChar = HostCharacterUtil.findMappingChar(codePage, b, hostCharMappingList)) == null) {
                replaceChar = Character.valueOf(c);
            }
            buffer.append(replaceChar);
            ++i;
        }
        return buffer.toString();
    }

    private static Map<Integer, Integer> genHexMap(String hexSubstitutes) {
        HashMap<Integer, Integer> hexMap = new HashMap<Integer, Integer>();
        if (hexSubstitutes != null) {
            StringTokenizer st = new StringTokenizer(hexSubstitutes);
            while (st.hasMoreElements()) {
                String hexSource = st.nextToken();
                String uniClient = st.nextToken();
                int source = Integer.parseInt(hexSource, 16);
                int unicode = Integer.parseInt(uniClient, 16);
                hexMap.put(unicode, source);
            }
        }
        return hexMap;
    }

    private int getTabWidth(int columnPosition) {
        int tc = 0;
        int lastTabVal = 0;
        while (tc < this._currentTabs._tabStops.length && lastTabVal <= columnPosition) {
            lastTabVal = this._currentTabs._tabStops[tc++];
        }
        while (lastTabVal <= columnPosition) {
            lastTabVal += this._currentTabs._tabIncrement == 0 ? 1 : this._currentTabs._tabIncrement;
        }
        int tabWidth = lastTabVal - columnPosition;
        return tabWidth;
    }

    void sequenceNumbersFormatChanged() {
        this.cacheSequenceNumbersFormat();
        if (this.document().elementList().sequenceNumbersWidth() != 0) {
            Element element = this.firstElement();
            while (element != null) {
                element.elementView(this).resetDisplayText();
                element = element.next();
            }
        }
        if (PrefixAreaParameter.getParameter().currentValue(this) && PrefixAreaTextParameter.getParameter().currentValue(this) == 2) {
            this.setPrefixAreaWidthsInvalid();
        }
    }

    private void cacheSequenceNumbersFormat() {
        this._sequenceNumbersFormat = SequenceNumbersFormatParameter.getParameter().currentValue(this);
        if (this._sequenceNumbersFormat == null) {
            this._sequenceNumbersFormatStyle = null;
        } else {
            int len = this._sequenceNumbersFormat.length();
            StringBuilder style = new StringBuilder(len);
            int i = 0;
            while (i < len) {
                char c = this._sequenceNumbersFormat.charAt(i);
                if (c == '9') {
                    style.append('\u0001');
                } else {
                    if (c == '\\' && i < len - 1) {
                        ++i;
                    }
                    style.append('\u0002');
                }
                ++i;
            }
            this._sequenceNumbersFormatStyle = style.toString();
        }
    }

    String sequenceNumbersFormat() {
        return this._sequenceNumbersFormat;
    }

    String getSequenceNumbersStyle() {
        return this._sequenceNumbersFormatStyle != null ? this._sequenceNumbersFormatStyle : this._document.elementList().sequenceNumbersStyle();
    }

    LpexNls nls() {
        return this._nls;
    }

    void setShowSosi(int showSosi) {
        boolean oldCurrentShowSosi = this.currentShowSosi();
        this._showSosiParm = showSosi;
        if (oldCurrentShowSosi != this.currentShowSosi()) {
            this.showSosiChanged();
        }
    }

    void showSosiChanged() {
        Element element = this.firstElement();
        while (element != null) {
            element.elementView(this).resetDisplayText();
            element = element.next();
        }
    }

    int showSosi() {
        return this._showSosiParm;
    }

    boolean currentShowSosi() {
        return ShowSosiParameter.getParameter().currentValue(this);
    }

    void setShowWhitespaceChar(int showWhitespaceChar) {
        boolean oldCurrentShowWhitespaceChar = this.currentShowWhitespaceChar();
        this._showWhitespaceCharParm = showWhitespaceChar;
        if (oldCurrentShowWhitespaceChar != this.currentShowWhitespaceChar()) {
            this.showWhitespaceCharChanged();
        }
    }

    void showWhitespaceCharChanged() {
        this.resetAllDisplayText();
    }

    void showHostCharChanged() {
        this.resetAllDisplayText();
    }

    void resetAllDisplayText() {
        Element element = this.firstElement();
        while (element != null) {
            element.elementView(this).resetDisplayText();
            element = element.next();
        }
    }

    int showWhitespaceChar() {
        return this._showWhitespaceCharParm;
    }

    boolean currentShowWhitespaceChar() {
        return ShowWhitespaceCharParameter.getParameter().currentValue(this);
    }

    boolean currentShowHostChar() {
        return ShowHostCharParameter.getParameter().currentValue(this);
    }

    void setWhitespaceCharMapping(Hashtable<Character, Character> whitespaceCharMapping) {
        this._whitespaceCharMapping = whitespaceCharMapping;
        this.showWhitespaceCharChanged();
    }

    void whitespaceCharMappingChanged() {
        this.resetAllDisplayText();
    }

    Hashtable<Character, Character> getWhitespaceCharMapping() {
        return this._whitespaceCharMapping;
    }

    Hashtable<Character, Character> currentWhitespaceCharMapping() {
        return WhitespaceCharacterUtil.getWhitespaceCharMappingHasttable(WhitespaceCharMappingParameter.getParameter().currentValue(this));
    }

    void lineNumbersChanged() {
        this._lineNumbersLength = LineNumbersParameters.LengthParameter.getParameter().currentValue(this);
        this._lineNumbersPad = LineNumbersParameters.PadParameter.getParameter().currentValue(this);
        this.setPrefixAreaWidthsInvalid();
    }

    void cursorWidthChanged() {
        this._cursorWidth = CursorParameters.WidthParameter.getParameter().currentValue(this);
    }

    int cursorWidth() {
        return this._cursorWidth;
    }

    int currentCursorBlinkTime() {
        return CursorParameters.BlinkTimeParameter.getParameter().currentValue(this);
    }

    void cursorBlinkTimeChanged() {
        if (this._lpexWindow != null) {
            ((TextWindow)this._lpexWindow.textWindow()).cursorBlinkTimeChanged();
        }
    }

    void styleAttributesChanged() {
        Element element = this.firstElement();
        while (element != null) {
            element.elementView(this).resetDisplayStyle();
            element = element.next();
        }
    }

    Classes classes() {
        return this._classes;
    }

    boolean forceAllVisible() {
        return this._forceAllVisible;
    }

    boolean setForceAllVisible(boolean forceAllVisible) {
        boolean oldForceAllVisible = this._forceAllVisible;
        this.setVisibleElementOrdinalsInvalid();
        this._forceAllVisible = forceAllVisible;
        return oldForceAllVisible;
    }

    void setEnforceTextLimit(int enforceTextLimitParm) {
        this._enforceTextLimitParm = enforceTextLimitParm;
    }

    int enforceTextLimit() {
        return this._enforceTextLimitParm;
    }

    void setFindTextIncremental(int findTextIncremental) {
        this._findTextIncremental = findTextIncremental;
    }

    int findTextIncremental() {
        return this._findTextIncremental;
    }

    void setVisualEditLineDialog(int visualEditLineDialog) {
        this._visualEditLineDialog = visualEditLineDialog;
    }

    int visualEditLineDialog() {
        return this._visualEditLineDialog;
    }

    boolean currentEnforceTextLimit() {
        return this._enforceTextLimit;
    }

    void elementRemoved(Element element) {
        this.documentPosition().elementRemoved(element);
        this._parsePendingList.elementRemoved(element);
        if (this._markList != null) {
            this._markList.elementRemoved(element);
        }
    }

    void elementInserted(Element element, boolean undoElement) {
        if (!element.show()) {
            int parsePendingFlags = 33;
            if (undoElement) {
                parsePendingFlags |= 0x40;
            }
            this._parsePendingList.add(element, parsePendingFlags);
        }
        this.setVisibleElementOrdinalsInvalid();
        if (this._markList != null) {
            this._markList.elementInserted(element);
        }
    }

    private void notifyMarksTextReplaced(Element element, int position, int len) {
        View view = this._document._firstView;
        while (view != null) {
            if (view._markList != null) {
                view._markList.textReplaced(element, position, len);
            }
            view = view._next;
        }
    }

    private void notifyMarksTextInserted(Element element, int position, int len) {
        View view = this._document._firstView;
        while (view != null) {
            if (view._markList != null) {
                view._markList.textInserted(element, position, len);
            }
            view = view._next;
        }
    }

    private void notifyMarksTextDeleted(Element element, int position, int len) {
        View view = this._document._firstView;
        while (view != null) {
            if (view._markList != null) {
                view._markList.textDeleted(element, position, len);
            }
            view = view._next;
        }
    }

    BlockCommand.Settings blockCommandSettings() {
        if (this._blockCommandSettings == null) {
            this._blockCommandSettings = new BlockCommand.Settings();
        }
        return this._blockCommandSettings;
    }

    CompareCommand.Settings compareCommandSettings() {
        if (this._compareCommandSettings == null) {
            this._compareCommandSettings = new CompareCommand.Settings();
        }
        return this._compareCommandSettings;
    }

    FindTextCommand.Settings findTextCommandSettings() {
        if (this._findTextCommandSettings == null) {
            this._findTextCommandSettings = new FindTextCommand.Settings();
        }
        return this._findTextCommandSettings;
    }

    PrintCommand.Settings printCommandSettings() {
        if (this._printCommandSettings == null) {
            this._printCommandSettings = new PrintCommand.Settings();
        }
        return this._printCommandSettings;
    }

    UpdateProfileCommand.Settings updateProfileCommandSettings() {
        if (this._updateProfileCommandSettings == null) {
            this._updateProfileCommandSettings = new UpdateProfileCommand.Settings();
        }
        return this._updateProfileCommandSettings;
    }

    ViHandler viHandler() {
        if (this._viHandler == null) {
            this._viHandler = new ViHandler(this);
        }
        return this._viHandler;
    }

    boolean vi() {
        return this._vi;
    }

    boolean autoCheck() {
        return this._autoCheck;
    }

    void setAutoCheck(boolean autoCheck) {
        this._autoCheck = autoCheck;
    }

    String fileLastComparedTo() {
        return this._lastComparedTo;
    }

    void setFileLastComparedTo(String fileName) {
        this._lastComparedTo = fileName;
    }

    String fileLastComparedToEncoding() {
        return this._lastComparedToEncoding;
    }

    void setFileLastComparedToEncoding(String fileEncoding) {
        this._lastComparedToEncoding = fileEncoding;
    }

    String fileLastComparedToSequenceNumbers() {
        return this._lastComparedToSequenceNumbers;
    }

    void setFileLastComparedToSequenceNumbers(String fileSequenceNumbers) {
        this._lastComparedToSequenceNumbers = fileSequenceNumbers;
    }

    void setCompareSession(boolean compareSession) {
        this._compareSession = compareSession;
    }

    boolean compareSession() {
        return this._compareSession;
    }

    FindTextOptions getFindTextOptions() {
        if (this._findTextOptions == null) {
            this._findTextOptions = new FindTextOptions();
        } else {
            this._findTextOptions.reset();
        }
        return this._findTextOptions;
    }

    LpexDocumentLocation documentLocation(int charOffset, int eolLength) {
        ElementList elementList = this.document().elementList();
        Element lastTextElement = null;
        int currentOffset = 0;
        Element e = elementList.first();
        while (e != null) {
            if (!e.show()) {
                if (currentOffset + elementList.fullTextLength(e) >= charOffset) {
                    int position = charOffset - currentOffset + 1;
                    if (position < 1) {
                        position = 1;
                    }
                    position = elementList.fullTextToTextPosition(e, position);
                    return new LpexDocumentLocation(elementList.ordinalOf(e), position);
                }
                lastTextElement = e;
                currentOffset += elementList.fullTextLength(e) + eolLength;
            }
            e = e.next();
        }
        if (lastTextElement == null) {
            return new LpexDocumentLocation(1, 1);
        }
        return new LpexDocumentLocation(elementList.ordinalOf(lastTextElement), lastTextElement.length() + 1);
    }

    int charOffset(LpexDocumentLocation documentLocation, int eolLength) {
        ElementList elementList = this.document().elementList();
        Element element = elementList.elementAt(documentLocation.element);
        int position = elementList.textToFullTextPosition(element, documentLocation.position);
        int currentOffset = 0;
        Element e = elementList.first();
        while (e != null) {
            if (e == element) {
                return e.show() ? currentOffset : currentOffset + position - 1;
            }
            if (!e.show()) {
                currentOffset += elementList.fullTextLength(e) + eolLength;
            }
            e = e.next();
        }
        return 0;
    }

    int visibleCharOffset(Element element, int position, int eolLength) {
        if (element == null) {
            return 0;
        }
        int targetOrdinal = this.visibleElementOrdinalOf(element);
        Element e = this._lastVisibleCharCountElementRequested;
        int currentCount = this._lastVisibleCharCount;
        boolean forward = true;
        if (e == null) {
            e = this._document.elementList().firstVisible(this);
            currentCount = 0;
        } else if (e != element) {
            int delta = targetOrdinal - this.visibleElementOrdinalOf(this._lastVisibleCharCountElementRequested);
            if (delta < 0) {
                delta = -delta;
                forward = false;
            }
            if (delta > targetOrdinal) {
                e = this._document.elementList().firstVisible(this);
                currentCount = 0;
                forward = true;
            }
        }
        while (e != null) {
            if (e == element) {
                if (position > e.length()) {
                    position = e.length() + 1;
                }
                this._lastVisibleCharCountElementRequested = e;
                this._lastVisibleCharCount = currentCount;
                return currentCount + position - 1 + eolLength * (targetOrdinal - 1);
            }
            if (forward) {
                currentCount += e.length();
                e = e.nextVisible(this);
                continue;
            }
            e = e.prevVisible(this);
            currentCount -= e.length();
        }
        return 0;
    }

    void verifyDocumentSection() {
        if (this.document().triggeringDocumentSectionListeners()) {
            return;
        }
        int neededLine = this.document().elementList().nonShowOrdinalOf(this.documentPosition().element()) + this.document().linesBeforeStart();
        int lowest = Math.max(1, neededLine - this._documentSectionThreshold);
        int highest = Math.min(this.document().linesCount(), neededLine + this._documentSectionThreshold);
        if (lowest < this.document().linesBeforeStart()) {
            this.document().triggerDocumentSectionListeners(this._lpexView, lowest);
        }
        if (highest > this.document().linesBeforeStart() + this.document().elementList().nonShowCount()) {
            this.document().triggerDocumentSectionListeners(this._lpexView, highest);
        }
    }

    void verifyDocumentSectionLine(int neededLine) {
        if (this.document().triggeringDocumentSectionListeners()) {
            return;
        }
        int lowest = Math.max(1, neededLine - this._documentSectionThreshold);
        int highest = Math.min(this.document().linesCount(), neededLine + this._documentSectionThreshold);
        if (lowest < this.document().linesBeforeStart()) {
            this.document().triggerDocumentSectionListeners(this._lpexView, lowest);
        } else if (highest > this.document().linesBeforeStart() + this.document().elementList().nonShowCount()) {
            this.document().triggerDocumentSectionListeners(this._lpexView, highest);
        }
    }

    void verifyDocumentSectionElement(int neededElement) {
        if (this.document().triggeringDocumentSectionListeners()) {
            return;
        }
        int sectionElements = this.document().elementList().count();
        int totalElements = this.document().linesBeforeStart() + sectionElements + this.document().linesAfterEnd();
        int lowest = Math.max(1, neededElement - this._documentSectionThreshold);
        int highest = Math.min(totalElements, neededElement + this._documentSectionThreshold);
        if (lowest < this.document().linesBeforeStart()) {
            this.document().triggerDocumentSectionListeners(this._lpexView, lowest);
        } else if (highest > this.document().linesBeforeStart() + sectionElements) {
            int showElements = sectionElements - this.document().elementList().nonShowCount();
            this.document().triggerDocumentSectionListeners(this._lpexView, highest - showElements);
        }
    }

    boolean verifyDocumentSectionDelta(int delta) {
        if (this.document().triggeringDocumentSectionListeners()) {
            return true;
        }
        if (delta == 0 || delta < 0 && this.document().linesBeforeStart() == 0 || delta > 0 && this.document().linesAfterEnd() == 0) {
            return true;
        }
        int neededLine = this.document().elementList().nonShowOrdinalOf(this.documentPosition().element()) + this.document().linesBeforeStart() + delta;
        if (delta < 0) {
            int lowest = Math.max(1, neededLine - this._documentSectionThreshold);
            if (lowest < this.document().linesBeforeStart()) {
                return this.document().triggerDocumentSectionListeners(this._lpexView, lowest);
            }
            return true;
        }
        int highest = Math.min(this.document().linesCount(), neededLine + this._documentSectionThreshold);
        if (highest > this.document().linesBeforeStart() + this.document().elementList().nonShowCount()) {
            return this.document().triggerDocumentSectionListeners(this._lpexView, highest);
        }
        return true;
    }

    void setDocumentSectionThreshold() {
        this._documentSectionThreshold = Math.max(100, this.screen().rows() * 2);
    }

    void setLpexMessageText(String key) {
        this.screen().setMessageText(LpexResources.message(key));
    }

    void setLpexMessageText(String key, int arg1) {
        this.screen().setMessageText(LpexResources.message(key, arg1));
    }

    void setLpexMessageText(String key, String arg1) {
        this.screen().setMessageText(LpexResources.message(key, arg1));
    }

    void setLpexMessageText(String key, String arg1, String arg2) {
        this.screen().setMessageText(LpexResources.message(key, arg1, arg2));
    }

    void setParserOverrideName(String name) {
        this._parsePendingList.setParserOverrideName(name);
    }

    void setHexSubStitutes(String subs) {
        this._hexSubs = subs;
    }

    String getHexSubstitutes() {
        return this._hexSubs;
    }

    public void setHostCharMapping(List<HostCharacterMapping> hostCharMappingList) {
        this._hostCharMapping = hostCharMappingList;
        this.showHostCharChanged();
    }

    public List<HostCharacterMapping> getHostCharMapping() {
        return this._hostCharMapping;
    }

    public void hostCharMappingChanged() {
        this.resetAllDisplayText();
    }

    public void setShowHostChar(int showHostChar) {
        boolean oldCurrentShowHosteChar = this.currentShowHostChar();
        this._showHostCharParm = showHostChar;
        if (oldCurrentShowHosteChar != this.currentShowHostChar()) {
            this.showHostCharChanged();
        }
    }

    public int showHostChar() {
        return this._showHostCharParm;
    }

    public int getBoundsStartCol() {
        return this._boundsStartColumn;
    }

    public int getBoundsEndCol() {
        return this._boundsEndColumn;
    }

    public void setBoundsStartCol(int col) {
        this._boundsStartColumn = col;
    }

    public void setBoundsEndCol(int col) {
        this._boundsEndColumn = col;
    }

    boolean isBidiFormatted() {
        return this._bidiFormatted;
    }

    public void setBidiFormatted() {
        this.setBidiFormatted(true);
    }

    public void setBidiFormatted(boolean bidi) {
        this._bidiFormatted = bidi;
    }
}

