/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.ActionUtilities;
import com.ibm.lpex.core.BeepParameter;
import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.CommandLine;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ElementList;
import com.ibm.lpex.core.KeyedList;
import com.ibm.lpex.core.LocateCommand;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.SetCommand;
import com.ibm.lpex.core.TextWindow;
import com.ibm.lpex.core.Undo;
import com.ibm.lpex.core.View;

final class ViHandler {
    static final int MODE_COMMAND = 0;
    static final int MODE_INSERT = 1;
    static final int MODE_REPLACE_CHARACTER = 2;
    static final int MODE_DELETE = 3;
    static final int MODE_YANK = 4;
    static final int MODE_REDRAW = 5;
    static final int MODE_CHANGE = 6;
    static final int MODE_REPLACE = 7;
    static final int MODE_BUFFER = 8;
    static final int MODE_FIND_CHARACTER = 9;
    static final int MODE_REVERSE_FIND_CHARACTER = 10;
    static final int MODE_FIND_BEFORE_CHARACTER = 11;
    static final int MODE_REVERSE_FIND_AFTER_CHARACTER = 12;
    static final int MODE_Z = 13;
    static final int MODE_MARK = 14;
    static final int MODE_TO = 15;
    static final int MODE_TO_FIRST_NON_WHITESPACE = 16;
    static final int MODE_BUFFER_COMMAND = 17;
    static final int MODE_INDENT = 18;
    static final int MODE_UNINDENT = 19;
    private View _view;
    private int _mode;
    private int _count;
    private String _insertString;
    private char _findCharacterCommand;
    private char _findCharacter;
    private String[] _buffers = new String[35];
    private int _currentBuffer;
    private boolean _appendToBuffer;
    private String _findCommand;
    private String _substituteCommand;
    private boolean _nextCharacterIsQuoted;
    private String _lastChangeCommand;
    private int _lastChangeCount;
    private int _lastChangeBuffer;
    private boolean _viChange;
    private Element _element;
    private int _position;
    private Element _savedElement;
    private String _savedText;
    private KeyedList _abbreviations = new KeyedList();
    private int _currentBufferCommand;
    private boolean _ignoreCount;
    private static final char CTRL_B = '\u0002';
    private static final char CTRL_D = '\u0004';
    private static final char CTRL_E = '\u0005';
    private static final char CTRL_F = '\u0006';
    private static final char CTRL_H = '\b';
    private static final char CTRL_J = '\n';
    private static final char CTRL_M = '\r';
    private static final char CTRL_N = '\u000e';
    private static final char CTRL_P = '\u0010';
    private static final char CTRL_U = '\u0015';
    private static final char CTRL_V = '\u0016';
    private static final char CTRL_W = '\u0017';
    private static final char CTRL_Y = '\u0019';
    private static final char CTRL_OPENBRACKET = '\u001b';

    ViHandler(View view) {
        this._view = view;
        this.setCommandMode();
    }

    void verifyMode() {
        if (this._mode != 0) {
            TextWindow textWindow = null;
            if (this._view.window() != null) {
                textWindow = (TextWindow)this._view.window().textWindow();
            }
            if (textWindow == null || !textWindow.focusGained()) {
                if (!this._view.parsePendingList().inParser()) {
                    this.setCommandMode();
                }
            } else if (!(this._mode != 7 && this._mode != 1 || this._view.documentPosition().element() == this._element && this._view.documentPosition().position() == this._position || this._view.parsePendingList().inParser())) {
                this.setCommandMode();
            }
        }
        if (this._savedElement != this._view.documentPosition().element()) {
            this._savedElement = null;
            this._savedText = null;
        }
    }

    void verifyChange() {
        if (!(this._viChange || this._mode != 1 && this._mode != 7 || this._view.parsePendingList().inParser())) {
            this.setCommandMode();
        }
    }

    void verifyChangeCheck() {
        if (!(this._viChange || this._mode != 1 && this._mode != 7 || this._view.parsePendingList().inParser())) {
            this.setCommandMode();
        }
    }

    int mode() {
        return this._mode;
    }

    void setCommandMode() {
        this._mode = 0;
        this._count = 0;
        this._currentBuffer = 0;
        this._appendToBuffer = false;
        this._nextCharacterIsQuoted = false;
        this._element = null;
        this._position = 0;
        this._ignoreCount = false;
        this._view.document().undo().check(this._view);
    }

    private void setInsertMode() {
        this._mode = 1;
        this._insertString = "";
        this._element = this._view.documentPosition().element();
        this._position = this._view.documentPosition().position();
    }

    private void setDeleteMode() {
        this._mode = 3;
    }

    private void setReplaceCharacterMode() {
        this._mode = 2;
    }

    private void setYankMode() {
        this._mode = 4;
    }

    private void setChangeMode() {
        this._mode = 6;
    }

    private void setRedrawMode() {
        this._mode = 5;
    }

    private void setReplaceMode() {
        this._mode = 7;
        this._insertString = "";
        this._element = this._view.documentPosition().element();
        this._position = this._view.documentPosition().position();
    }

    private void setBufferMode() {
        this._mode = 8;
    }

    private void setFindCharacterMode() {
        this._mode = 9;
    }

    private void setReverseFindCharacterMode() {
        this._mode = 10;
    }

    private void setFindBeforeCharacterMode() {
        this._mode = 11;
    }

    private void setReverseFindAfterCharacterMode() {
        this._mode = 12;
    }

    private void setZMode() {
        this._mode = 13;
    }

    private void setMarkMode() {
        this._mode = 14;
    }

    private void setToMode() {
        this._mode = 15;
    }

    private void setToFirstNonWhitespaceMode() {
        this._mode = 16;
    }

    private void setBufferCommandMode() {
        this._mode = 17;
    }

    private void setIndentMode() {
        this._mode = 18;
    }

    private void setUnindentMode() {
        this._mode = 19;
    }

    void processLpexKey(String lpexKey) {
        if (lpexKey != null && lpexKey.length() >= 3) {
            char c = switch (lpexKey.charAt(2)) {
                case 'b' -> '\u0002';
                case 'd' -> '\u0004';
                case 'e' -> '\u0005';
                case 'f' -> '\u0006';
                case 'h' -> '\b';
                case 'j' -> '\n';
                case 'm' -> '\r';
                case 'n' -> '\u000e';
                case 'p' -> '\u0010';
                case 'u' -> '\u0015';
                case 'v' -> '\u0016';
                case 'w' -> '\u0017';
                case 'y' -> '\u0019';
                default -> '\u0000';
            };
            if (c != '\u0000') {
                this.processCharacter(c);
            }
        }
    }

    void processCharacter(char c) {
        switch (this._mode) {
            case 0: {
                if (this._count == 0 && c >= '1' && c <= '9') {
                    this._count = c - 48;
                    break;
                }
                if (this._count != 0 && c >= '0' && c <= '9') {
                    this._count *= 10;
                    this._count += c - 48;
                    break;
                }
                this.processCommandCharacter(c);
                break;
            }
            case 1: {
                this.processInputCharacter(c);
                break;
            }
            case 2: {
                this.processReplaceCharacter(c);
                break;
            }
            case 3: {
                this.processDeleteCharacter(c);
                break;
            }
            case 6: {
                this.processChangeCharacter(c);
                break;
            }
            case 9: {
                this.processFindCharacter(c);
                break;
            }
            case 10: {
                this.processReverseFindCharacter(c);
                break;
            }
            case 11: {
                this.processFindBeforeCharacter(c);
                break;
            }
            case 12: {
                this.processReverseFindAfterCharacter(c);
                break;
            }
            case 4: {
                this.processYankCharacter(c);
                break;
            }
            case 5: {
                this.processRedrawCharacter(c);
                break;
            }
            case 7: {
                this.processInputCharacter(c);
                break;
            }
            case 8: {
                this.processBufferCharacter(c);
                break;
            }
            case 13: {
                this.processZCharacter(c);
                break;
            }
            case 14: {
                this.processMarkCharacter(c);
                break;
            }
            case 15: {
                this.processToCharacter(c);
                break;
            }
            case 16: {
                this.processToFirstNonWhitespaceCharacter(c);
                break;
            }
            case 17: {
                this.processBufferCommandCharacter(c);
                break;
            }
            case 18: {
                this.processIndentCharacter(c);
                break;
            }
            case 19: {
                this.processUnindentCharacter(c);
                break;
            }
            default: {
                this.setCommandMode();
            }
        }
    }

    private void processCommandCharacter(char c) {
        switch (c) {
            case '\"': {
                this.setBufferMode();
                break;
            }
            case '$': {
                this.endOfLine();
                break;
            }
            case '%': {
                this.matchingParenthesisOrBrace();
                break;
            }
            case '&': {
                this.repeatSubstitute();
                break;
            }
            case '\'': {
                this.setToFirstNonWhitespaceMode();
                break;
            }
            case '+': {
                this.firstNonWhitespaceOnNextLine();
                break;
            }
            case ',': {
                this.reverseRepeatFindCharacter();
                break;
            }
            case '-': {
                this.firstNonWhitespaceOnPreviousLine();
                break;
            }
            case '`': {
                this.setToMode();
                break;
            }
            case '.': {
                this.repeatLastChange();
                break;
            }
            case '/': 
            case ':': {
                this.exCommand(c);
                break;
            }
            case ';': {
                this.repeatFindCharacter();
                break;
            }
            case '<': {
                this.startChangeCommand(c);
                this.setUnindentMode();
                break;
            }
            case '>': {
                this.startChangeCommand(c);
                this.setIndentMode();
                break;
            }
            case '?': {
                this.exCommand(c);
                break;
            }
            case '@': {
                this.setBufferCommandMode();
                break;
            }
            case '^': {
                this.firstNonWhitespace();
                break;
            }
            case '_': {
                this.firstNonWhitespaceOnNextLineMinus1();
                break;
            }
            case '|': {
                this.column();
                break;
            }
            case '~': {
                this.startChangeCommand(c);
                this.toggleCharacterCase();
                break;
            }
            case '0': {
                this.startOfLine();
                break;
            }
            case 'a': {
                this.insertAfter();
                break;
            }
            case 'A': {
                this.insertAtEndOfLine();
                break;
            }
            case 'B': 
            case 'b': {
                this.startOfWord();
                break;
            }
            case 'c': {
                this.startChangeCommand(c);
                this.setChangeMode();
                break;
            }
            case 'C': {
                this.startChangeCommand(c);
                this.changeToLineEnd();
                break;
            }
            case 'd': {
                this.startChangeCommand(c);
                this.setDeleteMode();
                break;
            }
            case 'D': {
                this.startChangeCommand(c);
                this.deleteToLineEnd();
                break;
            }
            case 'E': 
            case 'e': {
                this.endOfWord();
                break;
            }
            case 'f': {
                this.setFindCharacterMode();
                break;
            }
            case 'F': {
                this.setReverseFindCharacterMode();
                break;
            }
            case 'G': {
                this.goToLine();
                break;
            }
            case 'h': {
                this.arrowLeft();
                break;
            }
            case 'H': {
                this.firstNonWhitespaceAtScreenTop();
                break;
            }
            case 'i': {
                this.startChangeCommand(c);
                this.setInsertMode();
                break;
            }
            case 'I': {
                this.startChangeCommand(c);
                this.insertAtStartOfLine();
                break;
            }
            case 'j': {
                this.down();
                break;
            }
            case 'J': {
                this.startChangeCommand(c);
                this.join();
                break;
            }
            case 'k': {
                this.up();
                break;
            }
            case 'l': {
                this.arrowRight();
                break;
            }
            case 'L': {
                this.firstNonWhitespaceAtScreenBottom();
                break;
            }
            case 'm': {
                this.setMarkMode();
                break;
            }
            case 'M': {
                this.firstNonWhitespaceAtScreenMiddle();
                break;
            }
            case 'n': {
                this.repeatFind();
                break;
            }
            case 'N': {
                this.reverseRepeatFind();
                break;
            }
            case 'o': {
                this.startChangeCommand(c);
                this.insertNewLine();
                break;
            }
            case 'O': {
                this.startChangeCommand(c);
                this.insertNewLineBefore();
                break;
            }
            case 'p': {
                this.startChangeCommand(c);
                this.pasteAfter();
                break;
            }
            case 'P': {
                this.startChangeCommand(c);
                this.paste();
                break;
            }
            case 'r': {
                this.startChangeCommand(c);
                this.setReplaceCharacterMode();
                break;
            }
            case 'R': {
                this.startChangeCommand(c);
                this.setReplaceMode();
                break;
            }
            case 's': {
                this.startChangeCommand(c);
                this.substitute();
                break;
            }
            case 'S': {
                this.startChangeCommand(c);
                this.changeLine();
                break;
            }
            case 't': {
                this.setFindBeforeCharacterMode();
                break;
            }
            case 'T': {
                this.setReverseFindAfterCharacterMode();
                break;
            }
            case 'u': {
                this.undo();
                break;
            }
            case 'U': {
                this.undoLine();
                break;
            }
            case 'W': 
            case 'w': {
                this.nextWord();
                break;
            }
            case 'x': {
                this.startChangeCommand(c);
                this.deleteCharacter();
                break;
            }
            case 'X': {
                this.startChangeCommand(c);
                this.deleteCharacterBefore();
                break;
            }
            case 'y': {
                this.setYankMode();
                break;
            }
            case 'Y': {
                this.yankLine();
                break;
            }
            case 'z': {
                this.setRedrawMode();
                break;
            }
            case 'Z': {
                this.setZMode();
                break;
            }
            case '\u0002': {
                this.scrollPageBackward();
                break;
            }
            case '\u0004': {
                this.scrollForwardHalfScreen();
                break;
            }
            case '\u0005': {
                this.scrollForward();
                break;
            }
            case '\u0006': {
                this.scrollPageForward();
                break;
            }
            case '\b': {
                this.arrowLeft();
                break;
            }
            case '\n': {
                this.down();
                break;
            }
            case '\r': {
                this.firstNonWhitespaceOnNextLine();
                break;
            }
            case '\u000e': {
                this.down();
                break;
            }
            case '\u0010': {
                this.up();
                break;
            }
            case '\u0015': {
                this.scrollBackwardHalfScreen();
                break;
            }
            case '\u0019': {
                this.scrollBackward();
                break;
            }
            default: {
                this.beep();
                this.setCommandMode();
            }
        }
    }

    private void processInputCharacter(char c) {
        this._lastChangeCommand = String.valueOf(this._lastChangeCommand) + c;
        if (!this._nextCharacterIsQuoted && c == '\u001b') {
            this.expandAbbreviation();
            if (!this._ignoreCount) {
                if (this._count == 0) {
                    this._count = 1;
                }
                int i = 1;
                while (i < this._count) {
                    this._viChange = true;
                    this._view.insertText(this._insertString);
                    this._viChange = false;
                    ++i;
                }
            }
            this.setCommandMode();
            this._view.documentPosition().left();
        } else if (!this._nextCharacterIsQuoted && c == '\b') {
            if (this._insertString.length() > 0) {
                this._viChange = true;
                ActionUtilities.doDefaultAction(this._view, 31);
                this._viChange = false;
                this._insertString = this._insertString.substring(0, this._insertString.length() - 1);
                this._element = this._view.documentPosition().element();
                this._position = this._view.documentPosition().position();
            } else {
                this.beep();
            }
        } else if (!this._nextCharacterIsQuoted && c == '\u0016') {
            this._nextCharacterIsQuoted = true;
        } else if (!this._nextCharacterIsQuoted && c == '\u0017') {
            int backSpaces = 0;
            int i = this._insertString.length() - 1;
            while (i >= 0) {
                c = this._insertString.charAt(i);
                if (c != ' ') break;
                --i;
            }
            while (i >= 0) {
                c = this._insertString.charAt(i);
                if (c == ' ' || c == '\n') break;
                backSpaces = backSpaces == 0 ? this._insertString.length() - i : ++backSpaces;
                --i;
            }
            if (backSpaces > 0) {
                this._viChange = true;
                this._view.documentPosition().left(backSpaces);
                this._view.deleteText(this._view.documentPosition().element(), this._view.documentPosition().position(), backSpaces);
                this._viChange = false;
                this._insertString = this._insertString.substring(0, this._insertString.length() - backSpaces);
                this._element = this._view.documentPosition().element();
                this._position = this._view.documentPosition().position();
            } else {
                this.beep();
            }
        } else {
            if (c == '\r') {
                c = (char)10;
            }
            if (!(this._nextCharacterIsQuoted || c != ' ' && c != '\n' && c != '\t')) {
                this.expandAbbreviation();
            }
            this._nextCharacterIsQuoted = false;
            this._viChange = true;
            if (this._mode == 1) {
                if (c == '\n') {
                    this._view.actionHandler().doAction(194);
                } else {
                    this._view.insertText(String.valueOf(c));
                }
            } else {
                this._view.replaceText(String.valueOf(c));
            }
            this._viChange = false;
            this._insertString = String.valueOf(this._insertString) + c;
            this._element = this._view.documentPosition().element();
            this._position = this._view.documentPosition().position();
        }
    }

    private void processReplaceCharacter(char c) {
        this._lastChangeCommand = String.valueOf(this._lastChangeCommand) + c;
        if (this._count == 0) {
            this._count = 1;
        }
        int i = 0;
        while (i < this._count) {
            this._view.replaceText(String.valueOf(c));
            ++i;
        }
        this.setCommandMode();
    }

    private void processDeleteCharacter(char c) {
        this._lastChangeCommand = String.valueOf(this._lastChangeCommand) + c;
        switch (c) {
            case '^': {
                this.deleteToLineStart();
                break;
            }
            case '$': {
                this.deleteToLineEnd();
                break;
            }
            case 'd': {
                this.deleteLine();
                break;
            }
            case 'w': {
                this.deleteToWordEnd();
                break;
            }
            default: {
                this.beep();
                this.setCommandMode();
            }
        }
    }

    private void processChangeCharacter(char c) {
        this._lastChangeCommand = String.valueOf(this._lastChangeCommand) + c;
        switch (c) {
            case '^': {
                this.deleteToLineStart();
                this.setInsertMode();
                break;
            }
            case '$': {
                this.deleteToLineEnd();
                this.setInsertMode();
                break;
            }
            case 'c': {
                this.changeLine();
                break;
            }
            case 'w': {
                this.deleteToWordEnd();
                this._ignoreCount = true;
                this.setInsertMode();
                break;
            }
            default: {
                this.beep();
                this.setCommandMode();
            }
        }
    }

    private void processFindCharacter(char c) {
        this._findCharacterCommand = (char)102;
        this._findCharacter = c;
        this.findCharacter();
    }

    private void processReverseFindCharacter(char c) {
        this._findCharacterCommand = (char)70;
        this._findCharacter = c;
        this.reverseFindCharacter();
    }

    private void processFindBeforeCharacter(char c) {
        this._findCharacterCommand = (char)116;
        this._findCharacter = c;
        this.findCharacter();
    }

    private void processReverseFindAfterCharacter(char c) {
        this._findCharacterCommand = (char)84;
        this._findCharacter = c;
        this.reverseFindCharacter();
    }

    private void processYankCharacter(char c) {
        switch (c) {
            case '^': {
                this.yankToLineStart();
                break;
            }
            case '$': {
                this.yankToLineEnd();
                break;
            }
            case 'w': {
                this.yankToWordEnd();
                break;
            }
            case 'y': {
                this.yankLine();
                break;
            }
            default: {
                this.beep();
                this.setCommandMode();
            }
        }
    }

    private void processRedrawCharacter(char c) {
        switch (c) {
            case '\r': {
                this.scrollTop();
                break;
            }
            case '.': {
                this.scrollCenter();
                break;
            }
            case '-': {
                this.scrollBottom();
                break;
            }
            default: {
                this.beep();
                this.setCommandMode();
            }
        }
    }

    private void processBufferCharacter(char c) {
        if (c >= 'a' && c <= 'z') {
            this._currentBuffer = 9 + c - 97;
            this._appendToBuffer = false;
            this._mode = 0;
        } else if (c >= 'A' && c < 'Z') {
            this._currentBuffer = 9 + c - 65;
            this._appendToBuffer = true;
            this._mode = 0;
        } else if (c >= '1' && c <= '9') {
            this._currentBuffer = c - 49;
            this._appendToBuffer = false;
            this._mode = 0;
        } else {
            this.setCommandMode();
        }
    }

    private void processZCharacter(char c) {
        if (c == 'Z') {
            CommandHandler.setStatus(null);
            Undo undo = this._view.document().undo();
            if (undo.dirty() || undo.changes() != 0) {
                this._view.commandHandler().doCommand("save");
            }
            if (CommandHandler.getStatus() == null) {
                this._view.commandHandler().doCommand("quit");
            }
        } else {
            this.beep();
        }
        this.setCommandMode();
    }

    private void processMarkCharacter(char c) {
        if (c >= 'a' && c <= 'z') {
            SetCommand.doCommand(this._view, "mark." + c);
        } else {
            this.beep();
        }
        this.setCommandMode();
    }

    private void processToCharacter(char c) {
        if (c >= 'a' && c <= 'z') {
            this.beforeJump();
            LocateCommand.doCommand(this._view, "mark " + c);
        } else if (c == '`') {
            SetCommand.doCommand(this._view, "mark.@OLD");
            LocateCommand.doCommand(this._view, "mark @QUICK");
            SetCommand.doCommand(this._view, "mark.@NEW");
            LocateCommand.doCommand(this._view, "mark @OLD");
            SetCommand.doCommand(this._view, "mark.@QUICK");
            LocateCommand.doCommand(this._view, "mark @NEW");
            SetCommand.doCommand(this._view, "mark.@OLD clear");
            SetCommand.doCommand(this._view, "mark.@NEW clear");
        } else {
            this.beep();
        }
        this.setCommandMode();
    }

    private void processToFirstNonWhitespaceCharacter(char c) {
        if (c >= 'a' && c <= 'z') {
            this.beforeJump();
            LocateCommand.doCommand(this._view, "mark " + c);
            if (CommandHandler.getStatus() == null) {
                this._view.documentPosition().home();
            }
        } else if (c == '\'') {
            SetCommand.doCommand(this._view, "mark.@OLD");
            LocateCommand.doCommand(this._view, "mark @QUICK");
            SetCommand.doCommand(this._view, "mark.@NEW");
            LocateCommand.doCommand(this._view, "mark @OLD");
            SetCommand.doCommand(this._view, "mark.@QUICK");
            LocateCommand.doCommand(this._view, "mark @NEW");
            SetCommand.doCommand(this._view, "mark.@OLD clear");
            SetCommand.doCommand(this._view, "mark.@NEW clear");
            if (CommandHandler.getStatus() == null) {
                this._view.documentPosition().home();
            }
        } else {
            this.beep();
        }
        this.setCommandMode();
    }

    private void processBufferCommandCharacter(char c) {
        String command = null;
        if (c >= 'a' && c <= 'z') {
            this._currentBufferCommand = 9 + c - 97;
            command = this._buffers[this._currentBufferCommand];
        } else if (c == '@' && this._currentBufferCommand != 0) {
            command = this._buffers[this._currentBufferCommand];
        }
        if (command != null && command.length() > 0) {
            if (command.charAt(0) == '\n') {
                command = command.substring(1);
            }
            this.doCommand(command);
        }
        this.setCommandMode();
    }

    private void processIndentCharacter(char c) {
        this._lastChangeCommand = String.valueOf(this._lastChangeCommand) + c;
        if (c == '>') {
            if (this._count == 0) {
                this._count = 1;
            }
            Element element = this._view.documentPosition().element();
            int i = 0;
            while (i < this._count) {
                if (element != null && !element.show()) {
                    this._view.insertText(element, 1, "\t");
                    element = element.nextVisibleNonShow(this._view);
                }
                ++i;
            }
        } else {
            this.beep();
        }
        this.setCommandMode();
    }

    private void processUnindentCharacter(char c) {
        this._lastChangeCommand = String.valueOf(this._lastChangeCommand) + c;
        if (c == '<') {
            if (this._count == 0) {
                this._count = 1;
            }
            Element element = this._view.documentPosition().element();
            int i = 0;
            while (i < this._count) {
                if (element != null && !element.show()) {
                    String text = element.text();
                    if (text.length() > 0 && text.charAt(0) == '\t') {
                        this._view.deleteText(element, 1, 1);
                    }
                    element = element.nextVisibleNonShow(this._view);
                }
                ++i;
            }
        } else {
            this.beep();
        }
        this.setCommandMode();
    }

    void doCommand(String commandString) {
        if (commandString != null && commandString.length() > 0) {
            if (commandString.charAt(0) == ':') {
                Command command = new Command(commandString);
                boolean badCommand = false;
                if (command.isCommand("lpex", 2)) {
                    if (command.skipOptionalCharacter(' ')) {
                        this._view.commandHandler().doCommand(command.remainingText());
                    } else {
                        badCommand = true;
                    }
                } else if (command.isCommand("quit", 1)) {
                    boolean exclamationMark = command.skipCharacter('!');
                    if (!command.noRemainingText()) {
                        badCommand = true;
                    } else {
                        Undo undo;
                        if (!exclamationMark && ((undo = this._view.document().undo()).dirty() || undo.changes() != 0)) {
                            this._view.setLpexMessageText("vi.quitUnsavedChanges");
                            return;
                        }
                        this._view.commandHandler().doCommand("quit");
                    }
                } else if (command.isCommand("wq", 2)) {
                    if (command.noRemainingText()) {
                        CommandHandler.setStatus(null);
                        Undo undo = this._view.document().undo();
                        if (undo.dirty() || undo.changes() != 0) {
                            this._view.commandHandler().doCommand("save");
                        }
                        if (CommandHandler.getStatus() == null) {
                            this._view.commandHandler().doCommand("quit");
                        }
                    } else {
                        badCommand = true;
                    }
                } else if (command.isCommand("w", 1)) {
                    boolean exclamationMark = command.skipCharacter('!');
                    if (!command.skipOptionalCharacter(' ')) {
                        badCommand = true;
                    } else if (command.noRemainingText()) {
                        if (!exclamationMark) {
                            Undo undo = this._view.document().undo();
                            if (undo.dirty() || undo.changes() != 0) {
                                this._view.commandHandler().doCommand("save");
                            }
                        } else {
                            this._view.commandHandler().doCommand("save");
                        }
                    } else {
                        this._view.commandHandler().doCommand("save " + command.remainingText());
                    }
                } else if (command.isCommand("edit", 1)) {
                    boolean exclamationMark = command.skipCharacter('!');
                    if (!command.skipOptionalCharacter(' ')) {
                        badCommand = true;
                    } else {
                        Undo undo = this._view.document().undo();
                        if (!exclamationMark && (undo.dirty() || undo.changes() != 0)) {
                            this._view.setLpexMessageText("vi.editUnsavedChanges");
                        } else {
                            if (!command.noRemainingText()) {
                                this._view.document().setName(command.remainingText());
                            }
                            this._view.commandHandler().doCommand("load");
                        }
                    }
                } else if (command.isCommand("abbreviate", 2)) {
                    if (!command.skipOptionalCharacter(' ')) {
                        badCommand = true;
                    } else {
                        String abbreviation = command.nextToken();
                        this._abbreviations.set(abbreviation, command.remainingText());
                    }
                } else if (command.isCommand("unabbreviate", 3)) {
                    if (!command.skipOptionalCharacter(' ')) {
                        badCommand = true;
                    } else {
                        String abbreviation = command.nextToken();
                        if (command.noRemainingText()) {
                            this._abbreviations.set(abbreviation, null);
                        } else {
                            badCommand = true;
                        }
                    }
                } else if (command.isCommand("substitute", 1)) {
                    if (!command.skipCharacter('/')) {
                        badCommand = true;
                    } else {
                        String findText = command.nextToken('/');
                        if (findText.length() == 0 || !command.skipCharacter('/')) {
                            badCommand = true;
                        } else {
                            Object options;
                            String replaceText = command.nextToken('/');
                            boolean global = false;
                            if (command.skipCharacter('/')) {
                                options = command.nextToken();
                                int i = 0;
                                while (i < ((String)options).length()) {
                                    char c = ((String)options).charAt(i);
                                    if (c == 'g') {
                                        global = true;
                                    } else if (c != 'c') {
                                        badCommand = true;
                                    }
                                    ++i;
                                }
                            }
                            if (!badCommand) {
                                this._substituteCommand = commandString;
                                options = "asis ";
                                if (global) {
                                    options = (String)options + "all ";
                                }
                                this._view.commandHandler().doCommand("findText " + (String)options + "replaceWith " + LpexStringTokenizer.addQuotes(replaceText) + " " + LpexStringTokenizer.addQuotes(findText));
                            }
                        }
                    }
                }
                if (badCommand) {
                    this._view.setLpexMessageText("command.invalid", commandString);
                }
            } else if (commandString.charAt(0) == '/') {
                this.beforeJump();
                this._findCommand = commandString;
                this._view.commandHandler().doCommand("findText asis " + LpexStringTokenizer.addQuotes(commandString.substring(1)));
            } else if (commandString.charAt(0) == '?') {
                this.beforeJump();
                this._findCommand = commandString;
                this._view.commandHandler().doCommand("findText up asis " + LpexStringTokenizer.addQuotes(commandString.substring(1)));
            } else {
                this._view.setLpexMessageText("command.invalid", commandString);
            }
        }
    }

    private void insertAfter() {
        this._view.documentPosition().right();
        this.setInsertMode();
    }

    private void insertAtEndOfLine() {
        this._view.documentPosition().end();
        this.setInsertMode();
    }

    private void arrowLeft() {
        if (this._count == 0) {
            this._count = 1;
        }
        this._view.documentPosition().arrowLeft(this._count);
        this.setCommandMode();
    }

    private void insertAtStartOfLine() {
        this._view.documentPosition().home();
        this.setInsertMode();
    }

    private void down() {
        if (this._count == 0) {
            this._count = 1;
        }
        this._view.documentPosition().down(this._count);
        this.setCommandMode();
    }

    private void up() {
        if (this._count == 0) {
            this._count = 1;
        }
        this._view.documentPosition().up(this._count);
        this.setCommandMode();
    }

    private void arrowRight() {
        if (this._count == 0) {
            this._count = 1;
        }
        this._view.documentPosition().arrowRight(this._count);
        this.setCommandMode();
    }

    private void insertNewLine() {
        Element element = new Element(this._view.document());
        this._view.insertElement(element);
        this.setInsertMode();
    }

    private void insertNewLineBefore() {
        Element element = new Element(this._view.document());
        this._view.insertElementBefore(element);
        this.setInsertMode();
    }

    private void undo() {
        Undo undo = this._view.document().undo();
        if (undo.redoAvailable()) {
            undo.redo(this._view);
        } else {
            undo.undo(this._view);
        }
        this._savedElement = null;
        this._savedText = null;
        this.setCommandMode();
    }

    private void undoLine() {
        if (this._savedElement != null && this._savedElement == this._view.documentPosition().element()) {
            this._view.overlayElements(this._savedText);
            this._view.documentPosition().home();
        } else {
            this.beep();
        }
    }

    private void deleteCharacter() {
        if (this._count == 0) {
            this._count = 1;
        }
        String deletedText = this._view.deleteText(this._count);
        this.storeInBuffer(deletedText);
        this.setCommandMode();
    }

    private void deleteCharacterBefore() {
        int position;
        if (this._count == 0) {
            this._count = 1;
        }
        if (this._count <= (position = this._view.documentPosition().position()) - 1) {
            this._view.documentPosition().left(this._count);
            String deletedText = this._view.deleteText(this._count);
            this.storeInBuffer(deletedText);
        } else {
            this.beep();
        }
        this.setCommandMode();
    }

    private void pasteAfter() {
        if (this._buffers[this._currentBuffer] != null && this._buffers[this._currentBuffer].length() > 0) {
            if (this._buffers[this._currentBuffer].charAt(0) == '\n') {
                Element element = new Element(this._view.document());
                this._view.insertElement(element);
                this._view.insertText(this._buffers[this._currentBuffer].substring(1));
            } else {
                this._view.documentPosition().right();
                this._view.insertText(this._buffers[this._currentBuffer]);
                this._view.documentPosition().left();
            }
            this.setCommandMode();
        }
    }

    private void paste() {
        if (this._buffers[this._currentBuffer] != null && this._buffers[this._currentBuffer].length() > 0) {
            if (this._buffers[this._currentBuffer].charAt(0) == '\n') {
                Element element = new Element(this._view.document());
                this._view.insertElementBefore(element);
                this._view.insertText(this._buffers[this._currentBuffer].substring(1));
            } else {
                this._view.insertText(this._buffers[this._currentBuffer]);
                this._view.documentPosition().left();
            }
            this.setCommandMode();
        }
    }

    private void changeToLineEnd() {
        String text;
        int position = this._view.documentPosition().position();
        Element element = this._view.documentPosition().element();
        if (element != null && !element.show() && (text = element.text()).length() >= position) {
            String deletedText = this._view.deleteText(element, position, text.length() - position + 1);
            this.storeInBuffer(deletedText);
        }
        this.setInsertMode();
    }

    private void deleteToLineStart() {
        int position = this._view.documentPosition().position();
        Element element = this._view.documentPosition().element();
        if (element != null && !element.show()) {
            String deletedText = this._view.deleteText(element, 1, position - 1);
            this.storeInBuffer(deletedText);
        }
        this.setCommandMode();
    }

    private void deleteToLineEnd() {
        String text;
        int position = this._view.documentPosition().position();
        Element element = this._view.documentPosition().element();
        if (element != null && !element.show() && (text = element.text()).length() >= position) {
            String deletedText = this._view.deleteText(element, position, text.length() - position + 1);
            this.storeInBuffer(deletedText);
        }
        this.setCommandMode();
    }

    private void deleteToWordEnd() {
        int position = this._view.documentPosition().position();
        Element element = this._view.documentPosition().element();
        if (element != null && !element.show()) {
            if (this._count == 0) {
                this._count = 1;
            }
            StringBuilder deletedText = new StringBuilder();
            int i = 0;
            while (i < this._count) {
                int wordEndPosition = ElementList.nextWordEnd(element, position);
                if (wordEndPosition == 0) {
                    wordEndPosition = position;
                }
                deletedText.append(this._view.deleteText(element, position, wordEndPosition - position + 2));
                ++i;
            }
            this.storeInBuffer(deletedText.toString());
        }
        this.setCommandMode();
    }

    private void deleteLine() {
        if (this._count == 0) {
            this._count = 1;
        }
        int lastOrdinal = 0;
        StringBuilder deletedText = new StringBuilder();
        ElementList elementList = this._view.document().elementList();
        int i = 0;
        while (i < this._count) {
            Element element = this._view.documentPosition().element();
            if (element != null) {
                int ordinal = elementList.ordinalOf(element);
                if (ordinal < lastOrdinal || this._view.markList().protect(element) || !element.show() && !this._view.changeAllowed()) break;
                deletedText.append("\n");
                deletedText.append(element.text());
                this._view.deleteElement(element);
                lastOrdinal = ordinal;
            }
            ++i;
        }
        this.storeInBuffer(deletedText.toString());
        this.setCommandMode();
    }

    private void changeLine() {
        Element element;
        if (this._count == 0) {
            this._count = 1;
        }
        int lastOrdinal = 0;
        StringBuilder deletedText = new StringBuilder();
        ElementList elementList = this._view.document().elementList();
        int i = 0;
        while (i < this._count - 1) {
            Element element2 = this._view.documentPosition().element();
            if (element2 != null) {
                int ordinal = elementList.ordinalOf(element2);
                if (ordinal < lastOrdinal || this._view.markList().protect(element2) || !element2.show() && !this._view.changeAllowed()) break;
                deletedText.append("\n");
                deletedText.append(element2.text());
                this._view.deleteElement(element2);
                lastOrdinal = ordinal;
            }
            ++i;
        }
        if ((element = this._view.documentPosition().element()) != null) {
            if (this._count > 1) {
                deletedText.append("\n");
            }
            if (element.show()) {
                deletedText.append(element.text());
                element = new Element(this._view.document());
                this._view.insertElement(element);
                this._view.deleteElement(element);
            } else {
                deletedText.append(this._view.deleteText(element, 1, element.length()));
                this._view.documentPosition().home();
            }
        } else {
            element = new Element(this._view.document());
            this._view.insertElement(element);
        }
        this.storeInBuffer(deletedText.toString());
        this._ignoreCount = true;
        this.setInsertMode();
    }

    private void yankToLineStart() {
        int position = this._view.documentPosition().position();
        Element element = this._view.documentPosition().element();
        if (element != null) {
            String text = element.text();
            if (position > text.length()) {
                position = text.length();
            }
            if (position > 0) {
                this.storeInBuffer(text.substring(0, position));
            }
        }
        this.setCommandMode();
    }

    private void yankToLineEnd() {
        String text;
        int position = this._view.documentPosition().position();
        Element element = this._view.documentPosition().element();
        if (element != null && (text = element.text()).length() >= position) {
            this.storeInBuffer(text.substring(position - 1));
        }
        this.setCommandMode();
    }

    private void yankToWordEnd() {
        String text;
        int position = this._view.documentPosition().position();
        Element element = this._view.documentPosition().element();
        if (element != null && (text = element.text()).length() >= position) {
            int wordEndPosition = ElementList.nextWordEnd(element, position);
            wordEndPosition = wordEndPosition == 0 ? position : ++wordEndPosition;
            if (wordEndPosition > text.length()) {
                wordEndPosition = text.length();
            }
            this.storeInBuffer(text.substring(position - 1, wordEndPosition));
        }
        this.setCommandMode();
    }

    private void yankLine() {
        if (this._count == 0) {
            this._count = 1;
        }
        StringBuilder yankedText = new StringBuilder();
        Element element = this._view.documentPosition().element();
        int i = 0;
        while (i < this._count && element != null) {
            yankedText.append("\n");
            yankedText.append(element.text());
            element = element.nextVisible(this._view);
            ++i;
        }
        this.storeInBuffer(yankedText.toString());
        this.setCommandMode();
    }

    private void scrollPageBackward() {
        if (this._count == 0) {
            this._count = 1;
        }
        int i = 0;
        while (i < this._count) {
            this._view.documentPosition().pageUp();
            ++i;
        }
        this.setCommandMode();
    }

    private void scrollPageForward() {
        if (this._count == 0) {
            this._count = 1;
        }
        int i = 0;
        while (i < this._count) {
            this._view.documentPosition().pageDown();
            ++i;
        }
        this.setCommandMode();
    }

    private void scrollBackwardHalfScreen() {
        if (this._count == 0) {
            this._count = this._view.screen().rows() / 2;
        }
        this.scrollBackward();
    }

    private void scrollForwardHalfScreen() {
        if (this._count == 0) {
            this._count = this._view.screen().rows() / 2;
        }
        this.scrollForward();
    }

    private void scrollBackward() {
        if (this._count == 0) {
            this._count = 1;
        }
        this._view.documentPosition().scrollUp(this._count);
        this.setCommandMode();
    }

    private void scrollForward() {
        if (this._count == 0) {
            this._count = 1;
        }
        this._view.documentPosition().scrollDown(this._count);
        this.setCommandMode();
    }

    private void endOfLine() {
        this._view.documentPosition().end();
        this.setCommandMode();
    }

    private void startOfLine() {
        this._view.documentPosition().home();
        this.setCommandMode();
    }

    private void firstNonWhitespace() {
        Element element = this._view.documentPosition().element();
        if (element != null) {
            String text = element.text();
            int position = 1;
            while (text.length() >= position && Character.isWhitespace(text.charAt(position - 1))) {
                ++position;
            }
            this._view.documentPosition().jump(element, position);
        }
        this.setCommandMode();
    }

    private void matchingParenthesisOrBrace() {
        Element element = this._view.documentPosition().element();
        if (element != null) {
            int position;
            String text = element.text();
            int savePosition = position = this._view.documentPosition().position();
            char matchChar = '\u0000';
            char originalChar = '\u0000';
            while (position <= text.length()) {
                char c = text.charAt(position - 1);
                if (c == '{' || c == '[' || c == '(' || c == ')' || c == ']' || c == '}') {
                    originalChar = c;
                    break;
                }
                ++position;
            }
            if (originalChar != '\u0000') {
                switch (originalChar) {
                    case '{': {
                        matchChar = '}';
                        break;
                    }
                    case '(': {
                        matchChar = ')';
                        break;
                    }
                    case '[': {
                        matchChar = ']';
                        break;
                    }
                    case '}': {
                        matchChar = '{';
                        break;
                    }
                    case ')': {
                        matchChar = '(';
                        break;
                    }
                    case ']': {
                        matchChar = '[';
                        break;
                    }
                }
                this._view.documentPosition().jump(element, position);
                int skipNum = 0;
                int currentPos = position - 1;
                boolean isFound = false;
                Element e = element;
                if (matchChar == '{' || matchChar == '(' || matchChar == '[') {
                    do {
                        String s = e.text();
                        if (currentPos < 0) {
                            currentPos = s.length();
                        }
                        --currentPos;
                        while (currentPos > -1) {
                            char c = s.charAt(currentPos);
                            if (c == matchChar && --skipNum < 0) {
                                isFound = true;
                                break;
                            }
                            if (c == originalChar) {
                                ++skipNum;
                            }
                            --currentPos;
                        }
                        if (isFound) continue;
                        e = e.prev();
                    } while (e != null && !isFound);
                } else {
                    do {
                        String s = e.text();
                        ++currentPos;
                        while (currentPos < s.length()) {
                            char c = s.charAt(currentPos);
                            if (c == matchChar && --skipNum < 0) {
                                isFound = true;
                                break;
                            }
                            if (c == originalChar) {
                                ++skipNum;
                            }
                            ++currentPos;
                        }
                        if (isFound) continue;
                        e = e.next();
                        currentPos = -1;
                    } while (e != null && !isFound);
                }
                if (isFound) {
                    this._view.documentPosition().jump(e, currentPos + 1);
                } else {
                    this._view.documentPosition().jump(element, savePosition);
                }
            } else {
                this.beep();
            }
        }
        this.setCommandMode();
    }

    private void column() {
        Element element;
        if (this._count == 0) {
            this._count = 1;
        }
        if ((element = this._view.documentPosition().element()) != null) {
            this._view.documentPosition().jump(element, this._count);
        }
        this.setCommandMode();
    }

    private void firstNonWhitespaceOnNextLine() {
        if (this._count == 0) {
            this._count = 1;
        }
        this._view.documentPosition().down(this._count);
        this.firstNonWhitespace();
    }

    private void firstNonWhitespaceOnNextLineMinus1() {
        if (this._count == 0) {
            this._count = 1;
        }
        --this._count;
        if (this._count > 0) {
            this._view.documentPosition().down(this._count);
        }
        this.firstNonWhitespace();
    }

    private void firstNonWhitespaceOnPreviousLine() {
        if (this._count == 0) {
            this._count = 1;
        }
        this._view.documentPosition().up(this._count);
        this.firstNonWhitespace();
    }

    private void startOfWord() {
        if (this._count == 0) {
            this._count = 1;
        }
        int i = 0;
        while (i < this._count) {
            this._view.documentPosition().prevWord();
            ++i;
        }
        this.setCommandMode();
    }

    private void endOfWord() {
        if (this._count == 0) {
            this._count = 1;
        }
        int i = 0;
        while (i < this._count) {
            this._view.documentPosition().nextWordEnd();
            ++i;
        }
        this.setCommandMode();
    }

    private void goToLine() {
        this.beforeJump();
        if (this._count == 0 || this._count > this._view.document().elementList().nonShowCount()) {
            this._view.documentPosition().bottom();
        } else {
            Element element = this._view.document().elementList().nonShowElementAt(this._count);
            if (element != null) {
                this._view.documentPosition().jump(element, 1);
            }
        }
        this.firstNonWhitespace();
    }

    private void firstNonWhitespaceAtScreenTop() {
        this._view.documentPosition().windowTop();
        int i = 1;
        while (i < this._count) {
            this._view.documentPosition().down();
            ++i;
        }
        this.firstNonWhitespace();
    }

    private void firstNonWhitespaceAtScreenMiddle() {
        this._view.documentPosition().windowMiddle();
        this.firstNonWhitespace();
    }

    private void firstNonWhitespaceAtScreenBottom() {
        this._view.documentPosition().windowBottom();
        int i = 1;
        while (i < this._count) {
            this._view.documentPosition().up();
            ++i;
        }
        this.firstNonWhitespace();
    }

    private void nextWord() {
        if (this._count == 0) {
            this._count = 1;
        }
        int i = 0;
        while (i < this._count) {
            this._view.documentPosition().nextWord();
            ++i;
        }
        this.setCommandMode();
    }

    private void scrollTop() {
        if (this._count != 0) {
            if (this._count > this._view.document().elementList().nonShowCount()) {
                this._view.documentPosition().bottom();
            } else {
                Element element = this._view.document().elementList().nonShowElementAt(this._count);
                if (element != null) {
                    this._view.documentPosition().jump(element, 1);
                }
            }
        }
        this._view.screen().setCursorRow(1);
        this.setCommandMode();
    }

    private void scrollCenter() {
        if (this._count != 0) {
            if (this._count > this._view.document().elementList().nonShowCount()) {
                this._view.documentPosition().bottom();
            } else {
                Element element = this._view.document().elementList().nonShowElementAt(this._count);
                if (element != null) {
                    this._view.documentPosition().jump(element, 1);
                }
            }
        }
        this._view.screen().setCursorRow((this._view.screen().rows() + 1) / 2);
        this.setCommandMode();
    }

    private void scrollBottom() {
        if (this._count != 0) {
            if (this._count > this._view.document().elementList().nonShowCount()) {
                this._view.documentPosition().bottom();
            } else {
                Element element = this._view.document().elementList().nonShowElementAt(this._count);
                if (element != null) {
                    this._view.documentPosition().jump(element, 1);
                }
            }
        }
        this._view.screen().setCursorRow(this._view.screen().rows());
        this.setCommandMode();
    }

    private void substitute() {
        if (this._count == 0) {
            this._count = 1;
        }
        String deletedText = this._view.deleteText(this._count);
        this.storeInBuffer(deletedText);
        this._ignoreCount = true;
        this.setInsertMode();
    }

    private void findCharacter() {
        if (this._count == 0) {
            this._count = 1;
        }
        int position = this._view.documentPosition().position();
        Element element = this._view.documentPosition().element();
        String text = element.text();
        boolean found = false;
        int i = 0;
        while (i < this._count) {
            found = false;
            ++position;
            while (position <= text.length()) {
                if (text.charAt(position - 1) == this._findCharacter) {
                    found = true;
                    break;
                }
                ++position;
            }
            ++i;
        }
        if (found) {
            if (this._findCharacterCommand == 't' || this._findCharacterCommand == 'T') {
                --position;
            }
            this._view.documentPosition().jump(element, position);
        } else {
            this.beep();
        }
        this.setCommandMode();
    }

    private void reverseFindCharacter() {
        Element element;
        String text;
        int position;
        if (this._count == 0) {
            this._count = 1;
        }
        if ((position = this._view.documentPosition().position()) > (text = (element = this._view.documentPosition().element()).text()).length()) {
            position = text.length();
        }
        boolean found = false;
        int i = 0;
        while (i < this._count) {
            found = false;
            --position;
            while (position > 0) {
                if (text.charAt(position - 1) == this._findCharacter) {
                    found = true;
                    break;
                }
                --position;
            }
            ++i;
        }
        if (found) {
            if (this._findCharacterCommand == 't' || this._findCharacterCommand == 'T') {
                ++position;
            }
            this._view.documentPosition().jump(element, position);
        } else {
            this.beep();
        }
        this.setCommandMode();
    }

    private void repeatFindCharacter() {
        if (this._findCharacterCommand == 'f' || this._findCharacterCommand == 't') {
            this.findCharacter();
        } else if (this._findCharacterCommand == 'F' || this._findCharacterCommand == 'T') {
            this.reverseFindCharacter();
        } else {
            this.beep();
            this.setCommandMode();
        }
    }

    private void reverseRepeatFindCharacter() {
        if (this._findCharacterCommand == 'f' || this._findCharacterCommand == 't') {
            this.reverseFindCharacter();
        } else if (this._findCharacterCommand == 'F' || this._findCharacterCommand == 'T') {
            this.findCharacter();
        } else {
            this.beep();
            this.setCommandMode();
        }
    }

    private void exCommand(char c) {
        if (this._view.window() != null) {
            CommandLine commandLine = (CommandLine)this._view.window().commandLine();
            commandLine.setMode(0);
            commandLine.setForceVisible(true);
            this._view.window().commandLineRequestFocus();
            commandLine.setCommandText(String.valueOf(c));
        }
    }

    private void toggleCharacterCase() {
        if (this._count == 0) {
            this._count = 1;
        }
        int i = 0;
        while (i < this._count) {
            Element element;
            String text;
            int position = this._view.documentPosition().position();
            if (position <= (text = (element = this._view.documentPosition().element()).text()).length()) {
                char c = text.charAt(position - 1);
                if (Character.isLowerCase(c)) {
                    this._view.replaceText(String.valueOf(Character.toUpperCase(c)));
                } else if (Character.isUpperCase(c)) {
                    this._view.replaceText(String.valueOf(Character.toLowerCase(c)));
                } else {
                    this._view.documentPosition().right();
                }
            } else {
                this._view.documentPosition().right();
            }
            ++i;
        }
        this.setCommandMode();
    }

    private void join() {
        if (this._count == 0) {
            this._count = 1;
        }
        int i = 0;
        while (i < this._count) {
            Element element = this._view.documentPosition().element();
            if (element != null && !element.show()) {
                Element element2 = element.nextVisibleNonShow(this._view);
                this._view.joinElements(element, element2);
            }
            ++i;
        }
        this.setCommandMode();
    }

    private void repeatFind() {
        if (this._count == 0) {
            this._count = 1;
        }
        this.beforeJump();
        int i = 0;
        while (i < this._count) {
            this.doCommand(this._findCommand);
            ++i;
        }
        this.setCommandMode();
    }

    private void repeatSubstitute() {
        if (this._count == 0) {
            this._count = 1;
        }
        this.beforeJump();
        int i = 0;
        while (i < this._count) {
            this.doCommand(this._substituteCommand);
            ++i;
        }
        this.setCommandMode();
    }

    private void reverseRepeatFind() {
        if (this._count == 0) {
            this._count = 1;
        }
        this.beforeJump();
        int i = 0;
        while (i < this._count) {
            if (this._findCommand.charAt(0) == '?') {
                this._view.commandHandler().doCommand("findText asis " + LpexStringTokenizer.addQuotes(this._findCommand.substring(1)));
            } else if (this._findCommand.charAt(0) == '/') {
                this._view.commandHandler().doCommand("findText up asis " + LpexStringTokenizer.addQuotes(this._findCommand.substring(1)));
            }
            ++i;
        }
        this.setCommandMode();
    }

    private void repeatLastChange() {
        if (this._lastChangeCommand != null && this._lastChangeCommand.length() > 0) {
            int saveLastChangeCount = this._lastChangeCount;
            int saveLastChangeBuffer = this._lastChangeBuffer;
            String saveLastChangeCommand = this._lastChangeCommand;
            if (this._count == 0) {
                this._count = this._lastChangeCount;
            }
            if (this._currentBuffer == 0) {
                this._currentBuffer = this._lastChangeBuffer;
            }
            int i = 0;
            while (i < saveLastChangeCommand.length()) {
                this.processCharacter(saveLastChangeCommand.charAt(i));
                ++i;
            }
            this._lastChangeCount = saveLastChangeCount;
            this._lastChangeBuffer = saveLastChangeBuffer;
            this._lastChangeCommand = saveLastChangeCommand;
        }
    }

    private void storeInBuffer(String text) {
        if (text != null && text.length() != 0) {
            if (this._currentBuffer >= 9) {
                if (this._buffers[this._currentBuffer] != null && this._appendToBuffer) {
                    int n = this._currentBuffer;
                    this._buffers[n] = String.valueOf(this._buffers[n]) + text;
                } else {
                    this._buffers[this._currentBuffer] = text;
                }
            } else {
                int i = 8;
                while (i > 0) {
                    this._buffers[i] = this._buffers[i - 1];
                    --i;
                }
                this._buffers[0] = text;
            }
        }
    }

    private void startChangeCommand(char c) {
        this._lastChangeCount = this._count;
        this._lastChangeCommand = String.valueOf(c);
        this._lastChangeBuffer = this._currentBuffer;
        if (this._savedElement != this._view.documentPosition().element()) {
            this._savedElement = this._view.documentPosition().element();
            if (this._savedElement.show()) {
                this._savedElement = null;
            }
            this._savedText = this._savedElement != null ? this._savedElement.text() : null;
        }
    }

    private void beforeJump() {
        SetCommand.doCommand(this._view, "mark.@QUICK");
    }

    private void expandAbbreviation() {
        if (this._abbreviations.first() != null) {
            String substitutionString;
            String lastWord = this._insertString;
            int i = this._insertString.length() - 1;
            while (i >= 0) {
                char c = this._insertString.charAt(i);
                if (c == ' ' || c == '\n' || c == '\t') {
                    if (i < this._insertString.length() - 1) {
                        lastWord = this._insertString.substring(i + 1);
                        break;
                    }
                    lastWord = "";
                    break;
                }
                --i;
            }
            if (lastWord.length() > 0 && (substitutionString = (String)this._abbreviations.query(lastWord, true)) != null) {
                int i2 = 0;
                while (i2 < lastWord.length()) {
                    this.processInputCharacter('\b');
                    ++i2;
                }
                i2 = 0;
                while (i2 < substitutionString.length()) {
                    this.processInputCharacter(substitutionString.charAt(i2));
                    ++i2;
                }
            }
        }
    }

    private void beep() {
        BeepParameter.getParameter().setValue(true);
    }

    private static final class Command {
        String _commandString;
        int _currentPosition = 0;

        Command(String commandString) {
            this._commandString = commandString;
            if (this._commandString.length() > 0 && this._commandString.charAt(0) == ':') {
                char c;
                ++this._currentPosition;
                StringBuilder integer = new StringBuilder();
                while (this._currentPosition < this._commandString.length()) {
                    c = this._commandString.charAt(this._currentPosition);
                    if (c < '0' || c > '9') break;
                    integer.append(c);
                    ++this._currentPosition;
                }
                if (integer.length() > 0) {
                    Integer.parseInt(integer.toString());
                }
                if (this._currentPosition < this._commandString.length() && (c = this._commandString.charAt(this._currentPosition)) == ',') {
                    ++this._currentPosition;
                    integer = new StringBuilder();
                    while (this._currentPosition < this._commandString.length()) {
                        c = this._commandString.charAt(this._currentPosition);
                        if (c < '0' || c > '9') break;
                        integer.append(c);
                        ++this._currentPosition;
                    }
                    if (integer.length() > 0) {
                        Integer.parseInt(integer.toString());
                    }
                }
            }
        }

        boolean isCommand(String expectedCommand, int significantCharacters) {
            if (this._commandString.length() >= significantCharacters) {
                int i = 0;
                int j = this._currentPosition;
                while (i < expectedCommand.length()) {
                    if (j >= this._commandString.length() || this._commandString.charAt(j) != expectedCommand.charAt(i)) {
                        if (i >= significantCharacters) break;
                        return false;
                    }
                    ++i;
                    ++j;
                }
                this._currentPosition = j;
                return true;
            }
            return false;
        }

        boolean skipCharacter(char c) {
            if (this._commandString.length() > this._currentPosition && this._commandString.charAt(this._currentPosition) == c) {
                ++this._currentPosition;
                return true;
            }
            return false;
        }

        boolean skipOptionalCharacter(char c) {
            if (this._commandString.length() > this._currentPosition) {
                return this.skipCharacter(c);
            }
            return true;
        }

        String remainingText() {
            return this._commandString.length() > this._currentPosition ? this._commandString.substring(this._currentPosition) : "";
        }

        String nextToken(char c) {
            if (this._commandString.length() > this._currentPosition) {
                int endPosition = this._currentPosition;
                while (this._commandString.length() > endPosition && this._commandString.charAt(endPosition) != c) {
                    ++endPosition;
                }
                String token = this._commandString.substring(this._currentPosition, endPosition);
                this._currentPosition = endPosition;
                return token;
            }
            return "";
        }

        String nextToken() {
            if (this._commandString.length() > this._currentPosition) {
                while (this.skipCharacter(' ')) {
                }
                int endPosition = this._currentPosition;
                while (this._commandString.length() > endPosition && this._commandString.charAt(endPosition) != ' ') {
                    ++endPosition;
                }
                String token = this._commandString.substring(this._currentPosition, endPosition);
                this._currentPosition = endPosition;
                this.skipCharacter(' ');
                return token;
            }
            return "";
        }

        boolean noRemainingText() {
            while (this._currentPosition < this._commandString.length() && this._commandString.charAt(this._currentPosition) == ' ') {
                ++this._currentPosition;
            }
            return this._commandString.length() <= this._currentPosition;
        }
    }
}

