/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ElementList;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.core.MessageLine;
import com.ibm.lpex.core.Screen;
import com.ibm.lpex.core.TextScrollBar;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.ScrollBar;

final class VerticalScrollBar
extends TextScrollBar {
    VerticalScrollBar(Screen screen) {
        this._screen = screen;
        this._minimum = 1;
        this._unitIncrement = 1;
    }

    @Override
    void build() {
        boolean needed;
        int maximum;
        Element topElement = this._screen.element(1);
        int value = topElement != null ? this._screen._view.visibleElementOrdinalOf(topElement) : 1;
        value += this._screen._view.document().linesBeforeStart();
        int visibleAmount = this._screen.rows();
        if (visibleAmount > (maximum = this._screen._view.visibleElementCount() + 1 + this._screen._view.document().linesBeforeStart() + this._screen._view.document().linesAfterEnd())) {
            visibleAmount = maximum;
        }
        if (maximum < 1) {
            visibleAmount = 0;
            maximum = 1;
        }
        if (value > maximum) {
            value = maximum;
        }
        int blockIncrement = this._screen.rows();
        if (this._value != value || this._visibleAmount != visibleAmount || this._maximum != maximum || this._blockIncrement != blockIncrement) {
            this._updateRequired = true;
            this._value = value;
            this._visibleAmount = visibleAmount;
            this._maximum = maximum;
            this._blockIncrement = blockIncrement;
        }
        boolean bl = needed = this._minimum + visibleAmount < maximum;
        if (needed != this._needed) {
            this._updateRequired = true;
            this._needed = needed;
            this._screen.buildTextWindow();
            this._screen.horizontalScrollBar().build();
        }
    }

    @Override
    void changeLpexWindow(LpexWindow oldLpexWindow, LpexWindow newLpexWindow) {
        if (oldLpexWindow != null && !oldLpexWindow.textWindow().isDisposed()) {
            oldLpexWindow.verticalScrollBar().removeSelectionListener((SelectionListener)this);
        }
        if (newLpexWindow != null) {
            newLpexWindow.verticalScrollBar().addSelectionListener((SelectionListener)this);
        }
        this._updateRequired = true;
    }

    @Override
    ScrollBar scrollBar() {
        return this._screen._lpexWindow != null ? this._screen._lpexWindow.verticalScrollBar() : null;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Element topElement;
        int topElementNumber;
        if (!this.scrollBar().getVisible()) {
            return;
        }
        int linesBeforeStart = this._screen._view.document().linesBeforeStart();
        int newElementNumber = this.scrollBar().getSelection();
        if (!this._screen._view.scrollWhileAdjusting()) {
            if (e.detail == 1) {
                int botLine;
                int topLine;
                ElementList elementList = this._screen._view.document().elementList();
                int rowsDelta = this._screen.rows() > 0 ? this._screen.rows() - 1 : 0;
                int visibleElements = this._screen._view.visibleElementCount();
                if (newElementNumber <= linesBeforeStart) {
                    topLine = newElementNumber;
                    botLine = topLine + rowsDelta;
                } else if (newElementNumber > linesBeforeStart + visibleElements) {
                    Element elem = this._screen._view.visibleElementAt(visibleElements);
                    int showLinesDelta = visibleElements - (elem != null ? elementList.nonShowOrdinalOf(elem) : 0);
                    topLine = newElementNumber - showLinesDelta;
                    botLine = topLine + rowsDelta;
                } else {
                    int newTopElement = newElementNumber - linesBeforeStart;
                    Element elem = this._screen._view.visibleElementAt(newTopElement);
                    if (elem == null && newTopElement == 1) {
                        elem = this._screen._view.visibleElementAt(newTopElement + 1);
                    }
                    topLine = elem != null ? elementList.nonShowOrdinalOf(elem) : 0;
                    int overflow = newTopElement + rowsDelta - visibleElements;
                    botLine = overflow > 0 ? overflow + ((elem = this._screen._view.visibleElementAt(visibleElements)) != null ? elementList.nonShowOrdinalOf(elem) : topLine) : ((elem = this._screen._view.visibleElementAt(newTopElement + rowsDelta)) != null ? elementList.nonShowOrdinalOf(elem) : topLine);
                    topLine += linesBeforeStart;
                    botLine += linesBeforeStart;
                }
                this._screen.setMessageKey("scrollingRange", String.valueOf(topLine), String.valueOf(botLine));
                ((MessageLine)this._screen._lpexWindow.messageLine()).setText(this._screen._messageText);
                ((MessageLine)this._screen._lpexWindow.messageLine()).updateMessage();
                return;
            }
            this._screen.clearMessageKey("scrollingRange");
        }
        int n = topElementNumber = (topElement = this._screen.element(1)) != null ? this._screen._view.visibleElementOrdinalOf(topElement) : 1;
        if ((topElementNumber += linesBeforeStart) > newElementNumber) {
            this._screen._view.documentPosition().scrollUp(topElementNumber - newElementNumber);
        } else if (newElementNumber > topElementNumber) {
            this._screen._view.documentPosition().scrollDown(newElementNumber - topElementNumber);
        } else if (e.detail == 0x1000002) {
            this._screen._view.documentPosition().scrollDown(1);
        } else if (e.detail == 0x1000001) {
            this._screen._view.documentPosition().scrollUp(1);
        }
        if (this._updateRequired && this._lastTrackValue == newElementNumber) {
            Document.screenShow();
        } else {
            this._tracking = true;
            Document.screenShow(this._screen);
            this._tracking = false;
        }
        this._lastTrackValue = newElementNumber;
    }
}

